noperspective in vec2 g_uv;
noperspective in float g_line_length;

uniform mat4 u_mvp_matrix;
uniform vec4 u_line_color;
uniform float u_line_width;
uniform vec2 u_aa_radius;

out vec4 frag_color;

void main()
{
/* We render a quad that is fattened by r, giving total width of the line to be w+r. We want smoothing to happen
           around w, so that the edge is properly smoothed out. As such, in the smoothstep function we have:
           Far edge   : 1.0                                          = (w+r) / (w+r)
           Close edge : 1.0 - (2r / (w+r)) = (w+r)/(w+r) - 2r/(w+r)) = (w-r) / (w+r)
           This way the smoothing is centered around 'w'.
         */
    float au = 1.0 - smoothstep(1.0 - ((2.0 * u_aa_radius[0]) / u_line_width), 1.0, abs(g_uv.x / u_line_width));
    float av = 1.0 - smoothstep(1.0 - ((2.0 * u_aa_radius[1]) / g_line_length), 1.0, abs(g_uv.y / g_line_length));
    frag_color = u_line_color;
    frag_color.a *= min(av, au);
}