in vec4 a_position;

in float pos_a_x;
in float pos_a_y;

in float pos_b_x;
in float pos_b_y;

uniform mat4 u_matrix_mvp;
uniform vec2 u_resolution;
uniform float u_width;

uniform vec4 u_color_min;
uniform vec4 u_color_max;

uniform float u_value_min;
uniform float u_value_max;

out vec4 color;

// robust util to map value
float map(float v, float in_min, float in_max, float out_min, float out_max) {
    // normalisation in range[in_min,in_max]
    float norm = 0.0;
    if (in_min < in_max) {
        norm = min(in_max, max(in_min, v)) - in_min;
        norm /= (in_max - in_min);
    } else if (in_min > in_max) {
        norm = min(in_min, max(in_max, v)) - in_max;
        norm /= (in_min - in_max);
        norm = 1.0 - norm;
    }
    // mapping in range [out_min,out_max]
    float result = norm * (out_max - out_min) + out_min;
    float mmin = out_min;
    float mmax = out_max;
    if (out_min > out_max) {
        mmin = out_max;
        mmax = out_min;
        result = (1. - norm) * (out_min - out_max) + out_max;
    }
    // clamping value
    return min(mmax, max(mmin, result));
}

void main()
{
    vec4 pos_a_udc = vec4(pos_a_x, pos_a_y, 0.0, 1.0) * u_matrix_mvp; // in UDC coords
    vec4 pos_b_udc = vec4(pos_b_x, pos_b_y, 0.0, 1.0) * u_matrix_mvp; // in UDC coords

    vec2 pos_a = ((pos_a_udc.xy + 1.0) / 2.0) * u_resolution; // in pixels
    vec2 pos_b = ((pos_b_udc.xy + 1.0) / 2.0) * u_resolution;

    vec2 x_base = vec2(normalize(pos_b - pos_a).xy);
    vec2 y_base = normalize(vec2(-x_base.y, x_base.x));

    vec2 offset_a_px = pos_a + u_width * (a_position.x * x_base + a_position.y * y_base);
    vec2 offset_b_px = pos_b + u_width * (a_position.x * x_base + a_position.y * y_base);

    vec2 offset_a = (offset_a_px / u_resolution) * 2.0 - 1.0;
    vec2 offset_b = (offset_b_px / u_resolution) * 2.0 - 1.0;

    vec2 point = mix(offset_a, offset_b, a_position.z);
    gl_Position = vec4(point, 0.0, 1.0);

    float t = map(abs(pos_a_y), u_value_min, u_value_max, 0.0, 1.0);
    color = mix(u_color_min, u_color_max, t);
}