#ifdef GL_ES
precision highp float;
#endif

in vec2 uv;

uniform float grid_div;
uniform float grid_thickness;

uniform vec2 grid_size;
uniform vec2 grid_pos;

uniform vec2 camera_pos;

uniform float grid_offset_y;

uniform vec4 grid_div_color;
uniform vec4 grid_major_color;

uniform vec2 u_resolution;
uniform int u_flipped_y;

out vec4 frag_color;

void main()
{
    vec4 background = vec4(0.0, 0.0, 0.0, 0.0);

    vec4 grid_px = vec4(grid_div, grid_div, grid_div * 5.0, grid_div * 5.0);

    vec2 grid_adjust = vec2(grid_thickness / 2.0, grid_thickness / 2.0);

    vec4 real_coord = (uv * grid_size).xyxy;

    float window_y = gl_FragCoord.y;
    if (u_flipped_y > 0) {
        window_y = u_resolution.y - gl_FragCoord.y;
    }

    vec2 window_coord = vec2(-grid_pos.x + gl_FragCoord.x, -grid_pos.y + window_y - grid_offset_y) + camera_pos;

    vec4 modded = mod(window_coord.xyxy + grid_adjust.xyxy, grid_px);
    vec4 rv = 1.0 - step(grid_thickness, modded);
    float div = max(rv.x, rv.y);
    float major = max(rv.z, rv.w);

    vec4 c = mix(mix(background, grid_div_color, div), grid_major_color, major);

    // Output to screen
    frag_color = c;
    // debug
//    frag_color = mix(vec4(window_coord / grid_size, 0.0, 1.0), c, 0.5);
}
