/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal.animation;

import androidx.collection.IntObjectMap;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.compottie.internal.AnimationState;
import io.github.alexzhirkevich.compottie.internal.animation.BaseKeyframeAnimationKt;
import io.github.alexzhirkevich.compottie.internal.animation.FloatRange;
import io.github.alexzhirkevich.compottie.internal.animation.Keyframe;
import io.github.alexzhirkevich.compottie.internal.animation.PropertyGroup;
import io.github.alexzhirkevich.compottie.internal.animation.RawKeyframeProperty;
import io.github.alexzhirkevich.keight.ScriptRuntime;
import io.github.alexzhirkevich.keight.js.JsAny;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0011\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0004\b\u0001\u0010\u0003*\u000e\b\u0002\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00030\u00052\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u0006B\u007f\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00020\n\u0012\u0006\u0010\u000b\u001a\u00028\u0000\u0012V\u0010\f\u001aR\u0012\u0004\u0012\u00028\u0002\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u000205H\u0004J\u0010\u00106\u001a\u00020\b2\u0006\u00104\u001a\u000205H\u0004J\u0015\u00107\u001a\u00028\u00002\u0006\u00104\u001a\u000205H\u0016\u00a2\u0006\u0002\u00108R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u000b\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR^\u0010\f\u001aR\u0012\u0004\u0012\u00028\u0002\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010.\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\u0006\u0012\u0004\u0018\u00018\u0001000/X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u00069"}, d2={"Lio/github/alexzhirkevich/compottie/internal/animation/BaseKeyframeAnimation;", "T", "", "K", "KF", "Lio/github/alexzhirkevich/compottie/internal/animation/Keyframe;", "Lio/github/alexzhirkevich/compottie/internal/animation/RawKeyframeProperty;", "index", "", "sourceKeyframes", "", "emptyValue", "map", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "start", "end", "", "progress", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/lang/Integer;Ljava/util/List;Ljava/lang/Object;Lkotlin/jvm/functions/Function4;)V", "getIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "Ljava/lang/Object;", "jsCache", "", "", "Lio/github/alexzhirkevich/keight/js/JsAny;", "getJsCache", "()Ljava/util/Map;", "group", "Lio/github/alexzhirkevich/compottie/internal/animation/PropertyGroup;", "getGroup", "()Lio/github/alexzhirkevich/compottie/internal/animation/PropertyGroup;", "setGroup", "(Lio/github/alexzhirkevich/compottie/internal/animation/PropertyGroup;)V", "keyframes", "getKeyframes", "()Ljava/util/List;", "timeIntervals", "Lio/github/alexzhirkevich/compottie/internal/animation/FloatRange;", "firstFrame", "lastFrame", "keyframesMappingRanges", "Landroidx/collection/IntObjectMap;", "Lkotlin/Pair;", "getKeyframesMappingRanges", "()Landroidx/collection/IntObjectMap;", "keyframeIndex", "state", "Lio/github/alexzhirkevich/compottie/internal/AnimationState;", "keyframeNumber", "raw", "(Lio/github/alexzhirkevich/compottie/internal/AnimationState;)Ljava/lang/Object;", "compottie-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBaseKeyframeAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseKeyframeAnimation.kt\nio/github/alexzhirkevich/compottie/internal/animation/BaseKeyframeAnimation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1056#2:133\n*S KotlinDebug\n*F\n+ 1 BaseKeyframeAnimation.kt\nio/github/alexzhirkevich/compottie/internal/animation/BaseKeyframeAnimation\n*L\n23#1:133\n*E\n"})
public class BaseKeyframeAnimation<T, K, KF extends Keyframe<? extends K>>
implements RawKeyframeProperty<T, KF> {
    @Nullable
    private final Integer index;
    @NotNull
    private final T emptyValue;
    @NotNull
    private final Function4<KF, K, K, Float, T> map;
    @NotNull
    private final Map<String, JsAny> jsCache;
    @Nullable
    private PropertyGroup group;
    @NotNull
    private final List<KF> keyframes;
    @NotNull
    private final List<FloatRange> timeIntervals;
    private final float firstFrame;
    private final float lastFrame;
    @NotNull
    private final IntObjectMap<Pair<K, K>> keyframesMappingRanges;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public BaseKeyframeAnimation(@Nullable Integer index, @NotNull List<? extends KF> sourceKeyframes, @NotNull T emptyValue, @NotNull Function4<? super KF, ? super K, ? super K, ? super Float, ? extends T> map) {
        MutableIntObjectMap mutableIntObjectMap;
        List list;
        BaseKeyframeAnimation baseKeyframeAnimation;
        List list2;
        Intrinsics.checkNotNullParameter(sourceKeyframes, (String)"sourceKeyframes");
        Intrinsics.checkNotNullParameter(emptyValue, (String)"emptyValue");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.index = index;
        this.emptyValue = emptyValue;
        this.map = map;
        this.jsCache = new HashMap();
        if (BaseKeyframeAnimationKt.access$isSorted(sourceKeyframes)) {
            list2 = sourceKeyframes;
        } else {
            Iterable $this$sortedBy$iv = sourceKeyframes;
            boolean $i$f$sortedBy = false;
            list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Keyframe p0 = (Keyframe)a;
                    boolean bl = false;
                    Comparable comparable = Float.valueOf(p0.getTime());
                    p0 = (Keyframe)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(p0.getTime()));
                }
            });
        }
        this.keyframes = list2;
        BaseKeyframeAnimation baseKeyframeAnimation2 = this;
        if (!((Collection)this.getKeyframes()).isEmpty()) {
            int n = CollectionsKt.getLastIndex(this.getKeyframes());
            baseKeyframeAnimation = baseKeyframeAnimation2;
            ArrayList<FloatRange> $i$f$sortedBy = new ArrayList<FloatRange>(n);
            int n2 = 0;
            while (n2 < n) {
                void it;
                int n3;
                int n4 = n3 = n2++;
                ArrayList<FloatRange> arrayList = $i$f$sortedBy;
                boolean bl = false;
                arrayList.add(new FloatRange(((Keyframe)this.getKeyframes().get((int)it)).getTime(), ((Keyframe)this.getKeyframes().get((int)(it + true))).getTime()));
            }
            list = $i$f$sortedBy;
            baseKeyframeAnimation2 = baseKeyframeAnimation;
        } else {
            list = CollectionsKt.emptyList();
        }
        baseKeyframeAnimation2.timeIntervals = list;
        this.firstFrame = this.getKeyframes().isEmpty() ? 0.0f : ((Keyframe)CollectionsKt.first(this.getKeyframes())).getTime();
        this.lastFrame = this.getKeyframes().isEmpty() ? 0.0f : ((Keyframe)CollectionsKt.last(this.getKeyframes())).getTime();
        MutableIntObjectMap $i$f$sortedBy = mutableIntObjectMap = new MutableIntObjectMap(0, 1, null);
        baseKeyframeAnimation = this;
        boolean bl = false;
        if (!this.getKeyframes().isEmpty()) {
            Object object;
            void $this$keyframesMappingRanges_u24lambda_u241;
            Keyframe first = (Keyframe)CollectionsKt.first(this.getKeyframes());
            Object t = first.getStart();
            Object object2 = first.getEndHold();
            if (object2 == null) {
                Keyframe keyframe = (Keyframe)CollectionsKt.getOrNull(this.getKeyframes(), (int)1);
                object2 = keyframe != null ? keyframe.getStart() : null;
            }
            $this$keyframesMappingRanges_u24lambda_u241.set(-1, (Object)new Pair(t, object2));
            Keyframe last = (Keyframe)CollectionsKt.last(this.getKeyframes());
            Keyframe preLast = (Keyframe)CollectionsKt.getOrNull(this.getKeyframes(), (int)(CollectionsKt.getLastIndex(this.getKeyframes()) - 1));
            int n = CollectionsKt.getLastIndex(this.getKeyframes());
            Keyframe keyframe = preLast;
            if (keyframe == null || (keyframe = keyframe.getStart()) == null) {
                keyframe = last.getStart();
            }
            if ((object = last.getStart()) == null) {
                Keyframe keyframe2 = preLast;
                object = keyframe2 != null ? keyframe2.getEnd() : null;
                if (object == null) {
                    Keyframe keyframe3 = preLast;
                    object = keyframe3 != null ? keyframe3.getStart() : null;
                }
            }
            $this$keyframesMappingRanges_u24lambda_u241.set(n, (Object)new Pair((Object)keyframe, object));
            int n5 = CollectionsKt.getLastIndex(this.getKeyframes());
            for (int i = 0; i < n5; ++i) {
                Object t2 = ((Keyframe)this.getKeyframes().get(i)).getStart();
                Object object3 = ((Keyframe)this.getKeyframes().get(i)).getEndHold();
                if (object3 == null) {
                    Keyframe keyframe4 = (Keyframe)CollectionsKt.getOrNull(this.getKeyframes(), (int)(i + 1));
                    object3 = keyframe4 != null ? keyframe4.getStart() : null;
                }
                $this$keyframesMappingRanges_u24lambda_u241.set(i, (Object)new Pair(t2, object3));
            }
        }
        baseKeyframeAnimation.keyframesMappingRanges = (IntObjectMap)mutableIntObjectMap;
    }

    @Override
    @Nullable
    public Integer getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public Map<String, JsAny> getJsCache() {
        return this.jsCache;
    }

    @Override
    @Nullable
    public PropertyGroup getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(@Nullable PropertyGroup propertyGroup) {
        this.group = propertyGroup;
    }

    @Override
    @NotNull
    public List<KF> getKeyframes() {
        return this.keyframes;
    }

    @NotNull
    protected final IntObjectMap<Pair<K, K>> getKeyframesMappingRanges() {
        return this.keyframesMappingRanges;
    }

    protected final float progress(int keyframeIndex, @NotNull AnimationState state) {
        float f;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (keyframeIndex < 0) {
            f = 0.0f;
        } else if (keyframeIndex > CollectionsKt.getLastIndex(this.timeIntervals)) {
            f = 1.0f;
        } else {
            FloatRange it = this.timeIntervals.get(keyframeIndex);
            boolean bl = false;
            f = (state.getFrame() - it.getStart()) / (it.getEndInclusive() - it.getStart());
        }
        return f;
    }

    protected final int keyframeNumber(@NotNull AnimationState state) {
        int n;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.getKeyframes().isEmpty()) {
            n = -2;
        } else if (state.getFrame() <= this.firstFrame) {
            n = -1;
        } else if (state.getFrame() >= this.lastFrame) {
            n = CollectionsKt.getLastIndex(this.getKeyframes());
        } else {
            int n2;
            int it = n2 = CollectionsKt.binarySearch$default(this.timeIntervals, (int)0, (int)0, arg_0 -> BaseKeyframeAnimation.keyframeNumber$lambda$3(state, arg_0), (int)3, null);
            boolean bl = false;
            boolean bl2 = it >= 0;
            Function0 function0 = BaseKeyframeAnimationKt.access$getInvalidKeyframeError$p();
            if (!bl2) {
                Object object = function0.invoke();
                throw new IllegalArgumentException(object.toString());
            }
            n = n2;
        }
        return n;
    }

    @Override
    @NotNull
    public T raw(@NotNull AnimationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int kfId = this.keyframeNumber(state);
        Pair pair = (Pair)this.keyframesMappingRanges.get(kfId);
        if (pair == null) {
            return this.emptyValue;
        }
        Pair range = pair;
        if (range.getFirst() == null || range.getSecond() == null) {
            return this.emptyValue;
        }
        Keyframe $this$raw_u24lambda_u245 = (Keyframe)this.getKeyframes().get(RangesKt.coerceIn((int)kfId, (ClosedRange)((ClosedRange)CollectionsKt.getIndices((Collection)this.getKeyframes()))));
        boolean bl = false;
        Object object = range.getFirst();
        Intrinsics.checkNotNull((Object)object);
        Object object2 = range.getSecond();
        Intrinsics.checkNotNull((Object)object2);
        return (T)this.map.invoke((Object)$this$raw_u24lambda_u245, object, object2, (Object)Float.valueOf(this.progress(kfId, state)));
    }

    @Override
    @Nullable
    public Object keys(@NotNull ScriptRuntime runtime, boolean excludeSymbols, boolean excludeNonEnumerables, @NotNull Continuation<? super List<? extends JsAny>> $completion) {
        return RawKeyframeProperty.DefaultImpls.keys(this, runtime, excludeSymbols, excludeNonEnumerables, $completion);
    }

    @Override
    @Nullable
    public Object get(@Nullable JsAny property, @NotNull ScriptRuntime runtime, @NotNull Continuation<? super JsAny> $completion) {
        return RawKeyframeProperty.DefaultImpls.get(this, property, runtime, $completion);
    }

    @Override
    public float rawFloat(@NotNull AnimationState state) {
        return RawKeyframeProperty.DefaultImpls.rawFloat(this, state);
    }

    @Override
    public long rawVec(@NotNull AnimationState state) {
        return RawKeyframeProperty.DefaultImpls.rawVec(this, state);
    }

    @Override
    public long rawColor(@NotNull AnimationState state) {
        return RawKeyframeProperty.DefaultImpls.rawColor(this, state);
    }

    @Nullable
    public Object proto(@NotNull ScriptRuntime runtime, @NotNull Continuation<? super JsAny> $completion) {
        return RawKeyframeProperty.DefaultImpls.proto(this, runtime, $completion);
    }

    @Nullable
    public Object delete(@Nullable JsAny property, @NotNull ScriptRuntime runtime, @NotNull Continuation<? super Boolean> $completion) {
        return RawKeyframeProperty.DefaultImpls.delete(this, property, runtime, $completion);
    }

    @Nullable
    public Object contains(@Nullable JsAny property, @NotNull ScriptRuntime runtime, @NotNull Continuation<? super Boolean> $completion) {
        return RawKeyframeProperty.DefaultImpls.contains(this, property, runtime, $completion);
    }

    @NotNull
    public Object toKotlin(@NotNull ScriptRuntime runtime) {
        return RawKeyframeProperty.DefaultImpls.toKotlin(this, runtime);
    }

    @NotNull
    public String getType() {
        return RawKeyframeProperty.DefaultImpls.getType(this);
    }

    private static final int keyframeNumber$lambda$3(AnimationState $state, FloatRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $state.getFrame() < it.getStart() ? 1 : ($state.getFrame() > it.getEndInclusive() ? -1 : 0);
    }
}

