/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexzhirkevich.compottie.internal;

import androidx.compose.runtime.internal.StabilityInferred;
import io.github.alexzhirkevich.compottie.internal.LottieJsonKt;
import io.github.alexzhirkevich.compottie.internal.animation.AnimatedColor;
import io.github.alexzhirkevich.compottie.internal.animation.AnimatedGradient;
import io.github.alexzhirkevich.compottie.internal.animation.AnimatedNumber;
import io.github.alexzhirkevich.compottie.internal.animation.AnimatedShape;
import io.github.alexzhirkevich.compottie.internal.animation.AnimatedVector2;
import io.github.alexzhirkevich.compottie.internal.animation.RawProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u0004J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u0004J3\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\f\b\u0000\u0010\u0017*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/github/alexzhirkevich/compottie/internal/Slots;", "", "slots", "", "", "Lkotlinx/serialization/json/JsonElement;", "<init>", "(Ljava/util/Map;)V", "cache", "", "Lio/github/alexzhirkevich/compottie/internal/animation/RawProperty;", "number", "Lio/github/alexzhirkevich/compottie/internal/animation/AnimatedNumber;", "sid", "vector", "Lio/github/alexzhirkevich/compottie/internal/animation/AnimatedVector2;", "color", "Lio/github/alexzhirkevich/compottie/internal/animation/AnimatedColor;", "gradient", "Lio/github/alexzhirkevich/compottie/internal/animation/AnimatedGradient;", "shape", "Lio/github/alexzhirkevich/compottie/internal/animation/AnimatedShape;", "property", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Ljava/lang/String;Lkotlinx/serialization/DeserializationStrategy;)Lio/github/alexzhirkevich/compottie/internal/animation/RawProperty;", "compottie-core"})
@StabilityInferred(parameters=0)
public final class Slots {
    @NotNull
    private final Map<String, JsonElement> slots;
    @NotNull
    private final Map<String, RawProperty<?>> cache;
    public static final int $stable = 8;

    public Slots(@NotNull Map<String, ? extends JsonElement> slots) {
        Intrinsics.checkNotNullParameter(slots, (String)"slots");
        this.slots = slots;
        this.cache = new LinkedHashMap();
    }

    @Nullable
    public final AnimatedNumber number(@NotNull String sid) {
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        return (AnimatedNumber)this.property(sid, (DeserializationStrategy)AnimatedNumber.Companion.serializer());
    }

    @Nullable
    public final AnimatedVector2 vector(@NotNull String sid) {
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        return (AnimatedVector2)this.property(sid, (DeserializationStrategy)AnimatedVector2.Companion.serializer());
    }

    @Nullable
    public final AnimatedColor color(@NotNull String sid) {
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        return (AnimatedColor)this.property(sid, (DeserializationStrategy)AnimatedColor.Companion.serializer());
    }

    @Nullable
    public final AnimatedGradient gradient(@NotNull String sid) {
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        return (AnimatedGradient)this.property(sid, (DeserializationStrategy)AnimatedGradient.Companion.serializer());
    }

    @Nullable
    public final AnimatedShape shape(@NotNull String sid) {
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        return (AnimatedShape)this.property(sid, (DeserializationStrategy)AnimatedShape.Companion.serializer());
    }

    private final <T extends RawProperty<?>> T property(String sid, DeserializationStrategy<? extends T> deserializer) {
        JsonElement jsonElement = this.slots.get(sid);
        if (jsonElement == null) {
            return null;
        }
        JsonElement json = jsonElement;
        RawProperty<?> cached = this.cache.get(sid);
        if (cached != null) {
            return (T)cached;
        }
        RawProperty rawProperty = (RawProperty)LottieJsonKt.getLottieJson().decodeFromJsonElement(deserializer, json);
        this.cache.put(sid, rawProperty);
        return (T)rawProperty;
    }
}

