/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.sigproc.filters;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.sigproc.filters.Filter;
import vet.inpulse.sigproc.filters.FilterCoeff;
import vet.inpulse.sigproc.filters.FloatBuffer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J0\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016J0\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016J\b\u0010(\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020 H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lvet/inpulse/sigproc/filters/SimpleFilter;", "Lvet/inpulse/sigproc/filters/Filter;", "fs", "", "coeff", "Lvet/inpulse/sigproc/filters/FilterCoeff;", "<init>", "(ILvet/inpulse/sigproc/filters/FilterCoeff;)V", "getFs", "()I", "getCoeff", "()Lvet/inpulse/sigproc/filters/FilterCoeff;", "num_data_filtered", "getNum_data_filtered", "setNum_data_filtered", "(I)V", "input_buffer", "Lvet/inpulse/sigproc/filters/FloatBuffer;", "getInput_buffer", "()Lvet/inpulse/sigproc/filters/FloatBuffer;", "output_buffer", "getOutput_buffer", "activated", "", "getActivated", "()Z", "setActivated", "(Z)V", "filterData", "", "newData", "filt", "", "src", "", "srcOffset", "dest", "destOffset", "length", "filtFilt", "reset", "_normalize_coefficients", "sigproc"})
public final class SimpleFilter
implements Filter {
    private final int fs;
    @NotNull
    private final FilterCoeff coeff;
    private int num_data_filtered;
    @NotNull
    private final FloatBuffer input_buffer;
    @NotNull
    private final FloatBuffer output_buffer;
    private boolean activated;

    public SimpleFilter(int fs, @NotNull FilterCoeff coeff) {
        Intrinsics.checkNotNullParameter((Object)coeff, (String)"coeff");
        this.fs = fs;
        this.coeff = coeff;
        this.input_buffer = FloatBuffer.Companion.create(this.coeff.getNumerator().length);
        this.output_buffer = FloatBuffer.Companion.create(this.coeff.getDenominator().length);
        this.activated = true;
        this._normalize_coefficients();
    }

    public final int getFs() {
        return this.fs;
    }

    @NotNull
    public final FilterCoeff getCoeff() {
        return this.coeff;
    }

    public final int getNum_data_filtered() {
        return this.num_data_filtered;
    }

    public final void setNum_data_filtered(int n) {
        this.num_data_filtered = n;
    }

    @NotNull
    public final FloatBuffer getInput_buffer() {
        return this.input_buffer;
    }

    @NotNull
    public final FloatBuffer getOutput_buffer() {
        return this.output_buffer;
    }

    @Override
    public boolean getActivated() {
        return this.activated;
    }

    @Override
    public void setActivated(boolean bl) {
        this.activated = bl;
    }

    @Override
    public float filterData(float newData) {
        float output = 0.0f;
        if (this.num_data_filtered < this.coeff.getDenominator().length) {
            this.input_buffer.put(newData);
            this.output_buffer.put(newData);
            int n = this.num_data_filtered;
            this.num_data_filtered = n + 1;
            output = newData;
        } else {
            int i;
            this.input_buffer.put(newData);
            int n = this.coeff.getNumerator().length;
            for (i = 0; i < n; ++i) {
                output += this.coeff.getNumerator()[i] * this.input_buffer.get(i);
            }
            n = this.coeff.getDenominator().length;
            for (i = 1; i < n; ++i) {
                output -= this.coeff.getDenominator()[i] * this.output_buffer.get(i - 1);
            }
            this.output_buffer.put(output);
        }
        return output;
    }

    @Override
    public void filt(@NotNull float[] src, int srcOffset, @NotNull float[] dest, int destOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void filtFilt(@NotNull float[] src, int srcOffset, @NotNull float[] dest, int destOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void reset() {
        this.num_data_filtered = 0;
        this.input_buffer.reset();
        this.output_buffer.reset();
    }

    private final void _normalize_coefficients() {
        if (!(this.coeff.getDenominator().length == 0)) {
            int n;
            float[] fArray;
            int i = 0;
            int n2 = this.coeff.getNumerator().length;
            while (i < n2) {
                fArray = this.coeff.getNumerator();
                n = i++;
                fArray[n] = fArray[n] / this.coeff.getDenominator()[0];
            }
            i = 0;
            n2 = this.coeff.getDenominator().length;
            while (i < n2) {
                fArray = this.coeff.getDenominator();
                n = i++;
                fArray[n] = fArray[n] / this.coeff.getDenominator()[0];
            }
        }
    }
}

