/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.sigproc.filters;

import kotlin.Metadata;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000e\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a \u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002\u001a \u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002\u001a \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002\u001a \u0010\u0017\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002\u00a8\u0006\u0018"}, d2={"binomialMult", "", "n", "", "p", "trinomialMult", "b", "c", "denominatorCoefficientsButterworthLowPass", "fcf", "", "numeratorCoefficientsButterworthLowPass", "sfButterworthLowPass", "numeratorCoefficientsButterworthHighPass", "denominatorCoefficientsButterworthHighPass", "sfButterworthHighPass", "numeratorCoefficientsButterworthBandStop", "fc1", "fc2", "denominatorCoefficientsButterworthBandStop", "sfButterworthBandStop", "numeratorCoefficientsButterworthBandPass", "denominatorCoefficientsButterworthBandPass", "sfButterworthBandPass", "sigproc"})
public final class IirKt {
    private static final float[] binomialMult(int n, float[] p) {
        float[] a = new float[2 * n];
        for (int i = 0; i < n; ++i) {
            for (int j = i; 0 < j; --j) {
                int n2 = 2 * j;
                a[n2] = a[n2] + (p[2 * i] * a[2 * (j - 1)] - p[2 * i + 1] * a[2 * (j - 1) + 1]);
                n2 = 2 * j + 1;
                a[n2] = a[n2] + (p[2 * i] * a[2 * (j - 1) + 1] + p[2 * i + 1] * a[2 * (j - 1)]);
            }
            a[0] = a[0] + p[2 * i];
            a[1] = a[1] + p[2 * i + 1];
        }
        return a;
    }

    private static final float[] trinomialMult(int n, float[] b, float[] c) {
        float[] a = new float[4 * n];
        a[2] = c[0];
        a[3] = c[1];
        a[0] = b[0];
        a[1] = b[1];
        for (int i = 1; i < n; ++i) {
            int n2 = 2 * (2 * i + 1);
            a[n2] = a[n2] + (c[2 * i] * a[2 * (2 * i - 1)] - c[2 * i + 1] * a[2 * (2 * i - 1) + 1]);
            n2 = 2 * (2 * i + 1) + 1;
            a[n2] = a[n2] + (c[2 * i] * a[2 * (2 * i - 1) + 1] + c[2 * i + 1] * a[2 * (2 * i - 1)]);
            for (int j = 2 * i; 1 < j; --j) {
                int n3 = 2 * j;
                a[n3] = a[n3] + (b[2 * i] * a[2 * (j - 1)] - b[2 * i + 1] * a[2 * (j - 1) + 1] + c[2 * i] * a[2 * (j - 2)] - c[2 * i + 1] * a[2 * (j - 2) + 1]);
                n3 = 2 * j + 1;
                a[n3] = a[n3] + (b[2 * i] * a[2 * (j - 1) + 1] + b[2 * i + 1] * a[2 * (j - 1)] + c[2 * i] * a[2 * (j - 2) + 1] + c[2 * i + 1] * a[2 * (j - 2)]);
            }
            a[2] = a[2] + (b[2 * i] * a[0] - b[2 * i + 1] * a[1] + c[2 * i]);
            a[3] = a[3] + (b[2 * i] * a[1] + b[2 * i + 1] * a[0] + c[2 * i + 1]);
            a[0] = a[0] + b[2 * i];
            a[1] = a[1] + b[2 * i + 1];
        }
        return a;
    }

    private static final float[] denominatorCoefficientsButterworthLowPass(int n, float fcf) {
        float[] rcof = new float[2 * n];
        double theta = Math.PI * (double)fcf;
        double st = Math.sin(theta);
        double ct = Math.cos(theta);
        for (int k = 0; k < n; ++k) {
            double parg = Math.PI * (double)(2 * k + 1) / (double)(2 * n);
            double sparg = Math.sin(parg);
            double cparg = Math.cos(parg);
            double a = (double)1.0f + st * sparg;
            rcof[2 * k] = (float)(-ct / a);
            rcof[2 * k + 1] = (float)(-st * cparg / a);
        }
        float[] denominatorCoefficients = IirKt.binomialMult(n, rcof);
        denominatorCoefficients[1] = denominatorCoefficients[0];
        denominatorCoefficients[0] = 1.0f;
        int k = 3;
        if (k <= n) {
            while (true) {
                denominatorCoefficients[k] = denominatorCoefficients[2 * k - 2];
                if (k == n) break;
                ++k;
            }
        }
        return denominatorCoefficients;
    }

    private static final float[] numeratorCoefficientsButterworthLowPass(int n) {
        float[] numeratorCoefficients = new float[n + 1];
        numeratorCoefficients[0] = 1.0f;
        numeratorCoefficients[1] = n;
        int i = 2;
        int m = n / 2;
        if (i <= m) {
            while (true) {
                numeratorCoefficients[i] = (float)(n - i + 1) * numeratorCoefficients[i - 1] / (float)i;
                numeratorCoefficients[n - i] = numeratorCoefficients[i];
                if (i == m) break;
                ++i;
            }
        }
        numeratorCoefficients[n - 1] = n;
        numeratorCoefficients[n] = 1.0f;
        return numeratorCoefficients;
    }

    private static final float sfButterworthLowPass(int n, float fcf) {
        float omega = (float)(Math.PI * (double)fcf);
        float fomega = (float)Math.sin(omega);
        double parg0 = Math.PI / (double)(2 * n);
        double sf = 1.0;
        int n2 = n / 2;
        for (int k = 0; k < n2; ++k) {
            sf *= 1.0 + (double)fomega * Math.sin((float)(2 * k + 1) * (float)parg0);
        }
        fomega = (float)Math.sin((double)omega / 2.0);
        if (n % 2 != 0) {
            sf *= (double)fomega + Math.cos((double)omega / 2.0);
        }
        sf = (double)((float)Math.pow(fomega, n)) / sf;
        return (float)sf;
    }

    private static final float[] numeratorCoefficientsButterworthHighPass(int n) {
        float[] numeratorCoefficients = IirKt.numeratorCoefficientsButterworthLowPass(n);
        int i = 0;
        if (i <= n) {
            while (true) {
                if (i % 2 != 0) {
                    numeratorCoefficients[i] = -numeratorCoefficients[i];
                }
                if (i == n) break;
                ++i;
            }
        }
        return numeratorCoefficients;
    }

    private static final float[] denominatorCoefficientsButterworthHighPass(int n, float fcf) {
        return IirKt.denominatorCoefficientsButterworthLowPass(n, fcf);
    }

    private static final float sfButterworthHighPass(int n, float fcf) {
        double omega = Math.PI * (double)fcf;
        float fomega = (float)Math.sin(omega);
        double parg0 = Math.PI / (double)(2 * n);
        float sf = 1.0f;
        int n2 = n / 2;
        for (int k = 0; k < n2; ++k) {
            sf *= 1.0f + fomega * (float)Math.sin((double)(2 * k + 1) * parg0);
        }
        fomega = (float)Math.cos(omega / 2.0);
        if (n % 2 != 0) {
            sf *= fomega + (float)Math.sin(omega / 2.0);
        }
        sf = (float)Math.pow(fomega, n) / sf;
        return sf;
    }

    private static final float[] numeratorCoefficientsButterworthBandStop(int n, float fc1, float fc2) {
        float alpha = (float)(-2.0 * Math.cos(Math.PI * (double)(fc2 + fc1) / 2.0) / Math.cos(Math.PI * (double)(fc2 - fc1) / 2.0));
        float[] numeratorCoefficients = new float[2 * n + 1];
        numeratorCoefficients[0] = 1.0f;
        numeratorCoefficients[2] = 1.0f;
        numeratorCoefficients[1] = alpha;
        for (int i = 1; i < n; ++i) {
            int n2 = 2 * i + 2;
            numeratorCoefficients[n2] = numeratorCoefficients[n2] + numeratorCoefficients[2 * i];
            for (int j = 2 * i; 1 < j; --j) {
                int n3 = j + 1;
                numeratorCoefficients[n3] = numeratorCoefficients[n3] + (alpha * numeratorCoefficients[j] + numeratorCoefficients[j - 1]);
            }
            numeratorCoefficients[2] = numeratorCoefficients[2] + (alpha * numeratorCoefficients[1] + 1.0f);
            numeratorCoefficients[1] = numeratorCoefficients[1] + alpha;
        }
        return numeratorCoefficients;
    }

    private static final float[] denominatorCoefficientsButterworthBandStop(int n, float fc1, float fc2) {
        float cp = (float)Math.cos(Math.PI * (double)(fc2 + fc1) / 2.0);
        double theta = Math.PI * (double)(fc2 - fc1) / 2.0;
        float st = (float)Math.sin(theta);
        float ct = (float)Math.cos(theta);
        float s2t = 2.0f * st * ct;
        float c2t = 2.0f * ct * ct - 1.0f;
        float[] rcof = new float[2 * n];
        float[] tcof = new float[2 * n];
        for (int k = 0; k < n; ++k) {
            double parg = Math.PI * (double)(2 * k + 1) / (double)(2 * n);
            float sparg = (float)Math.sin(parg);
            float cparg = (float)Math.cos(parg);
            float a = 1.0f + s2t * sparg;
            rcof[2 * k] = c2t / a;
            rcof[2 * k + 1] = -s2t * cparg / a;
            tcof[2 * k] = -2.0f * cp * (ct + st * sparg) / a;
            tcof[2 * k + 1] = 2.0f * cp * st * cparg / a;
        }
        float[] denominatorCoefficients = IirKt.trinomialMult(n, tcof, rcof);
        denominatorCoefficients[1] = denominatorCoefficients[0];
        denominatorCoefficients[0] = 1.0f;
        int k = 3;
        int n2 = 2 * n;
        if (k <= n2) {
            while (true) {
                denominatorCoefficients[k] = denominatorCoefficients[2 * k - 2];
                if (k == n2) break;
                ++k;
            }
        }
        return denominatorCoefficients;
    }

    private static final float sfButterworthBandStop(int n, float fc1, float fc2) {
        float tt = (float)Math.tan(Math.PI * (double)(fc2 - fc1) / 2.0);
        float sfr = 1.0f;
        float sfi = 0.0f;
        for (int k = 0; k < n; ++k) {
            double parg = Math.PI * (double)(2 * k + 1) / (double)(2 * n);
            float sparg = tt + (float)Math.sin(parg);
            float cparg = (float)Math.cos(parg);
            float a = (sfr + sfi) * (sparg - cparg);
            float b = sfr * sparg;
            float c = -sfi * cparg;
            sfr = b - c;
            sfi = a - b - c;
        }
        return 1.0f / sfr;
    }

    private static final float[] numeratorCoefficientsButterworthBandPass(int n) {
        float[] numeratorCoefficients = new float[2 * n + 1];
        float[] tcof = IirKt.numeratorCoefficientsButterworthHighPass(n);
        for (int i = 0; i < n; ++i) {
            numeratorCoefficients[2 * i] = tcof[i];
            numeratorCoefficients[2 * i + 1] = 0.0f;
        }
        numeratorCoefficients[2 * n] = tcof[n];
        return numeratorCoefficients;
    }

    private static final float[] denominatorCoefficientsButterworthBandPass(int n, float fc1, float fc2) {
        float cp = (float)Math.cos(Math.PI * (double)(fc2 + fc1) / 2.0);
        double theta = Math.PI * (double)(fc2 - fc1) / 2.0;
        float st = (float)Math.sin(theta);
        float ct = (float)Math.cos(theta);
        float s2t = 2.0f * st * ct;
        float c2t = 2.0f * ct * ct - 1.0f;
        float[] rcof = new float[2 * n];
        float[] tcof = new float[2 * n];
        for (int k = 0; k < n; ++k) {
            double parg = Math.PI * (double)(2 * k + 1) / (double)(2 * n);
            float sparg = (float)Math.sin(parg);
            float cparg = (float)Math.cos(parg);
            float a = 1.0f + s2t * sparg;
            rcof[2 * k] = c2t / a;
            rcof[2 * k + 1] = s2t * cparg / a;
            tcof[2 * k] = -2.0f * cp * (ct + st * sparg) / a;
            tcof[2 * k + 1] = -2.0f * cp * st * cparg / a;
        }
        float[] denominatorCoefficients = IirKt.trinomialMult(n, tcof, rcof);
        denominatorCoefficients[1] = denominatorCoefficients[0];
        denominatorCoefficients[0] = 1.0f;
        int k = 3;
        int n2 = 2 * n;
        if (k <= n2) {
            while (true) {
                denominatorCoefficients[k] = denominatorCoefficients[2 * k - 2];
                if (k == n2) break;
                ++k;
            }
        }
        return denominatorCoefficients;
    }

    private static final float sfButterworthBandPass(int n, float fc1, float fc2) {
        float ctt = 1.0f / (float)Math.tan(Math.PI * (double)(fc2 - fc1) / 2.0);
        float sfr = 1.0f;
        float sfi = 0.0f;
        for (int k = 0; k < n; ++k) {
            double parg = Math.PI * (double)(2 * k + 1) / (double)(2 * n);
            float sparg = ctt + (float)Math.sin(parg);
            float cparg = (float)Math.cos(parg);
            float a = (sfr + sfi) * (sparg - cparg);
            float b = sfr * sparg;
            float c = -sfi * cparg;
            sfr = b - c;
            sfi = a - b - c;
        }
        return 1.0f / sfr;
    }

    public static final /* synthetic */ float[] access$denominatorCoefficientsButterworthLowPass(int n, float fcf) {
        return IirKt.denominatorCoefficientsButterworthLowPass(n, fcf);
    }

    public static final /* synthetic */ float[] access$numeratorCoefficientsButterworthLowPass(int n) {
        return IirKt.numeratorCoefficientsButterworthLowPass(n);
    }

    public static final /* synthetic */ float access$sfButterworthLowPass(int n, float fcf) {
        return IirKt.sfButterworthLowPass(n, fcf);
    }

    public static final /* synthetic */ float[] access$denominatorCoefficientsButterworthHighPass(int n, float fcf) {
        return IirKt.denominatorCoefficientsButterworthHighPass(n, fcf);
    }

    public static final /* synthetic */ float[] access$numeratorCoefficientsButterworthHighPass(int n) {
        return IirKt.numeratorCoefficientsButterworthHighPass(n);
    }

    public static final /* synthetic */ float access$sfButterworthHighPass(int n, float fcf) {
        return IirKt.sfButterworthHighPass(n, fcf);
    }

    public static final /* synthetic */ float[] access$denominatorCoefficientsButterworthBandPass(int n, float fc1, float fc2) {
        return IirKt.denominatorCoefficientsButterworthBandPass(n, fc1, fc2);
    }

    public static final /* synthetic */ float[] access$numeratorCoefficientsButterworthBandPass(int n) {
        return IirKt.numeratorCoefficientsButterworthBandPass(n);
    }

    public static final /* synthetic */ float access$sfButterworthBandPass(int n, float fc1, float fc2) {
        return IirKt.sfButterworthBandPass(n, fc1, fc2);
    }

    public static final /* synthetic */ float[] access$denominatorCoefficientsButterworthBandStop(int n, float fc1, float fc2) {
        return IirKt.denominatorCoefficientsButterworthBandStop(n, fc1, fc2);
    }

    public static final /* synthetic */ float[] access$numeratorCoefficientsButterworthBandStop(int n, float fc1, float fc2) {
        return IirKt.numeratorCoefficientsButterworthBandStop(n, fc1, fc2);
    }

    public static final /* synthetic */ float access$sfButterworthBandStop(int n, float fc1, float fc2) {
        return IirKt.sfButterworthBandStop(n, fc1, fc2);
    }
}

