/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.sigproc.filters;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.sigproc.core.SigProcErrorType;
import vet.inpulse.sigproc.core.SigProcException;
import vet.inpulse.sigproc.filters.FilterCoeff;
import vet.inpulse.sigproc.filters.IIR_TYPE;
import vet.inpulse.sigproc.filters.IirKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\t\u00a8\u0006\u0014"}, d2={"Lvet/inpulse/sigproc/filters/IIR;", "", "<init>", "()V", "butter", "Lvet/inpulse/sigproc/filters/FilterCoeff;", "order", "", "fc1", "", "fc2", "fs", "filter", "Lvet/inpulse/sigproc/filters/IIR_TYPE;", "notch", "notchFreq", "", "notchWidth", "baselineCoeff", "baselineFreq", "sigproc"})
public final class IIR {
    @NotNull
    public static final IIR INSTANCE = new IIR();

    private IIR() {
    }

    @NotNull
    public final FilterCoeff butter(int order, float fc1, float fc2, int fs, @NotNull IIR_TYPE filter) {
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        if (order <= 0 || fc1 <= 0.0f || fc1 >= (float)(fs / 2)) {
            throw new SigProcException(SigProcErrorType.LIBSIGPROC_INVALID_INPUT, null, 2, null);
        }
        float fcc = fc1 / (float)(fs / 2);
        float fcc2 = fc2 / (float)(fs / 2);
        return switch (WhenMappings.$EnumSwitchMapping$0[filter.ordinal()]) {
            case 1 -> {
                float[] denominator = IirKt.access$denominatorCoefficientsButterworthLowPass(order, fcc);
                float[] numerator = IirKt.access$numeratorCoefficientsButterworthLowPass(order);
                float sf = IirKt.access$sfButterworthLowPass(order, fcc);
                int i = 0;
                if (i <= order) {
                    do {
                        int var12_24 = ++i;
                        numerator[var12_24] = numerator[var12_24] * sf;
                    } while (i != order);
                }
                yield new FilterCoeff(numerator, denominator);
            }
            case 2 -> {
                float[] denominator = IirKt.access$denominatorCoefficientsButterworthHighPass(order, fcc);
                float[] numerator = IirKt.access$numeratorCoefficientsButterworthHighPass(order);
                float sf = IirKt.access$sfButterworthHighPass(order, fcc);
                int i = 0;
                if (i <= order) {
                    do {
                        int var12_25 = ++i;
                        numerator[var12_25] = numerator[var12_25] * sf;
                    } while (i != order);
                }
                yield new FilterCoeff(numerator, denominator);
            }
            case 3 -> {
                if (fc2 >= (float)(fs / 2) || fc1 >= fc2) {
                    throw new SigProcException(SigProcErrorType.LIBSIGPROC_INVALID_INPUT, null, 2, null);
                }
                float[] denominator = IirKt.access$denominatorCoefficientsButterworthBandPass(order, fcc, fcc2);
                float[] numerator = IirKt.access$numeratorCoefficientsButterworthBandPass(order);
                float sf = IirKt.access$sfButterworthBandPass(order, fcc, fcc2);
                int i = 0;
                int var12_26 = numerator.length;
                while (i < var12_26) {
                    int var13_28 = i++;
                    numerator[var13_28] = numerator[var13_28] * sf;
                }
                yield new FilterCoeff(numerator, denominator);
            }
            case 4 -> {
                if (fc2 >= (float)(fs / 2) || fc1 >= fc2) {
                    throw new SigProcException(SigProcErrorType.LIBSIGPROC_INVALID_INPUT, null, 2, null);
                }
                float[] denominator = IirKt.access$denominatorCoefficientsButterworthBandStop(order, fcc, fcc2);
                float[] numerator = IirKt.access$numeratorCoefficientsButterworthBandStop(order, fcc, fcc2);
                float sf = IirKt.access$sfButterworthBandStop(order, fcc, fcc2);
                int i = 0;
                int var12_27 = numerator.length;
                while (i < var12_27) {
                    int var13_29 = i++;
                    numerator[var13_29] = numerator[var13_29] * sf;
                }
                yield new FilterCoeff(numerator, denominator);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final FilterCoeff notch(@NotNull Number notchFreq, int fs, int notchWidth) {
        Intrinsics.checkNotNullParameter((Object)notchFreq, (String)"notchFreq");
        if (notchWidth <= 0 || notchFreq.floatValue() <= 0.0f || notchFreq.floatValue() >= (float)(fs / 2) || fs <= 0) {
            throw new SigProcException(SigProcErrorType.LIBSIGPROC_INVALID_INPUT, null, 2, null);
        }
        double w = Math.PI * 2 / (double)fs * (double)notchFreq.floatValue();
        double r = 1.0 - (double)notchWidth * Math.PI / (double)fs;
        double cosw = Math.cos(w);
        double r2 = r * r;
        double den = (double)2 * Math.abs(1.0 - cosw);
        double b = Math.abs(1.0 - (double)2 * r * cosw + r2) / den;
        float[] fArray = new float[]{(float)b, (float)((double)-2 * b * cosw), (float)b};
        float[] numerator = fArray;
        float[] fArray2 = new float[]{1.0f, (float)((double)-2 * r * cosw), (float)r2};
        float[] denominator = fArray2;
        return new FilterCoeff(numerator, denominator);
    }

    @NotNull
    public final FilterCoeff baselineCoeff(int fs, float baselineFreq) {
        if (baselineFreq < 0.0f || fs <= 0) {
            throw new SigProcException(SigProcErrorType.LIBSIGPROC_INVALID_INPUT, null, 2, null);
        }
        float k = 0.7f;
        float fc = (float)2 * baselineFreq / (float)fs;
        double sqrt1 = (double)((float)2 * k) * (1.0 - Math.cos(Math.PI * 2 * (double)fc));
        double sinValue = Math.sin(Math.PI * 2 * (double)fc);
        double sqrt2 = (double)(k * k) * sinValue * sinValue;
        double num = 1.0 - (double)k * Math.cos(Math.PI * 2 * (double)fc) - Math.sqrt(sqrt1 - sqrt2);
        float den = 1.0f - k;
        double alpha = num / (double)den;
        float[] fArray = new float[]{(float)(1.0 - alpha)};
        float[] numerator = fArray;
        float[] fArray2 = new float[]{1.0f, -((float)alpha)};
        float[] denominator = fArray2;
        return new FilterCoeff(numerator, denominator);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IIR_TYPE.values().length];
            try {
                nArray[IIR_TYPE.LOW_PASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IIR_TYPE.HIGH_PASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IIR_TYPE.BAND_PASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IIR_TYPE.BAND_STOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

