/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.sigproc.filters;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\bJ\u001e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0005J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J1\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006,"}, d2={"Lvet/inpulse/sigproc/filters/FloatBuffer;", "", "samples", "", "actual_size", "", "write_id", "sum", "", "<init>", "([FIIF)V", "getSamples", "()[F", "getActual_size", "()I", "setActual_size", "(I)V", "getWrite_id", "setWrite_id", "getSum", "()F", "setSum", "(F)V", "reset", "", "put", "input", "add", "offset", "length", "get", "id", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "sigproc"})
public final class FloatBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] samples;
    private int actual_size;
    private int write_id;
    private float sum;

    public FloatBuffer(@NotNull float[] samples, int actual_size, int write_id, float sum) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        this.samples = samples;
        this.actual_size = actual_size;
        this.write_id = write_id;
        this.sum = sum;
    }

    @NotNull
    public final float[] getSamples() {
        return this.samples;
    }

    public final int getActual_size() {
        return this.actual_size;
    }

    public final void setActual_size(int n) {
        this.actual_size = n;
    }

    public final int getWrite_id() {
        return this.write_id;
    }

    public final void setWrite_id(int n) {
        this.write_id = n;
    }

    public final float getSum() {
        return this.sum;
    }

    public final void setSum(float f) {
        this.sum = f;
    }

    public final void reset() {
        this.actual_size = 0;
        this.write_id = 0;
        this.sum = 0.0f;
        int n = this.samples.length;
        for (int i = 0; i < n; ++i) {
            this.samples[i] = 0.0f;
        }
    }

    public final void put(float input) {
        this.sum += input - this.samples[this.write_id];
        this.samples[this.write_id] = input;
        ++this.write_id;
        this.write_id %= this.samples.length;
        if (this.actual_size < this.samples.length) {
            int n = this.actual_size;
            this.actual_size = n + 1;
        }
    }

    public final void add(@NotNull float[] input, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int c = this.write_id;
        for (int i = offset; i < length; ++i) {
            this.sum += input[i] - this.samples[c++];
        }
        ArraysKt.copyInto((float[])input, (float[])this.samples, (int)this.write_id, (int)offset, (int)length);
        this.write_id += length;
        this.actual_size += length;
    }

    public final float get(int id) {
        int coerced = id < 0 ? 0 : (id >= this.actual_size ? this.actual_size - 1 : id);
        int bufferIndex = this.write_id - 1 - coerced;
        if (bufferIndex < 0) {
            bufferIndex += this.samples.length;
        }
        return this.samples[bufferIndex];
    }

    @NotNull
    public final float[] component1() {
        return this.samples;
    }

    public final int component2() {
        return this.actual_size;
    }

    public final int component3() {
        return this.write_id;
    }

    public final float component4() {
        return this.sum;
    }

    @NotNull
    public final FloatBuffer copy(@NotNull float[] samples, int actual_size, int write_id, float sum) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        return new FloatBuffer(samples, actual_size, write_id, sum);
    }

    public static /* synthetic */ FloatBuffer copy$default(FloatBuffer floatBuffer, float[] fArray, int n, int n2, float f, int n3, Object object) {
        if ((n3 & 1) != 0) {
            fArray = floatBuffer.samples;
        }
        if ((n3 & 2) != 0) {
            n = floatBuffer.actual_size;
        }
        if ((n3 & 4) != 0) {
            n2 = floatBuffer.write_id;
        }
        if ((n3 & 8) != 0) {
            f = floatBuffer.sum;
        }
        return floatBuffer.copy(fArray, n, n2, f);
    }

    @NotNull
    public String toString() {
        return "FloatBuffer(samples=" + Arrays.toString(this.samples) + ", actual_size=" + this.actual_size + ", write_id=" + this.write_id + ", sum=" + this.sum + ")";
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.samples);
        result = result * 31 + Integer.hashCode(this.actual_size);
        result = result * 31 + Integer.hashCode(this.write_id);
        result = result * 31 + Float.hashCode(this.sum);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FloatBuffer)) {
            return false;
        }
        FloatBuffer floatBuffer = (FloatBuffer)other;
        if (!Intrinsics.areEqual((Object)this.samples, (Object)floatBuffer.samples)) {
            return false;
        }
        if (this.actual_size != floatBuffer.actual_size) {
            return false;
        }
        if (this.write_id != floatBuffer.write_id) {
            return false;
        }
        return Float.compare(this.sum, floatBuffer.sum) == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lvet/inpulse/sigproc/filters/FloatBuffer$Companion;", "", "<init>", "()V", "create", "Lvet/inpulse/sigproc/filters/FloatBuffer;", "size", "", "sigproc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FloatBuffer create(int size) {
            return new FloatBuffer(new float[size], 0, 0, 0.0f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

