/*
 * Decompiled with CFR 0.152.
 */
package dev.datlag.kcef.step.init;

import dev.datlag.kcef.KCEFException;
import dev.datlag.kcef.Platform;
import dev.datlag.kcef.common.ExtendCoroutineKt;
import dev.datlag.kcef.common.ExtendSystemKt;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.SystemBootstrap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0013\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u0015"}, d2={"Ldev/datlag/kcef/step/init/CefInitializer;", "", "<init>", "()V", "initialize", "Lorg/cef/CefApp;", "installDir", "Ljava/io/File;", "cefArgs", "", "", "cefSettings", "Lorg/cef/CefSettings;", "loadLibrary", "", "name", "equals", "other", "hashCode", "", "toString", "kcef"})
@SourceDebugExtension(value={"SMAP\nCefInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CefInitializer.kt\ndev/datlag/kcef/step/init/CefInitializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,137:1\n2632#2,3:138\n37#3,2:141\n37#3,2:143\n*S KotlinDebug\n*F\n+ 1 CefInitializer.kt\ndev/datlag/kcef/step/init/CefInitializer\n*L\n25#1:138,3\n60#1:141,2\n62#1:143,2\n*E\n"})
public final class CefInitializer {
    @NotNull
    public static final CefInitializer INSTANCE = new CefInitializer();

    private CefInitializer() {
    }

    @NotNull
    public final CefApp initialize(@NotNull File installDir, @NotNull Collection<String> cefArgs, @NotNull CefSettings cefSettings) {
        Object object;
        boolean success2;
        Object gpuLibPath;
        boolean bl;
        Platform.OS currentOs;
        block14: {
            Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
            Intrinsics.checkNotNullParameter(cefArgs, (String)"cefArgs");
            Intrinsics.checkNotNullParameter((Object)cefSettings, (String)"cefSettings");
            currentOs = Platform.INSTANCE.getCurrentPlatform().getOs();
            if (currentOs.isMacOSX()) {
                Intrinsics.checkNotNull((Object)currentOs, (String)"null cannot be cast to non-null type dev.datlag.kcef.Platform.OS.MACOSX");
                ExtendSystemKt.systemProperty("java.home", Platform.OS.MACOSX.getFrameworkPath$default((Platform.OS.MACOSX)currentOs, installDir, false, 2, null));
            }
            this.loadLibrary(installDir, "jawt");
            Iterable $this$none$iv = cefArgs;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"--disable-gpu", (boolean)true)) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        if (bl) {
            File file;
            if (currentOs.isMacOSX()) {
                Intrinsics.checkNotNull((Object)currentOs, (String)"null cannot be cast to non-null type dev.datlag.kcef.Platform.OS.MACOSX");
                String frameworkPath = ((Platform.OS.MACOSX)currentOs).getFrameworkPath(installDir, true);
                file = new File(frameworkPath, "Libraries");
            } else {
                file = installDir;
            }
            gpuLibPath = file;
            this.loadLibrary((File)gpuLibPath, "EGL");
            this.loadLibrary((File)gpuLibPath, "GLESv2");
            this.loadLibrary((File)gpuLibPath, "vk_swiftshader");
        }
        SystemBootstrap.setLoader(arg_0 -> CefInitializer.initialize$lambda$1(installDir, arg_0));
        gpuLibPath = cefSettings.locales_dir_path;
        if ((gpuLibPath == null || gpuLibPath.length() == 0) && !currentOs.isMacOSX()) {
            cefSettings.locales_dir_path = new File(installDir, "locales").getCanonicalPath();
        }
        if (((gpuLibPath = (CharSequence)cefSettings.resources_dir_path) == null || gpuLibPath.length() == 0) && !currentOs.isMacOSX()) {
            cefSettings.resources_dir_path = currentOs.getResourcesPath(installDir);
        }
        if ((gpuLibPath = (CharSequence)cefSettings.browser_subprocess_path) == null || gpuLibPath.length() == 0) {
            cefSettings.browser_subprocess_path = currentOs.getBrowserPath(installDir);
        }
        if (currentOs.isMacOSX()) {
            Intrinsics.checkNotNull((Object)currentOs, (String)"null cannot be cast to non-null type dev.datlag.kcef.Platform.OS.MACOSX");
            Platform.OS.MACOSX macOs = (Platform.OS.MACOSX)currentOs;
            Collection<String> $this$toTypedArray$iv = macOs.getFixedArgs(installDir, cefArgs);
            boolean $i$f$toTypedArray = false;
            Collection<String> thisCollection$iv = $this$toTypedArray$iv;
            v2 = CefApp.startup((String[])thisCollection$iv.toArray(new String[0]));
        } else {
            Collection<String> $this$toTypedArray$iv = cefArgs;
            boolean $i$f$toTypedArray = false;
            Collection<String> thisCollection$iv = $this$toTypedArray$iv;
            v2 = success2 = CefApp.startup((String[])thisCollection$iv.toArray(new String[0]));
        }
        if (!success2) {
            throw KCEFException.Startup.INSTANCE;
        }
        this.loadLibrary(installDir, "libcef");
        CefApp cefApp = CefApp.getInstanceIfAny();
        if (cefApp == null && (cefApp = (CefApp)(Result.isFailure-impl((Object)(object = ExtendCoroutineKt.scopeCatching(() -> CefInitializer.initialize$lambda$2(cefSettings)))) ? null : object)) == null) {
            CefApp cefApp2 = CefApp.getInstance();
            cefApp = cefApp2;
            Intrinsics.checkNotNullExpressionValue((Object)cefApp2, (String)"getInstance(...)");
        }
        return cefApp;
    }

    private final boolean loadLibrary(File installDir, String name) {
        Platform.OS os = Platform.INSTANCE.getCurrentPlatform().getOs();
        String ending = os.isWindows() ? ".dll" : (os.isLinux() ? ".so" : (os.isMacOSX() ? ".dylib" : ""));
        Ref.BooleanRef installDirLoaded = new Ref.BooleanRef();
        installDirLoaded.element = true;
        ExtendSystemKt.systemLoad(new File(installDir, name), (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$6(installDir, name, ending, installDirLoaded)));
        if (installDirLoaded.element) {
            return true;
        }
        Ref.BooleanRef installDirLibraryLoaded = new Ref.BooleanRef();
        installDirLibraryLoaded.element = true;
        ExtendSystemKt.systemLoadLibrary(new File(installDir, name), (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$10(installDir, name, ending, installDirLibraryLoaded)));
        if (installDirLibraryLoaded.element) {
            return true;
        }
        Ref.BooleanRef libraryLoaded = new Ref.BooleanRef();
        libraryLoaded.element = true;
        ExtendSystemKt.systemLoad(name, (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$18(name, ending, libraryLoaded)));
        return libraryLoaded.element;
    }

    @NotNull
    public String toString() {
        return "CefInitializer";
    }

    public int hashCode() {
        return -986980075;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CefInitializer)) {
            return false;
        }
        CefInitializer cfr_ignored_0 = (CefInitializer)other;
        return true;
    }

    private static final void initialize$lambda$1(File $installDir, String it) {
        Intrinsics.checkNotNull((Object)it);
        if (!INSTANCE.loadLibrary($installDir, it)) {
            System.out.println((Object)("Could not load '" + it + "' library"));
        }
    }

    private static final CefApp initialize$lambda$2(CefSettings $cefSettings) {
        return CefApp.getInstance((CefSettings)$cefSettings);
    }

    private static final Unit loadLibrary$lambda$6$lambda$5$lambda$4$lambda$3(Ref.BooleanRef $installDirLoaded) {
        $installDirLoaded.element = false;
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$6$lambda$5$lambda$4(File $installDir, String $name, String $ending, Ref.BooleanRef $installDirLoaded) {
        ExtendSystemKt.systemLoad(new File($installDir, "lib" + $name + $ending), (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$6$lambda$5$lambda$4$lambda$3($installDirLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$6$lambda$5(File $installDir, String $name, String $ending, Ref.BooleanRef $installDirLoaded) {
        ExtendSystemKt.systemLoad(new File($installDir, "lib" + $name), (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$6$lambda$5$lambda$4($installDir, $name, $ending, $installDirLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$6(File $installDir, String $name, String $ending, Ref.BooleanRef $installDirLoaded) {
        ExtendSystemKt.systemLoad(new File($installDir, $name + $ending), (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$6$lambda$5($installDir, $name, $ending, $installDirLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$10$lambda$9$lambda$8$lambda$7(Ref.BooleanRef $installDirLibraryLoaded) {
        $installDirLibraryLoaded.element = false;
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$10$lambda$9$lambda$8(File $installDir, String $name, String $ending, Ref.BooleanRef $installDirLibraryLoaded) {
        ExtendSystemKt.systemLoadLibrary(new File($installDir, "lib" + $name + $ending), (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$10$lambda$9$lambda$8$lambda$7($installDirLibraryLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$10$lambda$9(File $installDir, String $name, String $ending, Ref.BooleanRef $installDirLibraryLoaded) {
        ExtendSystemKt.systemLoadLibrary(new File($installDir, "lib" + $name), (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$10$lambda$9$lambda$8($installDir, $name, $ending, $installDirLibraryLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$10(File $installDir, String $name, String $ending, Ref.BooleanRef $installDirLibraryLoaded) {
        ExtendSystemKt.systemLoadLibrary(new File($installDir, $name + $ending), (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$10$lambda$9($installDir, $name, $ending, $installDirLibraryLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14$lambda$13$lambda$12$lambda$11(Ref.BooleanRef $libraryLoaded) {
        $libraryLoaded.element = false;
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14$lambda$13$lambda$12(String $name, String $ending, Ref.BooleanRef $libraryLoaded) {
        ExtendSystemKt.systemLoadLibrary("lib" + $name + $ending, (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14$lambda$13$lambda$12$lambda$11($libraryLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14$lambda$13(String $name, String $ending, Ref.BooleanRef $libraryLoaded) {
        ExtendSystemKt.systemLoadLibrary("lib" + $name, (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14$lambda$13$lambda$12($name, $ending, $libraryLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14(String $name, String $ending, Ref.BooleanRef $libraryLoaded) {
        ExtendSystemKt.systemLoadLibrary($name + $ending, (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14$lambda$13($name, $ending, $libraryLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15(String $name, String $ending, Ref.BooleanRef $libraryLoaded) {
        ExtendSystemKt.systemLoadLibrary($name, (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15$lambda$14($name, $ending, $libraryLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$18$lambda$17$lambda$16(String $name, String $ending, Ref.BooleanRef $libraryLoaded) {
        ExtendSystemKt.systemLoad("lib" + $name + $ending, (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$18$lambda$17$lambda$16$lambda$15($name, $ending, $libraryLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$18$lambda$17(String $name, String $ending, Ref.BooleanRef $libraryLoaded) {
        ExtendSystemKt.systemLoad("lib" + $name, (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$18$lambda$17$lambda$16($name, $ending, $libraryLoaded)));
        return Unit.INSTANCE;
    }

    private static final Unit loadLibrary$lambda$18(String $name, String $ending, Ref.BooleanRef $libraryLoaded) {
        ExtendSystemKt.systemLoad($name + $ending, (Function0<Unit>)((Function0)() -> CefInitializer.loadLibrary$lambda$18$lambda$17($name, $ending, $libraryLoaded)));
        return Unit.INSTANCE;
    }
}

