/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/internal/TheoreticalEnvelopeCalculator;", "", "samplingFrequency", "", "<init>", "(I)V", "step", "", "deltaP", "timeArray", "", "generateTheoreticalEnvelope", "", "slope", "a", "b", "repopulate", "", "maxTime", "core-signal-processing"})
public final class TheoreticalEnvelopeCalculator {
    private final float step;
    private final int deltaP;
    @NotNull
    private final List<Float> timeArray;

    public TheoreticalEnvelopeCalculator(int samplingFrequency) {
        this.step = 1.0f / (float)samplingFrequency;
        this.deltaP = 30;
        float minSlope = 3.0f;
        int capacity = (int)(2.0f * (float)this.deltaP * (float)samplingFrequency / minSlope);
        this.timeArray = new ArrayList(capacity);
    }

    @NotNull
    public final float[] generateTheoreticalEnvelope(float slope, float a, float b) {
        float t1 = (float)this.deltaP / ((float)2 * slope);
        float t2 = (float)(3 * this.deltaP) / ((float)2 * slope);
        float maxTime = (float)(2 * this.deltaP) / slope;
        this.repopulate(this.timeArray, maxTime);
        float offset = TheoreticalEnvelopeCalculator.generateTheoreticalEnvelope$firstPart(a, t1, t2, 0.0f);
        int n = this.timeArray.size();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            float t = ((Number)this.timeArray.get(n2)).floatValue();
            fArray[n2] = t < t1 ? TheoreticalEnvelopeCalculator.generateTheoreticalEnvelope$firstPart(a, t1, t2, t) - offset : (t < t2 ? TheoreticalEnvelopeCalculator.generateTheoreticalEnvelope$secondPart(a, b, t1, t2, t) - offset : TheoreticalEnvelopeCalculator.generateTheoreticalEnvelope$thirdPart(a, b, t1, t2, t) - offset);
        }
        return fArray;
    }

    public static /* synthetic */ float[] generateTheoreticalEnvelope$default(TheoreticalEnvelopeCalculator theoreticalEnvelopeCalculator, float f, float f2, float f3, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = -0.3f;
        }
        if ((n & 4) != 0) {
            f3 = -0.3f;
        }
        return theoreticalEnvelopeCalculator.generateTheoreticalEnvelope(f, f2, f3);
    }

    private final void repopulate(List<Float> $this$repopulate, float maxTime) {
        $this$repopulate.clear();
        for (float t = 0.0f; t < maxTime; t += this.step) {
            $this$repopulate.add(Float.valueOf(t));
        }
    }

    private static final float generateTheoreticalEnvelope$firstPart(float $a, float t1, float t2, float t) {
        return (float)Math.exp($a * (t1 - t)) - (float)Math.exp($a * (t2 - t));
    }

    private static final float generateTheoreticalEnvelope$secondPart(float $a, float $b, float t1, float t2, float t) {
        return 1.0f + $a / $b * (1.0f - (float)Math.exp(-$b * (t1 - t))) - (float)Math.exp($a * (t2 - t));
    }

    private static final float generateTheoreticalEnvelope$thirdPart(float $a, float $b, float t1, float t2, float t) {
        return $a / $b * (1.0f - (float)Math.exp(-$b * (t1 - t))) - $a / $b * (1.0f - (float)Math.exp(-$b * (t2 - t)));
    }
}

