/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.signalprocessing.nibp.internal.TheoreticalEnvelopeCalculator;
import vet.inpulse.core.signalprocessing.nibp.internal.TheoreticalScoreCalculatorKt;
import vet.inpulse.core.signalprocessing.nibp.internal.TheoreticalScoreCalculatorResult;
import vet.inpulse.math.SignalUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B^\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012M\b\u0002\u0010\u0004\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ6\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u00032\b\b\u0002\u0010\u001b\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010RS\u0010\u0004\u001aG\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/internal/NibpTheoreticalScoreCalculator;", "", "samplingFrequency", "", "scoreSignalBuilder", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "extendedEnvelope", "theoreticalEnvelope", "step", "", "<init>", "(ILkotlin/jvm/functions/Function3;)V", "getSamplingFrequency", "()I", "theoreticalEnvelopeCalculator", "Lvet/inpulse/core/signalprocessing/nibp/internal/TheoreticalEnvelopeCalculator;", "getTheoreticalEnvelopeCalculator", "()Lvet/inpulse/core/signalprocessing/nibp/internal/TheoreticalEnvelopeCalculator;", "theoreticalEnvelopeCalculator$delegate", "Lkotlin/Lazy;", "calculateScoreSignal", "Lvet/inpulse/core/signalprocessing/nibp/internal/TheoreticalScoreCalculatorResult;", "envelope", "leftIndex", "rightIndex", "core-signal-processing"})
@SourceDebugExtension(value={"SMAP\nTheoreticalScoreCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TheoreticalScoreCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/internal/NibpTheoreticalScoreCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n774#2:102\n865#2,2:103\n1068#2:105\n1563#2:106\n1634#2,3:107\n*S KotlinDebug\n*F\n+ 1 TheoreticalScoreCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/internal/NibpTheoreticalScoreCalculator\n*L\n71#1:102\n71#1:103,2\n72#1:105\n73#1:106\n73#1:107,3\n*E\n"})
public final class NibpTheoreticalScoreCalculator {
    private final int samplingFrequency;
    @NotNull
    private final Function3<float[], float[], Integer, double[]> scoreSignalBuilder;
    @NotNull
    private final Lazy theoreticalEnvelopeCalculator$delegate;

    public NibpTheoreticalScoreCalculator(int samplingFrequency, @NotNull Function3<? super float[], ? super float[], ? super Integer, double[]> scoreSignalBuilder) {
        Intrinsics.checkNotNullParameter(scoreSignalBuilder, (String)"scoreSignalBuilder");
        this.samplingFrequency = samplingFrequency;
        this.scoreSignalBuilder = scoreSignalBuilder;
        this.theoreticalEnvelopeCalculator$delegate = LazyKt.lazy(() -> NibpTheoreticalScoreCalculator.theoreticalEnvelopeCalculator_delegate$lambda$0(this));
    }

    public /* synthetic */ NibpTheoreticalScoreCalculator(int n, Function3 function3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            function3 = TheoreticalScoreCalculatorKt.access$getDEFAULT_CALCULATOR$p();
        }
        this(n, (Function3<? super float[], ? super float[], ? super Integer, double[]>)function3);
    }

    public final int getSamplingFrequency() {
        return this.samplingFrequency;
    }

    private final TheoreticalEnvelopeCalculator getTheoreticalEnvelopeCalculator() {
        Lazy lazy = this.theoreticalEnvelopeCalculator$delegate;
        return (TheoreticalEnvelopeCalculator)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TheoreticalScoreCalculatorResult calculateScoreSignal(@NotNull float[] envelope, @NotNull float[] theoreticalEnvelope, int leftIndex, int rightIndex, int step) {
        Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        Intrinsics.checkNotNullParameter((Object)theoreticalEnvelope, (String)"theoreticalEnvelope");
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$sortedByDescending$iv;
            IndexedValue it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            List innerEnvelope = ArraysKt.asList((float[])envelope).subList(leftIndex, rightIndex);
            int theoreticalSize = theoreticalEnvelope.length;
            if (!(theoreticalSize <= innerEnvelope.size())) {
                boolean $i$a$-require-NibpTheoreticalScoreCalculator$calculateScoreSignal$32 = false;
                String $i$a$-require-NibpTheoreticalScoreCalculator$calculateScoreSignal$32 = "Fail to calculate correlation between signals: Theoretical envelope is bigger than real one.";
                throw new IllegalArgumentException($i$a$-require-NibpTheoreticalScoreCalculator$calculateScoreSignal$32.toString());
            }
            float[] extendedEnvelope = new float[innerEnvelope.size() + theoreticalSize];
            int n = ((Collection)innerEnvelope).size();
            for (int i = 0; i < n; ++i) {
                extendedEnvelope[i + theoreticalSize / 2] = ((Number)innerEnvelope.get(i)).floatValue();
            }
            double[] scoreSignal = (double[])this.scoreSignalBuilder.invoke((Object)extendedEnvelope, (Object)theoreticalEnvelope, (Object)step);
            Iterable iterable = SignalUtilsKt.findPeaks$default((double[])scoreSignal, (double)0.0, (int)0, (double)0.0, (double)0.0, (boolean)true, (int)30, null);
            boolean $i$f$filter = false;
            void var13_19 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (IndexedValue)element$iv$iv;
                boolean bl = false;
                if (!(((Number)it.getValue()).doubleValue() > 0.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IndexedValue it = (IndexedValue)b;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getValue();
                    it = (IndexedValue)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
                }
            });
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(IndexedValue.copy$default((IndexedValue)it, (int)(it.getIndex() * step + leftIndex), null, (int)2, null));
            }
            List peaks = (List)destination$iv$iv;
            if (!(!((Collection)peaks).isEmpty())) {
                boolean bl = false;
                String string = "Failed to calculate score between theoretical and real signals: no peak found.";
                throw new IllegalArgumentException(string.toString());
            }
            return new TheoreticalScoreCalculatorResult.Success(ArraysKt.asList((double[])scoreSignal), peaks);
        }
        catch (Exception ex) {
            return new TheoreticalScoreCalculatorResult.Failed(ex);
        }
    }

    public static /* synthetic */ TheoreticalScoreCalculatorResult calculateScoreSignal$default(NibpTheoreticalScoreCalculator nibpTheoreticalScoreCalculator, float[] fArray, float[] fArray2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            fArray2 = TheoreticalEnvelopeCalculator.generateTheoreticalEnvelope$default(nibpTheoreticalScoreCalculator.getTheoreticalEnvelopeCalculator(), 6.0f, 0.0f, 0.0f, 6, null);
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = ArraysKt.getLastIndex((float[])fArray);
        }
        if ((n4 & 0x10) != 0) {
            n3 = 100;
        }
        return nibpTheoreticalScoreCalculator.calculateScoreSignal(fArray, fArray2, n, n2, n3);
    }

    private static final TheoreticalEnvelopeCalculator theoreticalEnvelopeCalculator_delegate$lambda$0(NibpTheoreticalScoreCalculator this$0) {
        return new TheoreticalEnvelopeCalculator(this$0.samplingFrequency);
    }
}

