/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.models.record_data.NibpMeasurementScores;
import vet.inpulse.core.models.record_data.NibpOscillometryData;
import vet.inpulse.core.signalprocessing.nibp.internal.NibpLinearityCalculator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/internal/NibpMeasurementScoreCalculator;", "", "samplingFrequency", "", "<init>", "(I)V", "getSamplingFrequency", "()I", "calculateScores", "Lvet/inpulse/core/models/record_data/NibpMeasurementScores;", "data", "Lvet/inpulse/core/models/record_data/NibpOscillometryData;", "systolicOutOfBounds", "", "(Lvet/inpulse/core/models/record_data/NibpOscillometryData;Ljava/lang/Boolean;)Lvet/inpulse/core/models/record_data/NibpMeasurementScores;", "calculateLinearityScore", "", "pulseScore", "rsd", "", "trustIndexCalculationA", "trustIndexCalculationB", "calculateTrustIndex", "maxCorrelation", "core-signal-processing"})
public final class NibpMeasurementScoreCalculator {
    private final int samplingFrequency;
    private final int trustIndexCalculationA;
    private final int trustIndexCalculationB;

    public NibpMeasurementScoreCalculator(int samplingFrequency) {
        this.samplingFrequency = samplingFrequency;
        this.trustIndexCalculationA = 4;
        this.trustIndexCalculationB = -75 * this.trustIndexCalculationA;
    }

    public final int getSamplingFrequency() {
        return this.samplingFrequency;
    }

    @NotNull
    public final NibpMeasurementScores calculateScores(@NotNull NibpOscillometryData data, @Nullable Boolean systolicOutOfBounds) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double linearityScore = this.calculateLinearityScore(data);
        return new NibpMeasurementScores(Double.valueOf(linearityScore), systolicOutOfBounds, null, null, null, null, 60, null);
    }

    public static /* synthetic */ NibpMeasurementScores calculateScores$default(NibpMeasurementScoreCalculator nibpMeasurementScoreCalculator, NibpOscillometryData nibpOscillometryData, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = null;
        }
        return nibpMeasurementScoreCalculator.calculateScores(nibpOscillometryData, bl);
    }

    private final double calculateLinearityScore(NibpOscillometryData data) {
        float[] deflation = data.getDeflation();
        int linearityOffset = data.getDeflation().length / 3;
        NibpLinearityCalculator.LinearityError linearityError = NibpLinearityCalculator.INSTANCE.calculateLinearityError(deflation, linearityOffset, linearityOffset);
        return NibpLinearityCalculator.INSTANCE.calculateLinearityScore(linearityError.getError());
    }

    private final double pulseScore(float rsd) {
        return (float)Math.exp(-rsd);
    }

    private final int calculateTrustIndex(float maxCorrelation) {
        float trustIndex = (float)this.trustIndexCalculationA * (maxCorrelation * (float)100) + (float)this.trustIndexCalculationB;
        return (int)(trustIndex < 0.0f ? 0.0f : (trustIndex > 100.0f ? 100.0f : trustIndex));
    }
}

