/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.signalprocessing.math_utils.MathUtilsKt;
import vet.inpulse.math.ArraysUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0011"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/internal/NibpLinearityCalculator;", "", "<init>", "()V", "calculateBestFittingAlfa", "", "deflation", "", "offsetLeft", "", "offsetRight", "calculateAlfaUsingSimpleDiff", "calculateLinearityError", "Lvet/inpulse/core/signalprocessing/nibp/internal/NibpLinearityCalculator$LinearityError;", "calculateLinearityScore", "error", "LinearityError", "core-signal-processing"})
public final class NibpLinearityCalculator {
    @NotNull
    public static final NibpLinearityCalculator INSTANCE = new NibpLinearityCalculator();

    private NibpLinearityCalculator() {
    }

    public final double calculateBestFittingAlfa(@NotNull float[] deflation, int offsetLeft, int offsetRight) {
        Intrinsics.checkNotNullParameter((Object)deflation, (String)"deflation");
        Sequence deflationCrossingZero = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)ArraysKt.asList((float[])deflation).subList(offsetLeft, deflation.length - offsetRight)), arg_0 -> NibpLinearityCalculator.calculateBestFittingAlfa$lambda$0(deflation, offsetLeft, arg_0));
        boolean bl = false;
        return ArraysUtilsKt.leastSquaresFit(MathUtilsKt.indicesAsDouble(deflation), (Sequence)deflationCrossingZero);
    }

    public final double calculateAlfaUsingSimpleDiff(@NotNull float[] deflation) {
        Intrinsics.checkNotNullParameter((Object)deflation, (String)"deflation");
        double sum = 0.0;
        int start = deflation.length / 3;
        int end = 2 * deflation.length / 3;
        int counter = 0;
        for (int i = start; i < end; ++i) {
            sum += (double)(deflation[i] - deflation[i - 1]);
            ++counter;
        }
        return sum / (double)counter;
    }

    @NotNull
    public final LinearityError calculateLinearityError(@NotNull float[] deflation, int offsetLeft, int offsetRight) {
        Intrinsics.checkNotNullParameter((Object)deflation, (String)"deflation");
        double alfa = this.calculateBestFittingAlfa(deflation, offsetLeft, offsetRight);
        double error = SequencesKt.sumOfDouble((Sequence)SequencesKt.mapIndexed((Sequence)CollectionsKt.asSequence((Iterable)ArraysKt.asList((float[])deflation).subList(offsetLeft, deflation.length - offsetRight)), (arg_0, arg_1) -> NibpLinearityCalculator.calculateLinearityError$lambda$2(alfa, deflation, offsetLeft, arg_0, arg_1)));
        return new LinearityError(error, alfa);
    }

    public static /* synthetic */ LinearityError calculateLinearityError$default(NibpLinearityCalculator nibpLinearityCalculator, float[] fArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 2000;
        }
        if ((n3 & 4) != 0) {
            n2 = 3000;
        }
        return nibpLinearityCalculator.calculateLinearityError(fArray, n, n2);
    }

    public final double calculateLinearityScore(double error) {
        int higherThreshold = 7500;
        int lowerThreshold = 20000;
        return error < (double)higherThreshold ? 1.0 : (error < (double)lowerThreshold ? Math.cos((error - (double)lowerThreshold) / (double)(lowerThreshold - higherThreshold)) : 0.0);
    }

    private static final double calculateBestFittingAlfa$lambda$0(float[] $deflation, int $offsetLeft, float it) {
        return (double)it - (double)$deflation[$offsetLeft];
    }

    private static final double calculateLinearityError$lambda$2(double $alfa, float[] $deflation, int $offsetLeft, int index, float realValue) {
        double idealValue = (double)index * $alfa;
        float deflationValueAdjustingZero = realValue - $deflation[$offsetLeft];
        return Math.abs((double)deflationValueAdjustingZero - idealValue);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/internal/NibpLinearityCalculator$LinearityError;", "", "error", "", "idealAlfa", "<init>", "(DD)V", "getError", "()D", "getIdealAlfa", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core-signal-processing"})
    public static final class LinearityError {
        private final double error;
        private final double idealAlfa;

        public LinearityError(double error, double idealAlfa) {
            this.error = error;
            this.idealAlfa = idealAlfa;
        }

        public final double getError() {
            return this.error;
        }

        public final double getIdealAlfa() {
            return this.idealAlfa;
        }

        public final double component1() {
            return this.error;
        }

        public final double component2() {
            return this.idealAlfa;
        }

        @NotNull
        public final LinearityError copy(double error, double idealAlfa) {
            return new LinearityError(error, idealAlfa);
        }

        public static /* synthetic */ LinearityError copy$default(LinearityError linearityError, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                d = linearityError.error;
            }
            if ((n & 2) != 0) {
                d2 = linearityError.idealAlfa;
            }
            return linearityError.copy(d, d2);
        }

        @NotNull
        public String toString() {
            return "LinearityError(error=" + this.error + ", idealAlfa=" + this.idealAlfa + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.error);
            result = result * 31 + Double.hashCode(this.idealAlfa);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LinearityError)) {
                return false;
            }
            LinearityError linearityError = (LinearityError)other;
            if (Double.compare(this.error, linearityError.error) != 0) {
                return false;
            }
            return Double.compare(this.idealAlfa, linearityError.idealAlfa) == 0;
        }
    }
}

