/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.signalprocessing.math_utils.MathUtilsKt;
import vet.inpulse.core.signalprocessing.nibp.internal.CorrelationResult;
import vet.inpulse.core.signalprocessing.nibp.internal.TheoreticalEnvelopeCalculator;
import vet.inpulse.math.SignalUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\rJ5\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\"\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\b\b\u0002\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010\u000e\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lvet/inpulse/core/signalprocessing/nibp/internal/NibpCorrelationCalculator;", "", "samplingFrequency", "", "<init>", "(I)V", "getSamplingFrequency", "()I", "envelopeCalculator", "Lvet/inpulse/core/signalprocessing/nibp/internal/TheoreticalEnvelopeCalculator;", "calculateCorrelationWithTheoreticalEnvelope", "Lvet/inpulse/core/signalprocessing/nibp/internal/CorrelationResult;", "envelope", "", "slope", "", "leftIndex", "rightIndex", "correlationStep", "theoreticalEnvelope", "adjustCorrelationScore", "", "maxCorrelation", "maxIndex", "secondHighest", "secondIndex", "adjustCorrelationScore$core_signal_processing", "finalAdjustment", "partialAdjusted", "sigmoid", "x", "translation", "core-signal-processing"})
@SourceDebugExtension(value={"SMAP\nNibpCorrelationCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NibpCorrelationCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/internal/NibpCorrelationCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n774#2:284\n865#2,2:285\n1068#2:287\n*S KotlinDebug\n*F\n+ 1 NibpCorrelationCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/internal/NibpCorrelationCalculator\n*L\n84#1:284\n84#1:285,2\n84#1:287\n*E\n"})
public final class NibpCorrelationCalculator {
    private final int samplingFrequency;
    @NotNull
    private final TheoreticalEnvelopeCalculator envelopeCalculator;

    public NibpCorrelationCalculator(int samplingFrequency) {
        this.samplingFrequency = samplingFrequency;
        this.envelopeCalculator = new TheoreticalEnvelopeCalculator(this.samplingFrequency);
    }

    public final int getSamplingFrequency() {
        return this.samplingFrequency;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CorrelationResult calculateCorrelationWithTheoreticalEnvelope(@NotNull float[] envelope, float slope, int leftIndex, int rightIndex, int correlationStep, @NotNull float[] theoreticalEnvelope) {
        Intrinsics.checkNotNullParameter((Object)envelope, (String)"envelope");
        Intrinsics.checkNotNullParameter((Object)theoreticalEnvelope, (String)"theoreticalEnvelope");
        try {
            void $this$sortedByDescending$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            int coercedLeft = RangesKt.coerceIn((int)leftIndex, (int)0, (int)envelope.length);
            int coercedRight = RangesKt.coerceIn((int)rightIndex, (int)coercedLeft, (int)envelope.length);
            List innerEnvelope = ArraysKt.asList((float[])envelope).subList(coercedLeft, coercedRight);
            int theoreticalSize = theoreticalEnvelope.length;
            if (!(theoreticalSize <= innerEnvelope.size())) {
                boolean $i$a$-require-NibpCorrelationCalculator$calculateCorrelationWithTheoreticalEnvelope$32 = false;
                String $i$a$-require-NibpCorrelationCalculator$calculateCorrelationWithTheoreticalEnvelope$32 = "Fail to calculate correlation between signals: Theoretical envelope is bigger than real one.";
                throw new IllegalArgumentException($i$a$-require-NibpCorrelationCalculator$calculateCorrelationWithTheoreticalEnvelope$32.toString());
            }
            float[] envelopeForCorrelation = new float[innerEnvelope.size() + theoreticalSize];
            int n = ((Collection)innerEnvelope).size();
            for (int i = 0; i < n; ++i) {
                envelopeForCorrelation[i + theoreticalSize / 2] = ((Number)innerEnvelope.get(i)).floatValue();
            }
            float[] theoreticalEnvelopeToCalc = new float[envelopeForCorrelation.length];
            int signalSize = innerEnvelope.size() / correlationStep;
            int n2 = 0;
            Object object = new double[signalSize];
            while (n2 < signalSize) {
                int n3 = n2++;
                ArraysKt.fill$default((float[])theoreticalEnvelopeToCalc, (float)0.0f, (int)0, (int)0, (int)6, null);
                ArraysKt.copyInto((float[])theoreticalEnvelope, (float[])theoreticalEnvelopeToCalc, (int)(n3 * correlationStep), (int)0, (int)theoreticalSize);
                object[n3] = MathUtilsKt.correlation(envelopeForCorrelation, 0, theoreticalEnvelopeToCalc, 0, envelopeForCorrelation.length);
            }
            double[] correlationSignal = object;
            object = SignalUtilsKt.findPeaks$default((double[])correlationSignal, (double)0.0, (int)0, (double)0.0, (double)0.0, (boolean)true, (int)30, null);
            boolean $i$f$filter = false;
            void var18_25 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IndexedValue it = (IndexedValue)element$iv$iv;
                boolean bl = false;
                if (!(((Number)it.getValue()).doubleValue() > 0.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            List peaks = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    IndexedValue it = (IndexedValue)b;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getValue();
                    it = (IndexedValue)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
                }
            });
            if (!(!((Collection)peaks).isEmpty())) {
                boolean bl = false;
                String string = "Failed to calculate correlation between theoretical signal and real one - no correlation peak found.";
                throw new IllegalArgumentException(string.toString());
            }
            int indexMax = ((IndexedValue)CollectionsKt.first((List)peaks)).getIndex();
            return new CorrelationResult.Success(ArraysKt.asList((double[])correlationSignal), indexMax);
        }
        catch (Exception ex) {
            return new CorrelationResult.Failed(ex);
        }
    }

    public static /* synthetic */ CorrelationResult calculateCorrelationWithTheoreticalEnvelope$default(NibpCorrelationCalculator nibpCorrelationCalculator, float[] fArray, float f, int n, int n2, int n3, float[] fArray2, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n3 = 100;
        }
        if ((n4 & 0x20) != 0) {
            fArray2 = TheoreticalEnvelopeCalculator.generateTheoreticalEnvelope$default(nibpCorrelationCalculator.envelopeCalculator, f, 0.0f, 0.0f, 6, null);
        }
        return nibpCorrelationCalculator.calculateCorrelationWithTheoreticalEnvelope(fArray, f, n, n2, n3, fArray2);
    }

    public final double adjustCorrelationScore$core_signal_processing(double maxCorrelation, int maxIndex, double secondHighest, int secondIndex, int correlationStep) {
        int distance = Math.abs(maxIndex - secondIndex) * correlationStep;
        int zeroScoreDistance = 1800;
        int fullScoreDistance = 8000;
        int a = zeroScoreDistance;
        int b = fullScoreDistance - zeroScoreDistance;
        double adjustmentFactor = 1.0 - (distance < zeroScoreDistance ? Math.pow(distance - a, 2) / Math.pow(a, 2) : (distance < fullScoreDistance ? (double)(distance - a) / (double)b : 1.0));
        double partialAdjusted = maxCorrelation - 0.1 * adjustmentFactor * secondHighest;
        return this.finalAdjustment(partialAdjusted);
    }

    private final double finalAdjustment(double partialAdjusted) {
        double translation = 0.3;
        double sigmoidSlope = 12.0;
        double finalCorrelation = this.sigmoid(partialAdjusted, translation, sigmoidSlope);
        return RangesKt.coerceAtLeast((double)finalCorrelation, (double)0.0);
    }

    public final double sigmoid(double x, double translation, double slope) {
        double den = 1.0 + Math.exp(-slope * (x - translation));
        return 1.0 / den;
    }

    public static /* synthetic */ double sigmoid$default(NibpCorrelationCalculator nibpCorrelationCalculator, double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 1.0;
        }
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        return nibpCorrelationCalculator.sigmoid(d, d2, d3);
    }
}

