/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp.internal;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.math.MaxIndexDouble;
import vet.inpulse.math.SignalUtilsKt;
import vet.inpulse.math.complex.Complex;
import vet.inpulse.math.complex.ComplexArray;
import vet.inpulse.math.fft.FftKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/internal/CrestFactorCalculator;", "", "<init>", "()V", "Companion", "core-signal-processing"})
public final class CrestFactorCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JI\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000eJ5\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\f\u001a\u00020\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/internal/CrestFactorCalculator$Companion;", "", "<init>", "()V", "crestFactor", "Lkotlin/Pair;", "", "", "data", "", "offset", "length", "windowSize", "indexMax", "([FIIILjava/lang/Integer;)Lkotlin/Pair;", "signal", "Lvet/inpulse/math/complex/ComplexArray;", "(Lvet/inpulse/math/complex/ComplexArray;ILjava/lang/Integer;)Lkotlin/Pair;", "crestFactorScore", "core-signal-processing"})
    @SourceDebugExtension(value={"SMAP\nCrestFactorCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrestFactorCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/internal/CrestFactorCalculator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,92:1\n1#2:93\n13870#3,3:94\n*S KotlinDebug\n*F\n+ 1 CrestFactorCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/internal/CrestFactorCalculator$Companion\n*L\n51#1:94,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<Double, Integer> crestFactor(@NotNull float[] data, int offset, int length, int windowSize, @Nullable Integer indexMax) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ComplexArray signal = new ComplexArray(length);
            Complex tempComplex = new Complex(0.0, 0.0, 3, null);
            for (int i = 0; i < length; ++i) {
                tempComplex.setReal((double)data[offset + i]);
                signal.set(i, tempComplex);
            }
            return this.crestFactor(signal, windowSize, indexMax);
        }

        public static /* synthetic */ Pair crestFactor$default(Companion companion, float[] fArray, int n, int n2, int n3, Integer n4, int n5, Object object) {
            if ((n5 & 2) != 0) {
                n = 0;
            }
            if ((n5 & 4) != 0) {
                n2 = fArray.length;
            }
            if ((n5 & 8) != 0) {
                n3 = 512;
            }
            if ((n5 & 0x10) != 0) {
                n4 = null;
            }
            return companion.crestFactor(fArray, n, n2, n3, n4);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<Double, Integer> crestFactor(@NotNull ComplexArray signal, int windowSize, @Nullable Integer indexMax) {
            Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
            if (!SignalUtilsKt.intIsBinary((int)windowSize)) {
                boolean $i$a$-require-CrestFactorCalculator$Companion$crestFactor$22 = false;
                String $i$a$-require-CrestFactorCalculator$Companion$crestFactor$22 = "windowSize must be binary";
                throw new IllegalArgumentException($i$a$-require-CrestFactorCalculator$Companion$crestFactor$22.toString());
            }
            int timeSteps = signal.getSize() / windowSize;
            int n = 0;
            int n2 = signal.getSize() / windowSize;
            double[][] dArrayArray = new double[n2][];
            while (n < n2) {
                int n3 = n++;
                dArrayArray[n3] = new double[windowSize / 2];
            }
            double[][] powers = dArrayArray;
            FftKt.spectrogram((ComplexArray)signal, (int)0, (int)1, (int)signal.getSize(), (int)windowSize);
            Object[] $this$forEachIndexed$iv = (Object[])powers;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void storage;
                int n4 = index$iv++;
                double[] dArray = (double[])item$iv;
                int i = n4;
                boolean bl = false;
                FftKt.realSpectralPower((ComplexArray)signal, (int)(i * windowSize), (int)1, (int)windowSize, (double[])storage, (int)0, (int)1);
            }
            double[][] transposedPowers = ArraysUtilsKt.transpose((double[][])powers);
            MaxIndexDouble maxIndexDouble = indexMax == null ? SignalUtilsKt.maxIndex((double[])transposedPowers[1], (int)6, (int)1, (int)(timeSteps - 2 - 6)) : new MaxIndexDouble(transposedPowers[1][indexMax], indexMax.intValue());
            double maxValue1 = maxIndexDouble.component1();
            int index1 = maxIndexDouble.component2();
            MaxIndexDouble maxIndexDouble2 = indexMax == null ? SignalUtilsKt.maxIndex((double[])transposedPowers[2], (int)6, (int)1, (int)(timeSteps - 2 - 6)) : new MaxIndexDouble(transposedPowers[2][indexMax], indexMax.intValue());
            double maxValue2 = maxIndexDouble2.component1();
            int index2 = maxIndexDouble2.component2();
            MaxIndexDouble maxIndexDouble3 = indexMax == null ? SignalUtilsKt.maxIndex((double[])transposedPowers[3], (int)6, (int)1, (int)(timeSteps - 2 - 6)) : new MaxIndexDouble(transposedPowers[3][indexMax], indexMax.intValue());
            double maxValue3 = maxIndexDouble3.component1();
            int index3 = maxIndexDouble3.component2();
            double mean1 = SignalUtilsKt.mean((double[])transposedPowers[1], (int)3, (int)2);
            double mean2 = SignalUtilsKt.mean((double[])transposedPowers[2], (int)3, (int)2);
            double mean3 = SignalUtilsKt.mean((double[])transposedPowers[3], (int)3, (int)2);
            double[] dArray = new double[]{maxValue1, maxValue2, maxValue3};
            double[] maxValues = dArray;
            double[] dArray2 = new double[]{mean1, mean2, mean3};
            double[] meanValues = dArray2;
            Object object = new int[]{index1, index2, index3};
            int[] maxIndexes = object;
            object = SignalUtilsKt.maxIndex$default((double[])maxValues, (int)0, (int)0, (int)0, (int)14, null);
            double maxValue = object.component1();
            int maxIndex = object.component2();
            return TuplesKt.to((Object)(maxValue / meanValues[maxIndex]), (Object)maxIndexes[maxIndex]);
        }

        public static /* synthetic */ Pair crestFactor$default(Companion companion, ComplexArray complexArray, int n, Integer n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 512;
            }
            if ((n3 & 4) != 0) {
                n2 = null;
            }
            return companion.crestFactor(complexArray, n, n2);
        }

        public final double crestFactorScore(double crestFactor) {
            double timeConstant = 1.8333333333333333;
            double t = RangesKt.coerceAtLeast((double)(crestFactor / (double)100 - 0.2), (double)0.0);
            return 1.0 - Math.exp(-t / timeConstant);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

