/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.nibp.experimental;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.record_data.NibpOscillometryData;
import vet.inpulse.core.models.utils.SignalProcessingAlgorithmVersion;
import vet.inpulse.core.signalprocessing.filters.MovingAverageFilter;
import vet.inpulse.core.signalprocessing.math_utils.MathUtilsKt;
import vet.inpulse.core.signalprocessing.nibp.CommonNibpCalculator;
import vet.inpulse.math.SignalUtilsKt;
import vet.inpulse.sigproc.filters.CombinedFilter;
import vet.inpulse.sigproc.filters.Filter;
import vet.inpulse.sigproc.filters.IIR;
import vet.inpulse.sigproc.filters.IIR_TYPE;
import vet.inpulse.sigproc.filters.SimpleFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u001f\u001a\u00020 *\u00020!H\u0016J\u001c\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010#\u001a\u00020\u0016H\u0002J$\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010'\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,H\u0002J(\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010(\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lvet/inpulse/core/signalprocessing/nibp/experimental/ModifiedSimpleNibpCalculator;", "Lvet/inpulse/core/signalprocessing/nibp/CommonNibpCalculator;", "samplingFrequency", "", "<init>", "(I)V", "version", "Lvet/inpulse/core/models/utils/SignalProcessingAlgorithmVersion;", "getVersion", "()Lvet/inpulse/core/models/utils/SignalProcessingAlgorithmVersion;", "originalPeak", "", "Lkotlin/collections/IndexedValue;", "", "getOriginalPeak", "()Ljava/util/List;", "setOriginalPeak", "(Ljava/util/List;)V", "peaksWithoutArtifactsClass", "getPeaksWithoutArtifactsClass", "setPeaksWithoutArtifactsClass", "arrayUsedToFindPeaks", "", "getArrayUsedToFindPeaks", "()[F", "setArrayUsedToFindPeaks", "([F)V", "movingAverageFilter", "Lvet/inpulse/core/signalprocessing/filters/MovingAverageFilter;", "getMovingAverageFilter", "()Lvet/inpulse/core/signalprocessing/filters/MovingAverageFilter;", "calculateEnvelopes", "", "Lvet/inpulse/core/models/record_data/NibpOscillometryData;", "findPeaks", "oscillometry", "interpolatePeaks", "", "peaks", "oscillometrySize", "trustIndexCalculationA", "trustIndexCalculationB", "calculateTrustIndex", "maxCorrelation", "", "removeArtifacts", "originalPeaks", "core-signal-processing"})
@SourceDebugExtension(value={"SMAP\nModifiedSimpleNibpCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifiedSimpleNibpCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/experimental/ModifiedSimpleNibpCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1056#2:124\n1878#2,3:125\n1869#2,2:128\n*S KotlinDebug\n*F\n+ 1 ModifiedSimpleNibpCalculator.kt\nvet/inpulse/core/signalprocessing/nibp/experimental/ModifiedSimpleNibpCalculator\n*L\n67#1:124\n74#1:125,3\n104#1:128,2\n*E\n"})
public final class ModifiedSimpleNibpCalculator
extends CommonNibpCalculator {
    @NotNull
    private final SignalProcessingAlgorithmVersion version = new SignalProcessingAlgorithmVersion("MODIFIED-0.1");
    @NotNull
    private List<IndexedValue<Double>> originalPeak = CollectionsKt.emptyList();
    @NotNull
    private List<IndexedValue<Double>> peaksWithoutArtifactsClass = CollectionsKt.emptyList();
    @NotNull
    private float[] arrayUsedToFindPeaks = new float[0];
    @NotNull
    private final MovingAverageFilter movingAverageFilter = new MovingAverageFilter(3, null, 2, null);
    private final int trustIndexCalculationA;
    private final int trustIndexCalculationB = -75 * this.trustIndexCalculationA;

    public ModifiedSimpleNibpCalculator(int samplingFrequency) {
        super(samplingFrequency);
        this.trustIndexCalculationA = 4;
    }

    @NotNull
    public SignalProcessingAlgorithmVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final List<IndexedValue<Double>> getOriginalPeak() {
        return this.originalPeak;
    }

    public final void setOriginalPeak(@NotNull List<IndexedValue<Double>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.originalPeak = list;
    }

    @NotNull
    public final List<IndexedValue<Double>> getPeaksWithoutArtifactsClass() {
        return this.peaksWithoutArtifactsClass;
    }

    public final void setPeaksWithoutArtifactsClass(@NotNull List<IndexedValue<Double>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.peaksWithoutArtifactsClass = list;
    }

    @NotNull
    public final float[] getArrayUsedToFindPeaks() {
        return this.arrayUsedToFindPeaks;
    }

    public final void setArrayUsedToFindPeaks(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.arrayUsedToFindPeaks = fArray;
    }

    @NotNull
    public final MovingAverageFilter getMovingAverageFilter() {
        return this.movingAverageFilter;
    }

    @Override
    public void calculateEnvelopes(@NotNull NibpOscillometryData $this$calculateEnvelopes) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateEnvelopes, (String)"<this>");
        List<IndexedValue<Double>> peaksFound = this.findPeaks($this$calculateEnvelopes.getOscillometry());
        List<IndexedValue<Double>> peaksWithoutArtifacts = this.removeArtifacts(peaksFound);
        this.originalPeak = peaksFound;
        this.peaksWithoutArtifactsClass = peaksWithoutArtifacts;
        double[] interpolated = this.interpolatePeaks(peaksWithoutArtifacts, $this$calculateEnvelopes.getOscillometry().length);
        int n = 0;
        int n2 = interpolated.length;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = (float)interpolated[n3];
        }
        float[] interpolFloat = fArray;
        MathUtilsKt.lowPassSignal(interpolFloat, $this$calculateEnvelopes.getRoughEnvelope(), this.getSamplingFrequency(), 0.4f, 2);
        MathUtilsKt.lowPassSignal($this$calculateEnvelopes.getRoughEnvelope(), $this$calculateEnvelopes.getEnvelope(), this.getSamplingFrequency(), 0.15f, 2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IndexedValue<Double>> findPeaks(float[] oscillometry) {
        void $this$sortedBy$iv;
        float[] filtered = new float[oscillometry.length];
        MathUtilsKt.filtFiltSignal(oscillometry, filtered, this.getSamplingFrequency(), (Function1<? super CombinedFilter, Unit>)((Function1)arg_0 -> ModifiedSimpleNibpCalculator.findPeaks$lambda$0(this, arg_0)));
        this.arrayUsedToFindPeaks = filtered;
        int n = 0;
        int n2 = oscillometry.length;
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = RangesKt.coerceAtLeast((float)filtered[n3], (float)0.0f);
        }
        double[] inputToFindPeaks = dArray;
        Iterable iterable = SignalUtilsKt.findPeaks$default((double[])inputToFindPeaks, (double)0.0, (int)0, (double)0.0, (double)0.0, (boolean)false, (int)62, null);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IndexedValue it = (IndexedValue)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedValue)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final double[] interpolatePeaks(List<IndexedValue<Double>> peaks, int oscillometrySize) {
        double[] x = new double[peaks.size() + 2];
        double[] y = new double[peaks.size() + 2];
        Iterable $this$forEachIndexed$iv = peaks;
        int $i$f$forEachIndexed = 0;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void peak;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IndexedValue indexedValue = (IndexedValue)item$iv;
            int index = n;
            boolean bl = false;
            x[index + 1] = peak.getIndex();
            y[index + 1] = ((Number)peak.getValue()).doubleValue();
        }
        x[ArraysKt.getLastIndex((double[])x)] = (double)oscillometrySize - 1.0;
        $i$f$forEachIndexed = 0;
        double[] dArray = new double[oscillometrySize];
        while ($i$f$forEachIndexed < oscillometrySize) {
            int n = $i$f$forEachIndexed++;
            dArray[n] = n;
        }
        double[] oscIndices = dArray;
        double[] interpolated = new double[oscillometrySize];
        SignalUtilsKt.linearInterpolate((double[])x, (double[])y, (double[])oscIndices, (double[])interpolated);
        return interpolated;
    }

    private final int calculateTrustIndex(float maxCorrelation) {
        float trustIndex = (float)this.trustIndexCalculationA * (maxCorrelation * (float)100) + (float)this.trustIndexCalculationB;
        return (int)(trustIndex < 0.0f ? 0.0f : (trustIndex > 100.0f ? 100.0f : trustIndex));
    }

    private final List<IndexedValue<Double>> removeArtifacts(List<IndexedValue<Double>> originalPeaks) {
        List withoutArtifacts = CollectionsKt.toMutableList((Collection)originalPeaks);
        Iterable $this$forEach$iv = originalPeaks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexedValue peak = (IndexedValue)element$iv;
            boolean bl = false;
            float peakValue = (float)((Number)peak.getValue()).doubleValue();
            if (!this.movingAverageFilter.isBufferFull()) {
                this.movingAverageFilter.add(peakValue);
                continue;
            }
            float mean = this.movingAverageFilter.getMean();
            if (peakValue > (float)3 * mean) {
                withoutArtifacts.remove(peak);
                continue;
            }
            this.movingAverageFilter.add(peakValue);
        }
        return withoutArtifacts;
    }

    private static final Unit findPeaks$lambda$0(ModifiedSimpleNibpCalculator this$0, CombinedFilter $this$filtFiltSignal) {
        Intrinsics.checkNotNullParameter((Object)$this$filtFiltSignal, (String)"$this$filtFiltSignal");
        $this$filtFiltSignal.add((Filter)new SimpleFilter(this$0.getSamplingFrequency(), IIR.INSTANCE.butter(2, 1.6f, 0.0f, this$0.getSamplingFrequency(), IIR_TYPE.LOW_PASS)));
        return Unit.INSTANCE;
    }
}

