/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.ecg.online_detector;

import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.signalprocessing.ecg.online_detector.ThresholdCalculator;
import vet.inpulse.core.signalprocessing.filters.MovingAverageFilter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lvet/inpulse/core/signalprocessing/ecg/online_detector/NonlinearDecayThresholdCalculator;", "Lvet/inpulse/core/signalprocessing/ecg/online_detector/ThresholdCalculator;", "minThreshold", "", "minInterval", "", "maxInterval", "<init>", "(FII)V", "currentThreshold", "getCurrentThreshold", "()F", "setCurrentThreshold", "(F)V", "lastThreshold", "currentTau", "filterPeaks", "Lvet/inpulse/core/signalprocessing/filters/MovingAverageFilter;", "decaySamplesCounter", "Lkotlinx/atomicfu/AtomicInt;", "updateTimeConstant", "hrvInSamples", "(Ljava/lang/Float;)F", "updatePeaksInterval", "", "setNewThreshold", "peakValue", "decayThreshold", "core-signal-processing"})
public final class NonlinearDecayThresholdCalculator
implements ThresholdCalculator {
    private final float minThreshold;
    private final int minInterval;
    private final int maxInterval;
    private float currentThreshold;
    private float lastThreshold;
    private float currentTau;
    @NotNull
    private final MovingAverageFilter filterPeaks;
    @NotNull
    private final AtomicInt decaySamplesCounter;

    public NonlinearDecayThresholdCalculator(float minThreshold, int minInterval, int maxInterval) {
        this.minThreshold = minThreshold;
        this.minInterval = minInterval;
        this.maxInterval = maxInterval;
        this.currentThreshold = this.minThreshold;
        this.currentTau = this.updateTimeConstant(null);
        this.filterPeaks = new MovingAverageFilter(4, null, 2, null);
        this.decaySamplesCounter = AtomicFU.atomic((int)0);
    }

    @Override
    public float getCurrentThreshold() {
        return this.currentThreshold;
    }

    public void setCurrentThreshold(float f) {
        this.currentThreshold = f;
    }

    private final float updateTimeConstant(Float hrvInSamples) {
        float minimumTau = (float)this.minInterval * 0.6f;
        float maximumTau = (float)this.maxInterval * 0.3f;
        return hrvInSamples != null ? RangesKt.coerceIn((float)(hrvInSamples.floatValue() * 0.6f), (float)minimumTau, (float)maximumTau) : maximumTau;
    }

    @Override
    public void updatePeaksInterval(float hrvInSamples) {
        this.currentTau = this.updateTimeConstant(Float.valueOf(hrvInSamples));
    }

    @Override
    public void setNewThreshold(float peakValue) {
        float f;
        this.decaySamplesCounter.setValue(0);
        float peakAverage = this.filterPeaks.getMean();
        this.filterPeaks.add(peakValue);
        if (this.filterPeaks.isBufferFull() && peakValue > peakAverage) {
            float peakDelta = RangesKt.coerceAtLeast((float)(peakValue - peakAverage), (float)0.0f);
            float tau = peakAverage / 2.5f;
            f = peakDelta * (float)Math.exp(-peakDelta / tau) + peakAverage;
        } else {
            f = peakValue;
        }
        this.setCurrentThreshold(f);
        this.lastThreshold = this.getCurrentThreshold();
    }

    @Override
    public void decayThreshold() {
        float f;
        int t = this.decaySamplesCounter.getAndIncrement();
        if ((float)t <= (float)5 * this.currentTau) {
            float gain = RangesKt.coerceAtLeast((float)(this.lastThreshold - this.minThreshold), (float)0.0f);
            f = gain * (float)Math.exp((float)(-t) / this.currentTau) + this.minThreshold;
        } else {
            f = this.minThreshold;
        }
        this.setCurrentThreshold(f);
    }
}

