/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.ecg;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.math.SignalUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lvet/inpulse/core/signalprocessing/ecg/Poincare;", "", "<init>", "()V", "calculateParameters", "", "data", "core-signal-processing"})
@SourceDebugExtension(value={"SMAP\nPoincare.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Poincare.kt\nvet/inpulse/core/signalprocessing/ecg/Poincare\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public final class Poincare {
    @NotNull
    public static final Poincare INSTANCE = new Poincare();

    private Poincare() {
    }

    @NotNull
    public final float[] calculateParameters(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(data.length > 2)) {
            boolean $i$a$-require-Poincare$calculateParameters$22 = false;
            String $i$a$-require-Poincare$calculateParameters$22 = "Data must have at least 3 elements";
            throw new IllegalArgumentException($i$a$-require-Poincare$calculateParameters$22.toString());
        }
        float[] parameters = new float[5];
        float[] X1 = new float[data.length - 1];
        float[] X1_ = new float[data.length - 1];
        float[] X2 = new float[data.length - 1];
        float[] X2_ = new float[data.length - 1];
        ArraysKt.copyInto((float[])data, (float[])X1, (int)0, (int)0, (int)X1.length);
        ArraysKt.copyInto((float[])data, (float[])X2, (int)0, (int)1, (int)X2.length);
        int n = X1.length;
        for (int i = 0; i < n; ++i) {
            X1_[i] = (X1[i] - X2[i]) / (float)Math.sqrt(2.0f);
            X2_[i] = (X1[i] + X2[i]) / (float)Math.sqrt(2.0f);
        }
        float x1Dev = SignalUtilsKt.stddev((float[])X1_);
        float x2Dev = SignalUtilsKt.stddev((float[])X2_);
        parameters[0] = x1Dev;
        parameters[1] = x2Dev;
        parameters[2] = (float)((double)((float)Math.sqrt((float)Math.pow(x1Dev, 2) + (float)Math.pow(x2Dev, 2))) / Math.sqrt(2.0));
        parameters[3] = (float)Math.log10(x1Dev * x2Dev);
        parameters[4] = x2Dev / x1Dev;
        return parameters;
    }
}

