/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.ecg;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0006\n\u0002\u0010\u0013\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\tJ\u0014\u0010\u0004\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u000f\u00a8\u0006\u0015"}, d2={"Lvet/inpulse/core/signalprocessing/ecg/Linear;", "", "<init>", "()V", "mean", "", "data", "", "", "", "", "sdnn", "rmssd", "sum", "max", "", "", "min", "log", "x", "base", "core-signal-processing"})
public final class Linear {
    @NotNull
    public static final Linear INSTANCE = new Linear();

    private Linear() {
    }

    public final float mean(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float sum = 0.0f;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            float f = data[i];
            sum += f;
        }
        return sum / (float)data.length;
    }

    public final double mean(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double sum = 0.0;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            double f = data[i];
            sum += f;
        }
        return sum / (double)data.length;
    }

    public final double mean(@NotNull List<Float> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        double sum = 0.0;
        Iterator<Float> iterator = data.iterator();
        while (iterator.hasNext()) {
            float f = ((Number)iterator.next()).floatValue();
            sum += (double)f;
        }
        return sum / (double)data.size();
    }

    public final float sdnn(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float sum = 0.0f;
        float m = this.mean(data);
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            float f = data[i];
            sum += (f - m) * (f - m);
        }
        return (float)Math.sqrt(sum / (float)data.length);
    }

    public final double sdnn(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double sum = 0.0;
        double m = this.mean(data);
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            double f = data[i];
            sum += (f - m) * (f - m);
        }
        return Math.sqrt(sum / (double)data.length);
    }

    public final float rmssd(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float sum = 0.0f;
        float value = 0.0f;
        int n = data.length;
        for (int i = 1; i < n; ++i) {
            value = data[i] - data[i - 1];
            sum += value * value;
        }
        return (float)Math.sqrt(sum / (float)(data.length - 1));
    }

    public final double rmssd(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double sum = 0.0;
        double value = 0.0;
        int n = data.length;
        for (int i = 1; i < n; ++i) {
            value = data[i] - data[i - 1];
            sum += value * value;
        }
        return Math.sqrt(sum / (double)(data.length - 1));
    }

    public final float sum(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float sum = 0.0f;
        for (float d : data) {
            sum += d;
        }
        return sum;
    }

    public final double sum(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double sum = 0.0;
        for (double d : data) {
            sum += d;
        }
        return sum;
    }

    public final float max(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float max = Float.MIN_VALUE;
        for (float d : data) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public final int max(@NotNull int[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int max = Integer.MIN_VALUE;
        for (int d : data) {
            if (d <= max) continue;
            max = d;
        }
        return max;
    }

    public final float min(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float min = Float.MAX_VALUE;
        for (float d : data) {
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public final float log(int x, int base) {
        return (float)(Math.log(x) / Math.log(base));
    }

    public final float log(float x, int base) {
        return (float)(Math.log(x) / Math.log(base));
    }

    public final double log(double x, int base) {
        return Math.log(x) / Math.log(base);
    }
}

