/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.signalprocessing.ecg;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.signalprocessing.ecg.Linear;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\u0010\u0007\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0004\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\fJ'\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\u0002\u0010\u0014J\u0019\u0010\u0015\u001a\u00020\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\f\u00a8\u0006\u0019"}, d2={"Lvet/inpulse/core/signalprocessing/ecg/Entropy;", "", "<init>", "()V", "approximate", "", "n", "", "r", "data", "", "", "", "sample", "repmat", "", "size", "([[DI)[[D", "subtractABS", "data1", "([[D[[D)[[D", "max", "([[D)[D", "getArrayDistance", "sum", "core-signal-processing"})
public final class Entropy {
    @NotNull
    public static final Entropy INSTANCE = new Entropy();

    private Entropy() {
    }

    public final double approximate(int n, double r, @NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double[] correlation = new double[2];
        int i = n;
        int n2 = n + 1;
        if (i <= n2) {
            while (true) {
                boolean set = false;
                double count = 0.0;
                double[] counter = new double[data.length - i + 1];
                int j = 0;
                int n3 = data.length - i;
                if (j <= n3) {
                    while (true) {
                        double[] current_window = new double[i];
                        ArraysKt.copyInto((double[])data, (double[])current_window, (int)0, (int)j, (int)(j + i));
                        int k = 0;
                        int n4 = data.length - i;
                        if (k <= n4) {
                            while (true) {
                                double[] sliding_window = new double[i];
                                ArraysKt.copyInto((double[])data, (double[])sliding_window, (int)0, (int)k, (int)(k + i));
                                for (int l = 0; l < i; ++l) {
                                    if (!(Math.abs(current_window[l] - sliding_window[l]) > r) || set) continue;
                                    set = true;
                                }
                                if (!set) {
                                    count += 1.0;
                                }
                                set = false;
                                if (k == n4) break;
                                ++k;
                            }
                        }
                        counter[j] = count / (double)(data.length - i + 1);
                        count = 0.0;
                        if (j == n3) break;
                        ++j;
                    }
                }
                correlation[i - n] = Linear.INSTANCE.sum(counter) / (double)(data.length - i + 1);
                if (i == n2) break;
                ++i;
            }
        }
        return Math.log(correlation[0] / correlation[1]);
    }

    public final float approximate(int n, double r, @NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float[] correlation = new float[2];
        int i = n;
        int n2 = n + 1;
        if (i <= n2) {
            while (true) {
                boolean set = false;
                float count = 0.0f;
                float[] counter = new float[data.length - i + 1];
                int j = 0;
                int n3 = data.length - i;
                if (j <= n3) {
                    while (true) {
                        float[] current_window = new float[i];
                        ArraysKt.copyInto((float[])data, (float[])current_window, (int)0, (int)j, (int)(j + i));
                        int k = 0;
                        int n4 = data.length - i;
                        if (k <= n4) {
                            while (true) {
                                float[] sliding_window = new float[i];
                                ArraysKt.copyInto((float[])data, (float[])sliding_window, (int)0, (int)k, (int)(k + i));
                                for (int l = 0; l < i; ++l) {
                                    if (!(Math.abs((double)(current_window[l] - sliding_window[l])) > r) || set) continue;
                                    set = true;
                                }
                                if (!set) {
                                    count += 1.0f;
                                }
                                set = false;
                                if (k == n4) break;
                                ++k;
                            }
                        }
                        counter[j] = count / (float)(data.length - i + 1);
                        count = 0.0f;
                        if (j == n3) break;
                        ++j;
                    }
                }
                correlation[i - n] = Linear.INSTANCE.sum(counter) / (float)(data.length - i + 1);
                if (i == n2) break;
                ++i;
            }
        }
        return (float)Math.log(correlation[0] / correlation[1]);
    }

    public final double sample(int n, double r, @NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int size = data.length;
        double[] correlation = new double[2];
        int n2 = 0;
        int n3 = n + 1;
        double[][] dArrayArray = new double[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            dArrayArray[n4] = new double[size - n];
        }
        double[][] dataMat = dArrayArray;
        int i = 0;
        if (i <= n) {
            while (true) {
                ArraysKt.copyInto((double[])data, (double[])dataMat[i], (int)0, (int)i, (int)(i + size - n));
                if (i == n) break;
                ++i;
            }
        }
        if ((i = n) <= (n3 = n + 1)) {
            while (true) {
                int j;
                double[] count = new double[size - n];
                int n5 = 0;
                int n6 = i;
                double[][] dArrayArray2 = new double[n6][];
                while (n5 < n6) {
                    int n7 = n5++;
                    dArrayArray2[n7] = new double[size - n];
                }
                double[][] tempMat = dArrayArray2;
                for (j = 0; j < i; ++j) {
                    ArraysKt.copyInto((double[])dataMat[j], (double[])tempMat[j], (int)0, (int)0, (int)(size - n));
                }
                n6 = size - i;
                for (j = 1; j < n6; ++j) {
                    int k;
                    int n8;
                    int n9 = 0;
                    int n10 = ((Object[])tempMat).length;
                    double[][] dArrayArray3 = new double[n10][];
                    while (n9 < n10) {
                        int n11 = n9++;
                        dArrayArray3[n11] = new double[size - n - j];
                    }
                    double[][] temp = dArrayArray3;
                    n10 = 0;
                    int n12 = ((Object[])tempMat).length;
                    double[][] dArrayArray4 = new double[n12][];
                    while (n10 < n12) {
                        n8 = n10++;
                        dArrayArray4[n8] = new double[1];
                    }
                    double[][] value = dArrayArray4;
                    n12 = size - n - j;
                    for (k = 0; k < n12; ++k) {
                        n8 = ((Object[])tempMat).length;
                        for (int l = 0; l < n8; ++l) {
                            temp[l][k] = tempMat[l][k + j];
                        }
                    }
                    n12 = ((Object[])tempMat).length;
                    for (k = 0; k < n12; ++k) {
                        value[k][0] = tempMat[k][j - 1];
                    }
                    double[][] repmat = this.repmat(value, size - n - j);
                    double[][] subsdata = this.subtractABS(temp, repmat);
                    double[] dist = this.max(subsdata);
                    double[] dBool = this.getArrayDistance(dist, r);
                    count[j - 1] = this.sum(dBool) / (double)(size - n);
                }
                correlation[i - n] = this.sum(count) / (double)(size - n);
                if (i == n3) break;
                ++i;
            }
        }
        return Math.log(correlation[0] / correlation[1]);
    }

    public final float sample(int n, double r, @NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int size = data.length;
        float[] correlation = new float[2];
        int n2 = 0;
        int n3 = n + 1;
        float[][] fArrayArray = new float[n3][];
        while (n2 < n3) {
            int n4 = n2++;
            fArrayArray[n4] = new float[size - n];
        }
        float[][] dataMat = fArrayArray;
        int i = 0;
        if (i <= n) {
            while (true) {
                ArraysKt.copyInto((float[])data, (float[])dataMat[i], (int)0, (int)i, (int)(i + size - n));
                if (i == n) break;
                ++i;
            }
        }
        if ((i = n) <= (n3 = n + 1)) {
            while (true) {
                int j;
                float[] count = new float[size - n];
                int n5 = 0;
                int n6 = i;
                float[][] fArrayArray2 = new float[n6][];
                while (n5 < n6) {
                    int n7 = n5++;
                    fArrayArray2[n7] = new float[size - n];
                }
                float[][] tempMat = fArrayArray2;
                for (j = 0; j < i; ++j) {
                    ArraysKt.copyInto((float[])dataMat[j], (float[])tempMat[j], (int)0, (int)0, (int)(size - n));
                }
                n6 = size - i;
                for (j = 1; j < n6; ++j) {
                    int k;
                    int n8;
                    int n9 = 0;
                    int n10 = ((Object[])tempMat).length;
                    double[][] dArrayArray = new double[n10][];
                    while (n9 < n10) {
                        int n11 = n9++;
                        dArrayArray[n11] = new double[size - n - j];
                    }
                    double[][] temp = dArrayArray;
                    n10 = 0;
                    int n12 = ((Object[])tempMat).length;
                    double[][] dArrayArray2 = new double[n12][];
                    while (n10 < n12) {
                        n8 = n10++;
                        dArrayArray2[n8] = new double[1];
                    }
                    double[][] value = dArrayArray2;
                    n12 = size - n - j;
                    for (k = 0; k < n12; ++k) {
                        n8 = ((Object[])tempMat).length;
                        for (int l = 0; l < n8; ++l) {
                            temp[l][k] = tempMat[l][k + j];
                        }
                    }
                    n12 = ((Object[])tempMat).length;
                    for (k = 0; k < n12; ++k) {
                        value[k][0] = tempMat[k][j - 1];
                    }
                    double[][] repmat = this.repmat(value, size - n - j);
                    double[][] subsdata = this.subtractABS(temp, repmat);
                    double[] dist = this.max(subsdata);
                    double[] dBool = this.getArrayDistance(dist, r);
                    count[j - 1] = (float)(this.sum(dBool) / (double)(size - n));
                }
                correlation[i - n] = this.sum(count) / (float)(size - n);
                if (i == n3) break;
                ++i;
            }
        }
        return (float)Math.log(correlation[0] / correlation[1]);
    }

    @NotNull
    public final double[][] repmat(@NotNull double[][] data, int size) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int dataLength = ((Object[])data).length;
        int n = 0;
        int n2 = ((Object[])data).length;
        double[][] dArrayArray = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            dArrayArray[n3] = new double[size];
        }
        double[][] repmat = dArrayArray;
        for (int i = 0; i < dataLength; ++i) {
            for (int j = 0; j < size; ++j) {
                repmat[i][j] = data[i][0];
            }
        }
        return repmat;
    }

    @NotNull
    public final double[][] subtractABS(@NotNull double[][] data, @NotNull double[][] data1) {
        int n;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)data1, (String)"data1");
        int n2 = 0;
        int n3 = ((Object[])data).length;
        double[][] dArrayArray = new double[n3][];
        while (n2 < n3) {
            n = n2++;
            dArrayArray[n] = new double[data[0].length];
        }
        double[][] newData = dArrayArray;
        n3 = ((Object[])data).length;
        for (int i = 0; i < n3; ++i) {
            n = data[0].length;
            for (int j = 0; j < n; ++j) {
                newData[i][j] = Math.abs(data[i][j] - data1[i][j]);
            }
        }
        return newData;
    }

    @NotNull
    public final double[] max(@NotNull double[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double[] newData = new double[data[0].length];
        int n = newData.length;
        for (int i = 0; i < n; ++i) {
            double max = data[0][i];
            int n2 = ((Object[])data).length;
            for (int j = 1; j < n2; ++j) {
                max = Math.max(data[j][i], max);
            }
            newData[i] = max;
        }
        return newData;
    }

    @NotNull
    public final double[] getArrayDistance(@NotNull double[] data, double r) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double[] d = new double[data.length];
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            d[i] = data[i] < r ? 1.0 : 0.0;
        }
        return d;
    }

    public final double sum(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double sum = 0.0;
        for (double d : data) {
            sum += d;
        }
        return sum;
    }

    public final float sum(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float sum = 0.0f;
        for (float d : data) {
            sum += d;
        }
        return sum;
    }
}

