/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.spatial;

import androidx.collection.IntObjectMap;
import androidx.collection.IntObjectMapKt;
import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Actual_jvmKt;
import androidx.compose.ui.Actuals_skikoKt;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusTargetModifierNode;
import androidx.compose.ui.focus.FocusTargetNode;
import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.MatrixKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutNodeKt;
import androidx.compose.ui.node.MeasurePassDelegate;
import androidx.compose.ui.node.NodeChain;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.semantics.SemanticsInfo;
import androidx.compose.ui.spatial.RectList;
import androidx.compose.ui.spatial.RectManagerKt;
import androidx.compose.ui.spatial.RelativeLayoutBounds;
import androidx.compose.ui.spatial.ThrottledCallbacks;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0019\u001a\u00020\u0010J5\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\u0006\u0010%\u001a\u00020\u0010J\u000e\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0012J\u0006\u0010(\u001a\u00020\u0010J\u0016\u0010)\u001a\u0004\u0018\u00010\u00012\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ:\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001002J:\u00104\u001a\u00020,2\u0006\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001002J\u0010\u00105\u001a\u00020\u00102\b\u00106\u001a\u0004\u0018\u00010\u0001J\u000e\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0004J\u001e\u00109\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\u0012J\u000e\u0010<\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0004J\u0018\u0010=\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u00042\b\b\u0002\u0010>\u001a\u00020\u0012J\u0015\u0010?\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u0004\u00a2\u0006\u0004\b@\u0010AJ\f\u0010B\u001a\u00020\u0010*\u00020\u0004H\u0002J\u0010\u0010C\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0004H\u0002J\u0010\u0010F\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0004H\u0002J\u0014\u0010G\u001a\u00020\u0010*\u00020H2\u0006\u0010I\u001a\u00020EH\u0002J\f\u0010J\u001a\u00020\u0012*\u00020HH\u0002J\u0013\u0010K\u001a\u00020\u001c*\u00020\u0004H\u0002\u00a2\u0006\u0004\bL\u0010AJ\u000e\u0010M\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0004J\u001d\u0010N\u001a\u00020\u00122\u0006\u0010O\u001a\u00020!2\u0006\u0010P\u001a\u00020!H\u0000\u00a2\u0006\u0002\bQJ7\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020!2\u0006\u0010U\u001a\u00020!2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!2\u0006\u0010X\u001a\u00020!H\u0000\u00a2\u0006\u0002\bYJ1\u0010Z\u001a\u00020\u0012*\u0002012\u0006\u0010T\u001a\u00020!2\u0006\u0010U\u001a\u00020!2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!H\u0000\u00a2\u0006\u0002\b[J\u0019\u0010\\\u001a\u00020\u0012*\u00020\u00042\u0006\u0010]\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b^J\u000e\u0010_\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Landroidx/compose/ui/spatial/RectManager;", "", "layoutNodes", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/ui/node/LayoutNode;", "<init>", "(Landroidx/collection/IntObjectMap;)V", "rects", "Landroidx/compose/ui/spatial/RectList;", "getRects", "()Landroidx/compose/ui/spatial/RectList;", "throttledCallbacks", "Landroidx/compose/ui/spatial/ThrottledCallbacks;", "callbacks", "Landroidx/collection/MutableObjectList;", "Lkotlin/Function0;", "", "isDirty", "", "isScreenOrWindowDirty", "isFragmented", "dispatchToken", "scheduledDispatchDeadline", "", "dispatchLambda", "invalidate", "updateOffsets", "screenOffset", "Landroidx/compose/ui/unit/IntOffset;", "windowOffset", "viewToWindowMatrix", "Landroidx/compose/ui/graphics/Matrix;", "windowWidth", "", "windowHeight", "updateOffsets-gTq6Wqs", "(JJ[FII)V", "dispatchCallbacks", "scheduleDebounceCallback", "ensureSomethingScheduled", "removeScheduledCallback", "registerOnChangedCallback", "callback", "registerOnRectChangedCallback", "Landroidx/compose/ui/node/DelegatableNode$RegistrationHandle;", "id", "throttleMillis", "debounceMillis", "node", "Landroidx/compose/ui/node/DelegatableNode;", "Lkotlin/Function1;", "Landroidx/compose/ui/spatial/RelativeLayoutBounds;", "registerOnGlobalLayoutCallback", "unregisterOnChangedCallback", "token", "invalidateCallbacksFor", "layoutNode", "updateFlagsFor", "focusable", "gesturable", "onLayoutLayerPositionalPropertiesChanged", "onLayoutPositionChanged", "forceUpdate", "getOffsetFromRectListFor", "getOffsetFromRectListFor-Bjo55l4", "(Landroidx/compose/ui/node/LayoutNode;)J", "resetHasPositionalLayerTransformationsForSubtreeIfNeeded", "insertOrUpdateTransformedNodeSubhierarchy", "cachedRect", "Landroidx/compose/ui/geometry/MutableRect;", "insertOrUpdateTransformedNode", "boundingRectInRoot", "Landroidx/compose/ui/node/NodeCoordinator;", "rect", "hasPositionalLayerTransformations", "outerToInnerOffset", "outerToInnerOffset-Bjo55l4", "remove", "isTargetDrawnFirst", "targetId", "otherId", "isTargetDrawnFirst$ui", "findFocusableNodeFromRect", "Landroidx/compose/ui/focus/FocusTargetModifierNode;", "left", "top", "right", "bottom", "containerId", "findFocusableNodeFromRect$ui", "intersects", "intersects$ui", "isDescendantOf", "container", "isDescendantOf$ui", "unsetHasCallbacksFor", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRectManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n+ 3 RectManager.kt\nandroidx/compose/ui/spatial/RectManagerKt\n+ 4 ObjectList.kt\nandroidx/collection/ObjectList\n+ 5 RectList.kt\nandroidx/compose/ui/spatial/RectList\n+ 6 RectList.kt\nandroidx/compose/ui/spatial/RectListKt\n+ 7 LayoutNode.kt\nandroidx/compose/ui/node/LayoutNode\n+ 8 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 9 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 10 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 11 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 12 IntOffset.kt\nandroidx/compose/ui/unit/IntOffsetKt\n+ 13 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 14 NodeChain.kt\nandroidx/compose/ui/node/NodeChain\n+ 15 DelegatableNode.kt\nandroidx/compose/ui/node/DelegatableNodeKt\n+ 16 Modifier.kt\nandroidx/compose/ui/Modifier$Node\n+ 17 DelegatingNode.kt\nandroidx/compose/ui/node/DelegatingNode\n+ 18 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 19 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 20 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 21 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 22 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 23 Trace.desktop.kt\nandroidx/compose/ui/util/Trace_jbKt__Trace_desktopKt\n*L\n1#1,723:1\n1516#2:724\n720#3:725\n287#4,6:726\n972#5,7:732\n979#5,3:740\n983#5,3:744\n713#5:795\n714#5,8:797\n722#5,4:806\n726#5:812\n729#5,3:879\n1118#6:739\n1073#6:743\n1138#6,3:760\n1052#6:796\n1112#6:805\n1161#6,2:810\n1073#6:813\n211#7:747\n211#7:765\n211#7:774\n424#8,8:748\n424#8,8:766\n424#8,8:775\n30#9:756\n80#10:757\n80#10:764\n53#10,3:787\n53#10,3:792\n60#10:884\n85#10:891\n70#10:893\n90#10:900\n120#11:758\n96#11:759\n120#11:783\n96#11:784\n120#11:814\n120#11:882\n32#12:763\n159#12:785\n159#12:790\n30#13:786\n30#13:791\n698#14:815\n633#14,6:816\n654#14,3:822\n639#14,2:825\n699#14:832\n642#14,2:871\n657#14,3:873\n644#14:876\n634#14:877\n701#14:878\n556#15,5:827\n561#15:833\n566#15,2:835\n568#15,8:840\n576#15,9:851\n585#15,8:863\n247#16:834\n240#17,3:837\n243#17,3:860\n1107#18:848\n1085#18,2:849\n65#19:883\n69#19:892\n22#20,5:885\n22#20,5:894\n54#21:890\n59#21:899\n1#22:901\n23#23:902\n*S KotlinDebug\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n*L\n52#1:724\n79#1:725\n100#1:726,6\n101#1:732,7\n101#1:740,3\n101#1:744,3\n602#1:795\n602#1:797,8\n602#1:806,4\n602#1:812\n602#1:879,3\n101#1:739\n101#1:743\n373#1:760,3\n602#1:796\n602#1:805\n602#1:810,2\n602#1:813\n234#1:747\n389#1:765\n396#1:774\n234#1:748,8\n389#1:766,8\n396#1:775,8\n281#1:756\n281#1:757\n373#1:764\n455#1:787,3\n467#1:792,3\n649#1:884\n650#1:891\n651#1:893\n652#1:900\n315#1:758\n316#1:759\n437#1:783\n438#1:784\n611#1:814\n634#1:882\n373#1:763\n455#1:785\n467#1:790\n455#1:786\n467#1:791\n611#1:815\n611#1:816,6\n611#1:822,3\n611#1:825,2\n611#1:832\n611#1:871,2\n611#1:873,3\n611#1:876\n611#1:877\n611#1:878\n611#1:827,5\n611#1:833\n611#1:835,2\n611#1:840,8\n611#1:851,9\n611#1:863,8\n611#1:834\n611#1:837,3\n611#1:860,3\n611#1:848\n611#1:849,2\n649#1:883\n651#1:892\n649#1:885,5\n651#1:894,5\n650#1:890\n652#1:899\n60#1:902\n*E\n"})
public final class RectManager {
    @NotNull
    private final IntObjectMap<LayoutNode> layoutNodes;
    @NotNull
    private final RectList rects;
    @NotNull
    private final ThrottledCallbacks throttledCallbacks;
    @NotNull
    private final MutableObjectList<Function0<Unit>> callbacks;
    private boolean isDirty;
    private boolean isScreenOrWindowDirty;
    private boolean isFragmented;
    @Nullable
    private Object dispatchToken;
    private long scheduledDispatchDeadline;
    @NotNull
    private final Function0<Unit> dispatchLambda;
    @NotNull
    private final MutableRect cachedRect;
    public static final int $stable = 8;

    public RectManager(@NotNull IntObjectMap<LayoutNode> layoutNodes) {
        Intrinsics.checkNotNullParameter(layoutNodes, (String)"layoutNodes");
        this.layoutNodes = layoutNodes;
        this.rects = new RectList();
        this.throttledCallbacks = new ThrottledCallbacks();
        boolean $i$f$mutableObjectListOf = false;
        this.callbacks = new MutableObjectList(0, 1, null);
        this.scheduledDispatchDeadline = -1L;
        this.dispatchLambda = () -> RectManager.dispatchLambda$lambda$0(this);
        this.cachedRect = new MutableRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public /* synthetic */ RectManager(IntObjectMap intObjectMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            intObjectMap = IntObjectMapKt.intObjectMapOf();
        }
        this((IntObjectMap<LayoutNode>)intObjectMap);
    }

    @NotNull
    public final RectList getRects() {
        return this.rects;
    }

    public final void invalidate() {
        this.isDirty = true;
    }

    public final void updateOffsets-gTq6Wqs(long l, long l2, @NotNull float[] fArray, int windowWidth, int windowHeight) {
        int analysis;
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"$v$c$androidx-compose-ui-graphics-Matrix$-viewToWindowMatrix$0");
        int $this$hasNonTranslationComponents$iv = analysis = RectManagerKt.access$analyzeComponents-58bKbWc(fArray);
        boolean $i$f$getHasNonTranslationComponents = false;
        this.isScreenOrWindowDirty = this.throttledCallbacks.updateOffsets-LDcG7Xg(l, l2, (float[])(($this$hasNonTranslationComponents$iv & 2) == 0 ? fArray : null), windowWidth, windowHeight) || this.isScreenOrWindowDirty;
    }

    /*
     * WARNING - void declaration
     */
    public final void dispatchCallbacks() {
        boolean isDispatchGlobalCallbacks;
        this.removeScheduledCallback();
        long currentTime = Actual_jvmKt.currentTimeMillis();
        boolean bl = isDispatchGlobalCallbacks = this.isDirty || this.isScreenOrWindowDirty;
        if (this.isDirty) {
            this.isDirty = false;
            Object this_$iv = (ObjectList)this.callbacks;
            boolean $i$f$forEach = false;
            Object[] content$iv = this_$iv.content;
            int n = this_$iv._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Function0 it = (Function0)content$iv[i$iv];
                boolean bl2 = false;
                it.invoke();
            }
            this_$iv = this.rects;
            boolean $i$f$forEachUpdatedRect = false;
            long[] items$iv = this_$iv.items;
            int size$iv = this_$iv.itemsSize;
            for (int i$iv = 0; i$iv < items$iv.length - 2 && i$iv < size$iv; i$iv += 3) {
                void bottomRight;
                void topLeft;
                long meta$iv;
                long meta$iv$iv = meta$iv = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaUpdated = false;
                if (((int)(meta$iv$iv >> 60) & 1) == 0) continue;
                long topLeft$iv = items$iv[i$iv + 0];
                long bottomRight$iv = items$iv[i$iv + 1];
                long meta$iv$iv2 = meta$iv;
                boolean $i$f$unpackMetaValue = false;
                long l = bottomRight$iv;
                long l2 = topLeft$iv;
                int id = (int)meta$iv$iv2 & 0x1FFFFFF;
                boolean bl3 = false;
                this.throttledCallbacks.fireOnUpdatedRect(id, (long)topLeft, (long)bottomRight, currentTime);
            }
            this.rects.clearUpdated();
        }
        if (this.isScreenOrWindowDirty) {
            this.isScreenOrWindowDirty = false;
            this.throttledCallbacks.fireOnRectChangedEntries(currentTime);
        }
        if (isDispatchGlobalCallbacks) {
            this.throttledCallbacks.fireGlobalChangeEntries(currentTime);
        }
        if (this.isFragmented) {
            this.isFragmented = false;
            this.rects.defragment();
        }
        this.throttledCallbacks.triggerDebounced(currentTime);
        if (this.throttledCallbacks.getMinDebounceDeadline() > 0L) {
            this.scheduleDebounceCallback(true);
        }
    }

    public final void scheduleDebounceCallback(boolean ensureSomethingScheduled) {
        long deadline;
        boolean canExitEarly = !ensureSomethingScheduled || this.dispatchToken != null;
        long nextDeadline = this.throttledCallbacks.getMinDebounceDeadline();
        if (nextDeadline < 0L && canExitEarly) {
            return;
        }
        long currentScheduledDeadline = this.scheduledDispatchDeadline;
        if (currentScheduledDeadline == nextDeadline && canExitEarly) {
            return;
        }
        if (this.dispatchToken != null) {
            Actuals_skikoKt.removePost(this.dispatchToken);
        }
        long currentTime = Actual_jvmKt.currentTimeMillis();
        long nextFrameIsh = currentTime + (long)16;
        this.scheduledDispatchDeadline = deadline = Math.max(nextDeadline, nextFrameIsh);
        long delay = deadline - currentTime;
        this.dispatchToken = Actuals_skikoKt.postDelayed(delay, this.dispatchLambda);
    }

    public final void removeScheduledCallback() {
        if (this.dispatchToken != null) {
            Actuals_skikoKt.removePost(this.dispatchToken);
            this.dispatchToken = null;
        }
    }

    @Nullable
    public final Object registerOnChangedCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.add(callback);
        return callback;
    }

    @NotNull
    public final DelegatableNode.RegistrationHandle registerOnRectChangedCallback(int id, long throttleMillis, long debounceMillis, @NotNull DelegatableNode node, @NotNull Function1<? super RelativeLayoutBounds, Unit> callback) {
        DelegatableNode.RegistrationHandle registrationHandle;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        DelegatableNode.RegistrationHandle it = registrationHandle = this.throttledCallbacks.registerOnRectChanged(id, throttleMillis, debounceMillis, node, callback);
        boolean bl = false;
        LayoutNode layoutNode = DelegatableNodeKt.requireLayoutNode(node.getNode());
        if (layoutNode.getAddedToRectList$ui()) {
            this.rects.updateHasCallbacks(id, true);
        }
        this.invalidate();
        this.scheduleDebounceCallback(true);
        return registrationHandle;
    }

    @NotNull
    public final DelegatableNode.RegistrationHandle registerOnGlobalLayoutCallback(int id, long throttleMillis, long debounceMillis, @NotNull DelegatableNode node, @NotNull Function1<? super RelativeLayoutBounds, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.throttledCallbacks.registerOnGlobalChange(id, throttleMillis, debounceMillis, node, callback);
    }

    public final void unregisterOnChangedCallback(@Nullable Object token) {
        if ((TypeIntrinsics.isFunctionOfArity((Object)token, (int)0) ? (Function0)token : null) == null) {
            return;
        }
        this.callbacks.remove(token);
    }

    public final void invalidateCallbacksFor(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.getAddedToRectList$ui()) {
            this.isDirty = true;
            this.rects.markUpdated(layoutNode.getSemanticsId());
        }
        this.scheduleDebounceCallback(true);
    }

    public final void updateFlagsFor(@NotNull LayoutNode layoutNode, boolean focusable, boolean gesturable) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isAttached()) {
            this.rects.updateFlagsFor(layoutNode.getSemanticsId(), focusable, gesturable);
        }
    }

    public final void onLayoutLayerPositionalPropertiesChanged(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (!layoutNode.isPlaced()) {
            return;
        }
        long outerToInnerOffset = this.outerToInnerOffset-Bjo55l4(layoutNode);
        if (RectManagerKt.access$isSet--gyyYBs(outerToInnerOffset)) {
            layoutNode.setOuterToInnerOffset--gyyYBs$ui(outerToInnerOffset);
            layoutNode.setOuterToInnerOffsetDirty$ui(false);
            LayoutNode this_$iv = layoutNode;
            boolean $i$f$forEachChild = false;
            MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
            boolean $i$f$forEach = false;
            Object[] content$iv$iv = this_$iv$iv.content;
            int size$iv$iv = this_$iv$iv.getSize();
            for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
                boolean bl = false;
                RectManager.onLayoutPositionChanged$default(this, it, false, 2, null);
            }
            this.invalidateCallbacksFor(layoutNode);
        } else {
            this.insertOrUpdateTransformedNodeSubhierarchy(layoutNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onLayoutPositionChanged(@NotNull LayoutNode layoutNode, boolean forceUpdate) {
        long l;
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (!layoutNode.isPlaced()) {
            return;
        }
        LayoutNode parent = layoutNode.getParent$ui();
        if (parent != null && !parent.getHasPositionalLayerTransformationsInOffsetFromRoot$ui()) {
            if (parent.getOuterToInnerOffsetDirty$ui()) {
                parent.setOuterToInnerOffsetDirty$ui(false);
                parent.setOuterToInnerOffset--gyyYBs$ui(this.outerToInnerOffset-Bjo55l4(parent));
            }
            l = parent.getOuterToInnerOffset-nOcc-ac$ui();
        } else {
            l = parent == null ? IntOffset.Companion.getZero-nOcc-ac() : IntOffset.Companion.getMax-nOcc-ac();
        }
        long parentOuterInnerOffset = l;
        NodeCoordinator outer = layoutNode.getOuterCoordinator$ui();
        if (RectManagerKt.access$isSet--gyyYBs(parentOuterInnerOffset) && !this.hasPositionalLayerTransformations(outer)) {
            if (!layoutNode.getHasPositionalLayerTransformationsInOffsetFromRoot$ui()) {
                void val1$iv$iv;
                void width$iv;
                long offsetFromParent = IntOffset.plus-qkQi6aY((long)parentOuterInnerOffset, (long)outer.getPosition-nOcc-ac());
                MeasurePassDelegate delegate = layoutNode.getMeasurePassDelegate$ui();
                int width = delegate.getMeasuredWidth();
                int height = delegate.getMeasuredHeight();
                int n = width;
                int height$iv = height;
                boolean $i$f$IntSize = false;
                void var17_13 = width$iv;
                int val2$iv$iv = height$iv;
                boolean $i$f$packInts = false;
                long size = IntSize.constructor-impl((long)((long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL));
                int semanticsId = layoutNode.getSemanticsId();
                if (layoutNode.getAddedToRectList$ui()) {
                    if (forceUpdate || !IntOffset.equals-impl0((long)offsetFromParent, (long)layoutNode.getLastOffsetFromParent-nOcc-ac$ui()) || !IntSize.equals-impl0((long)size, (long)layoutNode.getLastSize-YbymL2g$ui())) {
                        if (parent != null) {
                            this.rects.moveBasedOnParentOffset(semanticsId, parent.getSemanticsId(), IntOffset.getX-impl((long)offsetFromParent), IntOffset.getY-impl((long)offsetFromParent), width, height);
                        } else {
                            this.rects.move(semanticsId, IntOffset.getX-impl((long)offsetFromParent), IntOffset.getY-impl((long)offsetFromParent), IntOffset.getX-impl((long)offsetFromParent) + width, IntOffset.getY-impl((long)offsetFromParent) + height);
                        }
                        this.invalidate();
                    }
                } else {
                    layoutNode.setAddedToRectList$ui(true);
                    boolean bl = false;
                    boolean focusable = layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(1024));
                    boolean bl2 = false;
                    boolean gesturable = layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(16));
                    boolean hasCallbacks = this.throttledCallbacks.getRectChangedMap().containsKey(semanticsId);
                    if (parent != null) {
                        this.rects.insertBasedOnParentOffset(semanticsId, parent.getSemanticsId(), IntOffset.getX-impl((long)offsetFromParent), IntOffset.getY-impl((long)offsetFromParent), width, height, focusable, gesturable, hasCallbacks);
                    } else {
                        RectList.insert$default(this.rects, semanticsId, IntOffset.getX-impl((long)offsetFromParent), IntOffset.getY-impl((long)offsetFromParent), IntOffset.getX-impl((long)offsetFromParent) + width, IntOffset.getY-impl((long)offsetFromParent) + height, 0, focusable, gesturable, hasCallbacks, 0, 544, null);
                    }
                    this.invalidate();
                }
                layoutNode.setLastSize-ozmzZPI$ui(size);
                layoutNode.setLastOffsetFromParent--gyyYBs$ui(offsetFromParent);
            } else {
                this.insertOrUpdateTransformedNodeSubhierarchy(layoutNode);
                this.resetHasPositionalLayerTransformationsForSubtreeIfNeeded(layoutNode);
            }
        } else {
            this.insertOrUpdateTransformedNodeSubhierarchy(layoutNode);
        }
    }

    public static /* synthetic */ void onLayoutPositionChanged$default(RectManager rectManager, LayoutNode layoutNode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        rectManager.onLayoutPositionChanged(layoutNode, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final long getOffsetFromRectListFor-Bjo55l4(@NotNull LayoutNode layoutNode) {
        long l;
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        long topLeft = this.rects.getTopLeft(layoutNode.getSemanticsId());
        if (topLeft == Long.MAX_VALUE) {
            l = IntOffset.Companion.getMax-nOcc-ac();
        } else {
            void val1$iv$iv;
            void y$iv;
            void x$iv;
            long xy$iv22 = topLeft;
            boolean $i$f$unpackX = false;
            int xy$iv22 = (int)(xy$iv22 >> 32);
            long xy$iv32 = topLeft;
            boolean $i$f$unpackY = false;
            int xy$iv32 = (int)xy$iv32;
            boolean $i$f$IntOffset = false;
            $i$f$unpackY = x$iv;
            void val2$iv$iv = y$iv;
            boolean $i$f$packInts = false;
            l = IntOffset.constructor-impl((long)((long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL));
        }
        return l;
    }

    private final void resetHasPositionalLayerTransformationsForSubtreeIfNeeded(LayoutNode $this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded) {
        if ($this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded.getHasPositionalLayerTransformationsInOffsetFromRoot$ui() && !this.hasPositionalLayerTransformations($this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded.getOuterCoordinator$ui())) {
            $this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded.setHasPositionalLayerTransformationsInOffsetFromRoot$ui(false);
            if ($this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded.getOuterToInnerOffsetDirty$ui()) {
                long it = this.outerToInnerOffset-Bjo55l4($this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded);
                $this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded.setOuterToInnerOffset--gyyYBs$ui(it);
                $this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded.setOuterToInnerOffsetDirty$ui(false);
            }
            if (!IntOffset.equals-impl0((long)$this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded.getOuterToInnerOffset-nOcc-ac$ui(), (long)IntOffset.Companion.getMax-nOcc-ac())) {
                LayoutNode this_$iv = $this$resetHasPositionalLayerTransformationsForSubtreeIfNeeded;
                boolean $i$f$forEachChild = false;
                MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
                boolean $i$f$forEach = false;
                Object[] content$iv$iv = this_$iv$iv.content;
                int size$iv$iv = this_$iv$iv.getSize();
                for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                    LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
                    boolean bl = false;
                    this.resetHasPositionalLayerTransformationsForSubtreeIfNeeded(it);
                }
            }
        }
    }

    private final void insertOrUpdateTransformedNodeSubhierarchy(LayoutNode layoutNode) {
        this.insertOrUpdateTransformedNode(layoutNode);
        LayoutNode this_$iv = layoutNode;
        boolean $i$f$forEachChild = false;
        MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
        boolean $i$f$forEach = false;
        Object[] content$iv$iv = this_$iv$iv.content;
        int size$iv$iv = this_$iv$iv.getSize();
        for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
            LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
            boolean bl = false;
            if (!it.isPlaced()) continue;
            this.insertOrUpdateTransformedNodeSubhierarchy(it);
        }
    }

    private final void insertOrUpdateTransformedNode(LayoutNode layoutNode) {
        layoutNode.setHasPositionalLayerTransformationsInOffsetFromRoot$ui(true);
        layoutNode.setLastOffsetFromParent--gyyYBs$ui(IntOffset.Companion.getMax-nOcc-ac());
        NodeCoordinator coord = layoutNode.getOuterCoordinator$ui();
        MeasurePassDelegate delegate = layoutNode.getMeasurePassDelegate$ui();
        int width = delegate.getMeasuredWidth();
        int height = delegate.getMeasuredHeight();
        MutableRect rect = this.cachedRect;
        rect.set(0.0f, 0.0f, (float)width, (float)height);
        this.boundingRectInRoot(coord, rect);
        int l = (int)rect.getLeft();
        int t = (int)rect.getTop();
        int r = (int)rect.getRight();
        int b = (int)rect.getBottom();
        int id = layoutNode.getSemanticsId();
        boolean firstPlacement = !layoutNode.getAddedToRectList$ui();
        layoutNode.setAddedToRectList$ui(true);
        if (firstPlacement || !this.rects.update(id, l, t, r, b)) {
            LayoutNode layoutNode2 = layoutNode.getParent$ui();
            int parentId = layoutNode2 != null ? layoutNode2.getSemanticsId() : -1;
            boolean bl = false;
            boolean bl2 = false;
            RectList.insert$default(this.rects, id, l, t, r, b, parentId, layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(1024)), layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(16)), this.throttledCallbacks.getRectChangedMap().containsKey(id), 0, 512, null);
        }
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    private final void boundingRectInRoot(NodeCoordinator $this$boundingRectInRoot, MutableRect rect) {
        for (NodeCoordinator coordinator = $this$boundingRectInRoot; coordinator != null; coordinator = coordinator.getWrappedBy$ui()) {
            void val1$iv$iv$iv;
            void x$iv$iv;
            float[] matrix;
            long offset;
            LayoutNode layoutNode = coordinator.getLayoutNode();
            if (coordinator == layoutNode.getOuterCoordinator$ui() && !layoutNode.getHasPositionalLayerTransformationsInOffsetFromRoot$ui() && !IntOffset.equals-impl0((long)(offset = this.getOffsetFromRectListFor-Bjo55l4(layoutNode)), (long)IntOffset.Companion.getMax-nOcc-ac())) {
                void val1$iv$iv$iv2;
                void x$iv$iv2;
                long l = offset;
                boolean $i$f$toOffset--gyyYBs2 = false;
                float f = IntOffset.getX-impl((long)l);
                float y$iv$iv = IntOffset.getY-impl((long)l);
                boolean $i$f$Offset2 = false;
                void var13_17 = x$iv$iv2;
                float val2$iv$iv$iv = y$iv$iv;
                boolean $i$f$packFloats = false;
                long v1$iv$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv$iv2);
                long v2$iv$iv$iv = Float.floatToRawIntBits(val2$iv$iv$iv);
                rect.translate-k-4lQ0M(Offset.constructor-impl((long)(v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL)));
                return;
            }
            OwnedLayer layer = coordinator.getLayer();
            if (layer != null && !MatrixKt.isIdentity-58bKbWc((float[])(matrix = layer.getUnderlyingMatrix-sQKQjiQ()))) {
                Matrix.map-impl((float[])matrix, (MutableRect)rect);
            }
            long l = coordinator.getPosition-nOcc-ac();
            boolean bl = false;
            float $i$f$toOffset--gyyYBs2 = IntOffset.getX-impl((long)l);
            float y$iv$iv = IntOffset.getY-impl((long)l);
            boolean $i$f$Offset = false;
            void $i$f$Offset2 = x$iv$iv;
            float val2$iv$iv$iv = y$iv$iv;
            boolean $i$f$packFloats = false;
            long v1$iv$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv$iv);
            long v2$iv$iv$iv = Float.floatToRawIntBits(val2$iv$iv$iv);
            rect.translate-k-4lQ0M(Offset.constructor-impl((long)(v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL)));
        }
    }

    private final boolean hasPositionalLayerTransformations(NodeCoordinator $this$hasPositionalLayerTransformations) {
        OwnedLayer ownedLayer = $this$hasPositionalLayerTransformations.getLayer();
        return ownedLayer != null ? !MatrixKt.isIdentity-58bKbWc((float[])ownedLayer.getUnderlyingMatrix-sQKQjiQ()) : false;
    }

    private final long outerToInnerOffset-Bjo55l4(LayoutNode $this$outerToInnerOffset_u2dBjo55l4) {
        NodeCoordinator terminator = $this$outerToInnerOffset_u2dBjo55l4.getOuterCoordinator$ui();
        long position = IntOffset.Companion.getZero-nOcc-ac();
        for (NodeCoordinator coordinator = $this$outerToInnerOffset_u2dBjo55l4.getInnerCoordinator$ui(); coordinator != null && coordinator != terminator; coordinator = coordinator.getWrappedBy$ui()) {
            if (this.hasPositionalLayerTransformations(coordinator)) {
                return IntOffset.Companion.getMax-nOcc-ac();
            }
            position = IntOffset.plus-qkQi6aY((long)position, (long)coordinator.getPosition-nOcc-ac());
        }
        return position;
    }

    public final void remove(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.getAddedToRectList$ui()) {
            this.rects.remove(layoutNode.getSemanticsId());
            layoutNode.setAddedToRectList$ui(false);
            this.invalidate();
            this.isFragmented = true;
        }
    }

    public final boolean isTargetDrawnFirst$ui(int targetId, int otherId) {
        LayoutNode layoutNode = (LayoutNode)this.layoutNodes.get(targetId);
        if (layoutNode == null) {
            return false;
        }
        LayoutNode nodeA = layoutNode;
        LayoutNode layoutNode2 = (LayoutNode)this.layoutNodes.get(otherId);
        if (layoutNode2 == null) {
            return false;
        }
        LayoutNode nodeB = layoutNode2;
        if (nodeA.getDepth$ui() == 0 || nodeB.getDepth$ui() == 0) {
            return false;
        }
        while (nodeA.getDepth$ui() > nodeB.getDepth$ui()) {
            if (nodeA.getParent$ui() != null) continue;
            return false;
        }
        if (nodeA == nodeB) {
            return false;
        }
        while (nodeB.getDepth$ui() > nodeA.getDepth$ui()) {
            if (nodeB.getParent$ui() != null) continue;
            return false;
        }
        if (nodeA == nodeB) {
            return false;
        }
        LayoutNode lastParentA = nodeA;
        LayoutNode lastParentB = nodeB;
        while (nodeA != nodeB) {
            lastParentA = nodeA;
            lastParentB = nodeB;
            if (nodeA.getParent$ui() == null) {
                return false;
            }
            if (nodeB.getParent$ui() != null) continue;
            return false;
        }
        if (lastParentA.getMeasurePassDelegate$ui().getZIndex$ui() == lastParentB.getMeasurePassDelegate$ui().getZIndex$ui()) {
            return lastParentA.getPlaceOrder$ui() < lastParentB.getPlaceOrder$ui();
        }
        return lastParentA.getMeasurePassDelegate$ui().getZIndex$ui() < lastParentB.getMeasurePassDelegate$ui().getZIndex$ui();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FocusTargetModifierNode findFocusableNodeFromRect$ui(int left, int top, int right, int bottom, int containerId) {
        void this_$iv;
        void x$iv$iv;
        void r$iv;
        void x$iv$iv2;
        void t$iv;
        void l$iv;
        SemanticsInfo semanticsInfo;
        LayoutNode layoutNode = (LayoutNode)this.layoutNodes.get(containerId);
        if (layoutNode == null) {
            return null;
        }
        LayoutNode container2 = layoutNode;
        FocusTargetNode focusTargetNode = LayoutNodeKt.requireOwner(container2).getFocusOwner().getActiveFocusTargetNode();
        int currentlyFocusedId = focusTargetNode != null && (semanticsInfo = DelegatableNodeKt.requireSemanticsInfo(focusTargetNode)) != null ? semanticsInfo.getSemanticsId() : -1;
        FocusTargetNode bestTarget = null;
        int bestDepth = 0;
        bestDepth = Integer.MAX_VALUE;
        RectList rectList = this.rects;
        int n = left;
        int n2 = top;
        int n3 = right;
        int b$iv = bottom;
        boolean $i$f$forEachFocusableIntersection = false;
        void var16_17 = l$iv;
        void y$iv$iv = t$iv;
        boolean $i$f$packXY = false;
        long destTopLeft$iv = (long)x$iv$iv2 << 32 | (long)y$iv$iv & 0xFFFFFFFFL;
        $i$f$packXY = r$iv;
        int y$iv$iv2 = b$iv;
        boolean $i$f$packXY2 = false;
        long destBottomRight$iv = (long)x$iv$iv << 32 | (long)y$iv$iv2 & 0xFFFFFFFFL;
        long[] items$iv = this_$iv.items;
        int size$iv = this_$iv.itemsSize;
        for (int i$iv = 0; i$iv < items$iv.length - 2 && i$iv < size$iv; i$iv += 3) {
            Modifier.Node node;
            LayoutNode node2;
            block14: {
                void this_$iv$iv$iv;
                void this_$iv$iv;
                void $v$c$androidx-compose-ui-node-NodeKind$-type$0$iv;
                void this_$iv2;
                void destLT$iv$iv;
                void srcRB$iv$iv;
                void srcLT$iv$iv;
                long meta$iv$iv = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaFocusable = false;
                if (((int)(meta$iv$iv >> 61) & 1) == 0) continue;
                long topLeft$iv = items$iv[i$iv + 0];
                long bottomRight$iv = items$iv[i$iv + 1];
                long l = topLeft$iv;
                long l2 = bottomRight$iv;
                long l3 = destTopLeft$iv;
                long destRB$iv$iv = destBottomRight$iv;
                boolean $i$f$rectIntersectsRect = false;
                long a$iv$iv = destRB$iv$iv - srcLT$iv$iv - 0x100000001L | srcRB$iv$iv - destLT$iv$iv - 0x100000001L;
                if (!((a$iv$iv & 0x8000000080000000L) == 0L)) continue;
                long meta$iv$iv2 = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaValue = false;
                int semanticsId = (int)meta$iv$iv2 & 0x1FFFFFF;
                boolean bl = false;
                node2 = (LayoutNode)this.layoutNodes.get(semanticsId);
                if (node2 == null) continue;
                if (currentlyFocusedId == semanticsId && currentlyFocusedId != -1) {
                    return null;
                }
                if (node2.getDepth$ui() >= bestDepth || !this.isDescendantOf$ui(node2, container2)) continue;
                NodeChain nodeChain = node2.getNodes$ui();
                int n4 = 0;
                n4 = NodeKind.constructor-impl(1024);
                boolean bl2 = false;
                void var48_41 = this_$iv2;
                void $v$c$androidx-compose-ui-node-NodeKind$-type$0$iv$iv = $v$c$androidx-compose-ui-node-NodeKind$-type$0$iv;
                boolean bl3 = false;
                void var51_44 = this_$iv$iv;
                void mask$iv$iv$iv = $v$c$androidx-compose-ui-node-NodeKind$-type$0$iv$iv;
                boolean $i$f$headToTail$ui = false;
                if ((NodeChain.access$getAggregateChildKindSet((NodeChain)this_$iv$iv$iv) & mask$iv$iv$iv) != 0) {
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    boolean $i$f$headToTail$ui2 = false;
                    for (Modifier.Node node$iv$iv$iv$iv = this_$iv$iv$iv$iv.getHead$ui(); node$iv$iv$iv$iv != null; node$iv$iv$iv$iv = node$iv$iv$iv$iv.getChild$ui()) {
                        Modifier.Node it$iv$iv$iv = node$iv$iv$iv$iv;
                        boolean bl4 = false;
                        if ((it$iv$iv$iv.getKindSet$ui() & mask$iv$iv$iv) != 0) {
                            void $this$dispatchForKind_u2d6rFNWt0$iv$iv$iv;
                            Modifier.Node it$iv$iv = it$iv$iv$iv;
                            boolean bl5 = false;
                            Modifier.Node node3 = it$iv$iv;
                            void $v$c$androidx-compose-ui-node-NodeKind$-kind$0$iv$iv$iv = $v$c$androidx-compose-ui-node-NodeKind$-type$0$iv$iv;
                            boolean bl6 = false;
                            MutableVector stack$iv$iv$iv = null;
                            Modifier.Node node$iv$iv$iv = null;
                            node$iv$iv$iv = $this$dispatchForKind_u2d6rFNWt0$iv$iv$iv;
                            while (node$iv$iv$iv != null) {
                                void this_$iv$iv$iv$iv2;
                                if (node$iv$iv$iv instanceof FocusTargetNode) {
                                    Modifier.Node it$iv = node$iv$iv$iv;
                                    boolean bl7 = false;
                                    node = it$iv;
                                    break block14;
                                }
                                Modifier.Node node4 = node$iv$iv$iv;
                                void $v$c$androidx-compose-ui-node-NodeKind$-kind$0$iv$iv$iv$iv = $v$c$androidx-compose-ui-node-NodeKind$-kind$0$iv$iv$iv;
                                boolean bl8 = false;
                                if ((this_$iv$iv$iv$iv2.getKindSet$ui() & $v$c$androidx-compose-ui-node-NodeKind$-kind$0$iv$iv$iv$iv) != 0 && node$iv$iv$iv instanceof DelegatingNode) {
                                    int count$iv$iv$iv = 0;
                                    DelegatingNode this_$iv$iv$iv$iv3 = (DelegatingNode)node$iv$iv$iv;
                                    boolean $i$f$forEachImmediateDelegate$ui = false;
                                    for (Modifier.Node node$iv$iv$iv$iv2 = this_$iv$iv$iv$iv3.getDelegate$ui(); node$iv$iv$iv$iv2 != null; node$iv$iv$iv$iv2 = node$iv$iv$iv$iv2.getChild$ui()) {
                                        void this_$iv$iv$iv$iv4;
                                        Modifier.Node next$iv$iv$iv = node$iv$iv$iv$iv2;
                                        boolean bl9 = false;
                                        Modifier.Node node5 = next$iv$iv$iv;
                                        $v$c$androidx-compose-ui-node-NodeKind$-kind$0$iv$iv$iv$iv = $v$c$androidx-compose-ui-node-NodeKind$-kind$0$iv$iv$iv;
                                        $i$f$isKind-H91voCI$ui = false;
                                        if (!((this_$iv$iv$iv$iv4.getKindSet$ui() & $v$c$androidx-compose-ui-node-NodeKind$-kind$0$iv$iv$iv$iv) != 0)) continue;
                                        if (++count$iv$iv$iv == 1) {
                                            node$iv$iv$iv = next$iv$iv$iv;
                                            continue;
                                        }
                                        MutableVector mutableVector = stack$iv$iv$iv;
                                        if (mutableVector == null) {
                                            boolean $i$f$mutableVectorOf = false;
                                            int capacity$iv$iv$iv$iv$iv = 16;
                                            boolean $i$f$MutableVector = false;
                                            mutableVector = new MutableVector((Object[])new Modifier.Node[capacity$iv$iv$iv$iv$iv], 0);
                                        }
                                        stack$iv$iv$iv = mutableVector;
                                        Modifier.Node theNode$iv$iv$iv = node$iv$iv$iv;
                                        if (theNode$iv$iv$iv != null) {
                                            MutableVector mutableVector2 = stack$iv$iv$iv;
                                            if (mutableVector2 != null) {
                                                mutableVector2.add((Object)theNode$iv$iv$iv);
                                            }
                                            node$iv$iv$iv = null;
                                        }
                                        MutableVector mutableVector3 = stack$iv$iv$iv;
                                        if (mutableVector3 == null) continue;
                                        mutableVector3.add((Object)next$iv$iv$iv);
                                    }
                                    if (count$iv$iv$iv == 1) continue;
                                }
                                node$iv$iv$iv = DelegatableNodeKt.access$pop(stack$iv$iv$iv);
                            }
                        }
                        if ((it$iv$iv$iv.getAggregateChildKindSet$ui() & mask$iv$iv$iv) == 0) break;
                    }
                }
                node = null;
            }
            FocusTargetNode target = (FocusTargetNode)node;
            if (target == null || !this.intersects$ui(target, left, top, right, bottom)) continue;
            bestTarget = target;
            bestDepth = node2.getDepth$ui();
        }
        return bestTarget;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean intersects$ui(@NotNull DelegatableNode $this$intersects, int left, int top, int right, int bottom) {
        void $this$fastRoundToInt$iv;
        void $this$fastRoundToInt$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$intersects, (String)"<this>");
        boolean bl = false;
        NodeCoordinator coordinator = DelegatableNodeKt.requireCoordinator-64DMado($this$intersects, NodeKind.constructor-impl(1024));
        LayoutNode layout2 = coordinator.getLayoutNode();
        if (Intrinsics.areEqual((Object)coordinator, (Object)layout2.getOuterCoordinator$ui())) {
            return true;
        }
        long localTopLeft = LayoutCoordinates.localPositionOf-S_NoaFU$default(layout2.getOuterCoordinator$ui(), coordinator, 0L, false, 6, null);
        long topLeft = layout2.getOuterCoordinator$ui().localToRoot-MK-Hz9U(localTopLeft);
        long size = coordinator.getSize-YbymL2g();
        long $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv22 = topLeft;
        boolean bl2 = false;
        long value$iv$iv = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv22;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv22 = Float.intBitsToFloat(bits$iv$iv$iv);
        boolean $i$f$fastRoundToInt = false;
        int containerLeft = Math.round((float)$this$fastRoundToInt$iv2);
        long l = size;
        boolean bl3 = false;
        long value$iv$iv2 = l;
        boolean $i$f$unpackInt1 = false;
        int containerRight = containerLeft + (int)(value$iv$iv2 >> 32);
        long $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv32 = topLeft;
        boolean bl4 = false;
        long value$iv$iv3 = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv32;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv32 = Float.intBitsToFloat(bits$iv$iv$iv2);
        boolean $i$f$fastRoundToInt2 = false;
        int containerTop = Math.round((float)$this$fastRoundToInt$iv);
        $v$c$androidx-compose-ui-unit-IntSize$-this$0$iv = size;
        boolean bl5 = false;
        long value$iv$iv4 = $v$c$androidx-compose-ui-unit-IntSize$-this$0$iv;
        boolean $i$f$unpackInt2 = false;
        int containerBottom = containerTop + (int)(value$iv$iv4 & 0xFFFFFFFFL);
        return left < containerRight && right > containerLeft && top < containerBottom && bottom > containerTop;
    }

    public final boolean isDescendantOf$ui(@NotNull LayoutNode $this$isDescendantOf, @NotNull LayoutNode container2) {
        Intrinsics.checkNotNullParameter((Object)$this$isDescendantOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        int ups = $this$isDescendantOf.getDepth$ui() - container2.getDepth$ui();
        if (ups <= 0) {
            return false;
        }
        LayoutNode node = null;
        node = $this$isDescendantOf;
        int n = 0;
        while (n < ups) {
            int it = n++;
            boolean bl = false;
            if (node.getParent$ui() != null) continue;
            return false;
        }
        return node == container2;
    }

    public final void unsetHasCallbacksFor(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this.rects.updateHasCallbacks(layoutNode.getSemanticsId(), false);
    }

    private static final Unit dispatchLambda$lambda$0(RectManager this$0) {
        this$0.dispatchToken = null;
        String sectionName$iv = "OnPositionedDispatch";
        boolean $i$f$trace = false;
        boolean bl = false;
        this$0.dispatchCallbacks();
        return Unit.INSTANCE;
    }

    public RectManager() {
        this(null, 1, null);
    }
}

