/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.client.cloudSync.impl.perEntity;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.time.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import vet.inpulse.core.models.cloud.ApiSyncResult;
import vet.inpulse.core.models.cloud.dto.EcgReportDTO;
import vet.inpulse.core.models.cloud.dto.EstablishmentDTO;
import vet.inpulse.core.models.cloud.dto.OwnerDTO;
import vet.inpulse.core.models.cloud.dto.PatientDTO;
import vet.inpulse.core.models.cloud.dto.RecordDTO;
import vet.inpulse.core.models.cloud.dto.RecordDataDTO;
import vet.inpulse.core.models.cloud.dto.SynchronizableDTO;
import vet.inpulse.core.models.cloud.dto.VeterinarianDTO;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003H\u0002\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"ref", "", "T", "Lvet/inpulse/core/models/cloud/ApiSyncResult;", "reference", "Lvet/inpulse/core/models/cloud/dto/SynchronizableDTO;", "core-client-cloud-sync"})
public final class CloudSyncClientServiceKt {
    private static final <T> String ref(ApiSyncResult<T> $this$ref) {
        StringBuilder stringBuilder;
        if (!($this$ref instanceof ApiSyncResult.V1)) {
            throw new NoWhenBranchMatchedException();
        }
        StringBuilder $this$ref_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$ref_u24lambda_u240.append("ServerSyncTime: " + ((ApiSyncResult.V1)$this$ref).getSyncTime() + ". ");
        $this$ref_u24lambda_u240.append("Downloaded: " + ((ApiSyncResult.V1)$this$ref).getDownloadList().size() + ". ");
        $this$ref_u24lambda_u240.append("SavedSuccessfully: " + ((ApiSyncResult.V1)$this$ref).getUpdateSyncTime().size() + ". ");
        $this$ref_u24lambda_u240.append("Rejected: " + ((ApiSyncResult.V1)$this$ref).getRejected().size() + ". ");
        $this$ref_u24lambda_u240.append("Failed: " + ((ApiSyncResult.V1)$this$ref).getFailedToSave() + ". ");
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String reference(SynchronizableDTO $this$reference) {
        Object object;
        SynchronizableDTO synchronizableDTO = $this$reference;
        if (synchronizableDTO instanceof EstablishmentDTO) {
            object = ((EstablishmentDTO)$this$reference).getName();
            return object;
        }
        if (synchronizableDTO instanceof OwnerDTO) {
            object = ((OwnerDTO)$this$reference).getName();
            return object;
        }
        if (synchronizableDTO instanceof PatientDTO) {
            object = ((PatientDTO)$this$reference).getName();
            return object;
        }
        if (synchronizableDTO instanceof VeterinarianDTO) {
            object = ((VeterinarianDTO)$this$reference).getName();
            return object;
        }
        if (synchronizableDTO instanceof RecordDTO) {
            StringBuilder stringBuilder;
            StringBuilder $this$reference_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            String string = ((RecordDTO)$this$reference).getRefCode();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                $this$reference_u24lambda_u242.append(it);
                $this$reference_u24lambda_u242.append(" - ");
            }
            $this$reference_u24lambda_u242.append(CloudSyncClientServiceKt.reference$toStringLocalDateTime(((RecordDTO)$this$reference).getRecordStart()));
            object = stringBuilder.toString();
            return object;
        }
        if (synchronizableDTO instanceof EcgReportDTO) {
            StringBuilder stringBuilder;
            if (!((EcgReportDTO)$this$reference instanceof EcgReportDTO.V1)) throw new NoWhenBranchMatchedException();
            StringBuilder $this$reference_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$reference_u24lambda_u243.append("EcgReport ");
            $this$reference_u24lambda_u243.append(CloudSyncClientServiceKt.reference$toStringLocalDateTime(((EcgReportDTO.V1)$this$reference).getReportDate()));
            object = stringBuilder.toString();
            return object;
        } else {
            if (!(synchronizableDTO instanceof RecordDataDTO)) return "Other-Type";
            object = ((RecordDataDTO)$this$reference).type() + "-(" + $this$reference.getId() + ")";
        }
        return object;
    }

    private static final String reference$toStringLocalDateTime(long $this$reference_u24toStringLocalDateTime) {
        return TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds($this$reference_u24toStringLocalDateTime), (TimeZone)TimeZone.Companion.currentSystemDefault()).toString();
    }

    public static final /* synthetic */ String access$reference(SynchronizableDTO $receiver) {
        return CloudSyncClientServiceKt.reference($receiver);
    }

    public static final /* synthetic */ String access$ref(ApiSyncResult $receiver) {
        return CloudSyncClientServiceKt.ref($receiver);
    }
}

