/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionNotifierServiceRecordAccess;
import com.intel.bluetooth.ServiceRecordImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;

public abstract class ServiceRecordsRegistry {
    private static Hashtable serviceRecordsMap = new Hashtable();

    private ServiceRecordsRegistry() {
    }

    static synchronized void register(BluetoothConnectionNotifierServiceRecordAccess notifier, ServiceRecordImpl serviceRecord) {
        serviceRecordsMap.put(serviceRecord, notifier);
    }

    static synchronized void unregister(ServiceRecordImpl serviceRecord) {
        serviceRecordsMap.remove(serviceRecord);
    }

    static synchronized int getDeviceServiceClasses() {
        int deviceServiceClasses = 0;
        Enumeration en = serviceRecordsMap.keys();
        while (en.hasMoreElements()) {
            ServiceRecordImpl serviceRecord = (ServiceRecordImpl)en.nextElement();
            deviceServiceClasses |= serviceRecord.deviceServiceClasses;
        }
        return deviceServiceClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateServiceRecord(ServiceRecord srvRecord) throws ServiceRegistrationException {
        Class<ServiceRecordsRegistry> clazz = ServiceRecordsRegistry.class;
        synchronized (ServiceRecordsRegistry.class) {
            BluetoothConnectionNotifierServiceRecordAccess owner = (BluetoothConnectionNotifierServiceRecordAccess)serviceRecordsMap.get(srvRecord);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (owner == null) {
                throw new IllegalArgumentException("Service record is not registered");
            }
            owner.updateServiceRecord(false);
            return;
        }
    }
}

