/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.bluetooth.DataElement;
import javax.bluetooth.UUID;

class BluetoothStackWIDCOMMSDPInputStream
extends InputStream {
    public static final boolean debug = false;
    private InputStream source;
    static final int ATTR_TYPE_INT = 0;
    static final int ATTR_TYPE_TWO_COMP = 1;
    static final int ATTR_TYPE_UUID = 2;
    static final int ATTR_TYPE_BOOL = 3;
    static final int ATTR_TYPE_ARRAY = 4;
    static final int MAX_SEQ_ENTRIES = 20;
    static final int MAX_ATTR_LEN_OLD = 256;
    private int valueSize = 0;

    protected BluetoothStackWIDCOMMSDPInputStream(InputStream in) throws IOException {
        this.source = in;
        this.readVersionInfo();
    }

    @Override
    public int read() throws IOException {
        return this.source.read();
    }

    private long readLong(int size) throws IOException {
        long result = 0L;
        for (int i = 0; i < size; ++i) {
            result += (long)this.read() << 8 * i;
        }
        return result;
    }

    private long readLongDebug(int size) throws IOException {
        long result = 0L;
        for (int i = 0; i < size; ++i) {
            int data = this.read();
            result += (long)data << 8 * i;
        }
        return result;
    }

    private int readInt() throws IOException {
        return (int)this.readLong(4);
    }

    private byte[] readBytes(int size) throws IOException {
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)this.read();
        }
        return result;
    }

    static String hexString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            buf.append(Integer.toHexString(b[i] >> 4 & 0xF));
            buf.append(Integer.toHexString(b[i] & 0xF));
        }
        return buf.toString();
    }

    static byte[] getUUIDHexBytes(UUID uuid) {
        return Utils.UUIDToByteArray(uuid);
    }

    private void readVersionInfo() throws IOException {
        this.valueSize = this.readInt();
    }

    public DataElement readElement() throws IOException {
        DataElement result = null;
        DataElement mainSeq = null;
        DataElement currentSeq = null;
        int elements = this.readInt();
        if (elements < 0 || elements > 20) {
            throw new IOException("Unexpected number of elements " + elements);
        }
        for (int i = 0; i < elements; ++i) {
            DataElement dataElement;
            boolean start_of_seq;
            int type = this.readInt();
            int length = this.readInt();
            boolean bl = start_of_seq = this.readInt() != 0;
            if (length < 0 || this.valueSize < length) {
                throw new IOException("Unexpected length " + length);
            }
            block0 : switch (type) {
                case 0: {
                    switch (length) {
                        case 1: {
                            dataElement = new DataElement(8, this.readLong(1));
                            break block0;
                        }
                        case 2: {
                            dataElement = new DataElement(9, this.readLong(2));
                            break block0;
                        }
                        case 4: {
                            dataElement = new DataElement(10, this.readLong(4));
                            break block0;
                        }
                        case 8: {
                            dataElement = new DataElement(11, this.readBytes(8));
                            break block0;
                        }
                        case 16: {
                            dataElement = new DataElement(12, this.readBytes(16));
                            break block0;
                        }
                    }
                    throw new IOException("Unknown U_INT length " + length);
                }
                case 1: {
                    switch (length) {
                        case 1: {
                            dataElement = new DataElement(16, (byte)this.readLong(1));
                            break block0;
                        }
                        case 2: {
                            dataElement = new DataElement(17, (short)this.readLong(2));
                            break block0;
                        }
                        case 4: {
                            dataElement = new DataElement(18, (int)this.readLong(4));
                            break block0;
                        }
                        case 8: {
                            dataElement = new DataElement(19, this.readLongDebug(8));
                            break block0;
                        }
                        case 16: {
                            dataElement = new DataElement(20, this.readBytes(16));
                            break block0;
                        }
                    }
                    throw new IOException("Unknown INT length " + length);
                }
                case 2: {
                    UUID uuid = null;
                    switch (length) {
                        case 2: {
                            uuid = new UUID(this.readLong(2));
                            break;
                        }
                        case 4: {
                            uuid = new UUID(this.readLong(4));
                            break;
                        }
                        case 16: {
                            uuid = new UUID(BluetoothStackWIDCOMMSDPInputStream.hexString(this.readBytes(16)), false);
                            break;
                        }
                        default: {
                            throw new IOException("Unknown UUID length " + length);
                        }
                    }
                    dataElement = new DataElement(24, uuid);
                    break;
                }
                case 3: {
                    dataElement = new DataElement(this.readLong(length) != 0L);
                    break;
                }
                case 4: {
                    dataElement = new DataElement(32, Utils.newStringUTF8(this.readBytes(length)));
                    break;
                }
                default: {
                    throw new IOException("Unknown data type " + type);
                }
            }
            if (start_of_seq) {
                DataElement newSeq = new DataElement(48);
                newSeq.addElement(dataElement);
                dataElement = newSeq;
                if (i != 0) {
                    if (mainSeq != null) {
                        mainSeq.addElement(newSeq);
                    } else {
                        result = mainSeq = new DataElement(48);
                        mainSeq.addElement(currentSeq);
                        mainSeq.addElement(newSeq);
                    }
                }
                currentSeq = newSeq;
            } else if (currentSeq != null) {
                currentSeq.addElement(dataElement);
            }
            if (result == null) {
                result = dataElement;
            }
            if (i >= elements - 1 || this.skip(this.valueSize - length) == (long)(this.valueSize - length)) continue;
            throw new IOException("Unexpected end of data");
        }
        return result;
    }
}

