/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.chat.socket;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.time.Clock;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.chat.api.StreamChatLogKt;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002()BU\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\u0010\u0006\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u0012\u001c\u0010\n\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0018\u001a\u00020\tJ\u0006\u0010\u0019\u001a\u00020\tJ\u0006\u0010\u001a\u001a\u00020\tJ\b\u0010\u001b\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\tH\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\tH\u0002J\b\u0010 \u001a\u00020!H\u0002JB\u0010\"\u001a\u00020\u0013*\u00020\u00052\u0006\u0010#\u001a\u00020\u00112'\u0010$\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010%\u00a2\u0006\u0002\b&H\u0002\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR&\u0010\n\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lvet/inpulse/chat/socket/ChatHealthMonitor;", "", "retryInterval", "Lvet/inpulse/chat/socket/ChatHealthMonitor$RetryInterval;", "userScope", "Lkotlinx/coroutines/CoroutineScope;", "checkCallback", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "reconnectCallback", "<init>", "(Lvet/inpulse/chat/socket/ChatHealthMonitor$RetryInterval;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "Lkotlin/jvm/functions/Function1;", "consecutiveFailures", "", "lastAck", "", "healthMonitorJob", "Lkotlinx/coroutines/Job;", "healthCheckJob", "reconnectJob", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "stop", "ack", "onDisconnected", "resetHealthMonitor", "postponeHealthMonitor", "postponeHealthCheck", "postponeReconnect", "stopAllJobs", "needToReconnect", "", "launchDelayed", "delayMilliseconds", "block", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lkotlinx/coroutines/CoroutineScope;JLkotlin/jvm/functions/Function2;)Lkotlinx/coroutines/Job;", "RetryInterval", "ExponencialRetryInterval", "chat-client"})
public final class ChatHealthMonitor {
    @NotNull
    private final RetryInterval retryInterval;
    @NotNull
    private final CoroutineScope userScope;
    @NotNull
    private final Function1<Continuation<? super Unit>, Object> checkCallback;
    @NotNull
    private final Function1<Continuation<? super Unit>, Object> reconnectCallback;
    private int consecutiveFailures;
    private long lastAck;
    @Nullable
    private Job healthMonitorJob;
    @Nullable
    private Job healthCheckJob;
    @Nullable
    private Job reconnectJob;
    @NotNull
    private final LoggerInterface logger;

    public ChatHealthMonitor(@NotNull RetryInterval retryInterval, @NotNull CoroutineScope userScope, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> checkCallback, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> reconnectCallback) {
        Intrinsics.checkNotNullParameter((Object)retryInterval, (String)"retryInterval");
        Intrinsics.checkNotNullParameter((Object)userScope, (String)"userScope");
        Intrinsics.checkNotNullParameter(checkCallback, (String)"checkCallback");
        Intrinsics.checkNotNullParameter(reconnectCallback, (String)"reconnectCallback");
        this.retryInterval = retryInterval;
        this.userScope = userScope;
        this.checkCallback = checkCallback;
        this.reconnectCallback = reconnectCallback;
        this.logger = StreamChatLogKt.getChatLogModule().getLogger("Chat:SocketMonitor");
    }

    public /* synthetic */ ChatHealthMonitor(RetryInterval retryInterval, CoroutineScope coroutineScope, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            retryInterval = ExponencialRetryInterval.INSTANCE;
        }
        this(retryInterval, coroutineScope, (Function1<? super Continuation<? super Unit>, ? extends Object>)function1, (Function1<? super Continuation<? super Unit>, ? extends Object>)function12);
    }

    public final void stop() {
        this.stopAllJobs();
    }

    public final void ack() {
        this.resetHealthMonitor();
    }

    public final void onDisconnected() {
        this.stopAllJobs();
        this.lastAck = 0L;
        this.postponeReconnect();
    }

    private final void resetHealthMonitor() {
        this.stopAllJobs();
        this.lastAck = Clock.System.INSTANCE.now().toEpochMilliseconds();
        this.consecutiveFailures = 0;
        this.postponeHealthMonitor();
    }

    private final void postponeHealthMonitor() {
        Job job = this.healthMonitorJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.healthMonitorJob = this.launchDelayed(this.userScope, 10000L, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ChatHealthMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (ChatHealthMonitor.access$needToReconnect(this.this$0)) {
                            ChatHealthMonitor.access$postponeReconnect(this.this$0);
                        } else {
                            ChatHealthMonitor.access$postponeHealthCheck(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void postponeHealthCheck() {
        Job job = this.healthCheckJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.healthCheckJob = this.launchDelayed(this.userScope, 1000L, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ChatHealthMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = ChatHealthMonitor.access$getCheckCallback$p(this.this$0).invoke((Object)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        ChatHealthMonitor.access$postponeHealthMonitor(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void postponeReconnect() {
        Job job = this.reconnectJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        int n = this.consecutiveFailures;
        this.consecutiveFailures = n + 1;
        long retryIntervalTime = this.retryInterval.nextInterval(n);
        this.logger.i(() -> ChatHealthMonitor.postponeReconnect$lambda$0(retryIntervalTime));
        this.reconnectJob = this.launchDelayed(this.userScope, retryIntervalTime, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ChatHealthMonitor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = ChatHealthMonitor.access$getReconnectCallback$p(this.this$0).invoke((Object)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        ChatHealthMonitor.access$postponeHealthMonitor(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void stopAllJobs() {
        block2: {
            Job job = this.reconnectJob;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            Job job2 = this.healthCheckJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            Job job3 = this.healthMonitorJob;
            if (job3 == null) break block2;
            Job.DefaultImpls.cancel$default((Job)job3, null, (int)1, null);
        }
    }

    private final boolean needToReconnect() {
        return Clock.System.INSTANCE.now().toEpochMilliseconds() - this.lastAck >= 30000L;
    }

    private final Job launchDelayed(CoroutineScope $this$launchDelayed, long delayMilliseconds, Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        return BuildersKt.launch$default((CoroutineScope)$this$launchDelayed, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(delayMilliseconds, block, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ long $delayMilliseconds;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super Unit>, Object> $block;
            {
                this.$delayMilliseconds = $delayMilliseconds;
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = DelayKt.delay((long)this.$delayMilliseconds, (Continuation)((Continuation)this));
                        if (v0 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.label = 2;
                        v1 = this.$block.invoke((Object)$this$launch, (Object)this);
                        if (v1 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final String postponeReconnect$lambda$0(long $retryIntervalTime) {
        return "Next connection attempt in " + $retryIntervalTime + " ms";
    }

    public static final /* synthetic */ boolean access$needToReconnect(ChatHealthMonitor $this) {
        return $this.needToReconnect();
    }

    public static final /* synthetic */ void access$postponeReconnect(ChatHealthMonitor $this) {
        $this.postponeReconnect();
    }

    public static final /* synthetic */ void access$postponeHealthCheck(ChatHealthMonitor $this) {
        $this.postponeHealthCheck();
    }

    public static final /* synthetic */ Function1 access$getCheckCallback$p(ChatHealthMonitor $this) {
        return $this.checkCallback;
    }

    public static final /* synthetic */ void access$postponeHealthMonitor(ChatHealthMonitor $this) {
        $this.postponeHealthMonitor();
    }

    public static final /* synthetic */ Function1 access$getReconnectCallback$p(ChatHealthMonitor $this) {
        return $this.reconnectCallback;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lvet/inpulse/chat/socket/ChatHealthMonitor$ExponencialRetryInterval;", "Lvet/inpulse/chat/socket/ChatHealthMonitor$RetryInterval;", "<init>", "()V", "nextInterval", "", "consecutiveFailures", "", "chat-client"})
    public static final class ExponencialRetryInterval
    implements RetryInterval {
        @NotNull
        public static final ExponencialRetryInterval INSTANCE = new ExponencialRetryInterval();

        private ExponencialRetryInterval() {
        }

        @Override
        public long nextInterval(int consecutiveFailures) {
            int max = Math.min(500 + consecutiveFailures * 2000, 25000);
            int min = Math.min(Math.max(250, (consecutiveFailures - 1) * 2000), 25000);
            return (long)Math.floor(Random.Default.nextFloat() * (float)(max - min) + (float)min);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lvet/inpulse/chat/socket/ChatHealthMonitor$RetryInterval;", "", "nextInterval", "", "consecutiveFailures", "", "chat-client"})
    public static interface RetryInterval {
        public long nextInterval(int var1);
    }
}

