/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.vector.PathNode;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\u001a\u001a\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\u0005\u001aX\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u001aX\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rH\u0002\u001a\r\u0010\u001e\u001a\u00020\r*\u00020\rH\u0082\b\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001f"}, d2={"EmptyArray", "", "getEmptyArray", "()[F", "toPath", "Landroidx/compose/ui/graphics/Path;", "", "Landroidx/compose/ui/graphics/vector/PathNode;", "target", "drawArc", "", "p", "x0", "", "y0", "x1", "y1", "a", "b", "theta", "isMoreThanHalf", "", "isPositiveArc", "arcToBezier", "cx", "cy", "e1x", "e1y", "start", "sweep", "toRadians", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nPathParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParserKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,573:1\n572#1:579\n35#2,5:574\n*S KotlinDebug\n*F\n+ 1 PathParser.kt\nandroidx/compose/ui/graphics/vector/PathParserKt\n*L\n432#1:579\n234#1:574,5\n*E\n"})
public final class PathParserKt {
    @NotNull
    private static final float[] EmptyArray = new float[0];

    @NotNull
    public static final float[] getEmptyArray() {
        return EmptyArray;
    }

    @NotNull
    public static final Path toPath(@NotNull List<? extends PathNode> $this$toPath, @NotNull Path target) {
        Intrinsics.checkNotNullParameter($this$toPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int fillType = target.getFillType-Rg-k1Os();
        target.rewind();
        target.setFillType-oQ8Xj4U(fillType);
        float currentX = 0.0f;
        float currentY = 0.0f;
        float ctrlX = 0.0f;
        float ctrlY = 0.0f;
        float segmentX = 0.0f;
        float segmentY = 0.0f;
        float reflectiveCtrlX = 0.0f;
        float reflectiveCtrlY = 0.0f;
        PathNode previousNode = null;
        previousNode = $this$toPath.isEmpty() ? (PathNode)PathNode.Close.INSTANCE : $this$toPath.get(0);
        List<? extends PathNode> $this$fastForEach$iv = $this$toPath;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            PathNode item$iv;
            PathNode node = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            PathNode pathNode = node;
            if (pathNode instanceof PathNode.Close) {
                currentX = segmentX;
                currentY = segmentY;
                ctrlX = segmentX;
                ctrlY = segmentY;
                target.close();
            } else if (pathNode instanceof PathNode.RelativeMoveTo) {
                target.relativeMoveTo(((PathNode.RelativeMoveTo)node).getDx(), ((PathNode.RelativeMoveTo)node).getDy());
                segmentX = currentX += ((PathNode.RelativeMoveTo)node).getDx();
                segmentY = currentY += ((PathNode.RelativeMoveTo)node).getDy();
            } else if (pathNode instanceof PathNode.MoveTo) {
                currentX = ((PathNode.MoveTo)node).getX();
                currentY = ((PathNode.MoveTo)node).getY();
                target.moveTo(((PathNode.MoveTo)node).getX(), ((PathNode.MoveTo)node).getY());
                segmentX = currentX;
                segmentY = currentY;
            } else if (pathNode instanceof PathNode.RelativeLineTo) {
                target.relativeLineTo(((PathNode.RelativeLineTo)node).getDx(), ((PathNode.RelativeLineTo)node).getDy());
                currentX += ((PathNode.RelativeLineTo)node).getDx();
                currentY += ((PathNode.RelativeLineTo)node).getDy();
            } else if (pathNode instanceof PathNode.LineTo) {
                target.lineTo(((PathNode.LineTo)node).getX(), ((PathNode.LineTo)node).getY());
                currentX = ((PathNode.LineTo)node).getX();
                currentY = ((PathNode.LineTo)node).getY();
            } else if (pathNode instanceof PathNode.RelativeHorizontalTo) {
                target.relativeLineTo(((PathNode.RelativeHorizontalTo)node).getDx(), 0.0f);
                currentX += ((PathNode.RelativeHorizontalTo)node).getDx();
            } else if (pathNode instanceof PathNode.HorizontalTo) {
                target.lineTo(((PathNode.HorizontalTo)node).getX(), currentY);
                currentX = ((PathNode.HorizontalTo)node).getX();
            } else if (pathNode instanceof PathNode.RelativeVerticalTo) {
                target.relativeLineTo(0.0f, ((PathNode.RelativeVerticalTo)node).getDy());
                currentY += ((PathNode.RelativeVerticalTo)node).getDy();
            } else if (pathNode instanceof PathNode.VerticalTo) {
                target.lineTo(currentX, ((PathNode.VerticalTo)node).getY());
                currentY = ((PathNode.VerticalTo)node).getY();
            } else if (pathNode instanceof PathNode.RelativeCurveTo) {
                target.relativeCubicTo(((PathNode.RelativeCurveTo)node).getDx1(), ((PathNode.RelativeCurveTo)node).getDy1(), ((PathNode.RelativeCurveTo)node).getDx2(), ((PathNode.RelativeCurveTo)node).getDy2(), ((PathNode.RelativeCurveTo)node).getDx3(), ((PathNode.RelativeCurveTo)node).getDy3());
                ctrlX = currentX + ((PathNode.RelativeCurveTo)node).getDx2();
                ctrlY = currentY + ((PathNode.RelativeCurveTo)node).getDy2();
                currentX += ((PathNode.RelativeCurveTo)node).getDx3();
                currentY += ((PathNode.RelativeCurveTo)node).getDy3();
            } else if (pathNode instanceof PathNode.CurveTo) {
                target.cubicTo(((PathNode.CurveTo)node).getX1(), ((PathNode.CurveTo)node).getY1(), ((PathNode.CurveTo)node).getX2(), ((PathNode.CurveTo)node).getY2(), ((PathNode.CurveTo)node).getX3(), ((PathNode.CurveTo)node).getY3());
                ctrlX = ((PathNode.CurveTo)node).getX2();
                ctrlY = ((PathNode.CurveTo)node).getY2();
                currentX = ((PathNode.CurveTo)node).getX3();
                currentY = ((PathNode.CurveTo)node).getY3();
            } else if (pathNode instanceof PathNode.RelativeReflectiveCurveTo) {
                if (previousNode.isCurve()) {
                    reflectiveCtrlX = currentX - ctrlX;
                    reflectiveCtrlY = currentY - ctrlY;
                } else {
                    reflectiveCtrlX = 0.0f;
                    reflectiveCtrlY = 0.0f;
                }
                target.relativeCubicTo(reflectiveCtrlX, reflectiveCtrlY, ((PathNode.RelativeReflectiveCurveTo)node).getDx1(), ((PathNode.RelativeReflectiveCurveTo)node).getDy1(), ((PathNode.RelativeReflectiveCurveTo)node).getDx2(), ((PathNode.RelativeReflectiveCurveTo)node).getDy2());
                ctrlX = currentX + ((PathNode.RelativeReflectiveCurveTo)node).getDx1();
                ctrlY = currentY + ((PathNode.RelativeReflectiveCurveTo)node).getDy1();
                currentX += ((PathNode.RelativeReflectiveCurveTo)node).getDx2();
                currentY += ((PathNode.RelativeReflectiveCurveTo)node).getDy2();
            } else if (pathNode instanceof PathNode.ReflectiveCurveTo) {
                if (previousNode.isCurve()) {
                    reflectiveCtrlX = (float)2 * currentX - ctrlX;
                    reflectiveCtrlY = (float)2 * currentY - ctrlY;
                } else {
                    reflectiveCtrlX = currentX;
                    reflectiveCtrlY = currentY;
                }
                target.cubicTo(reflectiveCtrlX, reflectiveCtrlY, ((PathNode.ReflectiveCurveTo)node).getX1(), ((PathNode.ReflectiveCurveTo)node).getY1(), ((PathNode.ReflectiveCurveTo)node).getX2(), ((PathNode.ReflectiveCurveTo)node).getY2());
                ctrlX = ((PathNode.ReflectiveCurveTo)node).getX1();
                ctrlY = ((PathNode.ReflectiveCurveTo)node).getY1();
                currentX = ((PathNode.ReflectiveCurveTo)node).getX2();
                currentY = ((PathNode.ReflectiveCurveTo)node).getY2();
            } else if (pathNode instanceof PathNode.RelativeQuadTo) {
                target.relativeQuadraticTo(((PathNode.RelativeQuadTo)node).getDx1(), ((PathNode.RelativeQuadTo)node).getDy1(), ((PathNode.RelativeQuadTo)node).getDx2(), ((PathNode.RelativeQuadTo)node).getDy2());
                ctrlX = currentX + ((PathNode.RelativeQuadTo)node).getDx1();
                ctrlY = currentY + ((PathNode.RelativeQuadTo)node).getDy1();
                currentX += ((PathNode.RelativeQuadTo)node).getDx2();
                currentY += ((PathNode.RelativeQuadTo)node).getDy2();
            } else if (pathNode instanceof PathNode.QuadTo) {
                target.quadraticTo(((PathNode.QuadTo)node).getX1(), ((PathNode.QuadTo)node).getY1(), ((PathNode.QuadTo)node).getX2(), ((PathNode.QuadTo)node).getY2());
                ctrlX = ((PathNode.QuadTo)node).getX1();
                ctrlY = ((PathNode.QuadTo)node).getY1();
                currentX = ((PathNode.QuadTo)node).getX2();
                currentY = ((PathNode.QuadTo)node).getY2();
            } else if (pathNode instanceof PathNode.RelativeReflectiveQuadTo) {
                if (previousNode.isQuad()) {
                    reflectiveCtrlX = currentX - ctrlX;
                    reflectiveCtrlY = currentY - ctrlY;
                } else {
                    reflectiveCtrlX = 0.0f;
                    reflectiveCtrlY = 0.0f;
                }
                target.relativeQuadraticTo(reflectiveCtrlX, reflectiveCtrlY, ((PathNode.RelativeReflectiveQuadTo)node).getDx(), ((PathNode.RelativeReflectiveQuadTo)node).getDy());
                ctrlX = currentX + reflectiveCtrlX;
                ctrlY = currentY + reflectiveCtrlY;
                currentX += ((PathNode.RelativeReflectiveQuadTo)node).getDx();
                currentY += ((PathNode.RelativeReflectiveQuadTo)node).getDy();
            } else if (pathNode instanceof PathNode.ReflectiveQuadTo) {
                if (previousNode.isQuad()) {
                    reflectiveCtrlX = (float)2 * currentX - ctrlX;
                    reflectiveCtrlY = (float)2 * currentY - ctrlY;
                } else {
                    reflectiveCtrlX = currentX;
                    reflectiveCtrlY = currentY;
                }
                target.quadraticTo(reflectiveCtrlX, reflectiveCtrlY, ((PathNode.ReflectiveQuadTo)node).getX(), ((PathNode.ReflectiveQuadTo)node).getY());
                ctrlX = reflectiveCtrlX;
                ctrlY = reflectiveCtrlY;
                currentX = ((PathNode.ReflectiveQuadTo)node).getX();
                currentY = ((PathNode.ReflectiveQuadTo)node).getY();
            } else if (pathNode instanceof PathNode.RelativeArcTo) {
                float arcStartX = ((PathNode.RelativeArcTo)node).getArcStartDx() + currentX;
                float arcStartY = ((PathNode.RelativeArcTo)node).getArcStartDy() + currentY;
                PathParserKt.drawArc(target, currentX, currentY, arcStartX, arcStartY, ((PathNode.RelativeArcTo)node).getHorizontalEllipseRadius(), ((PathNode.RelativeArcTo)node).getVerticalEllipseRadius(), ((PathNode.RelativeArcTo)node).getTheta(), ((PathNode.RelativeArcTo)node).isMoreThanHalf(), ((PathNode.RelativeArcTo)node).isPositiveArc());
                currentX = arcStartX;
                currentY = arcStartY;
                ctrlX = currentX;
                ctrlY = currentY;
            } else if (pathNode instanceof PathNode.ArcTo) {
                PathParserKt.drawArc(target, currentX, currentY, ((PathNode.ArcTo)node).getArcStartX(), ((PathNode.ArcTo)node).getArcStartY(), ((PathNode.ArcTo)node).getHorizontalEllipseRadius(), ((PathNode.ArcTo)node).getVerticalEllipseRadius(), ((PathNode.ArcTo)node).getTheta(), ((PathNode.ArcTo)node).isMoreThanHalf(), ((PathNode.ArcTo)node).isPositiveArc());
                currentX = ((PathNode.ArcTo)node).getArcStartX();
                currentY = ((PathNode.ArcTo)node).getArcStartY();
                ctrlX = currentX;
                ctrlY = currentY;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            previousNode = node;
        }
        return target;
    }

    public static /* synthetic */ Path toPath$default(List list, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = SkiaBackedPath_skikoKt.Path();
        }
        return PathParserKt.toPath(list, path);
    }

    private static final void drawArc(Path p, double x0, double y0, double x1, double y1, double a, double b, double theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        double $this$toRadians$iv = theta;
        boolean $i$f$toRadians = false;
        double thetaD = $this$toRadians$iv / (double)180 * Math.PI;
        double cosTheta = Math.cos(thetaD);
        double sinTheta = Math.sin(thetaD);
        double x0p = (x0 * cosTheta + y0 * sinTheta) / a;
        double y0p = (-x0 * sinTheta + y0 * cosTheta) / b;
        double x1p = (x1 * cosTheta + y1 * sinTheta) / a;
        double y1p = (-x1 * sinTheta + y1 * cosTheta) / b;
        double dx = x0p - x1p;
        double dy = y0p - y1p;
        double xm = (x0p + x1p) / (double)2;
        double ym = (y0p + y1p) / (double)2;
        double dsq = dx * dx + dy * dy;
        if (dsq == 0.0) {
            return;
        }
        double disc = 1.0 / dsq - 0.25;
        if (disc < 0.0) {
            float adjust = (float)(Math.sqrt(dsq) / 1.99999);
            PathParserKt.drawArc(p, x0, y0, x1, y1, a * (double)adjust, b * (double)adjust, theta, isMoreThanHalf, isPositiveArc);
            return;
        }
        double s = Math.sqrt(disc);
        double sdx = s * dx;
        double sdy = s * dy;
        double cx = 0.0;
        double cy = 0.0;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        double eta1 = Math.atan2(y1p - cy, x1p - cx);
        double sweep = eta1 - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= a;
        cx = cx * cosTheta - (cy *= b) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        PathParserKt.arcToBezier(p, cx, cy, a, b, x0, y0, thetaD, eta0, sweep);
    }

    private static final void arcToBezier(Path p, double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start, double sweep) {
        double eta1x = e1x;
        double eta1y = e1y;
        int numSegments = (int)Math.ceil(Math.abs(sweep * (double)4 / Math.PI));
        double eta1 = start;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
        double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
            double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
            double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
            double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / (double)2);
            double alpha = Math.sin(eta2 - eta1) * (Math.sqrt((double)4 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / (double)3;
            double q1x = eta1x + alpha * ep1x;
            double q1y = eta1y + alpha * ep1y;
            double q2x = e2x - alpha * ep2x;
            double q2y = e2y - alpha * ep2y;
            p.cubicTo((float)q1x, (float)q1y, (float)q2x, (float)q2y, (float)e2x, (float)e2y);
            eta1 = eta2;
            eta1x = e2x;
            eta1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }

    private static final double toRadians(double $this$toRadians) {
        boolean $i$f$toRadians = false;
        return $this$toRadians / (double)180 * Math.PI;
    }
}

