/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.shadow;

import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.Interpolatable;
import androidx.compose.ui.graphics.shadow.Shadow;
import androidx.compose.ui.unit.DpKt;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"lerpNonNull", "Landroidx/compose/ui/graphics/shadow/Shadow;", "a", "b", "t", "", "lerp", "ui-graphics"})
public final class ShadowKt {
    @NotNull
    public static final Shadow lerpNonNull(@NotNull Shadow a, @NotNull Shadow b, float t) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Object object = Interpolatable.Companion.lerp(a.getBrush(), b.getBrush(), t);
        return new Shadow(DpKt.lerp-Md-fbLM((float)a.getRadius-D9Ej5fM(), (float)b.getRadius-D9Ej5fM(), (float)t), DpKt.lerp-Md-fbLM((float)a.getSpread-D9Ej5fM(), (float)b.getSpread-D9Ej5fM(), (float)t), DpKt.lerp-xhh869w((long)a.getOffset-RKDOV3M(), (long)b.getOffset-RKDOV3M(), (float)t), ColorKt.lerp-jxsXWHM(a.getColor-0d7_KjU(), b.getColor-0d7_KjU(), t), object instanceof Brush ? (Brush)object : null, MathHelpersKt.lerp((float)a.getAlpha(), (float)b.getAlpha(), (float)t), t < 0.5f ? a.getBlendMode-0nO6VwU() : b.getBlendMode-0nO6VwU(), null);
    }

    @Nullable
    public static final Shadow lerp(@Nullable Shadow a, @Nullable Shadow b, float t) {
        Shadow shadow;
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            Shadow shadow2 = b;
            Intrinsics.checkNotNull((Object)shadow2);
            shadow = ShadowKt.lerpNonNull(shadow2.transparentCopy$ui_graphics(), b, t);
        } else {
            Shadow shadow3 = b;
            shadow = shadow3 == null ? ShadowKt.lerpNonNull(a, a.transparentCopy$ui_graphics(), t) : ShadowKt.lerpNonNull(a, shadow3, t);
        }
        return shadow;
    }
}

