/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.annotation.Size;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.ColorSpaces;
import androidx.compose.ui.graphics.colorspace.DoubleFunction;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.TransferParameters;
import androidx.compose.ui.graphics.colorspace.WhitePoint;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 _2\u00020\u0001:\u0001_B]\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014BE\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0018B]\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0019B%\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u001bB-\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u001cB1\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001a\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u001dB%\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0013\u0010\u001fB-\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0013\u0010 BA\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u001e\u001a\u00020\u0017\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010!B!\b\u0010\u0012\u0006\u0010\"\u001a\u00020\u0000\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010#J\b\u0010=\u001a\u00020\u0005H\u0007J\b\u0010>\u001a\u00020\u0005H\u0007J\b\u0010?\u001a\u00020\u0005H\u0007J\u0012\u0010=\u001a\u00020\u00052\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0007J\u0012\u0010>\u001a\u00020\u00052\b\b\u0001\u0010\b\u001a\u00020\u0005H\u0007J\u0012\u0010?\u001a\u00020\u00052\b\b\u0001\u0010+\u001a\u00020\u0005H\u0007J\u0010\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u0012H\u0016J\u0010\u0010B\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u0012H\u0016J \u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\rH\u0007J\u0012\u0010C\u001a\u00020\u00052\b\b\u0001\u0010G\u001a\u00020\u0005H\u0007J \u0010H\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\rH\u0007J\u0012\u0010H\u001a\u00020\u00052\b\b\u0001\u0010G\u001a\u00020\u0005H\u0007J\u0010\u0010I\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0016J%\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\r2\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\rH\u0010\u00a2\u0006\u0002\bOJ%\u0010P\u001a\u00020\r2\u0006\u0010L\u001a\u00020\r2\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\rH\u0010\u00a2\u0006\u0002\bQJ7\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\r2\u0006\u0010U\u001a\u00020\r2\u0006\u0010V\u001a\u00020\r2\u0006\u0010W\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0001H\u0010\u00a2\u0006\u0004\bX\u0010YJ\u0010\u0010Z\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0005H\u0016J\u0013\u0010[\u001a\u00020:2\b\u0010\\\u001a\u0004\u0018\u00010]H\u0096\u0002J\b\u0010^\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\b\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)R\u0014\u0010+\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010)R\u0014\u0010-\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010/R\u0014\u00104\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010/R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00101R\u0014\u00107\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010/R\u0014\u00109\u001a\u00020:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010;R\u0014\u0010<\u001a\u00020:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010;\u00a8\u0006`"}, d2={"Landroidx/compose/ui/graphics/colorspace/Rgb;", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "name", "", "primaries", "", "whitePoint", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "transform", "oetf", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "eotf", "min", "", "max", "transferParameters", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "id", "", "<init>", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;[FLandroidx/compose/ui/graphics/colorspace/DoubleFunction;Landroidx/compose/ui/graphics/colorspace/DoubleFunction;FFLandroidx/compose/ui/graphics/colorspace/TransferParameters;I)V", "toXYZ", "Lkotlin/Function1;", "", "(Ljava/lang/String;[FLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;FF)V", "function", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/TransferParameters;)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Landroidx/compose/ui/graphics/colorspace/TransferParameters;)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;Landroidx/compose/ui/graphics/colorspace/TransferParameters;I)V", "gamma", "(Ljava/lang/String;[FD)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;D)V", "(Ljava/lang/String;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;DFFI)V", "colorSpace", "(Landroidx/compose/ui/graphics/colorspace/Rgb;[FLandroidx/compose/ui/graphics/colorspace/WhitePoint;)V", "getWhitePoint", "()Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "getTransferParameters", "()Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "getPrimaries$ui_graphics", "()[F", "getTransform$ui_graphics", "inverseTransform", "getInverseTransform$ui_graphics", "oetfOrig", "getOetfOrig$ui_graphics", "()Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "getOetf", "()Lkotlin/jvm/functions/Function1;", "oetfFunc", "getOetfFunc$ui_graphics", "eotfOrig", "getEotfOrig$ui_graphics", "getEotf", "eotfFunc", "getEotfFunc$ui_graphics", "isWideGamut", "", "()Z", "isSrgb", "getPrimaries", "getTransform", "getInverseTransform", "getMinValue", "component", "getMaxValue", "toLinear", "r", "g", "b", "v", "fromLinear", "toXyz", "toXy", "", "v0", "v1", "v2", "toXy$ui_graphics", "toZ", "toZ$ui_graphics", "xyzaToColor", "Landroidx/compose/ui/graphics/Color;", "x", "y", "z", "a", "xyzaToColor-JlNiLsg$ui_graphics", "(FFFFLandroidx/compose/ui/graphics/colorspace/ColorSpace;)J", "fromXyz", "equals", "other", "", "hashCode", "Companion", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nRgb.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rgb.kt\nandroidx/compose/ui/graphics/colorspace/Rgb\n+ 2 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,1259:1\n638#2:1260\n653#2:1261\n668#2:1265\n638#2:1266\n653#2:1267\n668#2:1268\n53#3,3:1262\n*S KotlinDebug\n*F\n+ 1 Rgb.kt\nandroidx/compose/ui/graphics/colorspace/Rgb\n*L\n788#1:1260\n789#1:1261\n799#1:1265\n811#1:1266\n812#1:1267\n813#1:1268\n791#1:1262,3\n*E\n"})
public final class Rgb
extends ColorSpace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WhitePoint whitePoint;
    private final float min;
    private final float max;
    @Nullable
    private final TransferParameters transferParameters;
    @NotNull
    private final float[] primaries;
    @NotNull
    private final float[] transform;
    @NotNull
    private final float[] inverseTransform;
    @NotNull
    private final DoubleFunction oetfOrig;
    @NotNull
    private final Function1<Double, Double> oetf;
    @NotNull
    private final DoubleFunction oetfFunc;
    @NotNull
    private final DoubleFunction eotfOrig;
    @NotNull
    private final Function1<Double, Double> eotf;
    @NotNull
    private final DoubleFunction eotfFunc;
    private final boolean isWideGamut;
    private final boolean isSrgb;
    @NotNull
    private static final DoubleFunction DoubleIdentity = Rgb::DoubleIdentity$lambda$0;

    public Rgb(@NotNull String name, @NotNull float[] primaries, @NotNull WhitePoint whitePoint, @Nullable float[] transform, @NotNull DoubleFunction oetf, @NotNull DoubleFunction eotf, float min, float max, @Nullable TransferParameters transferParameters, int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)oetf, (String)"oetf");
        Intrinsics.checkNotNullParameter((Object)eotf, (String)"eotf");
        super(name, ColorModel.Companion.getRgb-xdoWZVw(), id, null);
        this.whitePoint = whitePoint;
        this.min = min;
        this.max = max;
        this.transferParameters = transferParameters;
        this.oetfOrig = oetf;
        this.oetf = arg_0 -> Rgb.oetf$lambda$0(this, arg_0);
        this.oetfFunc = arg_0 -> Rgb.oetfFunc$lambda$0(this, arg_0);
        this.eotfOrig = eotf;
        this.eotf = arg_0 -> Rgb.eotf$lambda$0(this, arg_0);
        this.eotfFunc = arg_0 -> Rgb.eotfFunc$lambda$0(this, arg_0);
        if (primaries.length != 6 && primaries.length != 9) {
            throw new IllegalArgumentException("The color space's primaries must be defined as an array of 6 floats in xyY or 9 floats in XYZ");
        }
        if (this.min >= this.max) {
            throw new IllegalArgumentException("Invalid range: min=" + this.min + ", max=" + this.max + "; min must be strictly < max");
        }
        this.primaries = Rgb.Companion.xyPrimaries(primaries);
        if (transform == null) {
            this.transform = Rgb.Companion.computeXYZMatrix(this.primaries, this.whitePoint);
        } else {
            if (transform.length != 9) {
                throw new IllegalArgumentException("Transform must have 9 entries! Has " + transform.length);
            }
            this.transform = transform;
        }
        this.inverseTransform = ColorSpaceKt.inverse3x3(this.transform);
        this.isWideGamut = Rgb.Companion.isWideGamut(this.primaries, this.min, this.max);
        this.isSrgb = Rgb.Companion.isSrgb(this.primaries, this.whitePoint, oetf, eotf, this.min, this.max, id);
    }

    @NotNull
    public final WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    @Nullable
    public final TransferParameters getTransferParameters() {
        return this.transferParameters;
    }

    @NotNull
    public final float[] getPrimaries$ui_graphics() {
        return this.primaries;
    }

    @NotNull
    public final float[] getTransform$ui_graphics() {
        return this.transform;
    }

    @NotNull
    public final float[] getInverseTransform$ui_graphics() {
        return this.inverseTransform;
    }

    @NotNull
    public final DoubleFunction getOetfOrig$ui_graphics() {
        return this.oetfOrig;
    }

    @NotNull
    public final Function1<Double, Double> getOetf() {
        return this.oetf;
    }

    @NotNull
    public final DoubleFunction getOetfFunc$ui_graphics() {
        return this.oetfFunc;
    }

    @NotNull
    public final DoubleFunction getEotfOrig$ui_graphics() {
        return this.eotfOrig;
    }

    @NotNull
    public final Function1<Double, Double> getEotf() {
        return this.eotf;
    }

    @NotNull
    public final DoubleFunction getEotfFunc$ui_graphics() {
        return this.eotfFunc;
    }

    @Override
    public boolean isWideGamut() {
        return this.isWideGamut;
    }

    @Override
    public boolean isSrgb() {
        return this.isSrgb;
    }

    @Size(value=6L)
    @NotNull
    public final float[] getPrimaries() {
        float[] fArray = Arrays.copyOf(this.primaries, this.primaries.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        return fArray;
    }

    @Size(value=9L)
    @NotNull
    public final float[] getTransform() {
        float[] fArray = Arrays.copyOf(this.transform, this.transform.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        return fArray;
    }

    @Size(value=9L)
    @NotNull
    public final float[] getInverseTransform() {
        float[] fArray = Arrays.copyOf(this.inverseTransform, this.inverseTransform.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        return fArray;
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(value=9L) @NotNull float[] toXYZ, @NotNull Function1<? super Double, Double> oetf, @NotNull Function1<? super Double, Double> eotf) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)toXYZ, (String)"toXYZ");
        Intrinsics.checkNotNullParameter(oetf, (String)"oetf");
        Intrinsics.checkNotNullParameter(eotf, (String)"eotf");
        this(name, Companion.computePrimaries$ui_graphics(toXYZ), Rgb.Companion.computeWhitePoint(toXYZ), null, arg_0 -> Rgb._init_$lambda$0(oetf, arg_0), arg_0 -> Rgb._init_$lambda$1(eotf, arg_0), 0.0f, 1.0f, null, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(min=6L, max=9L) @NotNull float[] primaries, @NotNull WhitePoint whitePoint, @NotNull Function1<? super Double, Double> oetf, @NotNull Function1<? super Double, Double> eotf, float min, float max) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter(oetf, (String)"oetf");
        Intrinsics.checkNotNullParameter(eotf, (String)"eotf");
        this(name, primaries, whitePoint, null, arg_0 -> Rgb._init_$lambda$2(oetf, arg_0), arg_0 -> Rgb._init_$lambda$3(eotf, arg_0), min, max, null, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(value=9L) @NotNull float[] toXYZ, @NotNull TransferParameters function) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)toXYZ, (String)"toXYZ");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this(name, Companion.computePrimaries$ui_graphics(toXYZ), Rgb.Companion.computeWhitePoint(toXYZ), function, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(min=6L, max=9L) @NotNull float[] primaries, @NotNull WhitePoint whitePoint, @NotNull TransferParameters function) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this(name, primaries, whitePoint, function, -1);
    }

    public Rgb(@NotNull String name, @NotNull float[] primaries, @NotNull WhitePoint whitePoint, @NotNull TransferParameters function, int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this(name, primaries, whitePoint, null, Rgb.Companion.generateOetf(function), Rgb.Companion.generateEotf(function), 0.0f, 1.0f, function, id);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(value=9L) @NotNull float[] toXYZ, double gamma) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)toXYZ, (String)"toXYZ");
        this(name, Companion.computePrimaries$ui_graphics(toXYZ), Rgb.Companion.computeWhitePoint(toXYZ), gamma, 0.0f, 1.0f, -1);
    }

    public Rgb(@Size(min=1L) @NotNull String name, @Size(min=6L, max=9L) @NotNull float[] primaries, @NotNull WhitePoint whitePoint, double gamma) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        this(name, primaries, whitePoint, gamma, 0.0f, 1.0f, -1);
    }

    public Rgb(@NotNull String name, @NotNull float[] primaries, @NotNull WhitePoint whitePoint, double gamma, float min, float max, int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        this(name, primaries, whitePoint, null, gamma == 1.0 ? DoubleIdentity : arg_0 -> Rgb._init_$lambda$4(gamma, arg_0), gamma == 1.0 ? DoubleIdentity : arg_0 -> Rgb._init_$lambda$5(gamma, arg_0), min, max, new TransferParameters(gamma, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 96, null), id);
    }

    public Rgb(@NotNull Rgb colorSpace, @NotNull float[] transform, @NotNull WhitePoint whitePoint) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        this(colorSpace.getName(), colorSpace.primaries, whitePoint, transform, colorSpace.oetfOrig, colorSpace.eotfOrig, colorSpace.min, colorSpace.max, colorSpace.transferParameters, -1);
    }

    @Size(min=6L)
    @NotNull
    public final float[] getPrimaries(@Size(min=6L) @NotNull float[] primaries) {
        Intrinsics.checkNotNullParameter((Object)primaries, (String)"primaries");
        return ArraysKt.copyInto$default((float[])this.primaries, (float[])primaries, (int)0, (int)0, (int)0, (int)14, null);
    }

    @Size(min=9L)
    @NotNull
    public final float[] getTransform(@Size(min=9L) @NotNull float[] transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        return ArraysKt.copyInto$default((float[])this.transform, (float[])transform, (int)0, (int)0, (int)0, (int)14, null);
    }

    @Size(min=9L)
    @NotNull
    public final float[] getInverseTransform(@Size(min=9L) @NotNull float[] inverseTransform) {
        Intrinsics.checkNotNullParameter((Object)inverseTransform, (String)"inverseTransform");
        return ArraysKt.copyInto$default((float[])this.inverseTransform, (float[])inverseTransform, (int)0, (int)0, (int)0, (int)14, null);
    }

    @Override
    public float getMinValue(int component) {
        return this.min;
    }

    @Override
    public float getMaxValue(int component) {
        return this.max;
    }

    @Size(value=3L)
    @NotNull
    public final float[] toLinear(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.toLinear(fArray);
    }

    @Size(min=3L)
    @NotNull
    public final float[] toLinear(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (v.length < 3) {
            return v;
        }
        v[0] = (float)this.eotfFunc.invoke(v[0]);
        v[1] = (float)this.eotfFunc.invoke(v[1]);
        v[2] = (float)this.eotfFunc.invoke(v[2]);
        return v;
    }

    @Size(value=3L)
    @NotNull
    public final float[] fromLinear(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.fromLinear(fArray);
    }

    @Size(min=3L)
    @NotNull
    public final float[] fromLinear(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (v.length < 3) {
            return v;
        }
        v[0] = (float)this.oetfFunc.invoke(v[0]);
        v[1] = (float)this.oetfFunc.invoke(v[1]);
        v[2] = (float)this.oetfFunc.invoke(v[2]);
        return v;
    }

    @Override
    @NotNull
    public float[] toXyz(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (v.length < 3) {
            return v;
        }
        v[0] = (float)this.eotfFunc.invoke(v[0]);
        v[1] = (float)this.eotfFunc.invoke(v[1]);
        v[2] = (float)this.eotfFunc.invoke(v[2]);
        return ColorSpaceKt.mul3x3Float3(this.transform, v);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long toXy$ui_graphics(float v0, float v1, float v2) {
        void val1$iv;
        void r1$iv;
        void r0$iv;
        void lhs$iv;
        float r1$iv2;
        void r0$iv22;
        void lhs$iv2;
        float v00 = (float)this.eotfFunc.invoke(v0);
        float v10 = (float)this.eotfFunc.invoke(v1);
        float v20 = (float)this.eotfFunc.invoke(v2);
        if (this.transform.length < 9) {
            return 0L;
        }
        float[] fArray = this.transform;
        float f = v00;
        float f2 = v10;
        float r2$iv = v20;
        boolean $i$f$mul3x3Float3_0 = false;
        void x = lhs$iv2[0] * r0$iv22 + lhs$iv2[3] * r1$iv2 + lhs$iv2[6] * r2$iv;
        float[] r0$iv22 = this.transform;
        r1$iv2 = v00;
        r2$iv = v10;
        float r2$iv2 = v20;
        boolean $i$f$mul3x3Float3_1 = false;
        void y = lhs$iv[1] * r0$iv + lhs$iv[4] * r1$iv + lhs$iv[7] * r2$iv2;
        lhs$iv = x;
        void val2$iv = y;
        boolean $i$f$packFloats = false;
        long v1$iv = Float.floatToRawIntBits((float)val1$iv);
        long v2$iv = Float.floatToRawIntBits((float)val2$iv);
        return v1$iv << 32 | v2$iv & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public float toZ$ui_graphics(float v0, float v1, float v2) {
        void r1$iv;
        void r0$iv;
        void lhs$iv;
        float v00 = (float)this.eotfFunc.invoke(v0);
        float v10 = (float)this.eotfFunc.invoke(v1);
        float v20 = (float)this.eotfFunc.invoke(v2);
        float[] fArray = this.transform;
        float f = v00;
        float f2 = v10;
        float r2$iv = v20;
        boolean $i$f$mul3x3Float3_2 = false;
        void z = lhs$iv[2] * r0$iv + lhs$iv[5] * r1$iv + lhs$iv[8] * r2$iv;
        return (float)z;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long xyzaToColor-JlNiLsg$ui_graphics(float x, float y, float z, float a, @NotNull ColorSpace colorSpace) {
        void r1$iv;
        void r0$iv;
        void lhs$iv;
        float r1$iv2;
        void r0$iv32;
        void lhs$iv2;
        float r1$iv3;
        void r0$iv22;
        void lhs$iv3;
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        float[] fArray = this.inverseTransform;
        float f = x;
        float f2 = y;
        float r2$iv = z;
        boolean $i$f$mul3x3Float3_0 = false;
        float v0 = lhs$iv3[0] * r0$iv22 + lhs$iv3[3] * r1$iv3 + lhs$iv3[6] * r2$iv;
        float[] r0$iv22 = this.inverseTransform;
        r1$iv3 = x;
        r2$iv = y;
        float r2$iv2 = z;
        boolean $i$f$mul3x3Float3_1 = false;
        float v1 = lhs$iv2[1] * r0$iv32 + lhs$iv2[4] * r1$iv2 + lhs$iv2[7] * r2$iv2;
        float[] r0$iv32 = this.inverseTransform;
        r1$iv2 = x;
        r2$iv2 = y;
        float r2$iv3 = z;
        boolean $i$f$mul3x3Float3_2 = false;
        float v2 = lhs$iv[2] * r0$iv + lhs$iv[5] * r1$iv + lhs$iv[8] * r2$iv3;
        v0 = (float)this.oetfFunc.invoke(v0);
        v1 = (float)this.oetfFunc.invoke(v1);
        v2 = (float)this.oetfFunc.invoke(v2);
        return ColorKt.Color(v0, v1, v2, a, colorSpace);
    }

    @Override
    @NotNull
    public float[] fromXyz(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        ColorSpaceKt.mul3x3Float3(this.inverseTransform, v);
        if (v.length < 3) {
            return v;
        }
        v[0] = (float)this.oetfFunc.invoke(v[0]);
        v[1] = (float)this.oetfFunc.invoke(v[1]);
        v[2] = (float)this.oetfFunc.invoke(v[2]);
        return v;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Rgb rgb = (Rgb)other;
        if (Float.compare(rgb.min, this.min) != 0) {
            return false;
        }
        if (Float.compare(rgb.max, this.max) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.whitePoint, (Object)rgb.whitePoint)) {
            return false;
        }
        if (!Arrays.equals(this.primaries, rgb.primaries)) {
            return false;
        }
        if (this.transferParameters != null) {
            return Intrinsics.areEqual((Object)this.transferParameters, (Object)rgb.transferParameters);
        }
        if (rgb.transferParameters == null) {
            return true;
        }
        return !Intrinsics.areEqual((Object)this.oetfOrig, (Object)rgb.oetfOrig) ? false : Intrinsics.areEqual((Object)this.eotfOrig, (Object)rgb.eotfOrig);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.whitePoint.hashCode();
        result = 31 * result + Arrays.hashCode(this.primaries);
        result = 31 * result + (!(this.min == 0.0f) ? Float.floatToIntBits(this.min) : 0);
        result = 31 * result + (!(this.max == 0.0f) ? Float.floatToIntBits(this.max) : 0);
        TransferParameters transferParameters = this.transferParameters;
        result = 31 * result + (transferParameters != null ? transferParameters.hashCode() : 0);
        if (this.transferParameters == null) {
            result = 31 * result + this.oetfOrig.hashCode();
            result = 31 * result + this.eotfOrig.hashCode();
        }
        return result;
    }

    private static final double oetf$lambda$0(Rgb this$0, double x) {
        return RangesKt.coerceIn((double)this$0.oetfOrig.invoke(x), (double)this$0.min, (double)this$0.max);
    }

    private static final double oetfFunc$lambda$0(Rgb this$0, double x) {
        return RangesKt.coerceIn((double)this$0.oetfOrig.invoke(x), (double)this$0.min, (double)this$0.max);
    }

    private static final double eotf$lambda$0(Rgb this$0, double x) {
        return this$0.eotfOrig.invoke(RangesKt.coerceIn((double)x, (double)this$0.min, (double)this$0.max));
    }

    private static final double eotfFunc$lambda$0(Rgb this$0, double x) {
        return this$0.eotfOrig.invoke(RangesKt.coerceIn((double)x, (double)this$0.min, (double)this$0.max));
    }

    private static final double _init_$lambda$0(Function1 $oetf, double x) {
        return ((Number)$oetf.invoke((Object)x)).doubleValue();
    }

    private static final double _init_$lambda$1(Function1 $eotf, double x) {
        return ((Number)$eotf.invoke((Object)x)).doubleValue();
    }

    private static final double _init_$lambda$2(Function1 $oetf, double x) {
        return ((Number)$oetf.invoke((Object)x)).doubleValue();
    }

    private static final double _init_$lambda$3(Function1 $eotf, double x) {
        return ((Number)$eotf.invoke((Object)x)).doubleValue();
    }

    private static final double _init_$lambda$4(double $gamma, double x) {
        return Math.pow(x < 0.0 ? 0.0 : x, 1.0 / $gamma);
    }

    private static final double _init_$lambda$5(double $gamma, double x) {
        return Math.pow(x < 0.0 ? 0.0 : x, $gamma);
    }

    private static final double DoubleIdentity$lambda$0(double d) {
        return d;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J)\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0082\bJ\u0018\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002J\u0015\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\tH\u0002J\u0010\u0010&\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010'\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Landroidx/compose/ui/graphics/colorspace/Rgb$Companion;", "", "<init>", "()V", "DoubleIdentity", "Landroidx/compose/ui/graphics/colorspace/DoubleFunction;", "isSrgb", "", "primaries", "", "whitePoint", "Landroidx/compose/ui/graphics/colorspace/WhitePoint;", "OETF", "EOTF", "min", "", "max", "id", "", "compare", "point", "", "a", "b", "isWideGamut", "area", "cross", "ax", "ay", "bx", "by", "contains", "p1", "p2", "computePrimaries", "toXYZ", "computePrimaries$ui_graphics", "computeWhitePoint", "xyPrimaries", "computeXYZMatrix", "generateOetf", "function", "Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "generateEotf", "ui-graphics"})
    @SourceDebugExtension(value={"SMAP\nRgb.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rgb.kt\nandroidx/compose/ui/graphics/colorspace/Rgb$Companion\n*L\n1#1,1259:1\n977#1:1260\n977#1:1261\n977#1:1262\n977#1:1263\n977#1:1264\n977#1:1265\n*S KotlinDebug\n*F\n+ 1 Rgb.kt\nandroidx/compose/ui/graphics/colorspace/Rgb$Companion\n*L\n1050#1:1260\n1051#1:1261\n1057#1:1262\n1058#1:1263\n1063#1:1264\n1064#1:1265\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSrgb(float[] primaries, WhitePoint whitePoint, DoubleFunction OETF, DoubleFunction EOTF, float min, float max, int id) {
            if (id == 0) {
                return true;
            }
            if (!ColorSpaceKt.compare(primaries, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics())) {
                return false;
            }
            if (!ColorSpaceKt.compare(whitePoint, Illuminant.INSTANCE.getD65())) {
                return false;
            }
            if (!(min == 0.0f)) {
                return false;
            }
            if (!(max == 1.0f)) {
                return false;
            }
            Rgb srgb = ColorSpaces.INSTANCE.getSrgb();
            for (double x = 0.0; x <= 1.0; x += 0.00392156862745098) {
                if (!this.compare(x, OETF, srgb.getOetfOrig$ui_graphics())) {
                    return false;
                }
                if (this.compare(x, EOTF, srgb.getEotfOrig$ui_graphics())) continue;
                return false;
            }
            return true;
        }

        private final boolean compare(double point, DoubleFunction a, DoubleFunction b) {
            double rB;
            double rA = a.invoke(point);
            return Math.abs(rA - (rB = b.invoke(point))) <= 0.001;
        }

        private final boolean isWideGamut(float[] primaries, float min, float max) {
            return this.area(primaries) / this.area(ColorSpaces.INSTANCE.getNtsc1953Primaries$ui_graphics()) > 0.9f && this.contains(primaries, ColorSpaces.INSTANCE.getSrgbPrimaries$ui_graphics()) || min < 0.0f && max > 1.0f;
        }

        private final float area(float[] primaries) {
            if (primaries.length < 6) {
                return 0.0f;
            }
            float rx = primaries[0];
            float gy = primaries[3];
            float ry = primaries[1];
            float bx = primaries[4];
            float gx = primaries[2];
            float by = primaries[5];
            float det = rx * gy + ry * bx + gx * by - gy * bx - ry * gx - rx * by;
            float r = 0.5f * det;
            return r < 0.0f ? -r : r;
        }

        private final float cross(float ax, float ay, float bx, float by) {
            boolean $i$f$cross = false;
            return ax * by - ay * bx;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean contains(float[] p1, float[] p2) {
            float bx$iv;
            float ay$iv;
            float ax$iv;
            float[] fArray = new float[]{p1[0] - p2[0], p1[1] - p2[1], p1[2] - p2[2], p1[3] - p2[3], p1[4] - p2[4], p1[5] - p2[5]};
            float[] p0 = fArray;
            Companion companion = this;
            float f = p0[0];
            float f2 = p0[1];
            float f3 = p2[0] - p2[4];
            float by$iv = p2[1] - p2[5];
            boolean $i$f$cross = false;
            if (ax$iv * by$iv - ay$iv * bx$iv < 0.0f) return false;
            Companion companion2 = this;
            ax$iv = p2[0] - p2[2];
            ay$iv = p2[1] - p2[3];
            bx$iv = p0[0];
            by$iv = p0[1];
            $i$f$cross = false;
            if (ax$iv * by$iv - ay$iv * bx$iv < 0.0f) {
                return false;
            }
            Companion companion3 = this;
            ax$iv = p0[2];
            ay$iv = p0[3];
            bx$iv = p2[2] - p2[0];
            by$iv = p2[3] - p2[1];
            $i$f$cross = false;
            if (ax$iv * by$iv - ay$iv * bx$iv < 0.0f) return false;
            Companion companion4 = this;
            ax$iv = p2[2] - p2[4];
            ay$iv = p2[3] - p2[5];
            bx$iv = p0[2];
            by$iv = p0[3];
            $i$f$cross = false;
            if (ax$iv * by$iv - ay$iv * bx$iv < 0.0f) {
                return false;
            }
            Companion companion5 = this;
            ax$iv = p0[4];
            ay$iv = p0[5];
            bx$iv = p2[4] - p2[2];
            by$iv = p2[5] - p2[3];
            $i$f$cross = false;
            if (ax$iv * by$iv - ay$iv * bx$iv < 0.0f) return false;
            Companion companion6 = this;
            ax$iv = p2[4] - p2[0];
            ay$iv = p2[5] - p2[1];
            bx$iv = p0[4];
            by$iv = p0[5];
            $i$f$cross = false;
            if (ax$iv * by$iv - ay$iv * bx$iv < 0.0f) return false;
            return true;
        }

        @NotNull
        public final float[] computePrimaries$ui_graphics(@NotNull float[] toXYZ) {
            Intrinsics.checkNotNullParameter((Object)toXYZ, (String)"toXYZ");
            float[] fArray = new float[]{1.0f, 0.0f, 0.0f};
            float[] r = ColorSpaceKt.mul3x3Float3(toXYZ, fArray);
            float[] fArray2 = new float[]{0.0f, 1.0f, 0.0f};
            float[] g = ColorSpaceKt.mul3x3Float3(toXYZ, fArray2);
            float[] fArray3 = new float[]{0.0f, 0.0f, 1.0f};
            float[] b = ColorSpaceKt.mul3x3Float3(toXYZ, fArray3);
            float rSum = r[0] + r[1] + r[2];
            float gSum = g[0] + g[1] + g[2];
            float bSum = b[0] + b[1] + b[2];
            float[] fArray4 = new float[]{r[0] / rSum, r[1] / rSum, g[0] / gSum, g[1] / gSum, b[0] / bSum, b[1] / bSum};
            return fArray4;
        }

        private final WhitePoint computeWhitePoint(float[] toXYZ) {
            float[] fArray = new float[]{1.0f, 1.0f, 1.0f};
            float[] w = ColorSpaceKt.mul3x3Float3(toXYZ, fArray);
            float sum = w[0] + w[1] + w[2];
            return new WhitePoint(w[0] / sum, w[1] / sum);
        }

        private final float[] xyPrimaries(float[] primaries) {
            float[] xyPrimaries = new float[6];
            if (primaries.length == 9) {
                float sum = primaries[0] + primaries[1] + primaries[2];
                xyPrimaries[0] = primaries[0] / sum;
                xyPrimaries[1] = primaries[1] / sum;
                sum = primaries[3] + primaries[4] + primaries[5];
                xyPrimaries[2] = primaries[3] / sum;
                xyPrimaries[3] = primaries[4] / sum;
                sum = primaries[6] + primaries[7] + primaries[8];
                xyPrimaries[4] = primaries[6] / sum;
                xyPrimaries[5] = primaries[7] / sum;
            } else {
                ArraysKt.copyInto$default((float[])primaries, (float[])xyPrimaries, (int)0, (int)0, (int)6, (int)6, null);
            }
            return xyPrimaries;
        }

        private final float[] computeXYZMatrix(float[] primaries, WhitePoint whitePoint) {
            float rx = primaries[0];
            float ry = primaries[1];
            float gx = primaries[2];
            float gy = primaries[3];
            float bx = primaries[4];
            float by = primaries[5];
            float wx = whitePoint.getX();
            float wy = whitePoint.getY();
            float oneRxRy = (1.0f - rx) / ry;
            float oneGxGy = (1.0f - gx) / gy;
            float oneBxBy = (1.0f - bx) / by;
            float oneWxWy = (1.0f - wx) / wy;
            float rxRy = rx / ry;
            float gxGy = gx / gy;
            float bxBy = bx / by;
            float wxWy = wx / wy;
            float byNumerator = (oneWxWy - oneRxRy) * (gxGy - rxRy) - (wxWy - rxRy) * (oneGxGy - oneRxRy);
            float byDenominator = (oneBxBy - oneRxRy) * (gxGy - rxRy) - (bxBy - rxRy) * (oneGxGy - oneRxRy);
            float bY = byNumerator / byDenominator;
            float gY = (wxWy - rxRy - bY * (bxBy - rxRy)) / (gxGy - rxRy);
            float rY = 1.0f - gY - bY;
            float rYRy = rY / ry;
            float gYGy = gY / gy;
            float bYBy = bY / by;
            float[] fArray = new float[]{rYRy * rx, rY, rYRy * (1.0f - rx - ry), gYGy * gx, gY, gYGy * (1.0f - gx - gy), bYBy * bx, bY, bYBy * (1.0f - bx - by)};
            return fArray;
        }

        private final DoubleFunction generateOetf(TransferParameters function) {
            return function.isHLGish$ui_graphics() ? arg_0 -> Companion.generateOetf$lambda$0(function, arg_0) : (function.isPQish$ui_graphics() ? arg_0 -> Companion.generateOetf$lambda$1(function, arg_0) : (function.getE() == 0.0 && function.getF() == 0.0 ? arg_0 -> Companion.generateOetf$lambda$2(function, arg_0) : arg_0 -> Companion.generateOetf$lambda$3(function, arg_0)));
        }

        private final DoubleFunction generateEotf(TransferParameters function) {
            return function.isHLGish$ui_graphics() ? arg_0 -> Companion.generateEotf$lambda$0(function, arg_0) : (function.isPQish$ui_graphics() ? arg_0 -> Companion.generateEotf$lambda$1(function, arg_0) : (function.getE() == 0.0 && function.getF() == 0.0 ? arg_0 -> Companion.generateEotf$lambda$2(function, arg_0) : arg_0 -> Companion.generateEotf$lambda$3(function, arg_0)));
        }

        private static final double generateOetf$lambda$0(TransferParameters $function, double x) {
            return ColorSpaces.INSTANCE.transferHlgOetf$ui_graphics($function, x);
        }

        private static final double generateOetf$lambda$1(TransferParameters $function, double x) {
            return ColorSpaces.INSTANCE.transferSt2048Oetf$ui_graphics($function, x);
        }

        private static final double generateOetf$lambda$2(TransferParameters $function, double x) {
            return ColorSpaceKt.rcpResponse(x, $function.getA(), $function.getB(), $function.getC(), $function.getD(), $function.getGamma());
        }

        private static final double generateOetf$lambda$3(TransferParameters $function, double x) {
            return ColorSpaceKt.rcpResponse(x, $function.getA(), $function.getB(), $function.getC(), $function.getD(), $function.getE(), $function.getF(), $function.getGamma());
        }

        private static final double generateEotf$lambda$0(TransferParameters $function, double x) {
            return ColorSpaces.INSTANCE.transferHlgEotf$ui_graphics($function, x);
        }

        private static final double generateEotf$lambda$1(TransferParameters $function, double x) {
            return ColorSpaces.INSTANCE.transferSt2048Eotf$ui_graphics($function, x);
        }

        private static final double generateEotf$lambda$2(TransferParameters $function, double x) {
            return ColorSpaceKt.response(x, $function.getA(), $function.getB(), $function.getC(), $function.getD(), $function.getGamma());
        }

        private static final double generateEotf$lambda$3(TransferParameters $function, double x) {
            return ColorSpaceKt.response(x, $function.getA(), $function.getB(), $function.getC(), $function.getD(), $function.getE(), $function.getF(), $function.getGamma());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

