/*
 * Decompiled with CFR 0.152.
 */
package dev.romainguy.kotlin.math;

import dev.romainguy.kotlin.math.RationalKt;
import kotlin.Metadata;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0014\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\b\b\u0087@\u0018\u0000 C2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001CB\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\tJ\r\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\tJ\u001e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000f\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010\tJ\r\u0010 \u001a\u00020\u001a\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u001a\u00a2\u0006\u0004\b$\u0010\"J\r\u0010%\u001a\u00020\u001a\u00a2\u0006\u0004\b&\u0010\"J\r\u0010'\u001a\u00020\u001a\u00a2\u0006\u0004\b(\u0010\"J\u001e\u0010)\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b*\u0010\u0018J\u001e\u0010+\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b,\u0010\u0018J\u001e\u0010-\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b.\u0010\u0018J\r\u0010/\u001a\u000200\u00a2\u0006\u0004\b1\u00102J\r\u00103\u001a\u000204\u00a2\u0006\u0004\b5\u00106J\r\u00107\u001a\u00020\u0007\u00a2\u0006\u0004\b8\u0010\tJ\r\u00109\u001a\u00020\u0003\u00a2\u0006\u0004\b:\u0010\u0005J\u000f\u0010;\u001a\u00020<H\u0016\u00a2\u0006\u0004\b=\u0010>J\u0019\u0010?\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b@\u0010\u0005J\u0019\u0010A\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\bB\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u0088\u0001\u0002\u0092\u0001\u00020\u0003\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006D"}, d2={"Ldev/romainguy/kotlin/math/Rational;", "", "r", "", "constructor-impl", "(J)J", "denominator", "", "getDenominator-impl", "(J)I", "numerator", "getNumerator-impl", "sign", "getSign-impl", "compareTo", "other", "compareTo-CiJUd3Q", "(JJ)I", "component1", "component1-impl", "component2", "component2-impl", "div", "div-UUAewD0", "(JJ)J", "equals", "", "", "equals-impl", "(JLjava/lang/Object;)Z", "hashCode", "hashCode-impl", "isFinite", "isFinite-impl", "(J)Z", "isInfinite", "isInfinite-impl", "isNaN", "isNaN-impl", "isZero", "isZero-impl", "minus", "minus-UUAewD0", "plus", "plus-UUAewD0", "times", "times-UUAewD0", "toDouble", "", "toDouble-impl", "(J)D", "toFloat", "", "toFloat-impl", "(J)F", "toInt", "toInt-impl", "toLong", "toLong-impl", "toString", "", "toString-impl", "(J)Ljava/lang/String;", "unaryMinus", "unaryMinus--nfT5vM", "unaryPlus", "unaryPlus--nfT5vM", "Companion", "kotlin-math"})
public final class Rational
implements Comparable<Rational> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long r;
    private static final long NaN = RationalKt.Rational(0, 0);
    private static final long POSITIVE_INFINITY = RationalKt.Rational(1, 0);
    private static final long NEGATIVE_INFINITY = RationalKt.Rational(-1, 0);
    private static final long ZERO = RationalKt.Rational(0, 1);

    public static final int getSign-impl(long arg0) {
        return (int)(arg0 >>> 32) < 0 ? -1 : 1;
    }

    public static final int getNumerator-impl(long arg0) {
        return (int)(arg0 >>> 32);
    }

    public static final int getDenominator-impl(long arg0) {
        return (int)(arg0 & 0xFFFFFFFFL);
    }

    public static final int component1-impl(long arg0) {
        return Rational.getNumerator-impl(arg0);
    }

    public static final int component2-impl(long arg0) {
        return Rational.getDenominator-impl(arg0);
    }

    public static final boolean isNaN-impl(long arg0) {
        return arg0 == 0L;
    }

    public static final boolean isFinite-impl(long arg0) {
        return Rational.getDenominator-impl(arg0) != 0;
    }

    public static final boolean isInfinite-impl(long arg0) {
        return Rational.getNumerator-impl(arg0) != 0 && Rational.getDenominator-impl(arg0) == 0;
    }

    public static final boolean isZero-impl(long arg0) {
        return Rational.getNumerator-impl(arg0) == 0 && Rational.getDenominator-impl(arg0) != 0;
    }

    public static final double toDouble-impl(long arg0) {
        return (double)Rational.getNumerator-impl(arg0) / (double)Rational.getDenominator-impl(arg0);
    }

    public static final float toFloat-impl(long arg0) {
        return (float)Rational.getNumerator-impl(arg0) / (float)Rational.getDenominator-impl(arg0);
    }

    public static final int toInt-impl(long arg0) {
        return Rational.isNaN-impl(arg0) ? 0 : (Rational.isInfinite-impl(arg0) ? (Rational.getSign-impl(arg0) > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE) : Rational.getNumerator-impl(arg0) / Rational.getDenominator-impl(arg0));
    }

    public static final long toLong-impl(long arg0) {
        return Rational.isNaN-impl(arg0) ? 0L : (Rational.isInfinite-impl(arg0) ? (Rational.getSign-impl(arg0) > 0 ? Long.MAX_VALUE : Long.MIN_VALUE) : (long)Rational.getNumerator-impl(arg0) / (long)Rational.getDenominator-impl(arg0));
    }

    public static final long unaryMinus--nfT5vM(long arg0) {
        return RationalKt.Rational(-Rational.getNumerator-impl(arg0), Rational.getDenominator-impl(arg0));
    }

    public static final long unaryPlus--nfT5vM(long arg0) {
        return Rational.constructor-impl(arg0);
    }

    public static final long plus-UUAewD0(long arg0, long other) {
        if (arg0 == 0L || other == 0L) {
            return NaN;
        }
        long n = Rational.getNumerator-impl(arg0);
        long d = Rational.getDenominator-impl(arg0);
        if (n != 0L && d == 0L) {
            return arg0;
        }
        long on = Rational.getNumerator-impl(other);
        long od = Rational.getDenominator-impl(other);
        if (on != 0L && od == 0L) {
            return arg0;
        }
        long a = n * od;
        long b = d * on;
        n = a + b;
        long gcd = RationalKt.access$gcd(n, d *= od);
        return Rational.constructor-impl((n /= gcd) << 32 | (d /= gcd));
    }

    public static final long minus-UUAewD0(long arg0, long other) {
        return Rational.plus-UUAewD0(arg0, Rational.unaryMinus--nfT5vM(other));
    }

    public static final long times-UUAewD0(long arg0, long other) {
        if (arg0 == 0L || other == 0L) {
            return NaN;
        }
        long n = Rational.getNumerator-impl(arg0);
        long d = Rational.getDenominator-impl(arg0);
        if (n != 0L && d == 0L) {
            return arg0;
        }
        long on = Rational.getNumerator-impl(other);
        long od = Rational.getDenominator-impl(other);
        if (on != 0L && od == 0L) {
            return arg0;
        }
        long gcd = RationalKt.access$gcd(n *= on, d *= od);
        return Rational.constructor-impl((n /= gcd) << 32 | (d /= gcd));
    }

    public static final long div-UUAewD0(long arg0, long other) {
        if (arg0 == 0L || other == 0L) {
            return NaN;
        }
        long n = Rational.getNumerator-impl(arg0);
        long d = Rational.getDenominator-impl(arg0);
        if (n != 0L && d == 0L) {
            return arg0;
        }
        long on = Rational.getDenominator-impl(other);
        long od = Rational.getNumerator-impl(other);
        if (on == 0L && od != 0L) {
            return ZERO;
        }
        long gcd = RationalKt.access$gcd(n *= on, d *= od);
        return Rational.constructor-impl((n /= gcd) << 32 | (d /= gcd));
    }

    public static int compareTo-CiJUd3Q(long arg0, long other) {
        int n;
        if (arg0 == other) {
            return 0;
        }
        if (Rational.isNaN-impl(arg0)) {
            n = 1;
        } else if (Rational.isNaN-impl(other)) {
            n = -1;
        } else if (Rational.isInfinite-impl(arg0) && Rational.isInfinite-impl(other)) {
            n = Rational.getSign-impl(arg0) > Rational.getSign-impl(other) ? 1 : -1;
        } else {
            long b;
            long a = (long)Rational.getNumerator-impl(arg0) * (long)Rational.getDenominator-impl(other);
            return a > (b = (long)Rational.getNumerator-impl(other) * (long)Rational.getDenominator-impl(arg0)) ? 1 : -1;
        }
        return n;
    }

    public int compareTo-CiJUd3Q(long other) {
        return Rational.compareTo-CiJUd3Q(this.r, other);
    }

    @NotNull
    public static String toString-impl(long arg0) {
        return Rational.isNaN-impl(arg0) ? "NaN" : (Rational.isInfinite-impl(arg0) ? (Rational.getSign-impl(arg0) > 0 ? "+" : "-") + "Infinity" : (Rational.isZero-impl(arg0) ? (Rational.getSign-impl(arg0) < 0 ? "-" : "") + '0' : (Rational.getDenominator-impl(arg0) == 1 ? String.valueOf(Rational.getNumerator-impl(arg0)) : "" + Rational.getNumerator-impl(arg0) + '/' + Rational.getDenominator-impl(arg0))));
    }

    @NotNull
    public String toString() {
        return Rational.toString-impl(this.r);
    }

    public static int hashCode-impl(long arg0) {
        return Long.hashCode(arg0);
    }

    public int hashCode() {
        return Rational.hashCode-impl(this.r);
    }

    public static boolean equals-impl(long arg0, Object other) {
        if (!(other instanceof Rational)) {
            return false;
        }
        long l = ((Rational)other).unbox-impl();
        return arg0 == l;
    }

    public boolean equals(Object other) {
        return Rational.equals-impl(this.r, other);
    }

    private /* synthetic */ Rational(long r) {
        this.r = r;
    }

    public static long constructor-impl(long r) {
        return r;
    }

    public static final /* synthetic */ Rational box-impl(long v) {
        return new Rational(v);
    }

    public final /* synthetic */ long unbox-impl() {
        return this.r;
    }

    public static final boolean equals-impl0(long p1, long p2) {
        return p1 == p2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\b\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\t\u0010\u0006R\u001c\u0010\n\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000b\u0010\u0006R\u001c\u0010\f\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\r\u0010\u0006\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000e"}, d2={"Ldev/romainguy/kotlin/math/Rational$Companion;", "", "()V", "NEGATIVE_INFINITY", "Ldev/romainguy/kotlin/math/Rational;", "getNEGATIVE_INFINITY--nfT5vM", "()J", "J", "NaN", "getNaN--nfT5vM", "POSITIVE_INFINITY", "getPOSITIVE_INFINITY--nfT5vM", "ZERO", "getZERO--nfT5vM", "kotlin-math"})
    public static final class Companion {
        private Companion() {
        }

        public final long getNaN--nfT5vM() {
            return NaN;
        }

        public final long getPOSITIVE_INFINITY--nfT5vM() {
            return POSITIVE_INFINITY;
        }

        public final long getNEGATIVE_INFINITY--nfT5vM() {
            return NEGATIVE_INFINITY;
        }

        public final long getZERO--nfT5vM() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

