/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material;

import androidx.compose.foundation.text.selection.TextSelectionColors;
import androidx.compose.material.Colors;
import androidx.compose.material.ColorsKt;
import androidx.compose.material.ContentAlpha;
import androidx.compose.material.ContentColorKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocal;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000e\u001a\u0015\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u00a2\u0006\u0002\u0010\u0004\u001a'\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a'\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a/\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001f\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\"\u000e\u0010\u0018\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"rememberTextSelectionColors", "Landroidx/compose/foundation/text/selection/TextSelectionColors;", "colors", "Landroidx/compose/material/Colors;", "(Landroidx/compose/material/Colors;Landroidx/compose/runtime/Composer;I)Landroidx/compose/foundation/text/selection/TextSelectionColors;", "calculateSelectionBackgroundColor", "Landroidx/compose/ui/graphics/Color;", "selectionColor", "textColor", "backgroundColor", "calculateSelectionBackgroundColor-ysEtTa8", "(JJJ)J", "binarySearchForAccessibleSelectionColorAlpha", "", "binarySearchForAccessibleSelectionColorAlpha-ysEtTa8", "(JJJ)F", "calculateContrastRatio", "selectionColorAlpha", "calculateContrastRatio-nb2GgbA", "(JFJJ)F", "foreground", "background", "calculateContrastRatio--OWjLjI", "(JJ)F", "DefaultSelectionBackgroundAlpha", "MinimumSelectionBackgroundAlpha", "DesiredContrastRatio", "material"})
@SourceDebugExtension(value={"SMAP\nMaterialTextSelectionColors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaterialTextSelectionColors.kt\nandroidx/compose/material/MaterialTextSelectionColorsKt\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 CompositionLocal.kt\nandroidx/compose/runtime/CompositionLocal\n+ 4 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,244:1\n646#2:245\n635#2:246\n75#3:247\n1128#4,6:248\n*S KotlinDebug\n*F\n+ 1 MaterialTextSelectionColors.kt\nandroidx/compose/material/MaterialTextSelectionColorsKt\n*L\n45#1:245\n45#1:246\n45#1:247\n47#1:248,6\n*E\n"})
public final class MaterialTextSelectionColorsKt {
    private static final float DefaultSelectionBackgroundAlpha = 0.4f;
    private static final float MinimumSelectionBackgroundAlpha = 0.2f;
    private static final float DesiredContrastRatio = 4.5f;

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public static final TextSelectionColors rememberTextSelectionColors(@NotNull Colors colors, @Nullable Composer $composer, int $changed) {
        Object object;
        void $this$cache$iv;
        long l;
        void $v$c$androidx-compose-ui-graphics-Color$-$this$takeOrElse$0$iv22;
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-721696685, (String)"C(rememberTextSelectionColors)N(colors)45@1907L6,46@1926L418:MaterialTextSelectionColors.kt#jmzs0o");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-721696685, (int)$changed, (int)-1, (String)"androidx.compose.material.rememberTextSelectionColors (MaterialTextSelectionColors.kt:35)");
        }
        long primaryColor = colors.getPrimary-0d7_KjU();
        long backgroundColor = colors.getBackground-0d7_KjU();
        $composer.startReplaceGroup(-2060762245);
        ComposerKt.sourceInformation((Composer)$composer, (String)"*44@1858L7");
        long l2 = ColorsKt.contentColorFor-4WTKRHQ(colors, backgroundColor);
        boolean bl = false;
        void $v$c$androidx-compose-ui-graphics-Color$-$this$isSpecified$0$iv$iv = $v$c$androidx-compose-ui-graphics-Color$-$this$takeOrElse$0$iv22;
        boolean bl2 = false;
        if ($v$c$androidx-compose-ui-graphics-Color$-$this$isSpecified$0$iv$iv != 16L) {
            l = $v$c$androidx-compose-ui-graphics-Color$-$this$takeOrElse$0$iv22;
        } else {
            void this_$iv;
            void $composer$iv;
            boolean bl3 = false;
            CompositionLocal compositionLocal = (CompositionLocal)ContentColorKt.getLocalContentColor();
            Composer composer = $composer;
            int $changed$iv = 6;
            boolean $i$f$getCurrent = false;
            ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)2023513938, (String)"CC(<get-current>):CompositionLocal.kt#9igjgp");
            Object object2 = $composer$iv.consume((CompositionLocal)this_$iv);
            ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
            l = ((Color)object2).unbox-impl();
        }
        void var9_18 = l;
        $composer.endReplaceGroup();
        long textColorWithLowestAlpha = Color.copy-wmQWz5c$default((long)var9_18, (float)ContentAlpha.INSTANCE.getMedium($composer, 6), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null);
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-2060758699, (String)"CC(remember):MaterialTextSelectionColors.kt#9igjgp");
        Composer $v$c$androidx-compose-ui-graphics-Color$-$this$takeOrElse$0$iv22 = $composer;
        boolean invalid$iv = $composer.changed(primaryColor) | $composer.changed(backgroundColor) | $composer.changed(textColorWithLowestAlpha);
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl4 = false;
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            boolean bl5 = false;
            TextSelectionColors value$iv = new TextSelectionColors(colors.getPrimary-0d7_KjU(), MaterialTextSelectionColorsKt.calculateSelectionBackgroundColor-ysEtTa8(primaryColor, textColorWithLowestAlpha, backgroundColor), null);
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        TextSelectionColors textSelectionColors = (TextSelectionColors)object;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        TextSelectionColors textSelectionColors2 = textSelectionColors;
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return textSelectionColors2;
    }

    public static final long calculateSelectionBackgroundColor-ysEtTa8(long l, long l2, long l3) {
        float maximumContrastRatio = MaterialTextSelectionColorsKt.calculateContrastRatio-nb2GgbA(l, 0.4f, l2, l3);
        float minimumContrastRatio = MaterialTextSelectionColorsKt.calculateContrastRatio-nb2GgbA(l, 0.2f, l2, l3);
        float alpha = maximumContrastRatio >= 4.5f ? 0.4f : (minimumContrastRatio < 4.5f ? 0.2f : MaterialTextSelectionColorsKt.binarySearchForAccessibleSelectionColorAlpha-ysEtTa8(l, l2, l3));
        return Color.copy-wmQWz5c$default((long)l, (float)alpha, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null);
    }

    private static final float binarySearchForAccessibleSelectionColorAlpha-ysEtTa8(long l, long l2, long l3) {
        int maxAttempts = 7;
        float lowAlpha = 0.2f;
        float alpha = 0.4f;
        float highAlpha = 0.4f;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            float contrastRatio = MaterialTextSelectionColorsKt.calculateContrastRatio-nb2GgbA(l, alpha, l2, l3);
            float percentageError = contrastRatio / 4.5f - 1.0f;
            if (0.0f <= percentageError ? percentageError <= 0.01f : false) break;
            if (percentageError < 0.0f) {
                highAlpha = alpha;
            } else {
                lowAlpha = alpha;
            }
            alpha = (highAlpha + lowAlpha) / 2.0f;
        }
        return alpha;
    }

    private static final float calculateContrastRatio-nb2GgbA(long l, float selectionColorAlpha, long l2, long l3) {
        long compositeBackground = ColorKt.compositeOver--OWjLjI((long)Color.copy-wmQWz5c$default((long)l, (float)selectionColorAlpha, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), (long)l3);
        long compositeTextColor = ColorKt.compositeOver--OWjLjI((long)l2, (long)compositeBackground);
        return MaterialTextSelectionColorsKt.calculateContrastRatio--OWjLjI(compositeTextColor, compositeBackground);
    }

    public static final float calculateContrastRatio--OWjLjI(long l, long l2) {
        float foregroundLuminance = ColorKt.luminance-8_81llA((long)l) + 0.05f;
        float backgroundLuminance = ColorKt.luminance-8_81llA((long)l2) + 0.05f;
        return Math.max(foregroundLuminance, backgroundLuminance) / Math.min(foregroundLuminance, backgroundLuminance);
    }
}

