/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.wavelet;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.math.SignalUtilsKt;
import vet.inpulse.math.wavelet.CoefficientRanges;
import vet.inpulse.math.wavelet.Wavelet;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001aZ\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u001aZ\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u001a)\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0013\u001aN\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007\u001aF\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007\u001a!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0016\u001a+\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\b\b\u0002\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"dwt", "", "wavelet", "Lvet/inpulse/math/wavelet/Wavelet;", "data", "", "srcOffset", "", "srcStride", "dest", "destOffset", "destStride", "length", "level", "workspace", "idwt", "decompose", "", "levels", "(Lvet/inpulse/math/wavelet/Wavelet;[DI)[[D", "decomposeCompact", "Lvet/inpulse/math/wavelet/CoefficientRanges;", "(Lvet/inpulse/math/wavelet/Wavelet;[D)[[D", "recompose", "decomposition", "(Lvet/inpulse/math/wavelet/Wavelet;[[DI)[D", "math"})
@SourceDebugExtension(value={"SMAP\nWaveletTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaveletTransform.kt\nvet/inpulse/math/wavelet/WaveletTransformKt\n+ 2 SignalUtils.kt\nvet/inpulse/math/SignalUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n206#2:179\n206#2:180\n206#2:182\n206#2:183\n1#3:181\n*S KotlinDebug\n*F\n+ 1 WaveletTransform.kt\nvet/inpulse/math/wavelet/WaveletTransformKt\n*L\n25#1:179\n68#1:180\n141#1:182\n145#1:183\n*E\n"})
public final class WaveletTransformKt {
    public static final void dwt(@NotNull Wavelet wavelet, @NotNull double[] data, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length, int level, @Nullable double[] workspace) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)wavelet, (String)"wavelet");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        ArraysUtilsKt.requireBinaryAndGetMaxLevel(length, level);
        if (length < 2) {
            return;
        }
        if (level == 0) {
            int i = 0;
            while (i < length) {
                int offset$iv;
                int stride$iv;
                int n = destOffset;
                int n2 = destStride;
                int index$iv = i;
                boolean $i$f$element = false;
                int n3 = index$iv * stride$iv + offset$iv;
                offset$iv = destOffset;
                stride$iv = destStride;
                index$iv = i++;
                $i$f$element = false;
                dest[n3] = data[index$iv * stride$iv + offset$iv];
            }
            return;
        }
        if (workspace != null) {
            if (!(workspace.length >= length)) {
                String stride$iv = "Failed requirement.";
                throw new IllegalArgumentException(stride$iv.toString());
            }
            dArray = workspace;
        } else {
            dArray = new double[length];
        }
        double[] w = dArray;
        wavelet.forwardStep(data, srcOffset, srcStride, dest, destOffset, destStride, length, w);
        int i = length >> 1;
        for (int l = 1; i >= 2 && l < level; i >>= 1, ++l) {
            wavelet.forwardStep(dest, destOffset, destStride, dest, destOffset, destStride, i, w);
        }
    }

    public static /* synthetic */ void dwt$default(Wavelet wavelet, double[] dArray, int n, int n2, double[] dArray2, int n3, int n4, int n5, int n6, double[] dArray3, int n7, Object object) {
        if ((n7 & 0x200) != 0) {
            dArray3 = null;
        }
        WaveletTransformKt.dwt(wavelet, dArray, n, n2, dArray2, n3, n4, n5, n6, dArray3);
    }

    public static final void idwt(@NotNull Wavelet wavelet, @NotNull double[] data, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length, int level, @Nullable double[] workspace) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)wavelet, (String)"wavelet");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int maxLevels = ArraysUtilsKt.requireBinaryAndGetMaxLevel(length, level);
        if (length < 2) {
            return;
        }
        if (level == 0) {
            int i = 0;
            while (i < length) {
                int offset$iv;
                int stride$iv;
                int n = destOffset;
                int n2 = destStride;
                int index$iv = i;
                boolean $i$f$element = false;
                int n3 = index$iv * stride$iv + offset$iv;
                offset$iv = destOffset;
                stride$iv = destStride;
                index$iv = i++;
                $i$f$element = false;
                dest[n3] = data[index$iv * stride$iv + offset$iv];
            }
            return;
        }
        int h = 2;
        for (int i = level; i < maxLevels; ++i) {
            h <<= 1;
        }
        if (workspace != null) {
            if (!(workspace.length >= length)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            dArray = workspace;
        } else {
            dArray = new double[length];
        }
        double[] w = dArray;
        wavelet.inverseStep(data, srcOffset, srcStride, dest, destOffset, destStride, h, w);
        h <<= 1;
        while (h <= length) {
            wavelet.inverseStep(dest, destOffset, destStride, dest, destOffset, destStride, h, w);
            h <<= 1;
        }
    }

    public static /* synthetic */ void idwt$default(Wavelet wavelet, double[] dArray, int n, int n2, double[] dArray2, int n3, int n4, int n5, int n6, double[] dArray3, int n7, Object object) {
        if ((n7 & 0x200) != 0) {
            dArray3 = null;
        }
        WaveletTransformKt.idwt(wavelet, dArray, n, n2, dArray2, n3, n4, n5, n6, dArray3);
    }

    @NotNull
    public static final double[][] decompose(@NotNull Wavelet wavelet, @NotNull double[] data, int levels) {
        Intrinsics.checkNotNullParameter((Object)wavelet, (String)"wavelet");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int l = SignalUtilsKt.binaryLog(data.length);
        if (!(l >= levels)) {
            boolean $i$a$-require-WaveletTransformKt$decompose$22 = false;
            String $i$a$-require-WaveletTransformKt$decompose$22 = "levels must not exceed " + l + " max levels for this array";
            throw new IllegalArgumentException($i$a$-require-WaveletTransformKt$decompose$22.toString());
        }
        int $i$a$-require-WaveletTransformKt$decompose$22 = 0;
        int n = l + 1;
        double[][] dArrayArray = new double[n][];
        while ($i$a$-require-WaveletTransformKt$decompose$22 < n) {
            int n2 = $i$a$-require-WaveletTransformKt$decompose$22++;
            dArrayArray[n2] = new double[data.length];
        }
        double[][] decomposition = dArrayArray;
        double[] workspace = new double[data.length];
        int p = 0;
        if (p <= l) {
            while (true) {
                WaveletTransformKt.dwt(wavelet, data, 0, 1, decomposition[p], 0, 1, data.length, p, workspace);
                if (p == l) break;
                ++p;
            }
        }
        return decomposition;
    }

    @NotNull
    public static final CoefficientRanges decomposeCompact(@NotNull Wavelet wavelet, @NotNull double[] data, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length, int level) {
        int offset$iv;
        int stride$iv;
        int offset$iv2;
        Intrinsics.checkNotNullParameter((Object)wavelet, (String)"wavelet");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!SignalUtilsKt.isBinary(length)) {
            boolean $i$a$-require-WaveletTransformKt$decomposeCompact$32 = false;
            String $i$a$-require-WaveletTransformKt$decomposeCompact$32 = "length must be power of 2";
            throw new IllegalArgumentException($i$a$-require-WaveletTransformKt$decomposeCompact$32.toString());
        }
        int maxLevels = SignalUtilsKt.binaryLog(length);
        if (!(level <= maxLevels)) {
            boolean $i$a$-require-WaveletTransformKt$decomposeCompact$42 = false;
            String $i$a$-require-WaveletTransformKt$decomposeCompact$42 = "level requested exceeds maximum level";
            throw new IllegalArgumentException($i$a$-require-WaveletTransformKt$decomposeCompact$42.toString());
        }
        ArraysUtilsKt.copy(data, srcOffset, srcStride, dest, destOffset, destStride, length);
        double[] workspace = new double[length];
        Object[] ranges = new IntProgression[level + 1];
        int h = length;
        int hh = h >> 1;
        int l = 1;
        if (l <= level) {
            while (true) {
                int stride$iv2;
                WaveletTransformKt.dwt(wavelet, dest, destOffset, destStride, dest, destOffset, destStride, h, 1, workspace);
                int n = destOffset;
                int n2 = destStride;
                int index$iv = hh;
                boolean $i$f$element = false;
                int n3 = index$iv * stride$iv2 + offset$iv2;
                offset$iv2 = destOffset;
                stride$iv2 = destStride;
                index$iv = hh << 1;
                $i$f$element = false;
                ranges[level + 1 - l] = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)n3, (int)(index$iv * stride$iv2 + offset$iv2))), (int)destStride);
                hh = (h >>= 1) >> 1;
                if (l == level) break;
                ++l;
            }
        }
        l = destOffset;
        offset$iv2 = destStride;
        int index$iv = 0;
        boolean $i$f$element = false;
        int n = index$iv * stride$iv + offset$iv;
        offset$iv = destOffset;
        stride$iv = destStride;
        index$iv = h;
        $i$f$element = false;
        ranges[0] = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)n, (int)(index$iv * stride$iv + offset$iv))), (int)destStride);
        return new CoefficientRanges((IntProgression[])ArraysKt.requireNoNulls((Object[])ranges));
    }

    @NotNull
    public static final CoefficientRanges decomposeCompact(@NotNull Wavelet wavelet, @NotNull double[] data, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length) {
        Intrinsics.checkNotNullParameter((Object)wavelet, (String)"wavelet");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return WaveletTransformKt.decomposeCompact(wavelet, data, srcOffset, srcStride, dest, destOffset, destStride, length, SignalUtilsKt.binaryLog(length));
    }

    @NotNull
    public static final double[][] decompose(@NotNull Wavelet wavelet, @NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)wavelet, (String)"wavelet");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return WaveletTransformKt.decompose(wavelet, data, SignalUtilsKt.binaryLog(data.length));
    }

    @NotNull
    public static final double[] recompose(@NotNull Wavelet wavelet, @NotNull double[][] decomposition, int level) {
        Intrinsics.checkNotNullParameter((Object)wavelet, (String)"wavelet");
        Intrinsics.checkNotNullParameter((Object)decomposition, (String)"decomposition");
        if (!(((Object[])decomposition).length >= level)) {
            boolean bl = false;
            String string = "decomposition must have size > level";
            throw new IllegalArgumentException(string.toString());
        }
        double[] ret = new double[decomposition[0].length];
        WaveletTransformKt.idwt$default(wavelet, decomposition[level], 0, 1, ret, 0, 1, ret.length, level, null, 512, null);
        return ret;
    }

    public static /* synthetic */ double[] recompose$default(Wavelet wavelet, double[][] dArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return WaveletTransformKt.recompose(wavelet, dArray, n);
    }
}

