/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.wavelet;

import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.math.wavelet.Wavelet;
import vet.inpulse.math.wavelet.WaveletCoefficients;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"VALID_DB", "Lkotlin/ranges/IntProgression;", "getVALID_DB", "()Lkotlin/ranges/IntProgression;", "dbn", "Lvet/inpulse/math/wavelet/Wavelet;", "n", "", "dbnCentered", "math"})
@SourceDebugExtension(value={"SMAP\nDaubechies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Daubechies.kt\nvet/inpulse/math/wavelet/DaubechiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class DaubechiesKt {
    @NotNull
    private static final IntProgression VALID_DB = RangesKt.step((IntProgression)((IntProgression)new IntRange(4, 20)), (int)2);

    @NotNull
    public static final IntProgression getVALID_DB() {
        return VALID_DB;
    }

    @NotNull
    public static final Wavelet dbn(int n) {
        if (!(n % 2 == 0)) {
            boolean $i$a$-require-DaubechiesKt$dbn$32 = false;
            String $i$a$-require-DaubechiesKt$dbn$32 = "n is not even";
            throw new IllegalArgumentException($i$a$-require-DaubechiesKt$dbn$32.toString());
        }
        if (!(4 <= n ? n < 21 : false)) {
            boolean $i$a$-require-DaubechiesKt$dbn$42 = false;
            String $i$a$-require-DaubechiesKt$dbn$42 = "n is not in [4; 20]";
            throw new IllegalArgumentException($i$a$-require-DaubechiesKt$dbn$42.toString());
        }
        double[] scalingCoeffs = switch (n) {
            case 4 -> {
                double[] var3_6 = new double[]{0.48296291314453416, 0.8365163037378079, 0.2241438680420134, -0.12940952255126037};
                yield var3_6;
            }
            case 6 -> {
                double[] var3_6 = new double[]{0.33267055295008263, 0.8068915093110925, 0.45987750211849154, -0.13501102001025458, -0.08544127388202666, 0.03522629188570953};
                yield var3_6;
            }
            case 8 -> {
                double[] var3_6 = new double[]{0.2303778133088965, 0.7148465705529157, 0.6308807679298589, -0.027983769416859854, -0.18703481171909309, 0.030841381835560764, 0.0328830116668852, -0.010597401785069032};
                yield var3_6;
            }
            case 10 -> {
                double[] var3_6 = new double[]{0.16010239797419293, 0.6038292697971896, 0.7243085284377729, 0.13842814590132074, -0.24229488706638203, -0.032244869584638375, 0.07757149384004572, -0.006241490212798274, -0.012580751999081999, 0.0033357252854737712};
                yield var3_6;
            }
            case 12 -> {
                double[] var3_6 = new double[]{0.11154074335010947, 0.49462389039845306, 0.7511339080210954, 0.31525035170919763, -0.22626469396543983, -0.12976686756726194, 0.09750160558732304, 0.027522865530305727, -0.03158203931748603, 5.538422011614961E-4, 0.004777257510945511, -0.0010773010853084796};
                yield var3_6;
            }
            case 14 -> {
                double[] var3_6 = new double[]{0.07785205408500918, 0.3965393194819173, 0.7291320908462351, 0.4697822874051931, -0.14390600392856498, -0.22403618499387498, 0.07130921926683026, 0.08061260915108308, -0.03802993693501441, -0.01657454163066688, 0.01255099855609984, 4.295779729213665E-4, -0.0018016407040474908, 3.5371379997452024E-4};
                yield var3_6;
            }
            case 16 -> {
                double[] var3_6 = new double[]{0.05441584224310401, 0.31287159091429995, 0.6756307362972898, 0.5853546836542067, -0.015829105256349306, -0.2840155429615469, 4.724845739132828E-4, 0.12874742662047847, -0.017369301001807547, -0.044088253930794755, 0.013981027917398282, 0.008746094047405777, -0.004870352993451574, -3.9174037337694705E-4, 6.754494064505693E-4, -1.1747678412476953E-4};
                yield var3_6;
            }
            case 18 -> {
                double[] var3_6 = new double[]{0.038077947363878345, 0.24383467461259034, 0.6048231236901112, 0.6572880780513005, 0.13319738582500756, -0.2932737832791749, -0.09684078322297646, 0.14854074933810638, 0.03072568147933338, -0.06763282906132997, 2.5094711483145197E-4, 0.022361662123679096, -0.004723204757751397, -0.00428150368246343, 0.0018476468830562265, 2.3038576352319597E-4, -2.519631889427101E-4, 3.93473203162716E-5};
                yield var3_6;
            }
            case 20 -> {
                double[] var3_6 = new double[]{0.026670057900555554, 0.1881768000776915, 0.5272011889317256, 0.6884590394536035, 0.2811723436605775, -0.24984642432731538, -0.19594627437737705, 0.12736934033579325, 0.09305736460357235, -0.07139414716639708, -0.029457536821875813, 0.033212674059341, 0.0036065535669561697, -0.010733175483330575, 0.001395351747052901, 0.001992405295185056, -6.858566949597116E-4, -1.1646685512928545E-4, 9.358867032006959E-5, -1.3264202894521244E-5};
                yield var3_6;
            }
            default -> throw new IllegalStateException("n is not even and not in [4; 20]");
        };
        WaveletCoefficients coeffs = Wavelet.Companion.buildOrthonormalSpace(scalingCoeffs);
        return new Wavelet("DB" + n, 2, coeffs.getScalingDecompositionCoefficients(), coeffs.getWaveletDecompositionCoefficients(), coeffs.getScalingReconstructionCoefficients(), coeffs.getWaveletReconstructionCoefficients(), 0, 64, null);
    }

    @NotNull
    public static final Wavelet dbnCentered(int n) {
        return Wavelet.copy$default(DaubechiesKt.dbn(n), null, 0, null, null, null, null, n >> 1, 63, null);
    }
}

