/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.linalg;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.SignalUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0019\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0086\u0002J!\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000bH\u0086\u0002J#\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000e2\u0010\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\u0015H\u0086\u0002J\u0018\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\u00172\u0006\u0010\u000f\u001a\u00020\u000eJ\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u0086\nJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u000eH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Lvet/inpulse/math/linalg/Matrix3x3;", "", "data", "", "<init>", "([D)V", "()V", "getData", "()[D", "diag", "Lkotlin/sequences/Sequence;", "", "get", "i", "", "j", "set", "", "value", "row", "values", "Lvet/inpulse/math/linalg/Row;", "col", "Lvet/inpulse/math/linalg/Column;", "plus", "other", "times", "component1", "copy", "equals", "", "hashCode", "toString", "", "math"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\nvet/inpulse/math/linalg/Matrix3x3\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Matrix.kt\nvet/inpulse/math/linalg/MatrixKt\n*L\n1#1,116:1\n1#2:117\n1332#3,3:118\n12#4,3:121\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\nvet/inpulse/math/linalg/Matrix3x3\n*L\n48#1:118,3\n77#1:121,3\n*E\n"})
public final class Matrix3x3 {
    @NotNull
    private final double[] data;

    public Matrix3x3(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        if (!(this.data.length == 9)) {
            boolean bl = false;
            String string = "data size is not 9";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final double[] getData() {
        return this.data;
    }

    public Matrix3x3() {
        this(new double[9]);
    }

    @NotNull
    public final Sequence<Double> diag() {
        return SignalUtilsKt.filterByIndex(this.data, RangesKt.step((IntProgression)((IntProgression)new IntRange(0, 8)), (int)4));
    }

    public final double get(int i, int j) {
        int index = i * 3 + j;
        return this.data[index];
    }

    public final void set(int i, int j, double value) {
        int index = i * 3 + j;
        this.data[index] = value;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int row, @NotNull Sequence<Double> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Sequence<Double> $this$forEachIndexed$iv = values;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void v;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            double d = ((Number)item$iv).doubleValue();
            int i = n;
            boolean bl = false;
            this.set(row, i, (double)v);
        }
    }

    @NotNull
    public final Sequence<Double> row(int i) {
        return SignalUtilsKt.filterByIndex(this.data, (IntProgression)new IntRange(i * 3, i * 3 + 2));
    }

    @NotNull
    public final Sequence<Double> col(int j) {
        return SignalUtilsKt.filterByIndex(this.data, RangesKt.step((IntProgression)((IntProgression)new IntRange(j, 8)), (int)3));
    }

    @NotNull
    public final Matrix3x3 plus(@NotNull Matrix3x3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] d = new double[]{this.data[0] + other.data[0], this.data[1] + other.data[1], this.data[2] + other.data[2], this.data[3] + other.data[3], this.data[4] + other.data[4], this.data[5] + other.data[5], this.data[6] + other.data[6], this.data[7] + other.data[7], this.data[8] + other.data[8]};
        d[9] = this.data[9] + other.data[9];
        return new Matrix3x3(d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Matrix3x3 times(@NotNull Matrix3x3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$times = false;
        Matrix3x3 ret = new Matrix3x3();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                void col$iv;
                void $this$times$iv;
                Sequence<Double> sequence = this.row(i);
                Sequence<Double> sequence2 = other.col(j);
                int n = j;
                int n2 = i;
                Matrix3x3 matrix3x3 = ret;
                boolean $i$f$times2 = false;
                Sequence sequence3 = SequencesKt.zip((Sequence)$this$times$iv, (Sequence)col$iv);
                double d = 0.0;
                for (Object e : sequence3) {
                    Pair pair = (Pair)e;
                    double d2 = d;
                    boolean bl = false;
                    double i$iv = ((Number)pair.component1()).doubleValue();
                    double j$iv = ((Number)pair.component2()).doubleValue();
                    double d3 = i$iv * j$iv;
                    d = d2 + d3;
                }
                double d4 = d;
                matrix3x3.set(n2, n, d4);
            }
        }
        return ret;
    }

    @NotNull
    public final double[] component1() {
        return this.data;
    }

    @NotNull
    public final Matrix3x3 copy(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new Matrix3x3(data);
    }

    public static /* synthetic */ Matrix3x3 copy$default(Matrix3x3 matrix3x3, double[] dArray, int n, Object object) {
        if ((n & 1) != 0) {
            dArray = matrix3x3.data;
        }
        return matrix3x3.copy(dArray);
    }

    @NotNull
    public String toString() {
        return "Matrix3x3(data=" + Arrays.toString(this.data) + ")";
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Matrix3x3)) {
            return false;
        }
        Matrix3x3 matrix3x3 = (Matrix3x3)other;
        return Intrinsics.areEqual((Object)this.data, (Object)matrix3x3.data);
    }
}

