/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math.complex;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.complex.Polar;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\r\u001a\u00020\u0000J\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0002J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001cH\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001cH\u0086\u0002J\t\u0010\u001f\u001a\u00020\u001eH\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001cH\u0086\u0002J\u0011\u0010!\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010!\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010#\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010#\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010%\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010&\u001a\u00020'J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010.\u001a\u00020\u001cH\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012\u00a8\u00061"}, d2={"Lvet/inpulse/math/complex/Complex;", "", "real", "", "imag", "<init>", "(DD)V", "getReal", "()D", "setReal", "(D)V", "getImag", "setImag", "set1R", "set", "c", "conj", "getConj", "()Lvet/inpulse/math/complex/Complex;", "magSqr", "getMagSqr", "mag", "getMag", "reciprocal", "getReciprocal", "plus", "r", "", "", "plusAssign", "", "unaryPlus", "minus", "minusAssign", "times", "timesAssign", "div", "divAssign", "toPolar", "Lvet/inpulse/math/complex/Polar;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "math"})
@SourceDebugExtension(value={"SMAP\nComplex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Complex.kt\nvet/inpulse/math/complex/Complex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class Complex {
    private double real;
    private double imag;

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public /* synthetic */ Complex(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        this(d, d2);
    }

    public final double getReal() {
        return this.real;
    }

    public final void setReal(double d) {
        this.real = d;
    }

    public final double getImag() {
        return this.imag;
    }

    public final void setImag(double d) {
        this.imag = d;
    }

    @NotNull
    public final Complex set1R() {
        this.real = 1.0;
        this.imag = 0.0;
        return this;
    }

    @NotNull
    public final Complex set(double real, double imag) {
        this.real = real;
        this.imag = imag;
        return this;
    }

    @NotNull
    public final Complex set(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.real = c.real;
        this.imag = c.imag;
        return this;
    }

    @NotNull
    public final Complex getConj() {
        return new Complex(this.real, -this.imag);
    }

    public final double getMagSqr() {
        return Math.pow(this.real, 2) + Math.pow(this.imag, 2);
    }

    public final double getMag() {
        return Math.sqrt(this.getMagSqr());
    }

    @NotNull
    public final Complex getReciprocal() {
        double x = this.real;
        double y = this.imag;
        double realPart = x / this.getMagSqr();
        double imagPart = -(y / this.getMagSqr());
        return new Complex(realPart, imagPart);
    }

    @NotNull
    public final Complex plus(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Complex(this.real + c.real, this.imag + c.imag);
    }

    @NotNull
    public final Complex plus(double r) {
        return new Complex(this.real + r, this.imag);
    }

    @NotNull
    public final Complex plus(float r) {
        return new Complex(this.real + (double)r, this.imag);
    }

    @NotNull
    public final Complex plus(int r) {
        return new Complex(this.real + (double)r, this.imag);
    }

    public final void plusAssign(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.real += c.real;
        this.imag += c.imag;
    }

    public final void plusAssign(double r) {
        this.real += r;
    }

    public final void plusAssign(float r) {
        this.real += (double)r;
    }

    public final void plusAssign(int r) {
        this.real += (double)r;
    }

    public final void unaryPlus() {
        this.real += 1.0;
        this.imag += 1.0;
    }

    @NotNull
    public final Complex minus(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return new Complex(this.real - c.real, this.imag - c.imag);
    }

    @NotNull
    public final Complex minus(double r) {
        return new Complex(this.real - r, this.imag);
    }

    @NotNull
    public final Complex minus(float r) {
        return new Complex(this.real - (double)r, this.imag);
    }

    @NotNull
    public final Complex minus(int r) {
        return new Complex(this.real - (double)r, this.imag);
    }

    public final void minusAssign(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.real -= c.real;
        this.imag -= c.imag;
    }

    public final void minusAssign(double r) {
        this.real -= r;
    }

    @NotNull
    public final Complex times(double real) {
        return new Complex(real * this.real, real * this.imag);
    }

    public final void timesAssign(double real) {
        this.real *= real;
        this.imag *= real;
    }

    @NotNull
    public final Complex times(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        double term1 = this.real * c.real - this.imag * c.imag;
        double term2 = this.real * c.imag + this.imag * c.real;
        return new Complex(term1, term2);
    }

    public final void timesAssign(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        double real = this.real * c.real - this.imag * c.imag;
        double imag = this.real * c.imag + this.imag * c.real;
        this.real = real;
        this.imag = imag;
    }

    @NotNull
    public final Complex div(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!(!(c.getMagSqr() == 0.0))) {
            boolean bl = false;
            String string = "Division by zero. c=" + c + ".";
            throw new IllegalArgumentException(string.toString());
        }
        return this.times(c.getReciprocal());
    }

    public final void divAssign(@NotNull Complex c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!(!(c.getMagSqr() == 0.0))) {
            boolean bl = false;
            String string = "Division by zero. c=" + c + ".";
            throw new IllegalArgumentException(string.toString());
        }
        this.timesAssign(c.getReciprocal());
    }

    @NotNull
    public final Polar toPolar() {
        double r = this.getMag();
        double arg = this.real >= 0.0 ? Math.atan2(this.imag, this.real) : Math.atan2(this.imag, this.real) + Math.PI;
        return new Polar(r, arg);
    }

    public final double component1() {
        return this.real;
    }

    public final double component2() {
        return this.imag;
    }

    @NotNull
    public final Complex copy(double real, double imag) {
        return new Complex(real, imag);
    }

    public static /* synthetic */ Complex copy$default(Complex complex, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = complex.real;
        }
        if ((n & 2) != 0) {
            d2 = complex.imag;
        }
        return complex.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Complex(real=" + this.real + ", imag=" + this.imag + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.real);
        result = result * 31 + Double.hashCode(this.imag);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)other;
        if (Double.compare(this.real, complex.real) != 0) {
            return false;
        }
        return Double.compare(this.imag, complex.imag) == 0;
    }

    public Complex() {
        this(0.0, 0.0, 3, null);
    }
}

