/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.math.Data;
import vet.inpulse.math.DataKt;
import vet.inpulse.math.DoubleData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\tJ\u0018\u0010\u0004\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\r\u001a\u00020\t\u00a8\u0006\u0011"}, d2={"Lvet/inpulse/math/Windowing;", "", "<init>", "()V", "planckTaper", "", "data", "Lvet/inpulse/math/Data;", "t1", "", "t2", "t3", "t4", "epsilon", "Lvet/inpulse/math/DoubleData;", "size", "", "math"})
@SourceDebugExtension(value={"SMAP\nWindowing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Windowing.kt\nvet/inpulse/math/Windowing\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class Windowing {
    @NotNull
    public static final Windowing INSTANCE = new Windowing();

    private Windowing() {
    }

    public final void planckTaper(@NotNull Data data, double t1, double t2, double t3, double t4) {
        double w;
        double zt;
        double ztb;
        double zta;
        double num;
        double t;
        int i;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(0.0 <= t1 ? t1 <= 1.0 : false)) {
            boolean $i$a$-require-Windowing$planckTaper$52 = false;
            String $i$a$-require-Windowing$planckTaper$52 = "t1 must be in [0, 1]";
            throw new IllegalArgumentException($i$a$-require-Windowing$planckTaper$52.toString());
        }
        if (!(t1 <= t2 ? t2 <= 1.0 : false)) {
            boolean $i$a$-require-Windowing$planckTaper$62 = false;
            String $i$a$-require-Windowing$planckTaper$62 = "t2 must be in [t1, 1]";
            throw new IllegalArgumentException($i$a$-require-Windowing$planckTaper$62.toString());
        }
        if (!(t2 <= t3 ? t3 <= 1.0 : false)) {
            boolean $i$a$-require-Windowing$planckTaper$72 = false;
            String $i$a$-require-Windowing$planckTaper$72 = "t3 must be in [t2, 1]";
            throw new IllegalArgumentException($i$a$-require-Windowing$planckTaper$72.toString());
        }
        if (!(t3 <= t4 ? t4 <= 1.0 : false)) {
            boolean $i$a$-require-Windowing$planckTaper$82 = false;
            String $i$a$-require-Windowing$planckTaper$82 = "t4 must be in [t3, 1]";
            throw new IllegalArgumentException($i$a$-require-Windowing$planckTaper$82.toString());
        }
        int l = data.getLength() - 1;
        int i1 = (int)Math.floor(t1 * (double)l);
        int i2 = (int)Math.floor(t2 * (double)l);
        int i3 = (int)Math.ceil(t3 * (double)l);
        int i4 = (int)Math.ceil(t4 * (double)l);
        data.set(0, 0.0);
        data.set(l, 0.0);
        for (i = 1; i < i1; ++i) {
            data.set(i, 0.0);
        }
        for (i = i1; i < i2; ++i) {
            t = (double)i / (double)l;
            num = t2 - t1;
            zta = num / (t - t1);
            ztb = num / (t - t2);
            zt = zta + ztb;
            w = 1.0 / (Math.exp(zt) + 1.0);
            data.set(i, w);
        }
        for (i = i2; i < i3; ++i) {
            data.set(i, 1.0);
        }
        for (i = i3; i < i4; ++i) {
            t = (double)i / (double)l;
            num = t3 - t4;
            zta = num / (t - t3);
            ztb = num / (t - t4);
            zt = zta + ztb;
            w = 1.0 / (Math.exp(zt) + 1.0);
            data.set(i, w);
        }
        int n = l - 1;
        for (i = i4; i < n; ++i) {
            data.set(i, 0.0);
        }
    }

    public final void planckTaper(@NotNull Data data, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double t1 = 0.0;
        double t2 = epsilon;
        double t3 = 1.0 - epsilon;
        double t4 = 1.0;
        this.planckTaper(data, t1, t2, t3, t4);
    }

    public static /* synthetic */ void planckTaper$default(Windowing windowing, Data data, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.01;
        }
        windowing.planckTaper(data, d);
    }

    @NotNull
    public final DoubleData planckTaper(int size, double epsilon) {
        DoubleData data = DataKt.asData$default(new double[size], 0, 0, 0, 7, null);
        this.planckTaper(data, epsilon);
        return data;
    }

    public static /* synthetic */ DoubleData planckTaper$default(Windowing windowing, int n, double d, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 0.01;
        }
        return windowing.planckTaper(n, d);
    }
}

