/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.math.Curve;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003Jm\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006/"}, d2={"Lvet/inpulse/math/Sin3Curve;", "Lvet/inpulse/math/Curve;", "a1", "", "b1", "c1", "a2", "b2", "c2", "a3", "b3", "c3", "offset", "<init>", "(DDDDDDDDDD)V", "getA1", "()D", "getB1", "getC1", "getA2", "getB2", "getC2", "getA3", "getB3", "getC3", "getOffset", "eval", "x", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "math"})
public final class Sin3Curve
implements Curve {
    private final double a1;
    private final double b1;
    private final double c1;
    private final double a2;
    private final double b2;
    private final double c2;
    private final double a3;
    private final double b3;
    private final double c3;
    private final double offset;

    public Sin3Curve(double a1, double b1, double c1, double a2, double b2, double c2, double a3, double b3, double c3, double offset) {
        this.a1 = a1;
        this.b1 = b1;
        this.c1 = c1;
        this.a2 = a2;
        this.b2 = b2;
        this.c2 = c2;
        this.a3 = a3;
        this.b3 = b3;
        this.c3 = c3;
        this.offset = offset;
    }

    public final double getA1() {
        return this.a1;
    }

    public final double getB1() {
        return this.b1;
    }

    public final double getC1() {
        return this.c1;
    }

    public final double getA2() {
        return this.a2;
    }

    public final double getB2() {
        return this.b2;
    }

    public final double getC2() {
        return this.c2;
    }

    public final double getA3() {
        return this.a3;
    }

    public final double getB3() {
        return this.b3;
    }

    public final double getC3() {
        return this.c3;
    }

    public final double getOffset() {
        return this.offset;
    }

    @Override
    public double eval(double x) {
        double y1 = this.a1 * Math.sin(this.b1 * x + this.c1);
        double y2 = this.a2 * Math.sin(this.b2 * x + this.c2);
        double y3 = this.a3 * Math.sin(this.b3 * x + this.c3);
        return y1 + y2 + y3 + this.offset;
    }

    public final double component1() {
        return this.a1;
    }

    public final double component2() {
        return this.b1;
    }

    public final double component3() {
        return this.c1;
    }

    public final double component4() {
        return this.a2;
    }

    public final double component5() {
        return this.b2;
    }

    public final double component6() {
        return this.c2;
    }

    public final double component7() {
        return this.a3;
    }

    public final double component8() {
        return this.b3;
    }

    public final double component9() {
        return this.c3;
    }

    public final double component10() {
        return this.offset;
    }

    @NotNull
    public final Sin3Curve copy(double a1, double b1, double c1, double a2, double b2, double c2, double a3, double b3, double c3, double offset) {
        return new Sin3Curve(a1, b1, c1, a2, b2, c2, a3, b3, c3, offset);
    }

    public static /* synthetic */ Sin3Curve copy$default(Sin3Curve sin3Curve, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, int n, Object object) {
        if ((n & 1) != 0) {
            d = sin3Curve.a1;
        }
        if ((n & 2) != 0) {
            d2 = sin3Curve.b1;
        }
        if ((n & 4) != 0) {
            d3 = sin3Curve.c1;
        }
        if ((n & 8) != 0) {
            d4 = sin3Curve.a2;
        }
        if ((n & 0x10) != 0) {
            d5 = sin3Curve.b2;
        }
        if ((n & 0x20) != 0) {
            d6 = sin3Curve.c2;
        }
        if ((n & 0x40) != 0) {
            d7 = sin3Curve.a3;
        }
        if ((n & 0x80) != 0) {
            d8 = sin3Curve.b3;
        }
        if ((n & 0x100) != 0) {
            d9 = sin3Curve.c3;
        }
        if ((n & 0x200) != 0) {
            d10 = sin3Curve.offset;
        }
        return sin3Curve.copy(d, d2, d3, d4, d5, d6, d7, d8, d9, d10);
    }

    @NotNull
    public String toString() {
        return "Sin3Curve(a1=" + this.a1 + ", b1=" + this.b1 + ", c1=" + this.c1 + ", a2=" + this.a2 + ", b2=" + this.b2 + ", c2=" + this.c2 + ", a3=" + this.a3 + ", b3=" + this.b3 + ", c3=" + this.c3 + ", offset=" + this.offset + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.a1);
        result = result * 31 + Double.hashCode(this.b1);
        result = result * 31 + Double.hashCode(this.c1);
        result = result * 31 + Double.hashCode(this.a2);
        result = result * 31 + Double.hashCode(this.b2);
        result = result * 31 + Double.hashCode(this.c2);
        result = result * 31 + Double.hashCode(this.a3);
        result = result * 31 + Double.hashCode(this.b3);
        result = result * 31 + Double.hashCode(this.c3);
        result = result * 31 + Double.hashCode(this.offset);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Sin3Curve)) {
            return false;
        }
        Sin3Curve sin3Curve = (Sin3Curve)other;
        if (Double.compare(this.a1, sin3Curve.a1) != 0) {
            return false;
        }
        if (Double.compare(this.b1, sin3Curve.b1) != 0) {
            return false;
        }
        if (Double.compare(this.c1, sin3Curve.c1) != 0) {
            return false;
        }
        if (Double.compare(this.a2, sin3Curve.a2) != 0) {
            return false;
        }
        if (Double.compare(this.b2, sin3Curve.b2) != 0) {
            return false;
        }
        if (Double.compare(this.c2, sin3Curve.c2) != 0) {
            return false;
        }
        if (Double.compare(this.a3, sin3Curve.a3) != 0) {
            return false;
        }
        if (Double.compare(this.b3, sin3Curve.b3) != 0) {
            return false;
        }
        if (Double.compare(this.c3, sin3Curve.c3) != 0) {
            return false;
        }
        return Double.compare(this.offset, sin3Curve.offset) == 0;
    }
}

