/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.math.Data;
import vet.inpulse.math.DataKt;
import vet.inpulse.math.DoubleData;
import vet.inpulse.math.MaxIndexDouble;
import vet.inpulse.math.MaxIndexFloat;
import vet.inpulse.math.SecondOrderPoly;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\u0010\u0014\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a8\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\u0004\b\u0000\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00012\u0014\b\u0004\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u0086\b\u00f8\u0001\u0000\u001a\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0002\u001a&\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0002\u001aL\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\b\b\u0002\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\t\u001a4\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\b\b\u0002\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\t\u001a:\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\t\u001a\"\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\t\u001a>\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\t\u001a\"\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\t\u001aD\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u001f\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\t\u001a,\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u001f\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\t\u001a\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"\u001a\u000e\u0010 \u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u000e\u0010&\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a!\u0010'\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0002H\u0086\b\u001a\u000e\u0010)\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u000e\u0010*\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0002\u001a\u0011\u0010*\u001a\u00020\u0006*\u00020\u0002H\u0007\u00a2\u0006\u0002\b+\u001a\u000e\u0010,\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"\u001a,\u0010,\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0002\u001a,\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020.2\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0002\u001a\u001e\u0010,\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u0010,\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n\u001a\u000e\u0010/\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"\u001a\u0016\u00100\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010/\u001a\u00020\t\u001a.\u00101\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0002\u001a>\u00102\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a.\u00102\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00022\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0016\u00102\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\n2\u0006\u00105\u001a\u00020\n\u001a\u000e\u00102\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n\u001a&\u00108\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u001e\u00108\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u00108\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n\u001a\\\u00109\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00022\b\b\u0002\u00105\u001a\u00020\n2\b\b\u0002\u0010:\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u00103\u001a\u00020\u00022\b\b\u0002\u00104\u001a\u00020\u00022\b\b\u0002\u00106\u001a\u00020\u00022\b\b\u0002\u00107\u001a\u00020\u0002\u001a>\u00109\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00022\b\b\u0002\u0010:\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0002\u001a\"\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0<*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0=0\u0001\u001aL\u0010>\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0=0\u00012\u0006\u0010?\u001a\u00020\n2\b\b\u0002\u0010@\u001a\u00020\t2\b\b\u0002\u0010A\u001a\u00020\u00022\b\b\u0002\u0010B\u001a\u00020\t2\b\b\u0002\u0010C\u001a\u00020\t2\b\b\u0002\u0010D\u001a\u00020\u0006\u001aN\u0010E\u001a\u00020\u000e2.\u0010F\u001a*\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010Gj\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0001`H2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00020J2\u0006\u0010A\u001a\u00020\u0002H\u0002\u001a&\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\n\u001aF\u0010P\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010Q\u001a\u00020\u0002\u001aF\u0010R\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010Q\u001a\u00020\u0002\u001a&\u0010S\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\n\u001a\u0016\u0010S\u001a\u00020\n2\u0006\u0010M\u001a\u00020\n2\u0006\u0010T\u001a\u00020\u0002\u001a&\u0010U\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u001e\u0010U\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u0010U\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n\u001aB\u0010V\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0014\b\u0006\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0005H\u0086\b\u00f8\u0001\u0000\u001aD\u0010X\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010Y\u001a\u00020\u00022\u0014\b\u0002\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0005\u001a<\u0010Z\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0014\b\u0002\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0005\u001a\u0016\u0010[\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\"\u001a\u0016\u0010]\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\"\u001a \u0010^\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\"2\b\b\u0002\u0010\u0012\u001a\u00020\u0002\u001a\u0016\u0010_\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\"2\u0006\u0010`\u001a\u00020\"\u001a4\u0010a\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010\u0012\u001a\u00020\u00022\u0014\b\u0004\u0010b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0005H\u0086\b\u00f8\u0001\u0000\u001aJ\u0010c\u001a\u00020\u000e2\u0006\u0010d\u001a\u00020\n2\b\b\u0002\u00103\u001a\u00020\u00022\b\b\u0002\u00104\u001a\u00020\u00022\b\b\u0002\u00105\u001a\u00020\n2\b\b\u0002\u00106\u001a\u00020\u00022\b\b\u0002\u00107\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0002\u001a,\u0010e\u001a\u00020f2\u0006\u0010!\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0002\u001a\u001e\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020.\u001a.\u00101\u001a\u00020-2\u0006\u0010!\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u0002\u001a>\u00102\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020.2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a.\u00102\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020.2\u0006\u00103\u001a\u00020\u00022\u0006\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0016\u00102\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020.2\u0006\u00105\u001a\u00020.\u001a\u000e\u00102\u001a\u00020.2\u0006\u0010!\u001a\u00020.\u001a&\u00108\u001a\u00020-2\u0006\u0010!\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u001e\u00108\u001a\u00020-2\u0006\u0010!\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u00108\u001a\u00020-2\u0006\u0010!\u001a\u00020.\u001a\u000e\u0010g\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"\u001a,\u0010g\u001a\u00020\t2\u0006\u0010!\u001a\u00020.2\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0002\u001a,\u0010g\u001a\u00020\t2\u0006\u0010!\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0002\u001aF\u00109\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020.2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a6\u00109\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020.2\u0006\u00103\u001a\u00020\u00022\u0006\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u0002\u001a\u001e\u00109\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020.2\u0006\u00105\u001a\u00020.2\u0006\u0010%\u001a\u00020\u0002\u001a\u0016\u00109\u001a\u00020.2\u0006\u0010!\u001a\u00020.2\u0006\u0010%\u001a\u00020\u0002\u001a&\u0010U\u001a\u00020-2\u0006\u0010!\u001a\u00020.2\u0006\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u001e\u0010U\u001a\u00020-2\u0006\u0010!\u001a\u00020.2\u0006\u00103\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u000e\u0010U\u001a\u00020-2\u0006\u0010!\u001a\u00020.\u001a\u0010\u0010h\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a,\u0010e\u001a\u00020i2\u0006\u0010!\u001a\u00020.2\b\b\u0002\u0010\u0010\u001a\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u00022\b\b\u0002\u0010\u0012\u001a\u00020\u0002\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006j"}, d2={"findIndexes", "", "", "T", "predicate", "Lkotlin/Function1;", "", "filterByIndex", "Lkotlin/sequences/Sequence;", "", "", "range", "Lkotlin/ranges/IntProgression;", "impulse", "", "out", "offset", "stride", "length", "nyquist", "signalSin", "samplingRate", "frequency", "initialPhase", "amplitude", "ramp", "initialValue", "finalValue", "linspace", "output", "step", "stepOffset", "smoothstep", "data", "Lvet/inpulse/math/Data;", "Lvet/inpulse/math/DoubleData;", "factorial", "n", "consecutiveSum", "element", "index", "binaryLog", "isBinary", "intIsBinary", "mean", "", "", "max", "rescaleInplace", "norm", "l2normalize", "srcOffset", "srcStride", "dest", "destOffset", "destStride", "rms", "diff", "shiftOutput", "toLocPeaks", "Lkotlin/Pair;", "Lkotlin/collections/IndexedValue;", "findPeaks", "signal", "minPeakHeight", "minPeakDistance", "minPeakWidth", "maxPeakWidth", "doubleSided", "findPeaksPrune", "distances", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "indexes", "", "splineInterpolate", "x", "y", "xi", "yi", "movavg", "window", "movmedian", "linearInterpolate", "newSize", "stddev", "expectedValue", "probabilityFunction", "nthMoment", "moment", "kurtosis", "signalSumInplace", "input", "signalSumInplaceRepeat", "signalRepeat", "signalMultiplyInplace", "multiplier", "transformInplace", "transform", "decibel", "src", "maxIndex", "Lvet/inpulse/math/MaxIndexDouble;", "rmssd", "requirePositiveStride", "Lvet/inpulse/math/MaxIndexFloat;", "math"})
@SourceDebugExtension(value={"SMAP\nSignalUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignalUtils.kt\nvet/inpulse/math/SignalUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 SignalUtils.kt\nvet/inpulse/math/SignalUtilsKt$expectedValue$1\n*L\n1#1,1242:1\n206#1:1243\n206#1:1244\n206#1:1245\n206#1:1246\n206#1:1247\n206#1:1248\n962#1,9:1250\n206#1:1259\n206#1:1260\n206#1:1261\n206#1:1262\n206#1:1263\n206#1:1264\n206#1:1265\n18#1,8:1283\n206#1:1294\n206#1:1295\n206#1:1296\n206#1:1297\n206#1:1298\n206#1:1299\n206#1:1300\n206#1:1301\n206#1:1302\n881#1,3:1303\n206#1:1306\n884#1,3:1307\n206#1:1310\n874#1,10:1311\n206#1:1321\n884#1:1322\n886#1:1324\n206#1:1325\n206#1:1326\n206#1:1327\n206#1:1328\n206#1:1329\n206#1:1330\n206#1:1331\n206#1:1332\n206#1:1333\n206#1:1334\n206#1:1335\n206#1:1336\n1#2:1249\n1878#3,3:1266\n1021#3,2:1269\n1761#3,3:1273\n1563#3:1279\n1634#3,3:1280\n774#3:1291\n865#3,2:1292\n188#4,2:1271\n190#4:1276\n1255#5,2:1277\n879#6:1323\n*S KotlinDebug\n*F\n+ 1 SignalUtils.kt\nvet/inpulse/math/SignalUtilsKt\n*L\n47#1:1243\n59#1:1244\n88#1:1245\n117#1:1246\n122#1:1247\n164#1:1248\n285#1:1250,9\n305#1:1259\n315#1:1260\n334#1:1261\n335#1:1262\n364#1:1263\n411#1:1264\n424#1:1265\n618#1:1283,8\n729#1:1294\n730#1:1295\n737#1:1296\n756#1:1297\n757#1:1298\n762#1:1299\n766#1:1300\n864#1:1301\n883#1:1302\n898#1:1303,3\n898#1:1306\n898#1:1307,3\n900#1:1310\n903#1:1311,10\n903#1:1321\n903#1:1322\n903#1:1324\n985#1:1325\n987#1:1326\n1001#1:1327\n1047#1:1328\n1057#1:1329\n1077#1:1330\n1078#1:1331\n1107#1:1332\n1157#1:1333\n1170#1:1334\n1209#1:1335\n1233#1:1336\n456#1:1266,3\n513#1:1269,2\n535#1:1273,3\n597#1:1279\n597#1:1280,3\n622#1:1291\n622#1:1292,2\n534#1:1271,2\n534#1:1276\n555#1:1277,2\n903#1:1323\n*E\n"})
public final class SignalUtilsKt {
    @NotNull
    public static final <T> List<Integer> findIndexes(@NotNull List<? extends T> $this$findIndexes, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$findIndexes, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        boolean $i$f$findIndexes = false;
        List indexes = new ArrayList();
        int n = ((Collection)$this$findIndexes).size();
        for (int i = 0; i < n; ++i) {
            T v = $this$findIndexes.get(i);
            if (!((Boolean)predicate.invoke(v)).booleanValue()) continue;
            indexes.add(i);
        }
        return indexes;
    }

    @NotNull
    public static final Sequence<Double> filterByIndex(@NotNull double[] $this$filterByIndex, @NotNull IntProgression range) {
        Intrinsics.checkNotNullParameter((Object)$this$filterByIndex, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Ref.IntRef currentIndex = new Ref.IntRef();
        currentIndex.element = range.getFirst();
        return SequencesKt.generateSequence(() -> SignalUtilsKt.filterByIndex$lambda$0(currentIndex, range, $this$filterByIndex));
    }

    public static final void impulse(@NotNull double[] out, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out[offset] = 1.0;
        int i = 1;
        while (i < length) {
            int n = offset;
            int n2 = stride;
            int index$iv = i++;
            boolean $i$f$element = false;
            out[index$iv * stride$iv + offset$iv] = 0.0;
        }
    }

    @NotNull
    public static final double[] impulse(int length) {
        double[] impulse = new double[length];
        impulse[0] = 1.0;
        return impulse;
    }

    /*
     * WARNING - void declaration
     */
    public static final void nyquist(@NotNull double[] out, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        for (int i = 0; i < length; ++i) {
            void offset$iv;
            void stride$iv;
            int n = offset;
            int n2 = stride;
            int index$iv = i;
            boolean $i$f$element = false;
            int index = index$iv * stride$iv + offset$iv;
            out[index] = Math.pow(-1.0, i);
        }
    }

    @NotNull
    public static final double[] nyquist(int length) {
        double[] nyquist = new double[length];
        SignalUtilsKt.nyquist(nyquist, 0, 1, length);
        return nyquist;
    }

    public static final void signalSin(@NotNull double[] out, int offset, int stride, int length, int samplingRate, double frequency, double initialPhase, double amplitude) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        double pi2 = Math.PI * 2;
        double step = pi2 / (double)samplingRate;
        double phaseStep = frequency * step;
        double phase = initialPhase;
        for (int i = 0; i < length; ++i) {
            int n = offset;
            int n2 = stride;
            int index$iv = i;
            boolean $i$f$element = false;
            out[index$iv * stride$iv + offset$iv] = amplitude * Math.sin(phase);
            if (!((phase += phaseStep) > pi2)) continue;
            phase -= pi2;
        }
    }

    public static /* synthetic */ void signalSin$default(double[] dArray, int n, int n2, int n3, int n4, double d, double d2, double d3, int n5, Object object) {
        if ((n5 & 0x20) != 0) {
            d = 1.0;
        }
        if ((n5 & 0x40) != 0) {
            d2 = 0.0;
        }
        if ((n5 & 0x80) != 0) {
            d3 = 1.0;
        }
        SignalUtilsKt.signalSin(dArray, n, n2, n3, n4, d, d2, d3);
    }

    @NotNull
    public static final double[] signalSin(int length, int samplingRate, double frequency, double initialPhase, double amplitude) {
        double[] out = new double[length];
        SignalUtilsKt.signalSin(out, 0, 1, length, samplingRate, frequency, initialPhase, amplitude);
        return out;
    }

    public static /* synthetic */ double[] signalSin$default(int n, int n2, double d, double d2, double d3, int n3, Object object) {
        if ((n3 & 4) != 0) {
            d = 1.0;
        }
        if ((n3 & 8) != 0) {
            d2 = 0.0;
        }
        if ((n3 & 0x10) != 0) {
            d3 = 1.0;
        }
        return SignalUtilsKt.signalSin(n, n2, d, d2, d3);
    }

    /*
     * WARNING - void declaration
     */
    public static final void ramp(@NotNull double[] out, int offset, int stride, int length, double initialValue, double finalValue) {
        void offset$iv;
        void stride$iv;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int n = offset;
        int n2 = stride;
        int index$iv = length;
        boolean $i$f$element = false;
        if (!(out.length >= index$iv * stride$iv + offset$iv)) {
            boolean bl = false;
            String string = "output array is too small for given offset, stride and length";
            throw new IllegalArgumentException(string.toString());
        }
        double step = finalValue / (double)(length - 1);
        for (int i = 0; i < length; ++i) {
            void offset$iv2;
            void stride$iv2;
            int n3 = offset;
            int n4 = stride;
            int index$iv2 = i;
            boolean $i$f$element2 = false;
            int index = index$iv2 * stride$iv2 + offset$iv2;
            out[index] = initialValue + step * (double)i;
        }
    }

    public static /* synthetic */ void ramp$default(double[] dArray, int n, int n2, int n3, double d, double d2, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            d = 0.0;
        }
        if ((n4 & 0x20) != 0) {
            d2 = 1.0;
        }
        SignalUtilsKt.ramp(dArray, n, n2, n3, d, d2);
    }

    @NotNull
    public static final double[] ramp(int length, double initialValue, double finalValue) {
        double[] ramp = new double[length];
        SignalUtilsKt.ramp(ramp, 0, 1, length, initialValue, finalValue);
        return ramp;
    }

    public static /* synthetic */ double[] ramp$default(int n, double d, double d2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 0.0;
        }
        if ((n2 & 4) != 0) {
            d2 = 1.0;
        }
        return SignalUtilsKt.ramp(n, d, d2);
    }

    public static final void linspace(int length, @NotNull double[] output, int offset, int stride, double initialValue, double finalValue) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        SignalUtilsKt.ramp(output, offset, stride, length, initialValue, finalValue - initialValue);
    }

    public static /* synthetic */ void linspace$default(int n, double[] dArray, int n2, int n3, double d, double d2, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        if ((n4 & 0x10) != 0) {
            d = 0.0;
        }
        if ((n4 & 0x20) != 0) {
            d2 = 1.0;
        }
        SignalUtilsKt.linspace(n, dArray, n2, n3, d, d2);
    }

    @NotNull
    public static final double[] linspace(int length, double initialValue, double finalValue) {
        double[] out = new double[length];
        SignalUtilsKt.linspace(length, out, 0, 1, initialValue, finalValue);
        return out;
    }

    public static /* synthetic */ double[] linspace$default(int n, double d, double d2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = 0.0;
        }
        if ((n2 & 4) != 0) {
            d2 = 1.0;
        }
        return SignalUtilsKt.linspace(n, d, d2);
    }

    public static final void step(@NotNull double[] out, int offset, int stride, int length, int stepOffset, double initialValue, double finalValue) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        for (int i = 0; i < length; ++i) {
            int n = offset;
            int n2 = stride;
            int index$iv = i;
            boolean $i$f$element = false;
            out[index$iv * stride$iv + offset$iv] = i < stepOffset ? initialValue : finalValue;
        }
    }

    public static /* synthetic */ void step$default(double[] dArray, int n, int n2, int n3, int n4, double d, double d2, int n5, Object object) {
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        if ((n5 & 0x20) != 0) {
            d = 0.0;
        }
        if ((n5 & 0x40) != 0) {
            d2 = 1.0;
        }
        SignalUtilsKt.step(dArray, n, n2, n3, n4, d, d2);
    }

    @NotNull
    public static final double[] step(int length, int stepOffset, double initialValue, double finalValue) {
        double[] step = new double[length];
        SignalUtilsKt.step(step, 0, 1, length, stepOffset, initialValue, finalValue);
        return step;
    }

    public static /* synthetic */ double[] step$default(int n, int n2, double d, double d2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            d = 0.0;
        }
        if ((n3 & 8) != 0) {
            d2 = 1.0;
        }
        return SignalUtilsKt.step(n, n2, d, d2);
    }

    public static final void smoothstep(@NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = data.getLength() - 1;
        for (int i = 0; i < n; ++i) {
            double x = (double)i / ((double)data.getLength() - 1.0);
            double v = x * x * (3.0 - 2.0 * x);
            data.set(i, v);
        }
        data.set(data.getLength() - 1, 1.0);
    }

    @NotNull
    public static final DoubleData smoothstep(int length) {
        DoubleData data = DataKt.asData$default(new double[length], 0, 0, 0, 7, null);
        SignalUtilsKt.smoothstep(data);
        return data;
    }

    public static final int factorial(int n) {
        if (!(n > 0)) {
            boolean $i$a$-require-SignalUtilsKt$factorial$22 = false;
            String $i$a$-require-SignalUtilsKt$factorial$22 = "n must be positive";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$factorial$22.toString());
        }
        int v = 1;
        int a = 1;
        if (a <= n) {
            while (true) {
                v *= a;
                if (a == n) break;
                ++a;
            }
        }
        return v;
    }

    public static final int consecutiveSum(int n) {
        if (!(n > 0)) {
            boolean bl = false;
            String string = "n must be positive";
            throw new IllegalArgumentException(string.toString());
        }
        return n * (n + 1) / 2;
    }

    public static final int element(int offset, int stride, int index) {
        boolean $i$f$element = false;
        return index * stride + offset;
    }

    public static final int binaryLog(int n) {
        int k = 1;
        int logN = 0;
        while (k < n) {
            k *= 2;
            ++logN;
        }
        int nTest = 1 << logN;
        if (n != nTest) {
            return -1;
        }
        return logN;
    }

    public static final boolean isBinary(int n) {
        return SignalUtilsKt.binaryLog(n) > 0;
    }

    @JvmName(name="intIsBinary")
    public static final boolean intIsBinary(int $this$isBinary) {
        return SignalUtilsKt.isBinary($this$isBinary);
    }

    public static final double mean(@NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.isEmpty()) {
            return 0.0;
        }
        double acc = 0.0;
        int n = data.getLength();
        for (int i = 0; i < n; ++i) {
            double v = data.get(i);
            acc += v;
        }
        return acc / (double)data.getLength();
    }

    public static final double mean(@NotNull double[] data, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.mean(DataKt.asData(data, offset, stride, length));
    }

    public static /* synthetic */ double mean$default(double[] dArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = dArray.length;
        }
        return SignalUtilsKt.mean(dArray, n, n2, n3);
    }

    public static final float mean(@NotNull float[] data, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return (float)SignalUtilsKt.mean(DataKt.asData(data, offset, stride, length));
    }

    public static /* synthetic */ float mean$default(float[] fArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = fArray.length;
        }
        return SignalUtilsKt.mean(fArray, n, n2, n3);
    }

    public static final double mean(@NotNull double[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.mean(data, offset, 1, length);
    }

    public static final double mean(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.mean(data, 0, 1, data.length);
    }

    public static final double max(@NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double max = Double.NEGATIVE_INFINITY;
        int n = data.getLength();
        for (int i = 0; i < n; ++i) {
            double v = data.get(i);
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    /*
     * WARNING - void declaration
     */
    public static final void rescaleInplace(@NotNull Data data, double max) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double dataMax = SignalUtilsKt.max(data);
        double ratio = !(dataMax == 0.0) ? max / dataMax : 1.0;
        Data data$iv = data;
        int length$iv = data$iv.getLength();
        boolean $i$f$transformInplace = false;
        int i$iv = 0;
        while (i$iv < length$iv) {
            void v;
            double d = data$iv.get(i$iv);
            int n = i$iv++;
            Data data2 = data$iv;
            boolean bl = false;
            void var16_12 = v * ratio;
            data2.set(n, (double)var16_12);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final double norm(@NotNull double[] data, int offset, int stride, int length, int norm) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SignalUtilsKt.requirePositiveStride(stride);
        if (norm == -1) {
            double max = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < length; ++i) {
                void offset$iv;
                void stride$iv;
                int n = offset;
                int n2 = stride;
                int index$iv = i;
                boolean $i$f$element = false;
                double v = data[index$iv * stride$iv + offset$iv];
                if (!(v > max)) continue;
                max = v;
            }
            return max;
        }
        if (!(norm > 0)) {
            boolean bl = false;
            String string = "Zero norm not supported";
            throw new IllegalArgumentException(string.toString());
        }
        double acc = 0.0;
        int i = 0;
        while (i < length) {
            int offset$iv = offset;
            int stride$iv = stride;
            int index$iv = i++;
            boolean $i$f$element = false;
            double v = data[index$iv * stride$iv + offset$iv];
            acc += Math.pow(v, norm);
        }
        Math.pow(acc, 1.0 / (double)norm);
        return acc;
    }

    public static final void l2normalize(@NotNull double[] data, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        double l2norm = SignalUtilsKt.norm(data, srcOffset, srcStride, length, 2);
        int i = 0;
        while (i < length) {
            int offset$iv;
            int stride$iv;
            int n = srcOffset;
            int n2 = srcStride;
            int index$iv = i;
            boolean $i$f$element = false;
            double v = data[index$iv * stride$iv + offset$iv];
            offset$iv = destOffset;
            stride$iv = destStride;
            index$iv = i++;
            $i$f$element = false;
            dest[index$iv * stride$iv + offset$iv] = v / l2norm;
        }
    }

    public static final void l2normalize(@NotNull double[] data, int srcOffset, @NotNull double[] dest, int destOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SignalUtilsKt.l2normalize(data, srcOffset, 1, dest, destOffset, 1, length);
    }

    public static final void l2normalize(@NotNull double[] data, @NotNull double[] dest) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(dest.length >= data.length)) {
            boolean bl = false;
            String string = "destination can't fit data";
            throw new IllegalArgumentException(string.toString());
        }
        SignalUtilsKt.l2normalize(data, 0, 1, dest, 0, 1, data.length);
    }

    @NotNull
    public static final double[] l2normalize(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double[] dest = new double[data.length];
        SignalUtilsKt.l2normalize(data, 0, 1, dest, 0, 1, data.length);
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public static final double rms(@NotNull double[] data, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SignalUtilsKt.requirePositiveStride(stride);
        double acc = 0.0;
        int i = 0;
        while (i < length) {
            void offset$iv;
            void stride$iv;
            int n = offset;
            int n2 = stride;
            int index$iv = i++;
            boolean $i$f$element = false;
            double v = data[index$iv * stride$iv + offset$iv];
            acc += Math.pow(v, 2);
        }
        return Math.sqrt(acc /= (double)length);
    }

    public static final double rms(@NotNull double[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.rms(data, offset, 1, length);
    }

    public static final double rms(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.rms(data, 0, 1, data.length);
    }

    /*
     * WARNING - void declaration
     */
    public static final void diff(@NotNull double[] data, int n, @NotNull double[] dest, boolean shiftOutput, int length, int srcOffset, int srcStride, int destOffset, int destStride) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SignalUtilsKt.requirePositiveStride(srcStride);
        SignalUtilsKt.requirePositiveStride(destStride);
        if (!(n > 0)) {
            boolean $i$a$-require-SignalUtilsKt$diff$22 = false;
            String $i$a$-require-SignalUtilsKt$diff$22 = "can only do positive n diffs";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$diff$22.toString());
        }
        int shift = shiftOutput ? n : 0;
        double[] temp = new double[SignalUtilsKt.consecutiveSum(n + 1) - 1];
        int tempOffset = SignalUtilsKt.consecutiveSum(n) - 1;
        int n2 = length - n;
        for (int i = 0; i < n2; ++i) {
            int tempSrcOffset;
            int j;
            int n3 = n + 1;
            for (int k = 0; k < n3; ++k) {
                void offset$iv;
                void stride$iv;
                int n4 = srcOffset;
                int n5 = srcStride;
                int index$iv = i + k;
                boolean $i$f$element = false;
                temp[tempOffset + k] = data[index$iv * stride$iv + offset$iv];
            }
            for (j = n; 1 < j; --j) {
                tempSrcOffset = SignalUtilsKt.consecutiveSum(j) - 1;
                int tempDestOffset = SignalUtilsKt.consecutiveSum(j - 1) - 1;
                for (int k = 0; k < j; ++k) {
                    double a = temp[tempSrcOffset + k];
                    double b = temp[tempSrcOffset + k + 1];
                    temp[tempDestOffset + k] = b - a;
                }
            }
            j = destOffset;
            tempSrcOffset = destStride;
            int index$iv = i + shift;
            boolean $i$f$element = false;
            dest[index$iv * stride$iv + offset$iv] = temp[1] - temp[0];
        }
    }

    public static /* synthetic */ void diff$default(double[] dArray, int n, double[] dArray2, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        if ((n7 & 4) != 0) {
            dArray2 = dArray;
        }
        if ((n7 & 8) != 0) {
            bl = false;
        }
        if ((n7 & 0x10) != 0) {
            n2 = dArray.length;
        }
        if ((n7 & 0x20) != 0) {
            n3 = 0;
        }
        if ((n7 & 0x40) != 0) {
            n4 = 1;
        }
        if ((n7 & 0x80) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x100) != 0) {
            n6 = 1;
        }
        SignalUtilsKt.diff(dArray, n, dArray2, bl, n2, n3, n4, n5, n6);
    }

    @NotNull
    public static final double[] diff(@NotNull double[] data, int n, boolean shiftOutput, int length, int offset, int stride) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double[] dest = new double[length];
        SignalUtilsKt.diff(data, n, dest, shiftOutput, length, offset, stride, 0, 1);
        return dest;
    }

    public static /* synthetic */ double[] diff$default(double[] dArray, int n, boolean bl, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 4) != 0) {
            bl = false;
        }
        if ((n5 & 8) != 0) {
            n2 = dArray.length;
        }
        if ((n5 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x20) != 0) {
            n4 = 1;
        }
        return SignalUtilsKt.diff(dArray, n, bl, n2, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<double[], double[]> toLocPeaks(@NotNull List<IndexedValue<Double>> $this$toLocPeaks) {
        Intrinsics.checkNotNullParameter($this$toLocPeaks, (String)"<this>");
        double[] locs = new double[$this$toLocPeaks.size()];
        double[] peaks = new double[$this$toLocPeaks.size()];
        Iterable $this$forEachIndexed$iv = $this$toLocPeaks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void peak;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IndexedValue indexedValue = (IndexedValue)item$iv;
            int i = n;
            boolean bl = false;
            locs[i] = peak.getIndex();
            peaks[i] = ((Number)peak.getValue()).doubleValue();
        }
        return TuplesKt.to((Object)locs, (Object)peaks);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IndexedValue<Double>> findPeaks(@NotNull double[] signal, double minPeakHeight, int minPeakDistance, double minPeakWidth, double maxPeakWidth, boolean doubleSided) {
        void $this$mapTo$iv$iv;
        boolean shouldRunPruning;
        HashMap<Integer, List<Integer>> distances;
        List indexes;
        double[] data;
        block23: {
            int isD1ChangingSignal2;
            int i;
            int n;
            double[] dArray;
            Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
            if (!(signal.length > 1)) {
                boolean $i$a$-require-SignalUtilsKt$findPeaks$22 = false;
                String $i$a$-require-SignalUtilsKt$findPeaks$22 = "no data available";
                throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$findPeaks$22.toString());
            }
            if (!doubleSided) {
                Double d = ArraysKt.minOrNull((double[])signal);
                Intrinsics.checkNotNull((Object)d);
                if (!(d >= 0.0)) {
                    boolean $i$a$-require-SignalUtilsKt$findPeaks$data$22 = false;
                    String $i$a$-require-SignalUtilsKt$findPeaks$data$22 = "data contains negative values. use doubleSided = true";
                    throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$findPeaks$data$22.toString());
                }
                dArray = signal;
            } else {
                double mean = SignalUtilsKt.mean(signal);
                double[] tmp = new double[signal.length];
                n = signal.length;
                for (i = 0; i < n; ++i) {
                    tmp[i] = Math.abs(signal[i] - mean);
                }
                dArray = tmp;
            }
            data = dArray;
            double[] df1 = SignalUtilsKt.diff$default(data, 1, true, 0, 0, 0, 56, null);
            df1[0] = df1[1];
            double[] df2 = SignalUtilsKt.diff$default(data, 2, true, 0, 0, 0, 56, null);
            df2[0] = df2[2];
            df2[1] = df2[2];
            indexes = new ArrayList();
            n = data.length;
            for (i = 1; i < n; ++i) {
                boolean isD2Negative;
                double a = df1[i];
                double b = df1[i - 1];
                isD1ChangingSignal2 = a * b <= 0.0 ? 1 : 0;
                boolean bl = isD2Negative = df2[i] < 0.0;
                if (isD1ChangingSignal2 == 0 || !isD2Negative) continue;
                indexes.add(i - 1);
            }
            CollectionsKt.retainAll((List)indexes, arg_0 -> SignalUtilsKt.findPeaks$lambda$11(data, minPeakHeight, arg_0));
            List $this$sortByDescending$iv = indexes;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(data){
                    final /* synthetic */ double[] $data$inlined;
                    {
                        this.$data$inlined = dArray;
                    }

                    public final int compare(T a, T b) {
                        int i = ((Number)b).intValue();
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(this.$data$inlined[i]);
                        i = ((Number)a).intValue();
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(this.$data$inlined[i]));
                    }
                });
            }
            distances = new HashMap<Integer, List<Integer>>();
            int a = indexes.size();
            for (int i2 = 0; i2 < a; ++i2) {
                List list = new ArrayList();
                int x = ((Number)indexes.get(i2)).intValue();
                isD1ChangingSignal2 = indexes.size();
                for (int j = 0; j < isD1ChangingSignal2; ++j) {
                    boolean bl;
                    if (i2 == j) {
                        bl = list.add(Integer.MAX_VALUE);
                        continue;
                    }
                    int y = ((Number)indexes.get(j)).intValue();
                    int distance = x - y;
                    bl = list.add(Math.abs(distance));
                }
                ((Map)distances).put(i2, list);
            }
            Map $this$any$iv = distances;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                v4 = false;
            } else {
                Iterator x = $this$any$iv.entrySet().iterator();
                while (x.hasNext()) {
                    boolean bl;
                    block22: {
                        Map.Entry element$iv;
                        Map.Entry isD1ChangingSignal2 = element$iv = x.next();
                        boolean bl2 = false;
                        List list = (List)isD1ChangingSignal2.getValue();
                        Iterable $this$any$iv2 = list;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                int distance = ((Number)element$iv2).intValue();
                                boolean bl3 = false;
                                if (!(distance < minPeakDistance)) continue;
                                bl = true;
                                break block22;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v4 = true;
                    break block23;
                }
                v4 = shouldRunPruning = false;
            }
        }
        if (shouldRunPruning) {
            SignalUtilsKt.findPeaksPrune(distances, indexes, minPeakDistance);
        }
        int n = indexes.size();
        int np = data.length;
        double[] pp = new double[3];
        Ref.DoubleRef h = new Ref.DoubleRef();
        Ref.DoubleRef xm = new Ref.DoubleRef();
        Set indexesToRemove = new LinkedHashSet();
        for (int i = 0; i < n; ++i) {
            boolean isNotLocalMaxima;
            IntRange ind;
            block24: {
                boolean bl;
                int lowerBound = (int)Math.floor(Math.max(((Number)indexes.get(i)).doubleValue() - (double)minPeakDistance / 2.0, 0.0));
                int higherBound = (int)Math.ceil(Math.min(((Number)indexes.get(i)).doubleValue() + (double)minPeakDistance / 2.0, (double)np));
                ind = new IntRange(lowerBound, higherBound);
                Sequence<Double> $this$any$iv = SignalUtilsKt.filterByIndex(data, (IntProgression)ind);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    double it = ((Number)element$iv).doubleValue();
                    boolean bl4 = false;
                    if (!(it > data[((Number)indexes.get(i)).intValue()])) continue;
                    bl = true;
                    break block24;
                }
                bl = isNotLocalMaxima = false;
            }
            if (isNotLocalMaxima) {
                SecondOrderPoly poly = ArraysUtilsKt.secondOrderPolyFit((Sequence<Double>)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)ind)), SignalUtilsKt::findPeaks$lambda$16), SignalUtilsKt.filterByIndex(data, (IntProgression)ind));
                xm.element = -Math.pow(poly.getB(), 2) / ((double)2 * poly.getA());
                h.element = poly.eval(xm.element);
                pp[0] = poly.getA();
                pp[1] = poly.getB();
                pp[2] = poly.getC();
            } else {
                h.element = data[((Number)indexes.get(i)).intValue()];
                xm.element = ((Number)indexes.get(i)).intValue();
                ArraysUtilsKt.fill(pp, 0, pp.length, 0.0);
                Sequence xs = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)ind)), arg_0 -> SignalUtilsKt.findPeaks$lambda$17(xm, arg_0));
                Sequence ys = SequencesKt.map(SignalUtilsKt.filterByIndex(data, (IntProgression)ind), arg_0 -> SignalUtilsKt.findPeaks$lambda$18(h, arg_0));
                pp[0] = ArraysUtilsKt.leastSquaresFit((Sequence<Double>)xs, (Sequence<Double>)ys);
                pp[1] = (double)-2 * pp[0] * xm.element;
                pp[2] = h.element * pp[0] * (xm.element * xm.element);
            }
            double width = Math.sqrt(Math.abs(1.0 / pp[0])) + 1.0;
            if (!(width > maxPeakWidth || width < minPeakWidth || pp[0] > 0.0 || h.element < minPeakHeight || data[((Number)indexes.get(i)).intValue()] < 0.99 * h.element) && !(Math.abs(((Number)indexes.get(i)).doubleValue() - xm.element) > (double)(minPeakDistance / 2))) continue;
            indexesToRemove.add(i);
        }
        CollectionsKt.retainAll((List)indexes, arg_0 -> SignalUtilsKt.findPeaks$lambda$19(indexesToRemove, arg_0));
        Iterable $this$map$iv = indexes;
        boolean $i$f$map = false;
        Iterable higherBound = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n2 = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new IndexedValue((int)it, (Object)signal[it]));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List findPeaks$default(double[] dArray, double d, int n, double d2, double d3, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d = Double.MIN_VALUE;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            d2 = 1.0;
        }
        if ((n2 & 0x10) != 0) {
            d3 = Double.POSITIVE_INFINITY;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        return SignalUtilsKt.findPeaks(dArray, d, n, d2, d3, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final void findPeaksPrune(HashMap<Integer, List<Integer>> distances, List<Integer> indexes, int minPeakDistance) {
        Set set;
        Set $this$findPeaksPrune_u24lambda_u2421 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$findPeaksPrune_u24lambda_u2421, (Iterable)((Iterable)RangesKt.until((int)0, (int)distances.size())));
        Set nodeToVisit = set;
        Set visited = new LinkedHashSet();
        List $this$findPeaksPrune_u24lambda_u2422 = bl = (List)new ArrayList();
        boolean bl2 = false;
        $this$findPeaksPrune_u24lambda_u2422.addAll((Collection)indexes);
        List indexesPruned = bl;
        while (!((Collection)nodeToVisit).isEmpty()) {
            List list;
            void $this$filterTo$iv$iv;
            List<Integer> $this$findIndexes$iv;
            int node = ((Number)CollectionsKt.first((Iterable)nodeToVisit)).intValue();
            List<Integer> d = distances.get(node);
            visited.add(node);
            nodeToVisit.remove(node);
            Intrinsics.checkNotNull(d);
            boolean $i$f$findIndexes = false;
            List indexes$iv = new ArrayList();
            int n = ((Collection)$this$findIndexes$iv).size();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Integer v$iv = $this$findIndexes$iv.get(i$iv);
                int distance = ((Number)v$iv).intValue();
                boolean bl3 = false;
                if (!(distance < minPeakDistance)) continue;
                indexes$iv.add(i$iv);
            }
            List n2 = indexes$iv;
            Iterable $this$filter$iv = n2;
            boolean $i$f$filter = false;
            Iterable i$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl4 = false;
                if (!(!visited.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List neighs = (List)destination$iv$iv;
            if (!(!((Collection)neighs).isEmpty())) continue;
            List $this$findPeaksPrune_u24lambda_u2425 = list = (List)new ArrayList();
            boolean bl5 = false;
            Iterator iterator = neighs.iterator();
            while (iterator.hasNext()) {
                int idx = ((Number)iterator.next()).intValue();
                $this$findPeaksPrune_u24lambda_u2425.add(indexes.get(idx));
            }
            List neighsIndexes = list;
            CollectionsKt.retainAll((List)indexesPruned, arg_0 -> SignalUtilsKt.findPeaksPrune$lambda$26(neighsIndexes, arg_0));
        }
        indexes.clear();
        indexes.addAll(indexesPruned);
    }

    public static final void splineInterpolate(@NotNull double[] x, @NotNull double[] y, @NotNull double[] xi, @NotNull double[] yi) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)xi, (String)"xi");
        Intrinsics.checkNotNullParameter((Object)yi, (String)"yi");
        if (!(x.length > 1)) {
            boolean $i$a$-require-SignalUtilsKt$splineInterpolate$52 = false;
            String $i$a$-require-SignalUtilsKt$splineInterpolate$52 = "must be at least size 2";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$splineInterpolate$52.toString());
        }
        if (!(x.length == y.length)) {
            boolean $i$a$-require-SignalUtilsKt$splineInterpolate$62 = false;
            String $i$a$-require-SignalUtilsKt$splineInterpolate$62 = "x and y must have same size";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$splineInterpolate$62.toString());
        }
        if (!(xi.length == yi.length)) {
            boolean $i$a$-require-SignalUtilsKt$splineInterpolate$72 = false;
            String $i$a$-require-SignalUtilsKt$splineInterpolate$72 = "xi and yi must have same size";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$splineInterpolate$72.toString());
        }
        int n = x.length;
        double[] m = new double[n];
        int n2 = n - 1;
        for (int i = 1; i < n2; ++i) {
            double h1 = x[i] - x[i - 1];
            if (!(h1 > 0.0)) {
                boolean $i$a$-require-SignalUtilsKt$splineInterpolate$82 = false;
                String $i$a$-require-SignalUtilsKt$splineInterpolate$82 = "Control points must have only increasing values of x";
                throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$splineInterpolate$82.toString());
            }
            double h2 = x[i + 1] - x[i];
            double d1 = (y[i] - y[i - 1]) / h1;
            double d2 = (y[i + 1] - y[i]) / h2;
            m[i] = (d1 + d2) * 0.5;
        }
        m[0] = (y[1] - y[0]) / (x[1] - x[0]);
        m[n - 1] = (y[n - 1] - y[n - 2]) / (x[n - 1] - x[n - 2]);
        for (double ix : xi) {
            int mi = 0;
            while (mi < x.length - 2 && ix >= x[mi + 1]) {
                if (!(ix == x[++mi])) continue;
                yi[i] = x[mi];
            }
            double h = x[mi + 1] - x[mi];
            double t = (ix - x[mi]) / h;
            yi[i] = y[mi] * SignalUtilsKt.splineInterpolate$h00(t) + h * m[mi] * SignalUtilsKt.splineInterpolate$h10(t) + y[mi + 1] * SignalUtilsKt.splineInterpolate$h01(t) + h * m[mi + 1] * SignalUtilsKt.splineInterpolate$h11(t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void movavg(@NotNull double[] data, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length, int window) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int i = 0;
        while (i < length) {
            int offset$iv;
            void stride$iv;
            int offset$iv2;
            int stride$iv2;
            int offset$iv3;
            int stride$iv3;
            int n = srcOffset;
            int n2 = srcStride;
            int index$iv = i - window;
            boolean $i$f$element = false;
            offset$iv3 = index$iv * stride$iv3 + offset$iv3;
            stride$iv3 = srcOffset;
            index$iv = srcStride;
            int index$iv2 = 0;
            boolean $i$f$element2 = false;
            offset$iv2 = index$iv2 * stride$iv2 + offset$iv2;
            int minIndex = Math.max(offset$iv3, offset$iv2);
            offset$iv2 = srcOffset;
            stride$iv2 = srcStride;
            index$iv2 = i + window;
            $i$f$element2 = false;
            offset$iv2 = index$iv2 * stride$iv2 + offset$iv2;
            stride$iv2 = srcOffset;
            index$iv2 = srcStride;
            int index$iv3 = length - 1;
            boolean $i$f$element3 = false;
            offset$iv = index$iv3 * stride$iv + offset$iv;
            int maxIndex = Math.min(offset$iv2, offset$iv);
            IntProgression progression = RangesKt.step((IntProgression)((IntProgression)new IntRange(minIndex, maxIndex)), (int)srcStride);
            double acc = 0.0;
            int n3 = ArraysUtilsKt.length(progression) + 1;
            int j = progression.getFirst();
            int n4 = progression.getLast();
            int n5 = progression.getStep();
            if (n5 > 0 && j <= n4 || n5 < 0 && n4 <= j) {
                while (true) {
                    acc += data[j];
                    if (j == n4) break;
                    j += n5;
                }
            }
            j = destOffset;
            n4 = destStride;
            int index$iv4 = i++;
            boolean $i$f$element4 = false;
            dest[index$iv4 * stride$iv + offset$iv] = acc / (double)n3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void movmedian(@NotNull double[] data, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length, int window) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SignalUtilsKt.requirePositiveStride(srcStride);
        SignalUtilsKt.requirePositiveStride(destStride);
        if (!(window % 2 == 0)) {
            boolean $i$a$-require-SignalUtilsKt$movmedian$22 = false;
            String $i$a$-require-SignalUtilsKt$movmedian$22 = "window must be even";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$movmedian$22.toString());
        }
        double[] temp = new double[2 * window + 1];
        int i = 0;
        while (i < length) {
            int offset$iv;
            void stride$iv;
            int offset$iv2;
            int stride$iv2;
            int offset$iv3;
            int stride$iv3;
            int n = srcOffset;
            int n2 = srcStride;
            int index$iv = i - window;
            boolean $i$f$element = false;
            offset$iv3 = index$iv * stride$iv3 + offset$iv3;
            stride$iv3 = srcOffset;
            index$iv = srcStride;
            int index$iv2 = 0;
            boolean $i$f$element2 = false;
            offset$iv2 = index$iv2 * stride$iv2 + offset$iv2;
            int minIndex = Math.max(offset$iv3, offset$iv2);
            offset$iv2 = srcOffset;
            stride$iv2 = srcStride;
            index$iv2 = i + window;
            $i$f$element2 = false;
            offset$iv2 = index$iv2 * stride$iv2 + offset$iv2;
            stride$iv2 = srcOffset;
            index$iv2 = srcStride;
            int index$iv3 = length - 1;
            int $i$f$element3 = 0;
            offset$iv = index$iv3 * stride$iv + offset$iv;
            int maxIndex = Math.min(offset$iv2, offset$iv);
            IntProgression progression = RangesKt.step((IntProgression)((IntProgression)new IntRange(minIndex, maxIndex)), (int)srcStride);
            int c = 0;
            ArraysUtilsKt.fill(temp, 0, temp.length, Double.NEGATIVE_INFINITY);
            int j = progression.getFirst();
            index$iv3 = progression.getLast();
            $i$f$element3 = progression.getStep();
            if ($i$f$element3 > 0 && j <= index$iv3 || $i$f$element3 < 0 && index$iv3 <= j) {
                while (true) {
                    void offset$iv4;
                    void stride$iv4;
                    int n3 = srcOffset;
                    int n4 = srcStride;
                    int index$iv4 = j;
                    boolean $i$f$element4 = false;
                    temp[c] = data[index$iv4 * stride$iv4 + offset$iv4];
                    ++c;
                    if (j == index$iv3) break;
                    j += $i$f$element3;
                }
            }
            ArraysKt.sort((double[])temp);
            j = destOffset;
            index$iv3 = destStride;
            int index$iv5 = i++;
            boolean $i$f$element5 = false;
            dest[index$iv5 * stride$iv + offset$iv] = temp[window];
        }
    }

    public static final void linearInterpolate(@NotNull double[] x, @NotNull double[] y, @NotNull double[] xi, @NotNull double[] yi) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)xi, (String)"xi");
        Intrinsics.checkNotNullParameter((Object)yi, (String)"yi");
        if (!(x.length == y.length)) {
            boolean $i$a$-require-SignalUtilsKt$linearInterpolate$42 = false;
            String $i$a$-require-SignalUtilsKt$linearInterpolate$42 = "x.size != y.size";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$linearInterpolate$42.toString());
        }
        if (!(xi.length == yi.length)) {
            boolean bl = false;
            String string = "xi.size != yi.size";
            throw new IllegalArgumentException(string.toString());
        }
        int n = x.length - 1;
        for (int i = 0; i < n; ++i) {
            if (x[i] < x[i + 1]) continue;
            boolean bl = false;
            String string = "values of x must be strictly increasing";
            throw new IllegalArgumentException(string.toString());
        }
        for (double interpX : xi) {
            double calcY;
            int c1Index = -1;
            int n2 = x.length;
            for (int j = 0; j < n2; ++j) {
                double controlX = x[j];
                if (!(interpX <= controlX)) continue;
                c1Index = Math.max(0, j - 1);
                break;
            }
            if (c1Index == -1) {
                c1Index = x.length - 1;
            }
            int c2Index = 0;
            c2Index = c1Index >= x.length - 1 ? c1Index-- : c1Index + 1;
            double x1 = x[c1Index];
            double y1 = y[c1Index];
            double x2 = x[c2Index];
            double y2 = y[c2Index];
            double total = x2 - x1;
            double part = interpX - x1;
            double ratio = part / total;
            double incline = y2 - y1;
            yi[i] = calcY = y1 + ratio * incline;
        }
    }

    @NotNull
    public static final double[] linearInterpolate(@NotNull double[] y, int newSize) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        double[] yi = new double[newSize];
        double[] x = SignalUtilsKt.linspace(y.length, 0.0, y.length - 1);
        double[] xi = SignalUtilsKt.linspace(newSize, 0.0, y.length - 1);
        SignalUtilsKt.linearInterpolate(x, y, xi, yi);
        return yi;
    }

    /*
     * WARNING - void declaration
     */
    public static final double stddev(@NotNull double[] data, int srcOffset, int srcStride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (length < 2) {
            return 0.0;
        }
        if (!(length > 1)) {
            boolean bl = false;
            String string = "Data must have at least 2 elements.";
            throw new IllegalArgumentException(string.toString());
        }
        SignalUtilsKt.requirePositiveStride(srcStride);
        double mean = SignalUtilsKt.mean(data, srcOffset, srcStride, length);
        double acc = 0.0;
        int i = 0;
        while (i < length) {
            void offset$iv;
            void stride$iv;
            int n = srcOffset;
            int n2 = srcStride;
            int index$iv = i++;
            boolean $i$f$element = false;
            double v = data[index$iv * stride$iv + offset$iv];
            acc += Math.pow(v - mean, 2);
        }
        return Math.sqrt(1.0 / (double)(length - 1) * acc);
    }

    public static final double stddev(@NotNull double[] data, int srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.stddev(data, srcOffset, 1, length);
    }

    public static final double stddev(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.stddev(data, 0, 1, data.length);
    }

    /*
     * WARNING - void declaration
     */
    public static final double expectedValue(@NotNull double[] data, int srcOffset, int srcStride, int length, @NotNull Function1<? super Double, Double> probabilityFunction) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(probabilityFunction, (String)"probabilityFunction");
        boolean $i$f$expectedValue = false;
        double acc = 0.0;
        int i = 0;
        while (i < length) {
            void offset$iv;
            void stride$iv;
            int n = srcOffset;
            int n2 = srcStride;
            int index$iv = i++;
            boolean $i$f$element = false;
            double v = data[index$iv * stride$iv + offset$iv];
            acc += v * ((Number)probabilityFunction.invoke((Object)v)).doubleValue();
        }
        return acc;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ double expectedValue$default(double[] data, int srcOffset, int srcStride, int length, Function1 probabilityFunction, int n, Object object) {
        if ((n & 0x10) != 0) {
            probabilityFunction = (Function1)new Function1<Double, Double>(length){
                final /* synthetic */ int $length;
                {
                    this.$length = $length;
                }

                public final Double invoke(double d) {
                    return 1.0 / (double)this.$length;
                }
            };
        }
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)probabilityFunction, (String)"probabilityFunction");
        boolean $i$f$expectedValue = false;
        double acc = 0.0;
        int i = 0;
        while (i < length) {
            void offset$iv;
            void stride$iv;
            int n2 = srcOffset;
            int n3 = srcStride;
            int index$iv = i++;
            boolean $i$f$element = false;
            double v = data[index$iv * stride$iv + offset$iv];
            acc += v * ((Number)probabilityFunction.invoke((Object)v)).doubleValue();
        }
        return acc;
    }

    /*
     * WARNING - void declaration
     */
    public static final double nthMoment(@NotNull double[] data, int srcOffset, int srcStride, int length, int moment, @NotNull Function1<? super Double, Double> probabilityFunction) {
        boolean $i$f$element;
        int index$iv$iv;
        boolean srcStride$iv;
        void srcOffset$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(probabilityFunction, (String)"probabilityFunction");
        double[] temp = new double[length];
        double[] dArray = data;
        int n = srcOffset;
        int n2 = srcStride;
        int length$iv = length;
        int $i$f$expectedValue = 0;
        double acc$iv = 0.0;
        int i$iv = 0;
        while (i$iv < length$iv) {
            void offset$iv$iv;
            void stride$iv$iv;
            void data$iv;
            void var17_20 = srcOffset$iv;
            void var18_21 = srcStride$iv;
            index$iv$iv = i$iv++;
            $i$f$element = false;
            void v$iv = data$iv[index$iv$iv * stride$iv$iv + offset$iv$iv];
            acc$iv += v$iv * ((Number)probabilityFunction.invoke((Object)((double)v$iv))).doubleValue();
        }
        double expectedValue2 = acc$iv;
        for (int i = 0; i < length; ++i) {
            void offset$iv;
            void stride$iv;
            length$iv = srcOffset;
            $i$f$expectedValue = srcStride;
            int index$iv = i;
            boolean $i$f$element2 = false;
            double v = data[index$iv * stride$iv + offset$iv];
            temp[i] = Math.pow(v - expectedValue2, moment);
        }
        double[] i = data;
        boolean v = false;
        srcStride$iv = true;
        int n3 = length$iv = length;
        boolean $i$f$expectedValue2 = false;
        double acc$iv2 = 0.0;
        int i$iv2 = 0;
        while (i$iv2 < length$iv) {
            void offset$iv$iv;
            void stride$iv$iv;
            void data$iv;
            void v$iv;
            index$iv$iv = srcOffset$iv;
            $i$f$element = srcStride$iv;
            int index$iv$iv2 = i$iv2++;
            boolean $i$f$element3 = false;
            void var28_32 = v$iv = data$iv[index$iv$iv2 * stride$iv$iv + offset$iv$iv];
            double d = acc$iv2;
            boolean bl = false;
            double d2 = 1.0 / (double)n3;
            acc$iv2 = d + var28_32 * d2;
        }
        return acc$iv2;
    }

    public static /* synthetic */ double nthMoment$default(double[] dArray, int n, int n2, int n3, int n4, Function1 function1, int n5, Object object) {
        if ((n5 & 0x20) != 0) {
            function1 = arg_0 -> SignalUtilsKt.nthMoment$lambda$36(n3, arg_0);
        }
        return SignalUtilsKt.nthMoment(dArray, n, n2, n3, n4, (Function1<? super Double, Double>)function1);
    }

    public static final double kurtosis(@NotNull double[] data, int srcOffset, int srcStride, int length, @NotNull Function1<? super Double, Double> probabilityFunction) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(probabilityFunction, (String)"probabilityFunction");
        double stdDev = SignalUtilsKt.stddev(data, srcOffset, srcStride, length);
        double fourthMoment = SignalUtilsKt.nthMoment(data, srcOffset, srcStride, length, 4, probabilityFunction);
        return fourthMoment / stdDev;
    }

    public static /* synthetic */ double kurtosis$default(double[] dArray, int n, int n2, int n3, Function1 function1, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            function1 = arg_0 -> SignalUtilsKt.kurtosis$lambda$37(n3, arg_0);
        }
        return SignalUtilsKt.kurtosis(dArray, n, n2, n3, (Function1<? super Double, Double>)function1);
    }

    public static final void signalSumInplace(@NotNull Data output, @NotNull Data input) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int minSize = Math.min(output.getLength(), input.getLength());
        for (int i = 0; i < minSize; ++i) {
            int n = i;
            output.set(n, output.get(n) + input.get(i));
        }
    }

    public static final void signalSumInplaceRepeat(@NotNull Data output, @NotNull Data input) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (output.getLength() < input.getLength()) {
            SignalUtilsKt.signalSumInplace(output, input);
            return;
        }
        int n = output.getLength();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            output.set(n2, output.get(n2) + input.get(i % input.getLength()));
        }
    }

    public static final void signalRepeat(@NotNull Data output, @NotNull Data input, int length) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        for (int i = 0; i < length; ++i) {
            output.set(i, input.get(i % input.getLength()));
        }
    }

    public static /* synthetic */ void signalRepeat$default(Data data, Data data2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = data.getLength();
        }
        SignalUtilsKt.signalRepeat(data, data2, n);
    }

    public static final void signalMultiplyInplace(@NotNull Data output, @NotNull Data multiplier) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)multiplier, (String)"multiplier");
        int minSize = Math.min(output.getLength(), multiplier.getLength());
        for (int i = 0; i < minSize; ++i) {
            int n = i;
            output.set(n, output.get(n) * multiplier.get(i));
        }
    }

    public static final void transformInplace(@NotNull Data data, int length, @NotNull Function1<? super Double, Double> transform) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$transformInplace = false;
        for (int i = 0; i < length; ++i) {
            data.set(i, ((Number)transform.invoke((Object)data.get(i))).doubleValue());
        }
    }

    public static /* synthetic */ void transformInplace$default(Data data, int length, Function1 transform, int n, Object object) {
        if ((n & 2) != 0) {
            length = data.getLength();
        }
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        boolean $i$f$transformInplace = false;
        for (int i = 0; i < length; ++i) {
            data.set(i, ((Number)transform.invoke((Object)data.get(i))).doubleValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void decibel(@NotNull double[] src, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int i = 0;
        while (i < length) {
            void offset$iv;
            void stride$iv;
            int n = srcOffset;
            int n2 = srcStride;
            int index$iv = i;
            int $i$f$element = 0;
            double v = src[index$iv * stride$iv + offset$iv];
            double decibel = (double)10 * Math.log10(v);
            index$iv = destOffset;
            $i$f$element = destStride;
            int index$iv2 = i++;
            boolean $i$f$element2 = false;
            dest[index$iv2 * stride$iv + offset$iv] = decibel;
        }
    }

    public static /* synthetic */ void decibel$default(double[] dArray, int n, int n2, double[] dArray2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 2) != 0) {
            n = 0;
        }
        if ((n6 & 4) != 0) {
            n2 = 1;
        }
        if ((n6 & 8) != 0) {
            dArray2 = dArray;
        }
        if ((n6 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n4 = 1;
        }
        if ((n6 & 0x40) != 0) {
            n5 = dArray.length;
        }
        SignalUtilsKt.decibel(dArray, n, n2, dArray2, n3, n4, n5);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MaxIndexDouble maxIndex(@NotNull double[] data, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(length > 0)) {
            boolean $i$a$-require-SignalUtilsKt$maxIndex$22 = false;
            String $i$a$-require-SignalUtilsKt$maxIndex$22 = "length must be > 0.";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$maxIndex$22.toString());
        }
        int index = -1;
        double maxValue = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < length; ++i) {
            void offset$iv;
            void stride$iv;
            int n = offset;
            int n2 = stride;
            int index$iv = i;
            boolean $i$f$element = false;
            int curIndex = index$iv * stride$iv + offset$iv;
            double curValue = data[curIndex];
            if (!(curValue > maxValue)) continue;
            index = curIndex;
            maxValue = curValue;
        }
        return new MaxIndexDouble(maxValue, index);
    }

    public static /* synthetic */ MaxIndexDouble maxIndex$default(double[] dArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = dArray.length;
        }
        return SignalUtilsKt.maxIndex(dArray, n, n2, n3);
    }

    public static final float mean(@NotNull float[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.mean(data, offset, 1, length);
    }

    public static final float mean(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.mean(data, 0, 1, data.length);
    }

    /*
     * WARNING - void declaration
     */
    public static final float norm(@NotNull float[] data, int offset, int stride, int length, int norm) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SignalUtilsKt.requirePositiveStride(stride);
        if (norm == -1) {
            float max = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < length; ++i) {
                void offset$iv;
                void stride$iv;
                int n = offset;
                int n2 = stride;
                int index$iv = i;
                boolean $i$f$element = false;
                float v = data[index$iv * stride$iv + offset$iv];
                if (!(v > max)) continue;
                max = v;
            }
            return max;
        }
        if (!(norm > 0)) {
            boolean $i$a$-require-SignalUtilsKt$norm$32 = false;
            String $i$a$-require-SignalUtilsKt$norm$32 = "Zero norm not supported";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$norm$32.toString());
        }
        float acc = 0.0f;
        int i = 0;
        while (i < length) {
            int offset$iv = offset;
            int stride$iv = stride;
            int index$iv = i++;
            boolean $i$f$element = false;
            float v = data[index$iv * stride$iv + offset$iv];
            acc += (float)Math.pow(v, norm);
        }
        Math.pow(acc, 1.0f / (float)norm);
        return acc;
    }

    public static final void l2normalize(@NotNull float[] data, int srcOffset, int srcStride, @NotNull float[] dest, int destOffset, int destStride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(srcStride > 0 && destStride > 0)) {
            boolean $i$a$-require-SignalUtilsKt$l2normalize$32 = false;
            String $i$a$-require-SignalUtilsKt$l2normalize$32 = "stride cannot be negative";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$l2normalize$32.toString());
        }
        float l2norm = SignalUtilsKt.norm(data, srcOffset, srcStride, length, 2);
        int i = 0;
        while (i < length) {
            int offset$iv;
            int stride$iv;
            int n = srcOffset;
            int n2 = srcStride;
            int index$iv = i;
            boolean $i$f$element = false;
            float v = data[index$iv * stride$iv + offset$iv];
            offset$iv = destOffset;
            stride$iv = destStride;
            index$iv = i++;
            $i$f$element = false;
            dest[index$iv * stride$iv + offset$iv] = v / l2norm;
        }
    }

    public static final void l2normalize(@NotNull float[] data, int srcOffset, @NotNull float[] dest, int destOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SignalUtilsKt.l2normalize(data, srcOffset, 1, dest, destOffset, 1, length);
    }

    public static final void l2normalize(@NotNull float[] data, @NotNull float[] dest) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(dest.length >= data.length)) {
            boolean bl = false;
            String string = "destination can't fit data";
            throw new IllegalArgumentException(string.toString());
        }
        SignalUtilsKt.l2normalize(data, 0, 1, dest, 0, 1, data.length);
    }

    @NotNull
    public static final float[] l2normalize(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float[] dest = new float[data.length];
        SignalUtilsKt.l2normalize(data, 0, 1, dest, 0, 1, data.length);
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public static final float rms(@NotNull float[] data, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SignalUtilsKt.requirePositiveStride(stride);
        float acc = 0.0f;
        int i = 0;
        while (i < length) {
            void offset$iv;
            void stride$iv;
            int n = offset;
            int n2 = stride;
            int index$iv = i++;
            boolean $i$f$element = false;
            float v = data[index$iv * stride$iv + offset$iv];
            acc += (float)Math.pow(v, 2);
        }
        return (float)Math.sqrt(acc /= (float)length);
    }

    public static final float rms(@NotNull float[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.rms(data, offset, 1, length);
    }

    public static final float rms(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.rms(data, 0, 1, data.length);
    }

    public static final double rmssd(@NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(data.getLength() > 1)) {
            boolean bl = false;
            String string = "Data must have at least 2 elements.";
            throw new IllegalArgumentException(string.toString());
        }
        double sum = 0.0;
        int n = data.getLength();
        for (int i = 1; i < n; ++i) {
            double a = data.get(i) - data.get(i - 1);
            sum += Math.pow(a, 2);
        }
        return Math.sqrt(sum / (double)(data.getLength() - 1));
    }

    public static final double rmssd(@NotNull float[] data, int offset, int length, int stride) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.rmssd(DataKt.asData(data, offset, stride, length));
    }

    public static /* synthetic */ double rmssd$default(float[] fArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = fArray.length;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        return SignalUtilsKt.rmssd(fArray, n, n2, n3);
    }

    public static final double rmssd(@NotNull double[] data, int offset, int length, int stride) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.rmssd(DataKt.asData(data, offset, stride, length));
    }

    public static /* synthetic */ double rmssd$default(double[] dArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = dArray.length;
        }
        if ((n4 & 8) != 0) {
            n3 = 1;
        }
        return SignalUtilsKt.rmssd(dArray, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    public static final void diff(@NotNull float[] data, int srcOffset, int srcStride, @NotNull float[] dest, int destOffset, int destStride, int length, int n) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SignalUtilsKt.requirePositiveStride(srcStride);
        SignalUtilsKt.requirePositiveStride(destStride);
        if (!(n > 0)) {
            boolean $i$a$-require-SignalUtilsKt$diff$32 = false;
            String $i$a$-require-SignalUtilsKt$diff$32 = "can only do positive n diffs";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$diff$32.toString());
        }
        float[] temp = new float[SignalUtilsKt.consecutiveSum(n + 1) - 1];
        int tempOffset = SignalUtilsKt.consecutiveSum(n) - 1;
        int i = 0;
        int n2 = length - n;
        while (i < n2) {
            int tempSrcOffset;
            int j;
            int n3 = n + 1;
            for (int k = 0; k < n3; ++k) {
                void offset$iv;
                void stride$iv;
                int n4 = srcOffset;
                int n5 = srcStride;
                int index$iv = i + k;
                boolean $i$f$element = false;
                temp[tempOffset + k] = data[index$iv * stride$iv + offset$iv];
            }
            for (j = n; 1 < j; --j) {
                tempSrcOffset = SignalUtilsKt.consecutiveSum(j) - 1;
                int tempDestOffset = SignalUtilsKt.consecutiveSum(j - 1) - 1;
                for (int k = 0; k < j; ++k) {
                    float a = temp[tempSrcOffset + k];
                    float b = temp[tempSrcOffset + k + 1];
                    temp[tempDestOffset + k] = b - a;
                }
            }
            j = destOffset;
            tempSrcOffset = destStride;
            int index$iv = i++;
            boolean $i$f$element = false;
            dest[index$iv * stride$iv + offset$iv] = temp[1] - temp[0];
        }
    }

    public static final void diff(@NotNull float[] data, int srcOffset, @NotNull float[] dest, int destOffset, int length, int n) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SignalUtilsKt.diff(data, srcOffset, 1, dest, destOffset, 1, length, n);
    }

    public static final void diff(@NotNull float[] data, @NotNull float[] dest, int n) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SignalUtilsKt.diff(data, 0, 1, dest, 0, 1, data.length, n);
    }

    @NotNull
    public static final float[] diff(@NotNull float[] data, int n) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float[] dest = new float[data.length - 1];
        SignalUtilsKt.diff(data, 0, 1, dest, 0, 1, data.length, n);
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public static final float stddev(@NotNull float[] data, int srcOffset, int srcStride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(length > 1)) {
            boolean $i$a$-require-SignalUtilsKt$stddev$32 = false;
            String $i$a$-require-SignalUtilsKt$stddev$32 = "Data must have at least 2 elements.";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$stddev$32.toString());
        }
        SignalUtilsKt.requirePositiveStride(srcStride);
        float mean = SignalUtilsKt.mean(data, srcOffset, srcStride, length);
        float acc = 0.0f;
        int i = 0;
        while (i < length) {
            void offset$iv;
            void stride$iv;
            int n = srcOffset;
            int n2 = srcStride;
            int index$iv = i++;
            boolean $i$f$element = false;
            float v = data[index$iv * stride$iv + offset$iv];
            acc += (float)Math.pow(v - mean, 2);
        }
        return (float)Math.sqrt(1.0f / (float)(length - 1) * acc);
    }

    public static final float stddev(@NotNull float[] data, int srcOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.stddev(data, srcOffset, 1, length);
    }

    public static final float stddev(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return SignalUtilsKt.stddev(data, 0, 1, data.length);
    }

    private static final void requirePositiveStride(int stride) {
        if (!(stride > 0)) {
            boolean bl = false;
            String string = "stride cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MaxIndexFloat maxIndex(@NotNull float[] data, int offset, int stride, int length) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(length > 0)) {
            boolean $i$a$-require-SignalUtilsKt$maxIndex$32 = false;
            String $i$a$-require-SignalUtilsKt$maxIndex$32 = "length must be > 0.";
            throw new IllegalArgumentException($i$a$-require-SignalUtilsKt$maxIndex$32.toString());
        }
        int index = -1;
        float maxValue = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < length; ++i) {
            void offset$iv;
            void stride$iv;
            int n = offset;
            int n2 = stride;
            int index$iv = i;
            boolean $i$f$element = false;
            int curIndex = index$iv * stride$iv + offset$iv;
            float curValue = data[curIndex];
            if (!(curValue > maxValue)) continue;
            index = curIndex;
            maxValue = curValue;
        }
        return new MaxIndexFloat(maxValue, index);
    }

    public static /* synthetic */ MaxIndexFloat maxIndex$default(float[] fArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 2) != 0) {
            n = 0;
        }
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = fArray.length;
        }
        return SignalUtilsKt.maxIndex(fArray, n, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    private static final Double filterByIndex$lambda$0(Ref.IntRef $currentIndex, IntProgression $range, double[] $this_filterByIndex) {
        Double d;
        if ($currentIndex.element > $range.getLast()) {
            return null;
        }
        if ($currentIndex.element < $this_filterByIndex.length) {
            void var3_3;
            double v = $this_filterByIndex[$currentIndex.element];
            $currentIndex.element += $range.getStep();
            d = (double)var3_3;
        } else {
            d = null;
        }
        return d;
    }

    private static final boolean findPeaks$lambda$11(double[] $data, double $minPeakHeight, int i) {
        return $data[i] > $minPeakHeight;
    }

    private static final double findPeaks$lambda$16(int it) {
        return it;
    }

    private static final double findPeaks$lambda$17(Ref.DoubleRef $xm, int it) {
        double x = (double)it - $xm.element;
        return x * x;
    }

    private static final double findPeaks$lambda$18(Ref.DoubleRef $h, double it) {
        return it - $h.element;
    }

    private static final boolean findPeaks$lambda$19(Set $indexesToRemove, int it) {
        return !$indexesToRemove.contains(it);
    }

    private static final boolean findPeaksPrune$lambda$26(List $neighsIndexes, int it) {
        return !$neighsIndexes.contains(it);
    }

    private static final double splineInterpolate$h00(double t) {
        return (double)2 * Math.pow(t, 3) - (double)3 * Math.pow(t, 2) + 1.0;
    }

    private static final double splineInterpolate$h10(double t) {
        return Math.pow(t, 3) - (double)2 * Math.pow(t, 2) + t;
    }

    private static final double splineInterpolate$h01(double t) {
        return (double)-2 * Math.pow(t, 3) + (double)3 * Math.pow(t, 2);
    }

    private static final double splineInterpolate$h11(double t) {
        return Math.pow(t, 3) - Math.pow(t, 2);
    }

    private static final double nthMoment$lambda$36(int $length, double d) {
        return 1.0 / (double)$length;
    }

    private static final double kurtosis$lambda$37(int $length, double d) {
        return 1.0 / (double)$length;
    }
}

