/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.multik.api.ConstructorsKt;
import org.jetbrains.kotlinx.multik.api.Multik;
import org.jetbrains.kotlinx.multik.kotlin.linalg.QrFactorizationKt;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble32;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexDouble64;
import org.jetbrains.kotlinx.multik.ndarray.complex.ComplexFloat;
import org.jetbrains.kotlinx.multik.ndarray.data.DataType;
import org.jetbrains.kotlinx.multik.ndarray.data.MultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.MutableMultiArray;
import org.jetbrains.kotlinx.multik.ndarray.data.NDArray;
import org.jetbrains.kotlinx.multik.ndarray.data.ScalarsGettersAndSettersKt;
import vet.inpulse.math.Data;
import vet.inpulse.math.DoubleData;
import vet.inpulse.math.FirstOrderPoly;
import vet.inpulse.math.FitResult;
import vet.inpulse.math.Polynomial;
import vet.inpulse.math.PolynomialKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001b\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\"\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a#\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u001a\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0012"}, d2={"polynomialFitFirstOrder", "Lvet/inpulse/math/Polynomial;", "x", "Lvet/inpulse/math/Data;", "y", "(Lvet/inpulse/math/Data;Lvet/inpulse/math/Data;)[D", "firstOrderFit", "Lvet/inpulse/math/FirstOrderPoly;", "xs", "Lkotlin/sequences/Sequence;", "", "ys", "polyfit", "order", "", "(Lvet/inpulse/math/Data;Lvet/inpulse/math/Data;I)[D", "polyfitWithResiduals", "Lvet/inpulse/math/FitResult;", "math"})
@SourceDebugExtension(value={"SMAP\nPolynomial.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Polynomial.kt\nvet/inpulse/math/PolynomialKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 constructors.kt\norg/jetbrains/kotlinx/multik/api/ConstructorsKt\n+ 5 DataType.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType$Companion\n+ 6 DataType.jvm.kt\norg/jetbrains/kotlinx/multik/ndarray/data/DataType_jvmKt\n*L\n1#1,198:1\n1292#2,3:199\n1#3:202\n57#4:203\n49#4:216\n79#5:204\n79#5:217\n13#6,11:205\n13#6,11:218\n*S KotlinDebug\n*F\n+ 1 Polynomial.kt\nvet/inpulse/math/PolynomialKt\n*L\n107#1:199,3\n155#1:203\n156#1:216\n155#1:204\n156#1:217\n155#1:205,11\n156#1:218,11\n*E\n"})
public final class PolynomialKt {
    @NotNull
    public static final double[] polynomialFitFirstOrder(@NotNull Data x, @NotNull Data y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        int length = Math.min(x.getLength(), y.getLength());
        if (!(length >= 2)) {
            boolean bl = false;
            String string = "Need at least 2 data points to fit a 1st order polynomial";
            throw new IllegalArgumentException(string.toString());
        }
        double n = 0.0;
        double mEx = 0.0;
        double mEy = 0.0;
        double mExy = 0.0;
        double mEx2 = 0.0;
        for (int i = 0; i < length; ++i) {
            double xi = x.get(i);
            double yi = y.get(i);
            n += 1.0;
            mEx += xi;
            mEy += yi;
            mExy += xi * yi;
            mEx2 += Math.pow(xi, 2);
        }
        double beta = (n * mExy - mEx * mEy) / (n * mEx2 - Math.pow(mEx, 2));
        double alpha = 1.0 / n * (mEy - beta * mEx);
        double[] dArray = new double[]{alpha, beta};
        return Polynomial.constructor-impl(dArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirstOrderPoly firstOrderFit(@NotNull Sequence<Double> xs, @NotNull Sequence<Double> ys) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        Sequence sequence = SequencesKt.zip(xs, ys);
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J@\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\r\u00a8\u0006$"}, d2={"vet/inpulse/math/PolynomialKt$firstOrderFit$Accumulator", "", "n", "", "Ex", "Ey", "Exy", "Ex2", "<init>", "(DDDDD)V", "getN", "()D", "setN", "(D)V", "getEx", "setEx", "getEy", "setEy", "getExy", "setExy", "getEx2", "setEx2", "component1", "component2", "component3", "component4", "component5", "copy", "(DDDDD)Lvet/inpulse/math/PolynomialKt$firstOrderFit$Accumulator;", "equals", "", "other", "hashCode", "", "toString", "", "math"})
        public final class Accumulator {
            private double n;
            private double Ex;
            private double Ey;
            private double Exy;
            private double Ex2;

            public Accumulator(double n, double Ex, double Ey, double Exy, double Ex2) {
                this.n = n;
                this.Ex = Ex;
                this.Ey = Ey;
                this.Exy = Exy;
                this.Ex2 = Ex2;
            }

            public /* synthetic */ Accumulator(double d, double d2, double d3, double d4, double d5, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    d = 0.0;
                }
                if ((n & 2) != 0) {
                    d2 = 0.0;
                }
                if ((n & 4) != 0) {
                    d3 = 0.0;
                }
                if ((n & 8) != 0) {
                    d4 = 0.0;
                }
                if ((n & 0x10) != 0) {
                    d5 = 0.0;
                }
                this(d, d2, d3, d4, d5);
            }

            public final double getN() {
                return this.n;
            }

            public final void setN(double d) {
                this.n = d;
            }

            public final double getEx() {
                return this.Ex;
            }

            public final void setEx(double d) {
                this.Ex = d;
            }

            public final double getEy() {
                return this.Ey;
            }

            public final void setEy(double d) {
                this.Ey = d;
            }

            public final double getExy() {
                return this.Exy;
            }

            public final void setExy(double d) {
                this.Exy = d;
            }

            public final double getEx2() {
                return this.Ex2;
            }

            public final void setEx2(double d) {
                this.Ex2 = d;
            }

            public final double component1() {
                return this.n;
            }

            public final double component2() {
                return this.Ex;
            }

            public final double component3() {
                return this.Ey;
            }

            public final double component4() {
                return this.Exy;
            }

            public final double component5() {
                return this.Ex2;
            }

            public final Accumulator copy(double n, double Ex, double Ey, double Exy, double Ex2) {
                return new Accumulator(n, Ex, Ey, Exy, Ex2);
            }

            public static /* synthetic */ Accumulator copy$default(Accumulator accumulator, double d, double d2, double d3, double d4, double d5, int n, Object object) {
                if ((n & 1) != 0) {
                    d = accumulator.n;
                }
                if ((n & 2) != 0) {
                    d2 = accumulator.Ex;
                }
                if ((n & 4) != 0) {
                    d3 = accumulator.Ey;
                }
                if ((n & 8) != 0) {
                    d4 = accumulator.Exy;
                }
                if ((n & 0x10) != 0) {
                    d5 = accumulator.Ex2;
                }
                return accumulator.copy(d, d2, d3, d4, d5);
            }

            public String toString() {
                return "Accumulator(n=" + this.n + ", Ex=" + this.Ex + ", Ey=" + this.Ey + ", Exy=" + this.Exy + ", Ex2=" + this.Ex2 + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.n);
                result = result * 31 + Double.hashCode(this.Ex);
                result = result * 31 + Double.hashCode(this.Ey);
                result = result * 31 + Double.hashCode(this.Exy);
                result = result * 31 + Double.hashCode(this.Ex2);
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Accumulator)) {
                    return false;
                }
                Accumulator accumulator = (Accumulator)other;
                if (Double.compare(this.n, accumulator.n) != 0) {
                    return false;
                }
                if (Double.compare(this.Ex, accumulator.Ex) != 0) {
                    return false;
                }
                if (Double.compare(this.Ey, accumulator.Ey) != 0) {
                    return false;
                }
                if (Double.compare(this.Exy, accumulator.Exy) != 0) {
                    return false;
                }
                return Double.compare(this.Ex2, accumulator.Ex2) == 0;
            }
        }
        Accumulator initial$iv = new Accumulator(0.0, 0.0, 0.0, 0.0, 0.0, 31, null);
        boolean $i$f$fold = false;
        Accumulator accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Accumulator accumulator;
            Pair pair = (Pair)element$iv;
            Accumulator a = accumulator$iv;
            boolean bl = false;
            double x = ((Number)pair.component1()).doubleValue();
            double y = ((Number)pair.component2()).doubleValue();
            Accumulator $this$firstOrderFit_u24lambda_u242_u24lambda_u241 = accumulator = a;
            boolean bl2 = false;
            $this$firstOrderFit_u24lambda_u242_u24lambda_u241.setN($this$firstOrderFit_u24lambda_u242_u24lambda_u241.getN() + 1.0);
            $this$firstOrderFit_u24lambda_u242_u24lambda_u241.setEx($this$firstOrderFit_u24lambda_u242_u24lambda_u241.getEx() + x);
            $this$firstOrderFit_u24lambda_u242_u24lambda_u241.setEy($this$firstOrderFit_u24lambda_u242_u24lambda_u241.getEy() + y);
            $this$firstOrderFit_u24lambda_u242_u24lambda_u241.setExy($this$firstOrderFit_u24lambda_u242_u24lambda_u241.getExy() + x * y);
            $this$firstOrderFit_u24lambda_u242_u24lambda_u241.setEx2($this$firstOrderFit_u24lambda_u242_u24lambda_u241.getEx2() + Math.pow(x, 2));
            $this$firstOrderFit_u24lambda_u242_u24lambda_u241.setExy($this$firstOrderFit_u24lambda_u242_u24lambda_u241.getExy() + Math.pow(y, 2));
            accumulator$iv = accumulator;
        }
        Accumulator s = accumulator$iv;
        if (!(s.getN() > 2.0)) {
            boolean bl = false;
            String string = "Sequences have less than the required 2 data points";
            throw new IllegalArgumentException(string.toString());
        }
        double beta = (s.getN() * s.getExy() - s.getEx() * s.getEy()) / (s.getN() * s.getEx2() - Math.pow(s.getEx(), 2));
        double alpha = 1.0 / s.getN() * (s.getEy() - beta * s.getEx());
        return new FirstOrderPoly(beta, alpha);
    }

    @NotNull
    public static final double[] polyfit(@NotNull Data x, @NotNull Data y, int order) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return PolynomialKt.polyfitWithResiduals(x, y, order).getPolynomial-thQicJI();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FitResult polyfitWithResiduals(@NotNull Data x, @NotNull Data y, int order) {
        void $this$zeros$iv;
        DataType dataType;
        void $this$zeros$iv2;
        DataType dataType2;
        void dim1$iv22;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        if (!(order >= 0)) {
            boolean $i$a$-require-PolynomialKt$polyfitWithResiduals$42 = false;
            String $i$a$-require-PolynomialKt$polyfitWithResiduals$42 = "must be positive";
            throw new IllegalArgumentException($i$a$-require-PolynomialKt$polyfitWithResiduals$42.toString());
        }
        if (!(x.getLength() == y.getLength())) {
            boolean $i$a$-require-PolynomialKt$polyfitWithResiduals$52 = false;
            String $i$a$-require-PolynomialKt$polyfitWithResiduals$52 = "x and y must have the same length";
            throw new IllegalArgumentException($i$a$-require-PolynomialKt$polyfitWithResiduals$52.toString());
        }
        if (!(x.getLength() >= order)) {
            boolean $i$a$-require-PolynomialKt$polyfitWithResiduals$62 = false;
            String $i$a$-require-PolynomialKt$polyfitWithResiduals$62 = "not enough data points";
            throw new IllegalArgumentException($i$a$-require-PolynomialKt$polyfitWithResiduals$62.toString());
        }
        int n = x.getLength();
        int m = order + 1;
        Multik multik = Multik.INSTANCE;
        int n2 = m;
        int dim2$iv = m;
        boolean $i$f$zeros = false;
        Object object = new int[]{dim1$iv22, dim2$iv};
        int[] nArray = object;
        object = DataType.Companion;
        KClass type$iv$iv = Reflection.getOrCreateKotlinClass(Double.class);
        boolean $i$f$ofKClass = false;
        boolean $i$f$dataTypeOf = false;
        KClass kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType2 = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType2 = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType2 = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType2 = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType2 = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType2 = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType2 = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType2 = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        NDArray xMat = ConstructorsKt.zeros((Multik)$this$zeros$iv2, (int[])nArray, (DataType)dataType2);
        Multik dim1$iv22 = Multik.INSTANCE;
        int dim1$iv = m;
        $i$f$zeros = false;
        Object this_$iv$iv = new int[]{dim1$iv};
        int[] nArray2 = this_$iv$iv;
        this_$iv$iv = DataType.Companion;
        type$iv$iv = Reflection.getOrCreateKotlinClass(Double.class);
        $i$f$ofKClass = false;
        $i$f$dataTypeOf = false;
        kClass = type$iv$iv;
        if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            dataType = DataType.ByteDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            dataType = DataType.ShortDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            dataType = DataType.IntDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            dataType = DataType.LongDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            dataType = DataType.FloatDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            dataType = DataType.DoubleDataType;
        } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexFloat.class))) {
            dataType = DataType.ComplexFloatDataType;
        } else if ((Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble.class)) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble64.class))) ? true : Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(ComplexDouble32.class))) {
            dataType = DataType.ComplexDoubleDataType;
        } else {
            throw new IllegalStateException("One of the primitive types was expected, got " + type$iv$iv.getSimpleName());
        }
        NDArray yMat = ConstructorsKt.zeros((Multik)$this$zeros$iv, (int[])nArray2, (DataType)dataType);
        for (int d = 0; d < n; ++d) {
            double dX = x.get(d);
            double dY = y.get(d);
            int i = 0;
            while (i < m) {
                int j = 0;
                while (j < m) {
                    double v = Math.pow(dX, i + j);
                    int n3 = i;
                    int n4 = j++;
                    ScalarsGettersAndSettersKt.doubleSet2((MutableMultiArray)((MutableMultiArray)xMat), (int)n3, (int)n4, (double)(ScalarsGettersAndSettersKt.doubleGet2((MultiArray)((MultiArray)xMat), (int)n3, (int)n4) + v));
                }
                double v = dY * Math.pow(dX, i);
                int n5 = i++;
                ScalarsGettersAndSettersKt.doubleSet1((MutableMultiArray)((MutableMultiArray)yMat), (int)n5, (double)(ScalarsGettersAndSettersKt.doubleGet1((MultiArray)((MultiArray)yMat), (int)n5) + v));
            }
        }
        Pair pair = QrFactorizationKt.qrDouble((MultiArray)((MultiArray)xMat));
        NDArray q = (NDArray)pair.component1();
        NDArray r = (NDArray)pair.component2();
        NDArray qT = q.transpose(new int[0]);
        NDArray temp = Multik.INSTANCE.getLinalg().getLinAlgEx().dotMV((MultiArray)qT, (MultiArray)yMat);
        NDArray invR = Multik.INSTANCE.getLinalg().getLinAlgEx().inv((MultiArray)r);
        NDArray result = Multik.INSTANCE.getLinalg().getLinAlgEx().dotMV((MultiArray)invR, (MultiArray)temp);
        double[] coefficients = result.getData().getDoubleArray();
        double[] p = Polynomial.constructor-impl(coefficients);
        DoubleData res = new DoubleData(n);
        for (int i = 0; i < n; ++i) {
            res.set(i, y.get(i) - Polynomial.invoke-impl(p, x.get(i)));
        }
        double[] dArray = res.getData();
        double d = 0.0;
        int n6 = dArray.length;
        for (int i = 0; i < n6; ++i) {
            void it;
            double d2;
            double d3 = d2 = dArray[i];
            double d4 = d;
            boolean bl = false;
            double d5 = Math.pow((double)it, 2);
            d = d4 + d5;
        }
        double sumSquares = d;
        return new FitResult(p, res, sumSquares, null);
    }
}

