/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.math.ArraysUtilsKt;
import vet.inpulse.math.Data;
import vet.inpulse.math.DoubleData;
import vet.inpulse.math.SecondOrderPoly;
import vet.inpulse.math.SignalUtilsKt;
import vet.inpulse.math.linalg.Matrix3x3;
import vet.inpulse.math.linalg.MatrixKt;
import vet.inpulse.math.linalg.Vec3;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\f\u001a>\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001aH\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00162\b\b\u0002\u0010\u0011\u001a\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u001a.\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0001\u001a&\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0018\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0018\u001a\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n\u001a\"\u0010\u001e\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0 \u001a\"\u0010\"\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0 \u001aD\u0010#\u001a\b\u0012\u0004\u0012\u0002H%0$\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0$2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020\n0*\u001a\u001f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070,2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070,\u00a2\u0006\u0002\u0010-\u00a8\u0006."}, d2={"requireBinaryAndGetMaxLevel", "", "length", "level", "fill", "", "data", "", "offset", "value", "", "cumulativeSumMinusMean", "Lvet/inpulse/math/Data;", "input", "output", "copy", "src", "srcOffset", "srcStride", "dest", "destOffset", "destStride", "", "srcIndexes", "Lkotlin/ranges/IntProgression;", "destIndexes", "firstOrderPolySquare", "Lvet/inpulse/math/SecondOrderPoly;", "a", "b", "leastSquaresFit", "xs", "Lkotlin/sequences/Sequence;", "ys", "secondOrderPolyFit", "ratioFilter", "", "T", "items", "minRatio", "maxRatio", "valueFunction", "Lkotlin/Function1;", "transpose", "", "([[D)[[D", "math"})
@SourceDebugExtension(value={"SMAP\nArraysUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArraysUtils.kt\nvet/inpulse/math/ArraysUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SignalUtils.kt\nvet/inpulse/math/SignalUtilsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,237:1\n1#2:238\n206#3:239\n206#3:240\n206#3:241\n2322#4,7:242\n1292#4,3:249\n*S KotlinDebug\n*F\n+ 1 ArraysUtils.kt\nvet/inpulse/math/ArraysUtilsKt\n*L\n43#1:239\n57#1:240\n71#1:241\n131#1:242,7\n170#1:249,3\n*E\n"})
public final class ArraysUtilsKt {
    public static final int requireBinaryAndGetMaxLevel(int length, int level) {
        if (!SignalUtilsKt.intIsBinary(length)) {
            boolean bl = false;
            String string = "length is not power of 2";
            throw new IllegalArgumentException(string.toString());
        }
        int maxLevels = SignalUtilsKt.binaryLog(length);
        if (!(0 <= level ? level <= maxLevels : false)) {
            boolean bl = false;
            String string = "level is out of range of given array";
            throw new IllegalArgumentException(string.toString());
        }
        return maxLevels;
    }

    public static final void fill(@NotNull double[] data, int offset, int length, double value) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            data[i] = value;
        }
    }

    @NotNull
    public static final Data cumulativeSumMinusMean(@NotNull Data input, @NotNull Data output) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (input.isEmpty()) {
            return output;
        }
        double mean = SignalUtilsKt.mean(input);
        output.set(0, input.get(0) - mean);
        int n = input.getLength();
        for (int i = 1; i < n; ++i) {
            output.set(i, output.get(i - 1) + input.get(i) - mean);
        }
        return output;
    }

    public static /* synthetic */ Data cumulativeSumMinusMean$default(Data data, Data data2, int n, Object object) {
        if ((n & 2) != 0) {
            data2 = new DoubleData(data.getLength());
        }
        return ArraysUtilsKt.cumulativeSumMinusMean(data, data2);
    }

    public static final void copy(@NotNull double[] src, int srcOffset, int srcStride, @NotNull double[] dest, int destOffset, int destStride, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int i = 0;
        while (i < length) {
            int offset$iv;
            int stride$iv;
            int n = destOffset;
            int n2 = destStride;
            int index$iv = i;
            boolean $i$f$element = false;
            int n3 = index$iv * stride$iv + offset$iv;
            offset$iv = srcOffset;
            stride$iv = srcStride;
            index$iv = i++;
            $i$f$element = false;
            dest[n3] = src[index$iv * stride$iv + offset$iv];
        }
    }

    public static final void copy(@NotNull float[] src, @NotNull float[] dest, int srcOffset, int srcStride, int destOffset, int destStride, int length) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int i = 0;
        while (i < length) {
            int offset$iv;
            int stride$iv;
            int n = destOffset;
            int n2 = destStride;
            int index$iv = i;
            boolean $i$f$element = false;
            int n3 = index$iv * stride$iv + offset$iv;
            offset$iv = srcOffset;
            stride$iv = srcStride;
            index$iv = i++;
            $i$f$element = false;
            dest[n3] = src[index$iv * stride$iv + offset$iv];
        }
    }

    public static /* synthetic */ void copy$default(float[] fArray, float[] fArray2, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 4) != 0) {
            n = 0;
        }
        if ((n6 & 8) != 0) {
            n2 = 1;
        }
        if ((n6 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n4 = 1;
        }
        if ((n6 & 0x40) != 0) {
            n5 = fArray.length;
        }
        ArraysUtilsKt.copy(fArray, fArray2, n, n2, n3, n4, n5);
    }

    public static final void copy(@NotNull double[] src, @NotNull IntProgression srcIndexes, @NotNull double[] dest, int destOffset, int destStride) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)srcIndexes, (String)"srcIndexes");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int c = 0;
        int i = srcIndexes.getFirst();
        int n = srcIndexes.getLast();
        int n2 = srcIndexes.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                int n3 = destOffset;
                int n4 = destStride;
                int index$iv = c++;
                boolean $i$f$element = false;
                dest[index$iv * stride$iv + offset$iv] = src[i];
                if (i == n) break;
                i += n2;
            }
        }
    }

    public static final void copy(@NotNull double[] src, @NotNull IntProgression srcIndexes, @NotNull double[] dest, @NotNull IntProgression destIndexes) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)srcIndexes, (String)"srcIndexes");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)destIndexes, (String)"destIndexes");
        for (Pair pair : CollectionsKt.zip((Iterable)((Iterable)srcIndexes), (Iterable)((Iterable)destIndexes))) {
            int srcIndex = ((Number)pair.component1()).intValue();
            int destIndex = ((Number)pair.component2()).intValue();
            dest[destIndex] = src[srcIndex];
        }
    }

    public static final int length(@NotNull IntProgression $this$length) {
        Intrinsics.checkNotNullParameter((Object)$this$length, (String)"<this>");
        return ($this$length.getLast() - $this$length.getFirst()) / $this$length.getStep();
    }

    @NotNull
    public static final SecondOrderPoly firstOrderPolySquare(double a, double b) {
        double a2 = a * a;
        double b2 = (double)2 * a * b;
        double c2 = b * b;
        return new SecondOrderPoly(a2, b2, c2);
    }

    /*
     * WARNING - void declaration
     */
    public static final double leastSquaresFit(@NotNull Sequence<Double> xs, @NotNull Sequence<Double> ys) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        Sequence $this$reduce$iv = SequencesKt.map((Sequence)SequencesKt.zip(xs, ys), ArraysUtilsKt::leastSquaresFit$lambda$2);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty sequence can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void secondOrderPoly;
            SecondOrderPoly secondOrderPoly2 = (SecondOrderPoly)iterator$iv.next();
            SecondOrderPoly acc = (SecondOrderPoly)accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.plus((SecondOrderPoly)secondOrderPoly);
        }
        SecondOrderPoly polySum = (SecondOrderPoly)accumulator$iv;
        double a = (double)2 * polySum.getA();
        double b = polySum.getB();
        return b / -a;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SecondOrderPoly secondOrderPolyFit(@NotNull Sequence<Double> xs, @NotNull Sequence<Double> ys) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        Sequence sequence = SequencesKt.zip(xs, ys);
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b&\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001BW\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J^\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020/H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010\u00a8\u00060"}, d2={"vet/inpulse/math/ArraysUtilsKt$secondOrderPolyFit$Accumulator", "", "n", "", "Ex", "Ex2", "Ex3", "Ex4", "Ey", "Eyx", "Eyx2", "<init>", "(DDDDDDDD)V", "getN", "()D", "setN", "(D)V", "getEx", "setEx", "getEx2", "setEx2", "getEx3", "setEx3", "getEx4", "setEx4", "getEy", "setEy", "getEyx", "setEyx", "getEyx2", "setEyx2", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(DDDDDDDD)Lvet/inpulse/math/ArraysUtilsKt$secondOrderPolyFit$Accumulator;", "equals", "", "other", "hashCode", "", "toString", "", "math"})
        public final class Accumulator {
            private double n;
            private double Ex;
            private double Ex2;
            private double Ex3;
            private double Ex4;
            private double Ey;
            private double Eyx;
            private double Eyx2;

            public Accumulator(double n, double Ex, double Ex2, double Ex3, double Ex4, double Ey, double Eyx, double Eyx2) {
                this.n = n;
                this.Ex = Ex;
                this.Ex2 = Ex2;
                this.Ex3 = Ex3;
                this.Ex4 = Ex4;
                this.Ey = Ey;
                this.Eyx = Eyx;
                this.Eyx2 = Eyx2;
            }

            public /* synthetic */ Accumulator(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    d = 0.0;
                }
                if ((n & 2) != 0) {
                    d2 = 0.0;
                }
                if ((n & 4) != 0) {
                    d3 = 0.0;
                }
                if ((n & 8) != 0) {
                    d4 = 0.0;
                }
                if ((n & 0x10) != 0) {
                    d5 = 0.0;
                }
                if ((n & 0x20) != 0) {
                    d6 = 0.0;
                }
                if ((n & 0x40) != 0) {
                    d7 = 0.0;
                }
                if ((n & 0x80) != 0) {
                    d8 = 0.0;
                }
                this(d, d2, d3, d4, d5, d6, d7, d8);
            }

            public final double getN() {
                return this.n;
            }

            public final void setN(double d) {
                this.n = d;
            }

            public final double getEx() {
                return this.Ex;
            }

            public final void setEx(double d) {
                this.Ex = d;
            }

            public final double getEx2() {
                return this.Ex2;
            }

            public final void setEx2(double d) {
                this.Ex2 = d;
            }

            public final double getEx3() {
                return this.Ex3;
            }

            public final void setEx3(double d) {
                this.Ex3 = d;
            }

            public final double getEx4() {
                return this.Ex4;
            }

            public final void setEx4(double d) {
                this.Ex4 = d;
            }

            public final double getEy() {
                return this.Ey;
            }

            public final void setEy(double d) {
                this.Ey = d;
            }

            public final double getEyx() {
                return this.Eyx;
            }

            public final void setEyx(double d) {
                this.Eyx = d;
            }

            public final double getEyx2() {
                return this.Eyx2;
            }

            public final void setEyx2(double d) {
                this.Eyx2 = d;
            }

            public final double component1() {
                return this.n;
            }

            public final double component2() {
                return this.Ex;
            }

            public final double component3() {
                return this.Ex2;
            }

            public final double component4() {
                return this.Ex3;
            }

            public final double component5() {
                return this.Ex4;
            }

            public final double component6() {
                return this.Ey;
            }

            public final double component7() {
                return this.Eyx;
            }

            public final double component8() {
                return this.Eyx2;
            }

            public final Accumulator copy(double n, double Ex, double Ex2, double Ex3, double Ex4, double Ey, double Eyx, double Eyx2) {
                return new Accumulator(n, Ex, Ex2, Ex3, Ex4, Ey, Eyx, Eyx2);
            }

            public static /* synthetic */ Accumulator copy$default(Accumulator accumulator, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, Object object) {
                if ((n & 1) != 0) {
                    d = accumulator.n;
                }
                if ((n & 2) != 0) {
                    d2 = accumulator.Ex;
                }
                if ((n & 4) != 0) {
                    d3 = accumulator.Ex2;
                }
                if ((n & 8) != 0) {
                    d4 = accumulator.Ex3;
                }
                if ((n & 0x10) != 0) {
                    d5 = accumulator.Ex4;
                }
                if ((n & 0x20) != 0) {
                    d6 = accumulator.Ey;
                }
                if ((n & 0x40) != 0) {
                    d7 = accumulator.Eyx;
                }
                if ((n & 0x80) != 0) {
                    d8 = accumulator.Eyx2;
                }
                return accumulator.copy(d, d2, d3, d4, d5, d6, d7, d8);
            }

            public String toString() {
                return "Accumulator(n=" + this.n + ", Ex=" + this.Ex + ", Ex2=" + this.Ex2 + ", Ex3=" + this.Ex3 + ", Ex4=" + this.Ex4 + ", Ey=" + this.Ey + ", Eyx=" + this.Eyx + ", Eyx2=" + this.Eyx2 + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.n);
                result = result * 31 + Double.hashCode(this.Ex);
                result = result * 31 + Double.hashCode(this.Ex2);
                result = result * 31 + Double.hashCode(this.Ex3);
                result = result * 31 + Double.hashCode(this.Ex4);
                result = result * 31 + Double.hashCode(this.Ey);
                result = result * 31 + Double.hashCode(this.Eyx);
                result = result * 31 + Double.hashCode(this.Eyx2);
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Accumulator)) {
                    return false;
                }
                Accumulator accumulator = (Accumulator)other;
                if (Double.compare(this.n, accumulator.n) != 0) {
                    return false;
                }
                if (Double.compare(this.Ex, accumulator.Ex) != 0) {
                    return false;
                }
                if (Double.compare(this.Ex2, accumulator.Ex2) != 0) {
                    return false;
                }
                if (Double.compare(this.Ex3, accumulator.Ex3) != 0) {
                    return false;
                }
                if (Double.compare(this.Ex4, accumulator.Ex4) != 0) {
                    return false;
                }
                if (Double.compare(this.Ey, accumulator.Ey) != 0) {
                    return false;
                }
                if (Double.compare(this.Eyx, accumulator.Eyx) != 0) {
                    return false;
                }
                return Double.compare(this.Eyx2, accumulator.Eyx2) == 0;
            }
        }
        Accumulator initial$iv = new Accumulator(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 255, null);
        boolean $i$f$fold = false;
        Accumulator accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Accumulator accumulator;
            Pair pair = (Pair)element$iv;
            Accumulator a = accumulator$iv;
            boolean bl = false;
            double x = ((Number)pair.component1()).doubleValue();
            double y = ((Number)pair.component2()).doubleValue();
            Accumulator $this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244 = accumulator = a;
            boolean bl2 = false;
            $this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.setN($this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.getN() + 1.0);
            $this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.setEx($this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.getEx() + x);
            $this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.setEx2($this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.getEx2() + Math.pow(x, 2));
            $this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.setEx3($this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.getEx3() + Math.pow(x, 3));
            $this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.setEx4($this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.getEx4() + Math.pow(x, 4));
            $this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.setEy($this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.getEy() + y);
            $this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.setEyx($this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.getEyx() + y * x);
            $this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.setEyx2($this$secondOrderPolyFit_u24lambda_u245_u24lambda_u244.getEyx2() + y * Math.pow(x, 2));
            accumulator$iv = accumulator;
        }
        Accumulator s = accumulator$iv;
        if (!(s.getN() > 3.0)) {
            boolean $i$a$-require-ArraysUtilsKt$secondOrderPolyFit$22 = false;
            String $i$a$-require-ArraysUtilsKt$secondOrderPolyFit$22 = "Sequences have less than the required 3 data points";
            throw new IllegalArgumentException($i$a$-require-ArraysUtilsKt$secondOrderPolyFit$22.toString());
        }
        double[] $i$a$-require-ArraysUtilsKt$secondOrderPolyFit$22 = new double[]{s.getN(), s.getEx(), s.getEx2(), s.getEx(), s.getEx2(), s.getEx3(), s.getEx2(), s.getEx3(), s.getEx4()};
        Matrix3x3 system = new Matrix3x3($i$a$-require-ArraysUtilsKt$secondOrderPolyFit$22);
        Vec3 values = new Vec3(s.getEy(), s.getEyx(), s.getEyx2());
        Vec3 solution = MatrixKt.gaussianElimination(system, values);
        return new SecondOrderPoly(solution.getZ(), solution.getY(), solution.getX());
    }

    @NotNull
    public static final <T> List<T> ratioFilter(@NotNull List<? extends T> items, double minRatio, double maxRatio, @NotNull Function1<? super T, Double> valueFunction) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(valueFunction, (String)"valueFunction");
        List filtered = new ArrayList();
        if (items.isEmpty()) {
            return filtered;
        }
        Object firstItem = CollectionsKt.first(items);
        double lastItemValue = ((Number)valueFunction.invoke(firstItem)).doubleValue();
        if (!(!(lastItemValue == 0.0))) {
            boolean $i$a$-require-ArraysUtilsKt$ratioFilter$22 = false;
            String $i$a$-require-ArraysUtilsKt$ratioFilter$22 = "first value can't be 0";
            throw new IllegalArgumentException($i$a$-require-ArraysUtilsKt$ratioFilter$22.toString());
        }
        for (T i : items.subList(1, items.size())) {
            double value = ((Number)valueFunction.invoke(i)).doubleValue();
            if (value == 0.0) continue;
            double ratio = value / lastItemValue;
            boolean bl = minRatio <= ratio ? ratio <= maxRatio : false;
            if (!bl) continue;
            filtered.add(i);
            lastItemValue = value;
        }
        return filtered;
    }

    @NotNull
    public static final double[][] transpose(@NotNull double[][] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = ((Object[])data).length;
        int m = ((double[])ArraysKt.first((Object[])((Object[])data))).length;
        int n2 = 0;
        double[][] dArrayArray = new double[m][];
        while (n2 < m) {
            int n3 = n2++;
            dArrayArray[n3] = new double[n];
        }
        double[][] out = dArrayArray;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                out[j][i] = data[i][j];
            }
        }
        return out;
    }

    private static final SecondOrderPoly leastSquaresFit$lambda$2(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        double x = ((Number)pair.component1()).doubleValue();
        double y = ((Number)pair.component2()).doubleValue();
        double a = -x;
        return ArraysUtilsKt.firstOrderPolySquare(a, y);
    }
}

