/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.acquisition.modules.implementations.ppg.calibration;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.signalprocessing.filters.MovingAverageFilter;
import vet.inpulse.libcomm.core.device.data.PpgData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgSaturationDetector;", "", "fs", "", "upperRawLimit", "lowerRawLimit", "deltaLimit", "", "<init>", "(IIID)V", "deltaIRsBufferSize", "deltaIRs", "Lkotlin/collections/ArrayDeque;", "", "rawIRs", "Lvet/inpulse/core/signalprocessing/filters/MovingAverageFilter;", "addSample", "", "sample", "Lvet/inpulse/libcomm/core/device/data/PpgData;", "isSaturated", "", "reset", "core-acquisition"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPpgCalibrationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PpgCalibrationUtils.kt\nvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgSaturationDetector\n+ 2 PpgCalibrationUtils.kt\nvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgCalibrationUtilsKt\n*L\n1#1,125:1\n119#2,5:126\n*S KotlinDebug\n*F\n+ 1 PpgCalibrationUtils.kt\nvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgSaturationDetector\n*L\n103#1:126,5\n*E\n"})
public final class PpgSaturationDetector {
    private final int upperRawLimit;
    private final int lowerRawLimit;
    private final double deltaLimit;
    private final int deltaIRsBufferSize;
    @NotNull
    private final ArrayDeque<Float> deltaIRs;
    @NotNull
    private final MovingAverageFilter rawIRs;
    public static final int $stable = 8;

    public PpgSaturationDetector(int fs, int upperRawLimit, int lowerRawLimit, double deltaLimit) {
        this.upperRawLimit = upperRawLimit;
        this.lowerRawLimit = lowerRawLimit;
        this.deltaLimit = deltaLimit;
        this.deltaIRsBufferSize = fs;
        this.deltaIRs = new ArrayDeque(this.deltaIRsBufferSize);
        this.rawIRs = new MovingAverageFilter(fs * 2, null, 2, null);
    }

    public /* synthetic */ PpgSaturationDetector(int n, int n2, int n3, double d, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n2 = 2000000;
        }
        if ((n4 & 4) != 0) {
            n3 = 10000;
        }
        if ((n4 & 8) != 0) {
            d = 1.0E-5;
        }
        this(n, n2, n3, d);
    }

    public final void addSample(@NotNull PpgData sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        Integer n = sample.getInfraredRaw();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.rawIRs.add((float)it);
        } else {
            PpgSaturationDetector $this$addSample_u24lambda_u241 = this;
            boolean bl = false;
            $this$addSample_u24lambda_u241.deltaIRs.addLast((Object)Float.valueOf(sample.getInfrared()));
            if ($this$addSample_u24lambda_u241.deltaIRs.size() > $this$addSample_u24lambda_u241.deltaIRsBufferSize) {
                $this$addSample_u24lambda_u241.deltaIRs.removeFirstOrNull();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSaturated() {
        boolean bl;
        if (this.rawIRs.isBufferFull()) {
            float average = this.rawIRs.getMean();
            bl = average < (float)this.lowerRawLimit || average > (float)this.upperRawLimit;
        } else if (this.deltaIRs.size() >= this.deltaIRsBufferSize) {
            Iterable $this$sumOf$iv = (Iterable)this.deltaIRs;
            boolean $i$f$sumOf = false;
            float sum$iv = 0.0f;
            for (Object element$iv : $this$sumOf$iv) {
                void it;
                float f = ((Number)element$iv).floatValue();
                float f2 = sum$iv;
                boolean bl2 = false;
                float f3 = Math.abs((float)it);
                sum$iv = f2 + f3;
            }
            float sum = sum$iv;
            bl = (double)sum < this.deltaLimit;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void reset() {
        this.deltaIRs.clear();
        this.rawIRs.clear();
    }
}

