/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.acquisition.modules.implementations.ppg.calibration;

import androidx.compose.runtime.internal.StabilityInferred;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.acquisition.AcquisitionKoinModuleKt;
import vet.inpulse.core.acquisition.modules.implementations.ppg.PpgStatus;
import vet.inpulse.core.acquisition.modules.implementations.ppg.calibration.PpgCalibrationController;
import vet.inpulse.core.acquisition.modules.implementations.ppg.calibration.PpgParametersProvider;
import vet.inpulse.core.acquisition.modules.implementations.ppg.calibration.PpgSaturationDetector;
import vet.inpulse.libcomm.core.device.data.PpgCalibrationControlMode;
import vet.inpulse.libcomm.core.device.data.PpgCalibrationParameters;
import vet.inpulse.libcomm.core.device.data.PpgData;
import vet.inpulse.libcomm.core.device.data.PpgDiagnosis;
import vet.inpulse.libcomm.core.device.data.PpgDiagnosisStatus;
import vet.inpulse.libcomm.core.device.data.PpgSampleStatus;
import vet.inpulse.libcomm.core.device.module.PpgModule;
import vet.inpulse.shared.log.LoggerInterface;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\u0010\u0006\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0082@\u00a2\u0006\u0004\b(\u0010$J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgCalibrationController;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "device", "Lvet/inpulse/libcomm/core/device/module/PpgModule;", "onPpgParametersRequested", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Lvet/inpulse/libcomm/core/device/data/PpgCalibrationParameters;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lvet/inpulse/libcomm/core/device/module/PpgModule;Lkotlin/jvm/functions/Function1;)V", "Lkotlin/jvm/functions/Function1;", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "fs", "", "saturationDetector", "Lvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgSaturationDetector;", "ppgDiagnosisStream", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lvet/inpulse/libcomm/core/device/data/PpgDiagnosisStatus;", "samplesRequiredAfterFinishCalibrationToDetectAgain", "counterToRequestCalibration", "wasSaturated", "", "Ljava/lang/Boolean;", "saturationDebounceCounter", "saturationDebounceLimit", "lastStatusTEMP", "Lvet/inpulse/core/acquisition/modules/implementations/ppg/PpgStatus;", "addSample", "sample", "Lvet/inpulse/libcomm/core/device/data/PpgData;", "startPpgCalibration", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPpgDiagnosis", "Lkotlin/Result;", "Lvet/inpulse/libcomm/core/device/data/PpgDiagnosis;", "getPpgDiagnosis-IoAF18A", "isCalibrationRequired", "Companion", "core-acquisition"})
@StabilityInferred(parameters=0)
public final class PpgCalibrationController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final PpgModule device;
    @NotNull
    private final Function1<Continuation<? super PpgCalibrationParameters>, Object> onPpgParametersRequested;
    @NotNull
    private final LoggerInterface logger;
    private final int fs;
    @NotNull
    private final PpgSaturationDetector saturationDetector;
    @NotNull
    private final MutableStateFlow<PpgDiagnosisStatus> ppgDiagnosisStream;
    private final int samplesRequiredAfterFinishCalibrationToDetectAgain;
    private int counterToRequestCalibration;
    @Nullable
    private Boolean wasSaturated;
    private int saturationDebounceCounter;
    private final int saturationDebounceLimit;
    @Nullable
    private PpgStatus lastStatusTEMP;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "PpgCalibrationController";
    private static boolean AUTOMATIC_CALIBRATION_ENABLED = true;

    public PpgCalibrationController(@NotNull CoroutineScope scope, @NotNull PpgModule device, @NotNull Function1<? super Continuation<? super PpgCalibrationParameters>, ? extends Object> onPpgParametersRequested) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter(onPpgParametersRequested, (String)"onPpgParametersRequested");
        this.scope = scope;
        this.device = device;
        this.onPpgParametersRequested = onPpgParametersRequested;
        this.logger = AcquisitionKoinModuleKt.getAcquisitionLogModule().getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.fs = (int)((Number)this.device.getPpgSamplingRate().getValue()).floatValue();
        this.saturationDetector = new PpgSaturationDetector(this.fs, 0, 0, 0.0, 14, null);
        this.ppgDiagnosisStream = StateFlowKt.MutableStateFlow((Object)PpgDiagnosisStatus.NORMAL);
        this.samplesRequiredAfterFinishCalibrationToDetectAgain = this.fs * 3;
        this.saturationDebounceLimit = (int)((double)this.fs * 1.5);
    }

    @NotNull
    public final PpgStatus addSample(@NotNull PpgData sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        this.saturationDetector.addSample(sample);
        if (AUTOMATIC_CALIBRATION_ENABLED && this.isCalibrationRequired(sample)) {
            this.logger.d(PpgCalibrationController::addSample$lambda$0);
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ PpgCalibrationController this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.startPpgCalibration((Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        PpgStatus ppgStatus = switch (WhenMappings.$EnumSwitchMapping$1[((PpgDiagnosisStatus)this.ppgDiagnosisStream.getValue()).ordinal()]) {
            case 1 -> PpgStatus.CABLE_DISCONNECTED;
            case 2 -> PpgStatus.SENSOR_ERROR;
            case 3 -> {
                if (WhenMappings.$EnumSwitchMapping$0[sample.getStatus().ordinal()] == 1) {
                    yield PpgStatus.PERFORMING_CALIBRATION;
                }
                if (this.saturationDetector.isSaturated()) {
                    yield PpgStatus.LEAD_OFF;
                }
                yield PpgStatus.NORMAL;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        if (ppgStatus != this.lastStatusTEMP) {
            this.logger.d(() -> PpgCalibrationController.addSample$lambda$1(sample, this, ppgStatus));
            this.lastStatusTEMP = ppgStatus;
        }
        return ppgStatus;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Object startPpgCalibration(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof startPpgCalibration.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ PpgCalibrationController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startPpgCalibration((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                switch (WhenMappings.$EnumSwitchMapping$2[this.device.getPpgCalibrationControlMode().ordinal()]) {
                    case 1: {
                        return Unit.INSTANCE;
                    }
                    case 2: {
                        params = PpgParametersProvider.Companion.getDefaultCalibrationParametersV1();
                        this.logger.d((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, startPpgCalibration$lambda$2(vet.inpulse.libcomm.core.device.data.PpgCalibrationParameters$V1 ), ()Ljava/lang/String;)((PpgCalibrationParameters.V1)params));
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)params);
                        $continuation.label = 1;
                        v0 = this.device.calibratePpg-gIAlu-s((PpgCalibrationParameters)params, (Continuation)$continuation);
                        v1 = v0;
                        if (v0 != var9_4) return Unit.INSTANCE;
                        return var9_4;
                    }
                    case 1: {
                        params = (PpgCalibrationParameters.V1)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = ((Result)$result).unbox-impl();
                        return Unit.INSTANCE;
                    }
                    case 3: {
                        $continuation.label = 2;
                        v2 = this.getPpgDiagnosis-IoAF18A((Continuation<? super Result<PpgDiagnosis>>)$continuation);
                        if (v2 == var9_4) {
                            return var9_4;
                        }
                        ** GOTO lbl40
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = ((Result)$result).unbox-impl();
lbl40:
                // 2 sources

                v3 = (PpgDiagnosis)(Result.isFailure-impl((Object)(var3_7 = v2)) != false ? null : var3_7);
                if (v3 == null) return Unit.INSTANCE;
                diagnosis = v3;
                $i$a$-let-PpgCalibrationController$startPpgCalibration$3 = 0;
                if (diagnosis.getStatus() != PpgDiagnosisStatus.NORMAL) return Unit.INSTANCE;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)diagnosis);
                $continuation.I$0 = $i$a$-let-PpgCalibrationController$startPpgCalibration$3;
                $continuation.label = 3;
                v4 = this.onPpgParametersRequested.invoke((Object)$continuation);
                if (v4 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl57
            }
            case 3: {
                $i$a$-let-PpgCalibrationController$startPpgCalibration$3 = $continuation.I$0;
                diagnosis = (PpgDiagnosis)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl57:
                // 2 sources

                params = (PpgCalibrationParameters)v4;
                this.logger.d((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, startPpgCalibration$lambda$4$lambda$3(vet.inpulse.libcomm.core.device.data.PpgCalibrationParameters ), ()Ljava/lang/String;)((PpgCalibrationParameters)params));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)diagnosis);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)params);
                $continuation.I$0 = $i$a$-let-PpgCalibrationController$startPpgCalibration$3;
                $continuation.label = 4;
                v5 = this.device.calibratePpg-gIAlu-s(params, (Continuation)$continuation);
                v6 = v5;
                if (v5 != var9_4) return Unit.INSTANCE;
                return var9_4;
            }
            case 4: {
                $i$a$-let-PpgCalibrationController$startPpgCalibration$3 = $continuation.I$0;
                params = (PpgCalibrationParameters)$continuation.L$1;
                diagnosis = (PpgDiagnosis)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = ((Result)$result).unbox-impl();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getPpgDiagnosis-IoAF18A(Continuation<? super Result<PpgDiagnosis>> $completion) {
        if (!($completion instanceof getPpgDiagnosis.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ PpgCalibrationController this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    Object object = PpgCalibrationController.access$getPpgDiagnosis-IoAF18A(this.this$0, (Continuation)this);
                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        return object;
                    }
                    return Result.box-impl((Object)object);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.device.requestPpgDiagnosis-IoAF18A((Continuation)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = ((Result)$result).unbox-impl();
lbl20:
                // 2 sources

                result = var2_5 = v0;
                $i$a$-also-PpgCalibrationController$getPpgDiagnosis$2 = false;
                var5_8 = result;
                if (Result.isSuccess-impl((Object)var5_8)) {
                    it = (PpgDiagnosis)var5_8;
                    $i$a$-onSuccess-PpgCalibrationController$getPpgDiagnosis$2$1 = false;
                    this.ppgDiagnosisStream.setValue((Object)it.getStatus());
                }
                return var2_5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isCalibrationRequired(PpgData sample) {
        boolean bl;
        if (sample.getStatus() == PpgSampleStatus.CALIBRATING) {
            this.counterToRequestCalibration = 0;
            this.saturationDebounceCounter = 0;
            bl = false;
        } else if (this.counterToRequestCalibration > this.samplesRequiredAfterFinishCalibrationToDetectAgain) {
            boolean isSaturated = this.saturationDetector.isSaturated();
            if (!Intrinsics.areEqual((Object)this.wasSaturated, (Object)isSaturated)) {
                int n = this.saturationDebounceCounter;
                this.saturationDebounceCounter = n + 1;
                if (this.saturationDebounceCounter > this.saturationDebounceLimit) {
                    this.saturationDebounceCounter = 0;
                    this.wasSaturated = isSaturated;
                    bl = true;
                } else {
                    bl = false;
                }
            } else {
                this.saturationDebounceCounter = 0;
                bl = false;
            }
        } else {
            int n = this.counterToRequestCalibration;
            this.counterToRequestCalibration = n + 1;
            bl = false;
        }
        return bl;
    }

    private static final String addSample$lambda$0() {
        return "starting ppg calibration";
    }

    private static final String addSample$lambda$1(PpgData $sample, PpgCalibrationController this$0, PpgStatus $ppgStatus) {
        return "sampleStatus: " + $sample.getStatus() + "   diag: " + this$0.ppgDiagnosisStream.getValue() + "   status: " + $ppgStatus + "   saturated? " + this$0.saturationDetector.isSaturated() + "   redRaw: " + $sample.getRedRaw() + "   irRaw: " + $sample.getInfraredRaw();
    }

    private static final String startPpgCalibration$lambda$2(PpgCalibrationParameters.V1 $params) {
        return "starting PPG calibration: " + $params;
    }

    private static final String startPpgCalibration$lambda$4$lambda$3(PpgCalibrationParameters $params) {
        return "starting PPG calibration: " + $params;
    }

    public static final /* synthetic */ Object access$getPpgDiagnosis-IoAF18A(PpgCalibrationController $this, Continuation $completion) {
        return $this.getPpgDiagnosis-IoAF18A((Continuation<? super Result<PpgDiagnosis>>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgCalibrationController$Companion;", "", "<init>", "()V", "TAG", "", "AUTOMATIC_CALIBRATION_ENABLED", "", "getAUTOMATIC_CALIBRATION_ENABLED", "()Z", "setAUTOMATIC_CALIBRATION_ENABLED", "(Z)V", "core-acquisition"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getAUTOMATIC_CALIBRATION_ENABLED() {
            return AUTOMATIC_CALIBRATION_ENABLED;
        }

        public final void setAUTOMATIC_CALIBRATION_ENABLED(boolean bl) {
            AUTOMATIC_CALIBRATION_ENABLED = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[PpgSampleStatus.values().length];
            try {
                nArray[PpgSampleStatus.CALIBRATING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PpgDiagnosisStatus.values().length];
            try {
                nArray[PpgDiagnosisStatus.CABLE_DISCONNECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PpgDiagnosisStatus.MALFUNCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PpgDiagnosisStatus.NORMAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PpgCalibrationControlMode.values().length];
            try {
                nArray[PpgCalibrationControlMode.FULL_DEVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PpgCalibrationControlMode.MIXED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PpgCalibrationControlMode.FULL_CLIENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

