/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.acquisition.modules.implementations.ppg.calibration;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.core.acquisition.modules.implementations.ppg.calibration.PpgArtifactDetectorConfig;
import vet.inpulse.core.acquisition.modules.implementations.ppg.calibration.PpgCalibrationUtilsKt;
import vet.inpulse.libcomm.core.device.data.PpgData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgArtifactDetector;", "", "config", "Lvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgArtifactDetectorConfig;", "<init>", "(Lvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgArtifactDetectorConfig;)V", "deltasRed", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "deltasIR", "lastSample", "Lvet/inpulse/libcomm/core/device/data/PpgData;", "deltaProduct", "getDeltaProduct", "()F", "setDeltaProduct", "(F)V", "sumLastDeltas", "getSumLastDeltas", "setSumLastDeltas", "detectArtifact", "", "sample", "reset", "", "core-acquisition"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPpgCalibrationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PpgCalibrationUtils.kt\nvet/inpulse/core/acquisition/modules/implementations/ppg/calibration/PpgArtifactDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class PpgArtifactDetector {
    @NotNull
    private final PpgArtifactDetectorConfig config;
    @NotNull
    private final ArrayList<Float> deltasRed;
    @NotNull
    private final ArrayList<Float> deltasIR;
    @Nullable
    private PpgData lastSample;
    private float deltaProduct;
    private float sumLastDeltas;
    public static final int $stable = 8;

    public PpgArtifactDetector(@NotNull PpgArtifactDetectorConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.deltasRed = new ArrayList(this.config.getBufferSize() + 1);
        this.deltasIR = new ArrayList(this.config.getBufferSize() + 1);
    }

    public final float getDeltaProduct() {
        return this.deltaProduct;
    }

    public final void setDeltaProduct(float f) {
        this.deltaProduct = f;
    }

    public final float getSumLastDeltas() {
        return this.sumLastDeltas;
    }

    public final void setSumLastDeltas(float f) {
        this.sumLastDeltas = f;
    }

    public final boolean detectArtifact(@NotNull PpgData sample) {
        Float f;
        Float f2;
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        boolean artifactDetected = false;
        PpgData ppgData = this.lastSample;
        if (ppgData != null) {
            float it = ppgData.getInfrared();
            boolean bl = false;
            f2 = Float.valueOf(sample.getInfrared() - it);
        } else {
            f2 = null;
        }
        Float deltaIR = f2;
        PpgData ppgData2 = this.lastSample;
        if (ppgData2 != null) {
            float it = ppgData2.getRed();
            boolean bl = false;
            f = Float.valueOf(sample.getRed() - it);
        } else {
            f = null;
        }
        Float deltaRed = f;
        this.lastSample = sample;
        if (deltaIR == null || deltaRed == null) {
            return false;
        }
        this.deltasIR.add(deltaIR);
        this.deltasRed.add(deltaRed);
        if (this.deltasIR.size() >= this.config.getBufferSize()) {
            this.deltaProduct = Math.abs(PpgCalibrationUtilsKt.access$product(this.deltasIR));
            this.sumLastDeltas = Math.abs(((Number)CollectionsKt.last((List)this.deltasIR)).floatValue() + PpgCalibrationUtilsKt.access$beforeLast(this.deltasIR));
            if ((double)this.deltaProduct > this.config.getProductThreshold() && this.sumLastDeltas > this.config.getSumThreshold() || this.sumLastDeltas > this.config.getSumLimit()) {
                artifactDetected = true;
            }
            this.deltasIR.remove(0);
        }
        if (this.deltasRed.size() > this.config.getBufferSize()) {
            this.deltasRed.remove(0);
        }
        return artifactDetected;
    }

    public final void reset() {
        if (this.lastSample != null) {
            this.lastSample = null;
            this.deltasIR.clear();
            this.deltasRed.clear();
        }
    }
}

