/*
 * Decompiled with CFR 0.152.
 */
package io.github.vinceglb.filekit.mimeType;

import io.github.vinceglb.filekit.exceptions.InvalidMimeTypeException;
import io.github.vinceglb.filekit.mimeType.MimeTypeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/github/vinceglb/filekit/mimeType/MimeType;", "", "primaryType", "", "subtype", "parameters", "", "Lio/github/vinceglb/filekit/mimeType/MimeTypeParameter;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getPrimaryType", "()Ljava/lang/String;", "getSubtype", "getParameters", "()Ljava/util/Set;", "equals", "", "other", "hashCode", "", "toString", "Companion", "filekit-core"})
@SourceDebugExtension(value={"SMAP\nMimeType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MimeType.kt\nio/github/vinceglb/filekit/mimeType/MimeType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,102:1\n1208#2,2:103\n1236#2,4:105\n1208#2,2:109\n1236#2,4:111\n1222#2,2:118\n1252#2,4:120\n1869#2,2:124\n168#3,3:115\n*S KotlinDebug\n*F\n+ 1 MimeType.kt\nio/github/vinceglb/filekit/mimeType/MimeType\n*L\n30#1:103,2\n30#1:105,4\n31#1:109,2\n31#1:111,4\n45#1:118,2\n45#1:120,4\n58#1:124,2\n35#1:115,3\n*E\n"})
public final class MimeType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String primaryType;
    @NotNull
    private final String subtype;
    @NotNull
    private final Set<MimeTypeParameter> parameters;

    private MimeType(String primaryType, String subtype, Set<MimeTypeParameter> parameters) {
        this.primaryType = primaryType;
        this.subtype = subtype;
        this.parameters = parameters;
        if (StringsKt.isBlank((CharSequence)this.primaryType)) {
            throw new InvalidMimeTypeException("MIME type primary type must not be blank");
        }
        if (StringsKt.isBlank((CharSequence)this.subtype)) {
            throw new InvalidMimeTypeException("MIME type subtype must not be blank");
        }
    }

    /* synthetic */ MimeType(String string, String string2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        this(string, string2, set);
    }

    @NotNull
    public final String getPrimaryType() {
        return this.primaryType;
    }

    @NotNull
    public final String getSubtype() {
        return this.subtype;
    }

    @NotNull
    public final Set<MimeTypeParameter> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object other) {
        boolean bl;
        block11: {
            void $this$associateByTo$iv$iv;
            Map map;
            void $this$associateByTo$iv$iv2;
            if (this == other) {
                return true;
            }
            if (!(other instanceof MimeType)) {
                return false;
            }
            if (!StringsKt.equals((String)this.primaryType, (String)((MimeType)other).primaryType, (boolean)true)) {
                return false;
            }
            if (!StringsKt.equals((String)this.subtype, (String)((MimeType)other).subtype, (boolean)true)) {
                return false;
            }
            if (this.parameters.size() != ((MimeType)other).parameters.size()) {
                return false;
            }
            Iterable $this$associateBy$iv = this.parameters;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Object destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
                void it;
                MimeTypeParameter mimeTypeParameter = (MimeTypeParameter)element$iv$iv;
                map = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                map.put(string, element$iv$iv);
            }
            Map thisParams = destination$iv$iv;
            Iterable $this$associateBy$iv2 = ((MimeType)other).parameters;
            boolean $i$f$associateBy2 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv2;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                MimeTypeParameter bl2 = (MimeTypeParameter)element$iv$iv;
                map = destination$iv$iv2;
                boolean bl3 = false;
                String string = it.getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                map.put(string, element$iv$iv);
            }
            Map otherParams = destination$iv$iv2;
            if (!Intrinsics.areEqual(thisParams.keySet(), otherParams.keySet())) {
                return false;
            }
            Map $this$all$iv = thisParams;
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl4 = false;
                    String key = (String)entry.getKey();
                    MimeTypeParameter param = (MimeTypeParameter)entry.getValue();
                    MimeTypeParameter otherParam = (MimeTypeParameter)otherParams.get(key);
                    if (otherParam != null && Intrinsics.areEqual((Object)param.getValue(), (Object)otherParam.getValue())) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        String string = this.primaryType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        int typeHash = string.hashCode();
        String string2 = this.subtype.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        int subHash = string2.hashCode();
        Iterable iterable = this.parameters;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var7_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string3;
            MimeTypeParameter it;
            MimeTypeParameter mimeTypeParameter = (MimeTypeParameter)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            it = (MimeTypeParameter)element$iv$iv;
            boolean bl2 = false;
            String string4 = it.getValue();
            map.put(string3, string4);
        }
        int paramsHash = ((Object)destination$iv$iv).hashCode();
        return 31 * (31 * typeHash + subHash) + paramsHash;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        String base = this.primaryType + "/" + this.subtype;
        if (this.parameters.isEmpty()) {
            return base;
        }
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append(base);
        Iterable $this$forEach$iv = this.parameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MimeTypeParameter parameter = (MimeTypeParameter)element$iv;
            boolean bl2 = false;
            $this$toString_u24lambda_u240.append("; ");
            $this$toString_u24lambda_u240.append(parameter.getName());
            $this$toString_u24lambda_u240.append("=");
            $this$toString_u24lambda_u240.append(parameter.getValue());
        }
        return stringBuilder.toString();
    }

    public /* synthetic */ MimeType(String primaryType, String subtype, Set parameters, DefaultConstructorMarker $constructor_marker) {
        this(primaryType, subtype, parameters);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/github/vinceglb/filekit/mimeType/MimeType$Companion;", "", "<init>", "()V", "parse", "Lio/github/vinceglb/filekit/mimeType/MimeType;", "mimeType", "", "filekit-core"})
    @SourceDebugExtension(value={"SMAP\nMimeType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MimeType.kt\nio/github/vinceglb/filekit/mimeType/MimeType$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1563#2:103\n1634#2,3:104\n1563#2:107\n1634#2,3:108\n*S KotlinDebug\n*F\n+ 1 MimeType.kt\nio/github/vinceglb/filekit/mimeType/MimeType$Companion\n*L\n69#1:103\n69#1:104,3\n85#1:107\n85#1:108,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MimeType parse(@NotNull String mimeType) {
            Set set;
            Collection collection;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            String[] stringArray = new String[]{";"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)mimeType, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List parts = (List)destination$iv$iv;
            if (parts.isEmpty() || ((CharSequence)parts.get(0)).length() == 0) {
                throw new InvalidMimeTypeException("MIME type string must not be empty");
            }
            String[] $i$f$map22 = new String[]{"/"};
            List typeParts = StringsKt.split$default((CharSequence)((CharSequence)parts.get(0)), (String[])$i$f$map22, (boolean)false, (int)0, (int)6, null);
            if (typeParts.size() != 2) {
                throw new InvalidMimeTypeException("Invalid MIME type format: " + mimeType);
            }
            String string = ((String)typeParts.get(0)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String primaryType = string;
            String string2 = ((String)typeParts.get(1)).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String subtype = string2;
            if (parts.size() > 1) {
                void $this$mapTo$iv$iv2;
                Object item$iv$iv;
                Iterable $this$map$iv2 = CollectionsKt.drop((Iterable)parts, (int)1);
                boolean $i$f$map = false;
                item$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    String value;
                    String name;
                    void part;
                    String string3 = (String)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    String[] stringArray2 = new String[]{"="};
                    List nameValuePair = StringsKt.split$default((CharSequence)((CharSequence)part), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                    if (nameValuePair.size() != 2) {
                        throw new InvalidMimeTypeException("Invalid parameter in MIME type: " + (String)part);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)((String)nameValuePair.get(0)).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)((String)nameValuePair.get(0)).toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    collection.add(new MimeTypeParameter(name, value));
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            } else {
                set = SetsKt.emptySet();
            }
            Set parameters = set;
            return new MimeType(primaryType, subtype, parameters, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

