/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.models.utils.UtilityFrequency;
import vet.inpulse.math.DataKt;
import vet.inpulse.math.SignalUtilsKt;
import vet.inpulse.math.complex.ComplexArray;
import vet.inpulse.math.fft.FftKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u0001\u001a&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"calculateFftSize", "", "dataLength", "maxPower", "detectUtilityFrequency", "Lvet/inpulse/core/models/utils/UtilityFrequency;", "rawData", "", "offset", "fftSize", "samplingFrequency", "", "app"})
public final class SignalProcessingUtilsKt {
    public static final int calculateFftSize(int dataLength, int maxPower) {
        int fftSizePow = RangesKt.coerceAtMost((int)((int)Math.floor(MathKt.log2((double)dataLength))), (int)maxPower);
        return (int)Math.pow(2.0, fftSizePow);
    }

    public static /* synthetic */ int calculateFftSize$default(int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 11;
        }
        return SignalProcessingUtilsKt.calculateFftSize(n, n2);
    }

    @NotNull
    public static final UtilityFrequency detectUtilityFrequency(@NotNull float[] rawData, int offset, int fftSize, float samplingFrequency) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"rawData");
        double[] signal = DataKt.asData$default((float[])rawData, (int)offset, (int)0, (int)fftSize, (int)2, null).toDoubleArray();
        ComplexArray fft = FftKt.realFft$default((double[])signal, (int)fftSize, (int)0, (int)0, (int)12, null);
        double[] spectrum = FftKt.singleSidedSpectrum$default((ComplexArray)fft, (int)0, (int)0, (int)0, (int)14, null);
        int bucket50Hz = FftKt.fftPositiveFrequencyBucket((double)50.0, (double)samplingFrequency, (int)fftSize);
        int bucket60Hz = FftKt.fftPositiveFrequencyBucket((double)60.0, (double)samplingFrequency, (int)fftSize);
        double magnitude50Hz = SignalUtilsKt.mean((double[])spectrum, (int)(bucket50Hz - 1), (int)3);
        double magnitude60Hz = SignalUtilsKt.mean((double[])spectrum, (int)(bucket60Hz - 1), (int)3);
        return magnitude60Hz > magnitude50Hz ? UtilityFrequency._60Hz : UtilityFrequency._50Hz;
    }
}

