/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.analysis.ecg.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.app.acquisition.shared.services.impl.EcgReportPageExtensionsKt;
import vet.inpulse.app.analysis.ecg.utils.EcgAnalysisUtilsKt;
import vet.inpulse.app.analysis.ecg.viewModels.morphology.EcgMorphologyAnalysisManager;
import vet.inpulse.app.analysis.ecg.viewModels.morphology.EcgMorphologyAnalysisManagerImpl;
import vet.inpulse.app.shared.analysis.ecg.data.AnalysisWaveformsInfos;
import vet.inpulse.app.shared.analysis.ecg.data.EcgMorphologyComplexAxis;
import vet.inpulse.app.shared.analysis.ecg.data.EcgMorphologyMarkersIndexes;
import vet.inpulse.app.shared.analysis.ecg.data.EcgMorphologyParameters;
import vet.inpulse.app.shared.analysis.ecg.data.viewstate.EcgReportState;
import vet.inpulse.app.shared.analysis.qtc.QtcCalculatorAlgorithm;
import vet.inpulse.app.shared.krafiks.WaveformData;
import vet.inpulse.core.models.model.EcgComplex;
import vet.inpulse.core.models.model.EcgComplexAxisAnalysis;
import vet.inpulse.core.models.model.EcgComplexAxisMethod;
import vet.inpulse.core.models.model.EcgLead;
import vet.inpulse.core.models.model.EcgMorphologyAnalysis;
import vet.inpulse.core.models.model.EcgReportChartPage;
import vet.inpulse.core.models.model.HrvPoint;
import vet.inpulse.shared.utils.CoroutineUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u001a2\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\b\u0012\u0004\u0012\u00020\b0\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00022\u0006\u0010\f\u001a\u00020\r\u001a\u001e\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u0002*\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0002\u001a\u001e\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0002*\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0002\u001a:\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002*\u00020\u00012\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"toEcgMorphologyAnalysisList", "Lvet/inpulse/core/models/model/EcgMorphologyAnalysis;", "", "", "Lvet/inpulse/app/analysis/ecg/viewModels/morphology/EcgMorphologyAnalysisManager;", "toEcgReportChartPageList", "", "Lvet/inpulse/core/models/model/EcgReportChartPage;", "Lvet/inpulse/app/shared/analysis/ecg/data/viewstate/EcgReportState$PageAsImage;", "ecgChartData", "Lvet/inpulse/core/models/model/EcgLead;", "Lvet/inpulse/app/shared/krafiks/WaveformData$Static;", "waveformsInfos", "Lvet/inpulse/app/shared/analysis/ecg/data/AnalysisWaveformsInfos;", "toLeadsDataMap", "", "Lvet/inpulse/core/models/model/EcgComplex;", "toEcgMorphologyMarkersIndexesMap", "Lvet/inpulse/app/shared/analysis/ecg/data/EcgMorphologyMarkersIndexes;", "toEcgMorphologyAnalysisManagersMap", "rIndexes", "scope", "Lkotlinx/coroutines/CoroutineScope;", "app"})
@SourceDebugExtension(value={"SMAP\nEcgReportUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcgReportUtils.kt\nvet/inpulse/app/analysis/ecg/utils/EcgReportUtilsKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n126#2:144\n153#2,2:145\n126#2:147\n153#2,3:148\n155#2:151\n1056#3:152\n1617#3,9:153\n1869#3:162\n1870#3:164\n1626#3:165\n1193#3,2:166\n1267#3,4:168\n1193#3,2:172\n1267#3,4:174\n1193#3,2:178\n1267#3,2:180\n1563#3:182\n1634#3,3:183\n1573#3:186\n1604#3,4:187\n774#3:191\n865#3,2:192\n1563#3:194\n1634#3,3:195\n1270#3:198\n1#4:163\n*S KotlinDebug\n*F\n+ 1 EcgReportUtils.kt\nvet/inpulse/app/analysis/ecg/utils/EcgReportUtilsKt\n*L\n23#1:144\n23#1:145,2\n24#1:147\n24#1:148,3\n23#1:151\n53#1:152\n53#1:153,9\n53#1:162\n53#1:164\n53#1:165\n60#1:166,2\n60#1:168,4\n68#1:172,2\n68#1:174,4\n84#1:178,2\n84#1:180,2\n87#1:182\n87#1:183,3\n103#1:186\n103#1:187,4\n116#1:191\n116#1:192,2\n118#1:194\n118#1:195,3\n84#1:198\n53#1:163\n*E\n"})
public final class EcgReportUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final EcgMorphologyAnalysis toEcgMorphologyAnalysisList(@NotNull Map<Integer, ? extends EcgMorphologyAnalysisManager> $this$toEcgMorphologyAnalysisList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toEcgMorphologyAnalysisList, (String)"<this>");
        Map<Integer, ? extends EcgMorphologyAnalysisManager> $this$map$iv = $this$toEcgMorphologyAnalysisList;
        boolean $i$f$map = false;
        Map<Integer, ? extends EcgMorphologyAnalysisManager> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int analysisNumber = ((Number)entry.getKey()).intValue();
            EcgMorphologyAnalysisManager manager = (EcgMorphologyAnalysisManager)entry.getValue();
            Map $this$map$iv2 = (Map)manager.getMarkers().getValue();
            boolean $i$f$map2 = false;
            Map map3 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                EcgMorphologyMarkersIndexes markersIndexes;
                EcgLead lead;
                Collection collection2;
                block7: {
                    block6: {
                        Map.Entry item$iv$iv2;
                        Map.Entry entry2 = item$iv$iv2 = iterator2.next();
                        collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        lead = (EcgLead)entry2.getKey();
                        markersIndexes = (EcgMorphologyMarkersIndexes)entry2.getValue();
                        object = manager.getLeadsData().get(lead);
                        if (object == null) break block6;
                        List list = ArraysKt.toList((float[])object);
                        object = list;
                        if (list != null) break block7;
                    }
                    object = CollectionsKt.emptyList();
                }
                List list = markersIndexes.toEcgComplexMarkerList();
                Object object2 = (EcgMorphologyParameters)((Map)manager.getParameters().getValue()).get(lead);
                if (object2 == null || (object2 = object2.toEcgComplexParameterList()) == null) {
                    object2 = CollectionsKt.emptyList();
                }
                collection2.add(new EcgComplex.V1(lead, (List)object, list, (List)object2));
            }
            List ecgComplexes = (List)destination$iv$iv2;
            EcgMorphologyComplexAxis complexAxis = (EcgMorphologyComplexAxis)manager.getComplexAxis().getValue();
            collection.add(new EcgMorphologyAnalysis.Element.V1(analysisNumber, manager.getWaveformIndex(), manager.getRelativeIndexes(), manager.isAveraged(), ecgComplexes, (EcgComplexAxisAnalysis)new EcgComplexAxisAnalysis.V1((EcgComplexAxisMethod)manager.getMethod().getValue(), complexAxis.getPDegree(), complexAxis.getQrsDegree())));
        }
        List elements = (List)destination$iv$iv;
        return (EcgMorphologyAnalysis)new EcgMorphologyAnalysis.V1(elements);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<EcgReportChartPage> toEcgReportChartPageList(@NotNull List<EcgReportState.PageAsImage> $this$toEcgReportChartPageList, @NotNull Map<EcgLead, WaveformData.Static> ecgChartData, @NotNull AnalysisWaveformsInfos waveformsInfos) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toEcgReportChartPageList, (String)"<this>");
        Intrinsics.checkNotNullParameter(ecgChartData, (String)"ecgChartData");
        Intrinsics.checkNotNullParameter((Object)waveformsInfos, (String)"waveformsInfos");
        Iterable $this$sortedBy$iv = $this$toEcgReportChartPageList;
        boolean $i$f$sortedBy = false;
        Iterable $this$mapNotNull$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                EcgReportState.PageAsImage it = (EcgReportState.PageAsImage)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPageNumber());
                it = (EcgReportState.PageAsImage)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPageNumber()));
            }
        });
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EcgReportChartPage it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            EcgReportState.PageAsImage state2 = (EcgReportState.PageAsImage)element$iv$iv;
            boolean bl2 = false;
            if (EcgReportPageExtensionsKt.toModel(state2.getPage(), ecgChartData, waveformsInfos) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<EcgLead, float[]> toLeadsDataMap(List<? extends EcgComplex> $this$toLeadsDataMap) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = $this$toLeadsDataMap;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            EcgComplex ecgComplex = (EcgComplex)element$iv$iv;
            boolean bl = false;
            if (!(ecgComplex instanceof EcgComplex.V1)) {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair = TuplesKt.to((Object)((EcgComplex.V1)ecgComplex).getLead(), (Object)CollectionsKt.toFloatArray((Collection)((EcgComplex.V1)ecgComplex).getData()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<EcgLead, EcgMorphologyMarkersIndexes> toEcgMorphologyMarkersIndexesMap(List<? extends EcgComplex> $this$toEcgMorphologyMarkersIndexesMap) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = $this$toEcgMorphologyMarkersIndexesMap;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            EcgComplex ecgComplex = (EcgComplex)element$iv$iv;
            boolean bl = false;
            if (!(ecgComplex instanceof EcgComplex.V1)) {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair = TuplesKt.to((Object)((EcgComplex.V1)ecgComplex).getLead(), (Object)EcgMorphologyMarkersIndexes.Companion.fromEcgComplexMarkersList(((EcgComplex.V1)ecgComplex).getMarkers()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Integer, EcgMorphologyAnalysisManager> toEcgMorphologyAnalysisManagersMap(@NotNull EcgMorphologyAnalysis $this$toEcgMorphologyAnalysisManagersMap, @NotNull List<? extends List<Integer>> rIndexes, @NotNull AnalysisWaveformsInfos waveformsInfos, @NotNull CoroutineScope scope) {
        Map destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toEcgMorphologyAnalysisManagersMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(rIndexes, (String)"rIndexes");
        Intrinsics.checkNotNullParameter((Object)waveformsInfos, (String)"waveformsInfos");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        List samplingFrequencies = waveformsInfos.getSamplingFrequencies();
        if ($this$toEcgMorphologyAnalysisManagersMap instanceof EcgMorphologyAnalysis.V1) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((EcgMorphologyAnalysis.V1)$this$toEcgMorphologyAnalysisManagersMap).getList();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Collection destination$iv$iv2;
                float samplingFrequency;
                int waveformIndex;
                IntRange selectionRange;
                EcgComplexAxisMethod analysisMethod;
                Map<EcgLead, EcgMorphologyMarkersIndexes> markersMap;
                Map<EcgLead, float[]> leadsDataMap;
                Map map2 = destination$iv$iv;
                EcgMorphologyAnalysis.Element morphologyAnalysis = (EcgMorphologyAnalysis.Element)element$iv$iv;
                boolean bl = false;
                if (morphologyAnalysis instanceof EcgMorphologyAnalysis.Element.V1) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    void $this$mapIndexedTo$iv$iv;
                    EcgComplexAxisMethod ecgComplexAxisMethod;
                    Iterable it;
                    Collection collection;
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2 = ((EcgMorphologyAnalysis.Element.V1)morphologyAnalysis).getEcgComplexes();
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        EcgComplex ecgComplex = (EcgComplex)item$iv$iv;
                        collection = destination$iv$iv3;
                        boolean bl2 = false;
                        if (!(it instanceof EcgComplex.V1)) {
                            throw new NoWhenBranchMatchedException();
                        }
                        collection.add((EcgComplex.V1)it);
                    }
                    List ecgComplexes = (List)destination$iv$iv3;
                    leadsDataMap = EcgReportUtilsKt.toLeadsDataMap(ecgComplexes);
                    markersMap = EcgReportUtilsKt.toEcgMorphologyMarkersIndexesMap(ecgComplexes);
                    EcgComplexAxisAnalysis axisAnalysis = ((EcgMorphologyAnalysis.Element.V1)morphologyAnalysis).getAxisAnalysis();
                    if (axisAnalysis instanceof EcgComplexAxisAnalysis.V1) {
                        ecgComplexAxisMethod = ((EcgComplexAxisAnalysis.V1)axisAnalysis).getMethod();
                    } else if (axisAnalysis == null) {
                        ecgComplexAxisMethod = EcgComplexAxisMethod.SANTILLI;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    analysisMethod = ecgComplexAxisMethod;
                    selectionRange = ((EcgMorphologyAnalysis.Element.V1)morphologyAnalysis).getSelectionRange();
                    Iterable $this$mapIndexed$iv = rIndexes;
                    boolean $i$f$mapIndexed = false;
                    it = $this$mapIndexed$iv;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo22 = false;
                    int index$iv$iv = 0;
                    for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void waveformIndex2;
                        void list;
                        int n;
                        if ((n = index$iv$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        Iterator iterator = (List)item$iv$iv;
                        int n2 = n;
                        collection = destination$iv$iv4;
                        boolean bl3 = false;
                        collection.add(EcgAnalysisUtilsKt.calculateHrv((List<Integer>)list, ((Number)samplingFrequencies.get((int)waveformIndex2)).floatValue()));
                    }
                    List hrvData2 = (List)destination$iv$iv4;
                    waveformIndex = ((EcgMorphologyAnalysis.Element.V1)morphologyAnalysis).getWaveformIndex();
                    samplingFrequency = ((Number)samplingFrequencies.get(waveformIndex)).floatValue();
                    int heartRate = vet.inpulse.app.analysis.ecg.services.impl.EcgAnalysisUtilsKt.getIntervalHeartRate-1Y68eR8$default(hrvData2, selectionRange, 0L, samplingFrequency, waveformsInfos.getWaveformsSizes(), 2, null);
                    Iterable $i$f$mapIndexedTo22 = (Iterable)hrvData2.get(waveformIndex);
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        HrvPoint it2 = (HrvPoint)element$iv$iv2;
                        boolean bl4 = false;
                        if (!(it2.getRIndex() < selectionRange.getFirst())) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$map2 = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        HrvPoint it2 = (HrvPoint)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl5 = false;
                        collection.add(Float.valueOf(it2.getLastRRinMs()));
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                List previousRr = (List)destination$iv$iv2;
                int analysisNumber = ((EcgMorphologyAnalysis.Element.V1)morphologyAnalysis).getAnalysisNumber();
                boolean bl6 = ((EcgMorphologyAnalysis.Element.V1)morphologyAnalysis).getAveraged();
                QtcCalculatorAlgorithm qtcCalculatorAlgorithm = QtcCalculatorAlgorithm.Matsunaga;
                CoroutineScope coroutineScope = CoroutineUtilsKt.childSupervisorScope((CoroutineScope)scope, () -> EcgReportUtilsKt.toEcgMorphologyAnalysisManagersMap$lambda$0$4(analysisNumber));
                EcgMorphologyAnalysisManagerImpl manager = new EcgMorphologyAnalysisManagerImpl(analysisNumber, waveformIndex, selectionRange, leadsDataMap, bl6, samplingFrequency, coroutineScope, previousRr, qtcCalculatorAlgorithm, analysisMethod, markersMap, null, 2048, null);
                Pair pair = TuplesKt.to((Object)analysisNumber, (Object)manager);
                map2.put(pair.getFirst(), pair.getSecond());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return destination$iv$iv;
    }

    private static final CoroutineContext toEcgMorphologyAnalysisManagersMap$lambda$0$4(int $analysisNumber) {
        return (CoroutineContext)new CoroutineName("EcgMorphologyAnalysisManager " + $analysisNumber);
    }
}

