/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.app.acquisition.shared.services.impl;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vet.inpulse.app.AppDispatchers;
import vet.inpulse.app.acquisition.AppAcquisitionKoinModuleKt;
import vet.inpulse.app.acquisition.ecg.viewModels.device.EcgAcquisitionDeviceViewModel;
import vet.inpulse.app.acquisition.monitor.viewModels.device.MonitorAcquisitionDeviceViewModel;
import vet.inpulse.app.acquisition.nibp.viewModels.impl.NibpAcquisitionViewModelImpl;
import vet.inpulse.app.acquisition.shared.services.impl.AcquisitionServiceImpl$special$;
import vet.inpulse.app.acquisition.shared.services.impl.HandlerAndViewModel;
import vet.inpulse.app.acquisition.shared.services.impl.RecordAcquisitionHandlerImpl;
import vet.inpulse.app.acquisition.shared.viewModels.device.DeviceAcquisitionViewModel;
import vet.inpulse.app.shared.acquisition.data.RecordRef;
import vet.inpulse.app.shared.acquisition.services.AcquisitionService;
import vet.inpulse.app.shared.acquisition.services.RecordAcquisitionHandler;
import vet.inpulse.app.shared.acquisition.viewModels.AcquisitionViewModel;
import vet.inpulse.app.shared.nibp.viewModels.InMemoryNibpHistoryCache;
import vet.inpulse.app.shared.nibp.viewModels.NibpAllCharts;
import vet.inpulse.app.shared.nibp.viewModels.NibpAllChartsImpl;
import vet.inpulse.core.acquisition.AcquisitionController;
import vet.inpulse.core.models.model.KnownSpecies;
import vet.inpulse.core.models.model.Record;
import vet.inpulse.core.models.model.RecordType;
import vet.inpulse.libcomm.core.device.DeviceType;
import vet.inpulse.libcomm.core.locator.DeviceInfo;
import vet.inpulse.shared.log.LoggerInterface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\tH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\tH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u001fH\u0002R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lvet/inpulse/app/acquisition/shared/services/impl/AcquisitionServiceImpl;", "Lvet/inpulse/app/shared/acquisition/services/AcquisitionService;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "_currentAcquisitions", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lvet/inpulse/app/shared/acquisition/data/RecordRef;", "Lvet/inpulse/app/acquisition/shared/services/impl/HandlerAndViewModel;", "currentAcquisitions", "Lkotlinx/coroutines/flow/StateFlow;", "", "getCurrentAcquisitions", "()Lkotlinx/coroutines/flow/StateFlow;", "newAcquisitions", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "getNewAcquisitions", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "logger", "Lvet/inpulse/shared/log/LoggerInterface;", "startNewAcquisition", "", "record", "Lvet/inpulse/core/models/model/Record;", "species", "Lvet/inpulse/core/models/model/KnownSpecies;", "finishAcquisition", "ref", "getAcquisitionHandler", "Lvet/inpulse/app/shared/acquisition/services/RecordAcquisitionHandler;", "getAcquisitionViewModel", "Lvet/inpulse/app/shared/acquisition/viewModels/AcquisitionViewModel;", "getAcquisitionFromDeviceType", "deviceType", "Lvet/inpulse/libcomm/core/device/DeviceType;", "createViewModel", "acquisitionManager", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAcquisitionServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcquisitionServiceImpl.kt\nvet/inpulse/app/acquisition/shared/services/impl/AcquisitionServiceImpl\n+ 2 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 3 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 4 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n+ 5 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,148:1\n49#2:149\n51#2:153\n46#3:150\n51#3:152\n105#4:151\n230#5,5:154\n230#5,5:159\n536#6:164\n521#6,6:165\n*S KotlinDebug\n*F\n+ 1 AcquisitionServiceImpl.kt\nvet/inpulse/app/acquisition/shared/services/impl/AcquisitionServiceImpl\n*L\n38#1:149\n38#1:153\n38#1:150\n38#1:152\n38#1:151\n53#1:154,5\n68#1:159,5\n80#1:164\n80#1:165,6\n*E\n"})
public final class AcquisitionServiceImpl
implements AcquisitionService {
    @NotNull
    private final MutableStateFlow<Map<RecordRef, HandlerAndViewModel>> _currentAcquisitions;
    @NotNull
    private final StateFlow<Set<RecordRef>> currentAcquisitions;
    @NotNull
    private final MutableSharedFlow<RecordRef> newAcquisitions;
    @NotNull
    private final LoggerInterface logger;
    public static final int $stable = 8;

    public AcquisitionServiceImpl(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this._currentAcquisitions = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        Flow $this$map$iv = (Flow)this._currentAcquisitions;
        boolean $i$f$map = false;
        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        this.currentAcquisitions = FlowKt.stateIn((Flow)((Flow)new Flow<Set<? extends RecordRef>>($this$unsafeTransform$iv$iv){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    {
                        this.$this_unsafeFlow = $receiver;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof special$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ special$$inlined$map$1$2 this$0;
                                Object L$1;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = 0;
                                var10_14 = $this$map_u24lambda_u245;
                                var11_15 = (Continuation)$continuation;
                                it = (Map)value;
                                $i$a$-map-AcquisitionServiceImpl$currentAcquisitions$1 = false;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$map_u24lambda_u245);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$map$1;
                                $continuation.label = 1;
                                v0 = var10_14.emit(it.keySet(), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl38
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = $continuation.I$0;
                                $this$map_u24lambda_u245 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl38:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }), (CoroutineScope)scope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)SetsKt.emptySet());
        this.newAcquisitions = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.logger = AppAcquisitionKoinModuleKt.getAppAcquisitionLogModule().getLogger("AcquisitionService");
    }

    public /* synthetic */ AcquisitionServiceImpl(CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        }
        this(coroutineScope);
    }

    @NotNull
    public StateFlow<Set<RecordRef>> getCurrentAcquisitions() {
        return this.currentAcquisitions;
    }

    @NotNull
    public MutableSharedFlow<RecordRef> getNewAcquisitions() {
        return this.newAcquisitions;
    }

    public void startNewAcquisition(@NotNull Record record, @NotNull KnownSpecies species) {
        Map previous;
        Map nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)species, (String)"species");
        RecordRef ref = new RecordRef(record.recordType(), record.getId());
        if (((Map)this._currentAcquisitions.getValue()).containsKey(ref)) {
            return;
        }
        RecordAcquisitionHandlerImpl handler2 = new RecordAcquisitionHandlerImpl(record, species);
        AcquisitionViewModel viewModel2 = this.createViewModel(ref, handler2);
        HandlerAndViewModel value = new HandlerAndViewModel(handler2, viewModel2);
        MutableStateFlow<Map<RecordRef, HandlerAndViewModel>> $this$update$iv = this._currentAcquisitions;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            previous = (Map)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MapsKt.plus((Map)previous, (Pair)TuplesKt.to((Object)ref, (Object)value)))));
        this.getNewAcquisitions().tryEmit((Object)ref);
    }

    public void finishAcquisition(@NotNull RecordRef ref) {
        Map previous;
        Map nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.logger.d(() -> AcquisitionServiceImpl.finishAcquisition$lambda$0(ref));
        this.getNewAcquisitions().resetReplayCache();
        HandlerAndViewModel handlerAndViewModel = (HandlerAndViewModel)((Map)this._currentAcquisitions.getValue()).get(ref);
        if (handlerAndViewModel == null) {
            return;
        }
        HandlerAndViewModel handlerAndViewModel2 = handlerAndViewModel;
        RecordAcquisitionHandler handler2 = handlerAndViewModel2.component1();
        AcquisitionViewModel vm = handlerAndViewModel2.component2();
        CoroutineScopeKt.cancel$default((CoroutineScope)vm.getScope(), null, (int)1, null);
        handler2.finishRecord();
        MutableStateFlow<Map<RecordRef, HandlerAndViewModel>> $this$update$iv = this._currentAcquisitions;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            previous = (Map)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = MapsKt.minus((Map)previous, (Object)ref))));
    }

    @Nullable
    public RecordAcquisitionHandler getAcquisitionHandler(@NotNull RecordRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        HandlerAndViewModel handlerAndViewModel = (HandlerAndViewModel)((Map)this._currentAcquisitions.getValue()).get(ref);
        return handlerAndViewModel != null ? handlerAndViewModel.getAcquisitionHandler() : null;
    }

    @NotNull
    public AcquisitionViewModel getAcquisitionViewModel(@NotNull RecordRef ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        HandlerAndViewModel handlerAndViewModel = (HandlerAndViewModel)((Map)this._currentAcquisitions.getValue()).get(ref);
        if (handlerAndViewModel == null || (handlerAndViewModel = handlerAndViewModel.getViewModel()) == null) {
            throw new IllegalStateException(("No acquisition ViewModel found for record: " + ref.getRecordId() + " of type: " + ref.getType()).toString());
        }
        return handlerAndViewModel;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public RecordRef getAcquisitionFromDeviceType(@NotNull DeviceType deviceType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Map $this$filter$iv = (Map)this._currentAcquisitions.getValue();
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            DeviceInfo deviceInfo;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            HandlerAndViewModel handlerViewModel = (HandlerAndViewModel)entry.getValue();
            AcquisitionController acquisitionController = (AcquisitionController)handlerViewModel.getAcquisitionHandler().getAcquisitionController().getValue();
            DeviceInfo deviceInfo2 = deviceInfo = acquisitionController != null ? acquisitionController.getDeviceInfo() : null;
            if (!((deviceInfo2 != null ? deviceInfo2.getDeviceType() : null) == deviceType)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return (RecordRef)CollectionsKt.firstOrNull((Iterable)destination$iv$iv.keySet());
    }

    private final AcquisitionViewModel createViewModel(RecordRef ref, RecordAcquisitionHandler acquisitionManager) {
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)AppDispatchers.INSTANCE.getComputation()));
        DeviceAcquisitionViewModel acquisitionVM = new DeviceAcquisitionViewModel(scope, acquisitionManager);
        return switch (WhenMappings.$EnumSwitchMapping$0[ref.getType().ordinal()]) {
            case 1 -> new EcgAcquisitionDeviceViewModel(acquisitionVM, 0, false, 6, null);
            case 2 -> {
                EcgAcquisitionDeviceViewModel ecgVM = new EcgAcquisitionDeviceViewModel(acquisitionVM, 0, false, 2, null);
                int nibpMaxHistorySize = 10;
                NibpAllChartsImpl nibpAllChartsVM = new NibpAllChartsImpl(scope, ref.getRecordId(), new InMemoryNibpHistoryCache(nibpMaxHistorySize), DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS), nibpMaxHistorySize, null);
                long var9_10 = DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.SECONDS);
                NibpAcquisitionViewModelImpl nibpVM = new NibpAcquisitionViewModelImpl(acquisitionVM, (NibpAllCharts)nibpAllChartsVM, var9_10, null);
                yield new MonitorAcquisitionDeviceViewModel(acquisitionVM, ecgVM, nibpVM, 0, 0, 24, null);
            }
            case 3 -> {
                long var5_6 = DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.SECONDS);
                NibpAllChartsImpl var7_9 = new NibpAllChartsImpl(scope, ref.getRecordId(), new InMemoryNibpHistoryCache(Integer.MAX_VALUE), 0L, 0, 24, null);
                yield new NibpAcquisitionViewModelImpl(acquisitionVM, (NibpAllCharts)var7_9, var5_6, null);
            }
            case 4 -> throw new IllegalStateException(("Unknown record type: " + ref.getType()).toString());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String finishAcquisition$lambda$0(RecordRef $ref) {
        return "Finishing acquisition for record: " + $ref.getRecordId() + " of type: " + $ref.getType();
    }

    public AcquisitionServiceImpl() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RecordType.values().length];
            try {
                nArray[RecordType.ECG_RECORD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.ANESTHETIC_RECORD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.NIBP_RECORD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecordType.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

