/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.client.database.application.converters;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.uuid.Uuid;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.client.database.DatabaseLogModuleKt;
import vet.inpulse.core.client.database.DrugInfusionEntity;
import vet.inpulse.core.client.database.MonitorEventEntity;
import vet.inpulse.core.client.database.NibpResultEntity;
import vet.inpulse.core.models.model.DrugDosageUnit;
import vet.inpulse.core.models.model.DrugInfusionElement;
import vet.inpulse.core.models.model.InfusionTimeUnit;
import vet.inpulse.core.models.model.MonitorEventElement;
import vet.inpulse.core.models.model.MonitorEventType;
import vet.inpulse.core.models.model.NibpResultElement;
import vet.inpulse.core.models.record_data.BloodPressure;
import vet.inpulse.core.models.record_data.BloodPressureIndex;
import vet.inpulse.core.models.record_data.BloodPressureIndexes;
import vet.inpulse.core.models.record_data.BloodPressures;
import vet.inpulse.core.models.record_data.NibpCuffSize;
import vet.inpulse.core.models.record_data.PulsePerMinute;
import vet.inpulse.shared.log.LoggerInterface;
import vet.inpulse.shared.models.NibpProcedureRequest;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\bj\u0002`\t\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\u0005\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u000f\u001a*\u0010\u0004\u001a\u00020\u000f*\u00020\u000e2\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\bj\u0002`\t\u001a\n\u0010\r\u001a\u00020\u0010*\u00020\u0011\u001a*\u0010\u0004\u001a\u00020\u0011*\u00020\u00102\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\bj\u0002`\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"logger", "Lvet/inpulse/shared/log/LoggerInterface;", "deviceInfoJson", "Lkotlinx/serialization/json/Json;", "toDbEntity", "Lvet/inpulse/core/client/database/NibpResultEntity;", "Lvet/inpulse/core/models/model/NibpResultElement;", "recordId", "Lkotlin/uuid/Uuid;", "Lvet/inpulse/shared/models/UUID;", "lastModified", "", "orgId", "toModel", "Lvet/inpulse/core/models/model/MonitorEventElement;", "Lvet/inpulse/core/client/database/MonitorEventEntity;", "Lvet/inpulse/core/models/model/DrugInfusionElement;", "Lvet/inpulse/core/client/database/DrugInfusionEntity;", "core-client-database"})
@SourceDebugExtension(value={"SMAP\nRecordDataConverters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordDataConverters.kt\nvet/inpulse/core/client/database/application/converters/RecordDataConvertersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class RecordDataConvertersKt {
    @NotNull
    private static final LoggerInterface logger = DatabaseLogModuleKt.getDatabaseLogModule().getLogger("RecordDataConverters");
    @NotNull
    private static final Json deviceInfoJson = JsonKt.Json$default(null, RecordDataConvertersKt::deviceInfoJson$lambda$0, (int)1, null);

    @NotNull
    public static final NibpResultEntity toDbEntity(@NotNull NibpResultElement $this$toDbEntity, @NotNull Uuid recordId, long lastModified, @NotNull Uuid orgId) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)recordId, (String)"recordId");
        Intrinsics.checkNotNullParameter((Object)orgId, (String)"orgId");
        Uuid uuid = $this$toDbEntity.getId();
        if (uuid == null) {
            uuid = Uuid.Companion.random();
        }
        Uuid uuid2 = uuid;
        int n = $this$toDbEntity.getBloodPressureValues().getDiastolic-S1WnChQ();
        int n2 = $this$toDbEntity.getBloodPressureValues().getMean-c9_QRUg();
        int n3 = $this$toDbEntity.getBloodPressureValues().getSystolic-2AKUNdQ();
        long l = $this$toDbEntity.getTimestamp();
        int n4 = $this$toDbEntity.getCalculatedBloodPressureIndexes().getDiastolic-YiW0ZXM();
        int n5 = $this$toDbEntity.getCalculatedBloodPressureIndexes().getMean-8HJK8HE();
        int n6 = $this$toDbEntity.getCalculatedBloodPressureIndexes().getSystolic-gl8i1mk();
        int n7 = $this$toDbEntity.getLeftTrimIndex();
        int n8 = $this$toDbEntity.getRightTrimIndex();
        int n9 = $this$toDbEntity.getBloodPressureIndexes().getDiastolic-YiW0ZXM();
        int n10 = $this$toDbEntity.getBloodPressureIndexes().getMean-8HJK8HE();
        int n11 = $this$toDbEntity.getBloodPressureIndexes().getSystolic-gl8i1mk();
        boolean bl = $this$toDbEntity.getDeleted();
        PulsePerMinute pulsePerMinute = $this$toDbEntity.getPulsePerMinute-8kGXVMQ();
        Integer n12 = pulsePerMinute != null ? Integer.valueOf(pulsePerMinute.unbox-impl()) : null;
        NibpCuffSize nibpCuffSize = $this$toDbEntity.getCuffSize();
        String string = nibpCuffSize != null ? nibpCuffSize.name() : null;
        NibpProcedureRequest nibpProcedureRequest = $this$toDbEntity.getRequest();
        String string2 = nibpProcedureRequest != null ? nibpProcedureRequest.serialize() : null;
        String string3 = $this$toDbEntity.getVersion();
        return new NibpResultEntity(uuid2, recordId, orgId, n3, n2, n, l, n11, n10, n9, n7, n8, n6, n5, n4, n12, lastModified, bl, 0L, null, string, string2, string3);
    }

    @NotNull
    public static final NibpResultElement toModel(@NotNull NibpResultEntity $this$toModel) {
        PulsePerMinute pulsePerMinute;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Uuid uuid = $this$toModel.getId();
        long l = $this$toModel.getTimestamp();
        BloodPressures bloodPressures = new BloodPressures(BloodPressure.Systolic.constructor-impl((int)$this$toModel.getSystolicValue()), BloodPressure.Mean.constructor-impl((int)$this$toModel.getMeanValue()), BloodPressure.Diastolic.constructor-impl((int)$this$toModel.getDiastolicValue()), null);
        BloodPressureIndexes bloodPressureIndexes = new BloodPressureIndexes(BloodPressureIndex.Systolic.constructor-impl((int)$this$toModel.getCalculatedSystolicIndex()), BloodPressureIndex.Mean.constructor-impl((int)$this$toModel.getCalculatedMeanIndex()), BloodPressureIndex.Diastolic.constructor-impl((int)$this$toModel.getCalculatedDiastolicIndex()), null);
        int n = $this$toModel.getLeftTrimIndex();
        int n2 = $this$toModel.getRightTrimIndex();
        BloodPressureIndexes bloodPressureIndexes2 = new BloodPressureIndexes(BloodPressureIndex.Systolic.constructor-impl((int)$this$toModel.getSystolicIndex()), BloodPressureIndex.Mean.constructor-impl((int)$this$toModel.getMeanIndex()), BloodPressureIndex.Diastolic.constructor-impl((int)$this$toModel.getDiastolicIndex()), null);
        boolean bl = $this$toModel.getDeleted();
        Integer n3 = $this$toModel.getPulsePerMinute();
        if (n3 != null) {
            int it = ((Number)n3).intValue();
            boolean bl2 = false;
            pulsePerMinute = PulsePerMinute.box-impl((int)PulsePerMinute.constructor-impl((int)it));
        } else {
            pulsePerMinute = null;
        }
        PulsePerMinute pulsePerMinute2 = pulsePerMinute;
        NibpCuffSize nibpCuffSize = NibpCuffSize.Companion.parse($this$toModel.getCuffSize());
        NibpProcedureRequest nibpProcedureRequest = NibpProcedureRequest.Companion.fromJson($this$toModel.getRequest());
        String string = $this$toModel.getAlgorithmVersion();
        return new NibpResultElement(uuid, l, bloodPressures, n, bloodPressureIndexes, bloodPressureIndexes2, n2, bl, pulsePerMinute2, nibpCuffSize, nibpProcedureRequest, string, null);
    }

    @NotNull
    public static final MonitorEventElement toModel(@NotNull MonitorEventEntity $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        long l = $this$toModel.getTimestamp();
        Uuid uuid = $this$toModel.getId();
        String string = $this$toModel.getEventDescription();
        MonitorEventType monitorEventType = MonitorEventType.Companion.parse($this$toModel.getEventType());
        return new MonitorEventElement(l, string, monitorEventType, uuid);
    }

    @NotNull
    public static final MonitorEventEntity toDbEntity(@NotNull MonitorEventElement $this$toDbEntity, @NotNull Uuid recordId, long lastModified, @NotNull Uuid orgId) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)recordId, (String)"recordId");
        Intrinsics.checkNotNullParameter((Object)orgId, (String)"orgId");
        Uuid uuid = $this$toDbEntity.getId();
        if (uuid == null) {
            uuid = Uuid.Companion.random();
        }
        Uuid uuid2 = uuid;
        String string = $this$toDbEntity.getEventDescription();
        int n = $this$toDbEntity.getEventType().getDbValue();
        long l = $this$toDbEntity.getTimestamp();
        return new MonitorEventEntity(uuid2, recordId, orgId, string, l, n, false, lastModified, 0L, null);
    }

    @NotNull
    public static final DrugInfusionElement toModel(@NotNull DrugInfusionEntity $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        long l = $this$toModel.getInitialTime();
        Uuid uuid = $this$toModel.getId();
        boolean bl = $this$toModel.getContinuous();
        float f = $this$toModel.getAmount();
        int n = $this$toModel.getDrugId();
        Long l2 = $this$toModel.getFinalTime();
        InfusionTimeUnit infusionTimeUnit = InfusionTimeUnit.Companion.parse($this$toModel.getTimeUnit());
        DrugDosageUnit drugDosageUnit = DrugDosageUnit.Companion.parse($this$toModel.getDosageUnit());
        return new DrugInfusionElement(n, f, l, bl, l2, infusionTimeUnit, uuid, drugDosageUnit);
    }

    @NotNull
    public static final DrugInfusionEntity toDbEntity(@NotNull DrugInfusionElement $this$toDbEntity, @NotNull Uuid recordId, long lastModified, @NotNull Uuid orgId) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)recordId, (String)"recordId");
        Intrinsics.checkNotNullParameter((Object)orgId, (String)"orgId");
        Uuid uuid = $this$toDbEntity.getId();
        if (uuid == null) {
            uuid = Uuid.Companion.random();
        }
        Uuid uuid2 = uuid;
        float f = $this$toDbEntity.getAmount();
        boolean bl = $this$toDbEntity.getContinuous();
        int n = $this$toDbEntity.getDrugId();
        Long l = $this$toDbEntity.getFinalTime();
        long l2 = $this$toDbEntity.getTimestamp();
        int n2 = $this$toDbEntity.getTimeUnit().getDbValue();
        String string = $this$toDbEntity.getDosageUnit().toString();
        return new DrugInfusionEntity(uuid2, recordId, orgId, f, bl, n, l, l2, n2, string, false, lastModified, 0L, null);
    }

    private static final Unit deviceInfoJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }
}

