/*
 * Decompiled with CFR 0.152.
 */
package vet.inpulse.core.client.database.application.converters;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.uuid.Uuid;
import org.jetbrains.annotations.NotNull;
import vet.inpulse.core.client.database.BreedEntity;
import vet.inpulse.core.client.database.DrugClassificationEntity;
import vet.inpulse.core.client.database.DrugCombinationEntity;
import vet.inpulse.core.client.database.DrugEntity;
import vet.inpulse.core.client.database.PatientEntityItem;
import vet.inpulse.core.client.database.RecordEntityItem;
import vet.inpulse.core.client.database.SpeciesEntity;
import vet.inpulse.core.models.model.Breed;
import vet.inpulse.core.models.model.Drug;
import vet.inpulse.core.models.model.DrugCombination;
import vet.inpulse.core.models.model.DrugDosageUnit;
import vet.inpulse.core.models.model.NibpResultElement;
import vet.inpulse.core.models.model.PatientBreed;
import vet.inpulse.core.models.model.PatientItem;
import vet.inpulse.core.models.model.PatientSpecies;
import vet.inpulse.core.models.model.RecordItem;
import vet.inpulse.core.models.model.RecordType;
import vet.inpulse.core.models.model.Species;
import vet.inpulse.core.models.record_data.BloodPressureIndexes;
import vet.inpulse.core.models.record_data.NibpCalculatorOutput;
import vet.inpulse.core.models.record_data.NibpCuffSize;
import vet.inpulse.core.models.record_data.NibpOscillometryData;
import vet.inpulse.core.models.record_data.PulsePerMinute;
import vet.inpulse.core.models.repository.StringsRepository;
import vet.inpulse.shared.models.NibpProcedureRequest;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0002*\u00020\u0001H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0005*\u00020\u0004H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0007*\u00020\u0006H\u0000\u001a\f\u0010\u0000\u001a\u00020\b*\u00020\tH\u0000\u001a\f\u0010\u0003\u001a\u00020\t*\u00020\bH\u0000\u001a\f\u0010\u0000\u001a\u00020\n*\u00020\u000bH\u0000\u001a\f\u0010\u0003\u001a\u00020\u000b*\u00020\nH\u0000\u001a\u0014\u0010\u0000\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0014\u001a\u0012\u0010\u0015\u001a\u00020\u0014*\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"toModel", "Lvet/inpulse/core/models/model/Species;", "Lvet/inpulse/core/client/database/SpeciesEntity;", "toDbEntity", "Lvet/inpulse/core/models/model/Breed;", "Lvet/inpulse/core/client/database/BreedEntity;", "Lvet/inpulse/core/models/model/Drug;", "Lvet/inpulse/core/client/database/DrugEntity;", "Lvet/inpulse/core/models/model/Drug$Classification;", "Lvet/inpulse/core/client/database/DrugClassificationEntity;", "Lvet/inpulse/core/models/model/DrugCombination;", "Lvet/inpulse/core/client/database/DrugCombinationEntity;", "Lvet/inpulse/core/models/model/PatientItem;", "Lvet/inpulse/core/client/database/PatientEntityItem;", "r", "Lvet/inpulse/core/models/repository/StringsRepository;", "Lvet/inpulse/core/models/model/RecordItem;", "Lvet/inpulse/core/client/database/RecordEntityItem;", "resultsOnly", "Lvet/inpulse/core/models/model/NibpResultElement;", "Lvet/inpulse/core/models/record_data/NibpCalculatorOutput$Success;", "withData", "oscillometryData", "Lvet/inpulse/core/models/record_data/NibpOscillometryData;", "core-client-database"})
public final class OtherConvertersKt {
    @NotNull
    public static final Species toModel(@NotNull SpeciesEntity $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        return new Species($this$toModel.getId(), $this$toModel.getPt(), $this$toModel.getEn(), $this$toModel.getEs(), $this$toModel.getActive());
    }

    @NotNull
    public static final SpeciesEntity toDbEntity(@NotNull Species $this$toDbEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        return new SpeciesEntity($this$toDbEntity.getId(), $this$toDbEntity.getPt(), $this$toDbEntity.getEn(), $this$toDbEntity.getEs(), $this$toDbEntity.getActive());
    }

    @NotNull
    public static final Breed toModel(@NotNull BreedEntity $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        return new Breed($this$toModel.getId(), $this$toModel.getSpeciesId(), $this$toModel.getPt(), $this$toModel.getEn(), $this$toModel.getEs(), $this$toModel.getRawVariants(), $this$toModel.getActive());
    }

    @NotNull
    public static final BreedEntity toDbEntity(@NotNull Breed $this$toDbEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        return new BreedEntity($this$toDbEntity.getId(), $this$toDbEntity.getSpeciesId(), $this$toDbEntity.getPt(), $this$toDbEntity.getEn(), $this$toDbEntity.getEs(), $this$toDbEntity.getRawVariants(), $this$toDbEntity.getActive());
    }

    @NotNull
    public static final Drug toModel(@NotNull DrugEntity $this$toModel) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        int n = $this$toModel.getId();
        String string6 = $this$toModel.getPt();
        if (string6 == null) {
            string6 = "";
        }
        if ((string5 = $this$toModel.getVariantsPt()) == null) {
            string5 = "";
        }
        if ((string4 = $this$toModel.getEn()) == null) {
            string4 = "";
        }
        if ((string3 = $this$toModel.getVariantsEn()) == null) {
            string3 = "";
        }
        if ((string2 = $this$toModel.getEs()) == null) {
            string2 = "";
        }
        if ((string = $this$toModel.getVariantsEs()) == null) {
            string = "";
        }
        return new Drug(n, string6, string5, string4, string3, string2, string, $this$toModel.getActive(), $this$toModel.getClassification(), DrugDosageUnit.Companion.parse($this$toModel.getSuggestedDosageUnit()));
    }

    @NotNull
    public static final DrugEntity toDbEntity(@NotNull Drug $this$toDbEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        return new DrugEntity($this$toDbEntity.getId(), $this$toDbEntity.getNamePT(), $this$toDbEntity.getVariantsPT(), $this$toDbEntity.getNameEN(), $this$toDbEntity.getVariantsEN(), $this$toDbEntity.getNameES(), $this$toDbEntity.getVariantsES(), $this$toDbEntity.isActive(), $this$toDbEntity.getClassificationIds(), $this$toDbEntity.getSuggestedDosageUnit().toString());
    }

    @NotNull
    public static final Drug.Classification toModel(@NotNull DrugClassificationEntity $this$toModel) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        int n = $this$toModel.getId();
        String string3 = $this$toModel.getPt();
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = $this$toModel.getEn()) == null) {
            string2 = "";
        }
        if ((string = $this$toModel.getEn()) == null) {
            string = "";
        }
        return new Drug.Classification(n, string3, string2, string);
    }

    @NotNull
    public static final DrugClassificationEntity toDbEntity(@NotNull Drug.Classification $this$toDbEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        return new DrugClassificationEntity($this$toDbEntity.getId(), $this$toDbEntity.getPt(), $this$toDbEntity.getEn(), $this$toDbEntity.getEs());
    }

    @NotNull
    public static final DrugCombination toModel(@NotNull DrugCombinationEntity $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        return new DrugCombination($this$toModel.getId(), $this$toModel.getDrugIds(), $this$toModel.getName());
    }

    @NotNull
    public static final DrugCombinationEntity toDbEntity(@NotNull DrugCombination $this$toDbEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$toDbEntity, (String)"<this>");
        return new DrugCombinationEntity($this$toDbEntity.getId(), $this$toDbEntity.getDrugIds(), $this$toDbEntity.getName());
    }

    @NotNull
    public static final PatientItem toModel(@NotNull PatientEntityItem $this$toModel, @NotNull StringsRepository r) {
        PatientBreed patientBreed;
        PatientSpecies patientSpecies;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        CharSequence charSequence = $this$toModel.getCustomSpecies();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            PatientSpecies.FromDb fromDb;
            Integer n = $this$toModel.getSpeciesId();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                fromDb = new PatientSpecies.FromDb(it, r.selectLanguage($this$toModel.getSpeciesPt(), $this$toModel.getSpeciesEn(), $this$toModel.getSpeciesEs()));
            } else {
                fromDb = null;
            }
            patientSpecies = (PatientSpecies)fromDb;
        } else {
            patientSpecies = (PatientSpecies)new PatientSpecies.Custom($this$toModel.getCustomSpecies());
        }
        PatientSpecies species = patientSpecies;
        CharSequence charSequence2 = $this$toModel.getCustomBreed();
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            PatientBreed.FromDb fromDb;
            Integer n = $this$toModel.getBreedId();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                fromDb = new PatientBreed.FromDb(it, r.selectLanguage($this$toModel.getBreedPt(), $this$toModel.getBreedEn(), $this$toModel.getBreedEs()));
            } else {
                fromDb = null;
            }
            patientBreed = (PatientBreed)fromDb;
        } else {
            patientBreed = (PatientBreed)new PatientBreed.Custom($this$toModel.getCustomBreed());
        }
        PatientBreed breed = patientBreed;
        charSequence2 = $this$toModel.getPatientId();
        String string = $this$toModel.getPatientName();
        Uuid uuid = $this$toModel.getOwnerId();
        String string2 = $this$toModel.getOwnerName();
        if (string2 == null) {
            string2 = $this$toModel.getOwnerNameFromPatient();
        }
        String string3 = string2;
        String string4 = $this$toModel.getPatientSyncError();
        long l = $this$toModel.getPatientLastModified();
        return new PatientItem((Uuid)charSequence2, string, uuid, string3, species, breed, string4, Long.valueOf(l));
    }

    @NotNull
    public static final RecordItem toModel(@NotNull RecordEntityItem $this$toModel, @NotNull StringsRepository r) {
        PatientBreed patientBreed;
        PatientSpecies patientSpecies;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        CharSequence charSequence = $this$toModel.getCustomSpecies();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            PatientSpecies.FromDb fromDb;
            Integer n = $this$toModel.getSpeciesId();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                fromDb = new PatientSpecies.FromDb($this$toModel.getSpeciesId().intValue(), r.selectLanguage($this$toModel.getSpeciesPt(), $this$toModel.getSpeciesEn(), $this$toModel.getSpeciesEs()));
            } else {
                fromDb = null;
            }
            patientSpecies = (PatientSpecies)fromDb;
        } else {
            patientSpecies = (PatientSpecies)new PatientSpecies.Custom($this$toModel.getCustomSpecies());
        }
        PatientSpecies species = patientSpecies;
        CharSequence charSequence2 = $this$toModel.getCustomBreed();
        if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
            PatientBreed.FromDb fromDb;
            Integer n = $this$toModel.getBreedId();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                fromDb = new PatientBreed.FromDb(it, r.selectLanguage($this$toModel.getBreedPt(), $this$toModel.getBreedEn(), $this$toModel.getBreedEs()));
            } else {
                fromDb = null;
            }
            patientBreed = (PatientBreed)fromDb;
        } else {
            patientBreed = (PatientBreed)new PatientBreed.Custom($this$toModel.getCustomBreed());
        }
        PatientBreed breed = patientBreed;
        charSequence2 = $this$toModel.getId();
        RecordType recordType = $this$toModel.getRecordType();
        String string = $this$toModel.getRefCode();
        Uuid uuid = $this$toModel.getPatientId();
        String string2 = $this$toModel.getPatientName();
        String string3 = $this$toModel.getOwnerName();
        if (string3 == null) {
            string3 = $this$toModel.getOwnerNameFromPatient();
        }
        String string4 = string3;
        long l = $this$toModel.getRecordStart();
        String string5 = StringsRepository.getDate$default((StringsRepository)r, (Long)$this$toModel.getRecordStart(), null, null, (int)6, null);
        Long l2 = $this$toModel.getRecordEnd();
        Uuid uuid2 = $this$toModel.getEstablishmentId();
        String string6 = $this$toModel.getEstablishmentName();
        int n = (int)($this$toModel.getNumTelemedReports() + $this$toModel.getNumEcgReports());
        Uuid uuid3 = $this$toModel.getResponsibleId();
        String string7 = $this$toModel.getResponsibleName();
        String string8 = $this$toModel.getDataHash();
        String string9 = $this$toModel.getDataUrl();
        String string10 = $this$toModel.getRecordSyncError();
        long l3 = $this$toModel.getRecordLastModified();
        return new RecordItem((Uuid)charSequence2, recordType, string, uuid, string2, string4, species, breed, l, string5, l2, uuid2, string6, uuid3, string7, string8, string9, n, string10, Long.valueOf(l3));
    }

    @NotNull
    public static final NibpResultElement resultsOnly(@NotNull NibpCalculatorOutput.Success $this$resultsOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$resultsOnly, (String)"<this>");
        return new NibpResultElement($this$resultsOnly.getId(), $this$resultsOnly.getMeasurementTime(), $this$resultsOnly.getBloodPressureValues(), $this$resultsOnly.getLeftTrimIndex(), $this$resultsOnly.getCalculatedBloodPressureIndexes(), $this$resultsOnly.getBloodPressureIndexes(), $this$resultsOnly.getRightTrimIndex(), false, $this$resultsOnly.getPulsePerMinute-8kGXVMQ(), $this$resultsOnly.getCuffSize(), $this$resultsOnly.getRequest(), $this$resultsOnly.getAlgorithmVersion(), null);
    }

    @NotNull
    public static final NibpCalculatorOutput.Success withData(@NotNull NibpResultElement $this$withData, @NotNull NibpOscillometryData oscillometryData) {
        Intrinsics.checkNotNullParameter((Object)$this$withData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)oscillometryData, (String)"oscillometryData");
        Uuid uuid = $this$withData.getId();
        long l = $this$withData.getTimestamp();
        List list = oscillometryData.getRawBloodPressure();
        int n = oscillometryData.getStartDeflationIndex();
        BloodPressureIndexes bloodPressureIndexes = $this$withData.getCalculatedBloodPressureIndexes();
        int n2 = $this$withData.getLeftTrimIndex();
        int n3 = $this$withData.getRightTrimIndex();
        BloodPressureIndexes bloodPressureIndexes2 = $this$withData.getBloodPressureIndexes();
        List list2 = ArraysKt.asList((float[])oscillometryData.getDeflation()).subList($this$withData.getLeftTrimIndex(), $this$withData.getRightTrimIndex());
        List list3 = ArraysKt.asList((float[])oscillometryData.getEnvelope()).subList($this$withData.getLeftTrimIndex(), $this$withData.getRightTrimIndex());
        List list4 = ArraysKt.asList((float[])oscillometryData.getOscillometry()).subList($this$withData.getLeftTrimIndex(), $this$withData.getRightTrimIndex());
        PulsePerMinute pulsePerMinute = $this$withData.getPulsePerMinute-8kGXVMQ();
        NibpCuffSize nibpCuffSize = $this$withData.getCuffSize();
        NibpProcedureRequest nibpProcedureRequest = $this$withData.getRequest();
        String string = $this$withData.getVersion();
        return new NibpCalculatorOutput.Success(uuid, l, list, n, list2, list4, list3, bloodPressureIndexes, bloodPressureIndexes2, n2, n3, pulsePerMinute, nibpCuffSize, nibpProcedureRequest, string, null, 32768, null);
    }
}

