/*
 * Decompiled with CFR 0.152.
 */
package io.github.koalaplot.core.xygraph;

import androidx.compose.runtime.MutableState;
import androidx.compose.ui.unit.Dp;
import io.github.koalaplot.core.xygraph.LinearAxisModelKt;
import io.github.koalaplot.core.xygraph.TickValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u00152\u0006\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u0010\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/koalaplot/core/xygraph/IntTickCalculator;", "", "minimumMajorTickSpacing", "Landroidx/compose/ui/unit/Dp;", "currentRange", "Landroidx/compose/runtime/MutableState;", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "minimumMajorTickIncrement", "", "minorTickCount", "inverted", "", "<init>", "(FLandroidx/compose/runtime/MutableState;IIZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "F", "computeMajorTickValues", "", "minTickSpacing", "", "computeTickValues", "Lio/github/koalaplot/core/xygraph/TickValues;", "axisLength", "computeTickValues-0680j_4", "(F)Lio/github/koalaplot/core/xygraph/TickValues;", "computeMajorTickSpacing", "computeMinorTickValues", "majorTickValues", "majorTickSpacing", "koalaplot-core"})
@SourceDebugExtension(value={"SMAP\nIntLinearAxisModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntLinearAxisModel.kt\nio/github/koalaplot/core/xygraph/IntTickCalculator\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/Dp\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,386:1\n113#2:387\n63#3:388\n1563#4:389\n1634#4,3:390\n*S KotlinDebug\n*F\n+ 1 IntLinearAxisModel.kt\nio/github/koalaplot/core/xygraph/IntTickCalculator\n*L\n232#1:387\n235#1:388\n254#1:389\n254#1:390,3\n*E\n"})
final class IntTickCalculator {
    private final float minimumMajorTickSpacing;
    @NotNull
    private final MutableState<ClosedFloatingPointRange<Double>> currentRange;
    private final int minimumMajorTickIncrement;
    private final int minorTickCount;
    private final boolean inverted;

    private IntTickCalculator(float minimumMajorTickSpacing, MutableState<ClosedFloatingPointRange<Double>> currentRange, int minimumMajorTickIncrement, int minorTickCount, boolean inverted) {
        Intrinsics.checkNotNullParameter(currentRange, (String)"currentRange");
        this.minimumMajorTickSpacing = minimumMajorTickSpacing;
        this.currentRange = currentRange;
        this.minimumMajorTickIncrement = minimumMajorTickIncrement;
        this.minorTickCount = minorTickCount;
        this.inverted = inverted;
    }

    private final List<Integer> computeMajorTickValues(float minTickSpacing) {
        List list;
        int tickSpacing = this.computeMajorTickSpacing(minTickSpacing);
        List $this$computeMajorTickValues_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (tickSpacing > 0) {
            int lastTick;
            int tickCount = (int)Math.floor(((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() / (double)tickSpacing);
            do {
                if ((double)(lastTick = tickCount * tickSpacing) >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() && (double)lastTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue()) {
                    $this$computeMajorTickValues_u24lambda_u240.add(lastTick);
                }
                ++tickCount;
            } while ((double)lastTick < ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TickValues<Integer> computeTickValues-0680j_4(float f) {
        float f2;
        boolean $this$dp$iv2 = false;
        boolean $i$f$getDp = false;
        if (Dp.equals-impl0((float)f, (float)Dp.constructor-impl((float)((float)$this$dp$iv2)))) {
            f2 = 1.0f;
        } else {
            void arg0$iv;
            float $this$dp$iv2 = this.minimumMajorTickSpacing;
            float other$iv = f;
            boolean bl = false;
            f2 = ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((float)(arg0$iv / other$iv)), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        }
        float minTickSpacing = f2;
        List<Integer> majorTickValues = this.computeMajorTickValues(minTickSpacing);
        List<Integer> minorTickValues = this.computeMinorTickValues(majorTickValues, this.computeMajorTickSpacing(minTickSpacing));
        return new TickValues<Integer>(this, majorTickValues, minorTickValues){
            private final List<Integer> majorTickValues;
            private final List<Integer> minorTickValues;
            {
                this.majorTickValues = IntTickCalculator.access$getInverted$p($receiver) ? CollectionsKt.reversed((Iterable)$majorTickValues) : $majorTickValues;
                this.minorTickValues = IntTickCalculator.access$getInverted$p($receiver) ? CollectionsKt.reversed((Iterable)$minorTickValues) : $minorTickValues;
            }

            public List<Integer> getMajorTickValues() {
                return this.majorTickValues;
            }

            public List<Integer> getMinorTickValues() {
                return this.minorTickValues;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final int computeMajorTickSpacing(float minTickSpacing) {
        Iterator iterator;
        block3: {
            void $this$mapTo$iv$iv;
            if (!(minTickSpacing > 0.0f && minTickSpacing <= 1.0f)) {
                boolean bl = false;
                String string = "Minimum tick spacing must be greater than 0 and less than or equal to 1";
                throw new IllegalArgumentException(string.toString());
            }
            double length = ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue() - ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue();
            float magnitude = (float)Math.pow(10.0f, (float)Math.floor((float)Math.log10((float)length)));
            Iterable $this$map$iv = LinearAxisModelKt.getTickRatios();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MathKt.roundToInt((float)(it * magnitude)));
            }
            List scaledTickRatios = (List)destination$iv$iv;
            Iterable iterable2 = scaledTickRatios;
            for (Iterator iterator2 : iterable2) {
                int it = ((Number)((Object)iterator2)).intValue();
                boolean bl = false;
                if (!((float)it / (float)length >= minTickSpacing && it >= this.minimumMajorTickIncrement)) continue;
                iterator = iterator2;
                break block3;
            }
            iterator = null;
        }
        Integer n = (Integer)((Object)iterator);
        int tickSpacing = n != null ? n : this.minimumMajorTickIncrement;
        return tickSpacing;
    }

    private final List<Integer> computeMinorTickValues(List<Integer> majorTickValues, int majorTickSpacing) {
        int minorIncrement;
        List list;
        List $this$computeMinorTickValues_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this.minorTickCount > 0 && !((Collection)majorTickValues).isEmpty() && (minorIncrement = majorTickSpacing / (this.minorTickCount + 1)) != 0) {
            int nextTick;
            int n = CollectionsKt.getLastIndex(majorTickValues);
            block0: for (int major = 0; major < n; ++major) {
                int majorTick1 = ((Number)majorTickValues.get(major)).intValue();
                int i = 1;
                int n2 = this.minorTickCount;
                if (i > n2) continue;
                while (true) {
                    $this$computeMinorTickValues_u24lambda_u240.add(majorTick1 + minorIncrement * i);
                    if (i == n2) continue block0;
                    ++i;
                }
            }
            int i = 1;
            do {
                if ((double)(nextTick = ((Number)CollectionsKt.last(majorTickValues)).intValue() + minorIncrement * i) >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() && (double)nextTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue()) {
                    $this$computeMinorTickValues_u24lambda_u240.add(nextTick);
                }
                ++i;
            } while ((double)nextTick >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() && (double)nextTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
            i = 1;
            do {
                if ((double)(nextTick = ((Number)CollectionsKt.first(majorTickValues)).intValue() - minorIncrement * i) >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue() && (double)nextTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue()) {
                    $this$computeMinorTickValues_u24lambda_u240.add(nextTick);
                }
                ++i;
                if (!((double)nextTick >= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getStart())).doubleValue())) break;
            } while ((double)nextTick <= ((Number)((Object)((ClosedFloatingPointRange)this.currentRange.getValue()).getEndInclusive())).doubleValue());
        }
        return CollectionsKt.build((List)list);
    }

    public /* synthetic */ IntTickCalculator(float minimumMajorTickSpacing, MutableState currentRange, int minimumMajorTickIncrement, int minorTickCount, boolean inverted, DefaultConstructorMarker $constructor_marker) {
        this(minimumMajorTickSpacing, (MutableState<ClosedFloatingPointRange<Double>>)currentRange, minimumMajorTickIncrement, minorTickCount, inverted);
    }

    public static final /* synthetic */ boolean access$getInverted$p(IntTickCalculator $this) {
        return $this.inverted;
    }
}

